/*
 * Decompiled with CFR 0.152.
 */
package git4idea.inMemory.objects;

import git4idea.commands.GitObjectType;
import git4idea.inMemory.objects.Oid;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmInline;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001:\u0003\u001e\u001f B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u001a\u001a\u00020\u00112\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u0096\u0082\u0004J\n\u0010\u001c\u001a\u00020\u001dH\u0096\u0080\u0004R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0018\u0010\u0010\u001a\u00020\u0011X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u0082\u0001\u0003!\"#\u00a8\u0006$"}, d2={"Lgit4idea/inMemory/objects/GitObject;", "", "<init>", "()V", "body", "", "getBody", "()[B", "oid", "Lgit4idea/inMemory/objects/Oid;", "getOid", "()Lgit4idea/inMemory/objects/Oid;", "type", "Lgit4idea/commands/GitObjectType;", "getType", "()Lgit4idea/commands/GitObjectType;", "persisted", "", "getPersisted", "()Z", "setPersisted", "(Z)V", "dependencies", "", "getDependencies", "()Ljava/util/List;", "equals", "other", "hashCode", "", "Commit", "Blob", "Tree", "Lgit4idea/inMemory/objects/GitObject$Blob;", "Lgit4idea/inMemory/objects/GitObject$Commit;", "Lgit4idea/inMemory/objects/GitObject$Tree;", "intellij.vcs.git"})
public abstract sealed class GitObject {
    @NotNull
    private final List<Oid> dependencies = CollectionsKt.emptyList();

    private GitObject() {
    }

    @NotNull
    public abstract byte[] getBody();

    @NotNull
    public abstract Oid getOid();

    @NotNull
    public abstract GitObjectType getType();

    public abstract boolean getPersisted();

    public abstract void setPersisted(boolean var1);

    @NotNull
    public List<Oid> getDependencies() {
        return this.dependencies;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GitObject)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getOid(), (Object)((GitObject)other).getOid());
    }

    public int hashCode() {
        return this.getOid().hashCode();
    }

    public /* synthetic */ GitObject(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lgit4idea/inMemory/objects/GitObject$Blob;", "Lgit4idea/inMemory/objects/GitObject;", "body", "", "oid", "Lgit4idea/inMemory/objects/Oid;", "<init>", "([BLgit4idea/inMemory/objects/Oid;)V", "getBody", "()[B", "getOid", "()Lgit4idea/inMemory/objects/Oid;", "type", "Lgit4idea/commands/GitObjectType;", "getType", "()Lgit4idea/commands/GitObjectType;", "persisted", "", "getPersisted", "()Z", "setPersisted", "(Z)V", "intellij.vcs.git"})
    public static final class Blob
    extends GitObject {
        @NotNull
        private final byte[] body;
        @NotNull
        private final Oid oid;
        @NotNull
        private final GitObjectType type;
        private boolean persisted;

        public Blob(@NotNull byte[] body, @NotNull Oid oid) {
            Intrinsics.checkNotNullParameter((Object)body, (String)"body");
            Intrinsics.checkNotNullParameter((Object)oid, (String)"oid");
            super(null);
            this.body = body;
            this.oid = oid;
            this.type = GitObjectType.BLOB;
        }

        @Override
        @NotNull
        public byte[] getBody() {
            return this.body;
        }

        @Override
        @NotNull
        public Oid getOid() {
            return this.oid;
        }

        @Override
        @NotNull
        public GitObjectType getType() {
            return this.type;
        }

        @Override
        public boolean getPersisted() {
            return this.persisted;
        }

        @Override
        public void setPersisted(boolean bl) {
            this.persisted = bl;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\u0018\u0000 )2\u00020\u0001:\u0002()BO\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\n\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u0012\u0006\u0010\f\u001a\u00020\u0003\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0013R\u0011\u0010\f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0011R\u0013\u0010\r\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0011R\u0014\u0010\u001c\u001a\u00020\u001dX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\u00020!X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001a\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00050\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u0018\u00a8\u0006*"}, d2={"Lgit4idea/inMemory/objects/GitObject$Commit;", "Lgit4idea/inMemory/objects/GitObject;", "body", "", "oid", "Lgit4idea/inMemory/objects/Oid;", "author", "Lgit4idea/inMemory/objects/GitObject$Commit$Author;", "committer", "parentsOids", "", "treeOid", "message", "gpgSignature", "<init>", "([BLgit4idea/inMemory/objects/Oid;Lgit4idea/inMemory/objects/GitObject$Commit$Author;Lgit4idea/inMemory/objects/GitObject$Commit$Author;Ljava/util/List;Lgit4idea/inMemory/objects/Oid;[B[B)V", "getBody", "()[B", "getOid", "()Lgit4idea/inMemory/objects/Oid;", "getAuthor", "()Lgit4idea/inMemory/objects/GitObject$Commit$Author;", "getCommitter", "getParentsOids", "()Ljava/util/List;", "getTreeOid", "getMessage", "getGpgSignature", "type", "Lgit4idea/commands/GitObjectType;", "getType", "()Lgit4idea/commands/GitObjectType;", "persisted", "", "getPersisted", "()Z", "setPersisted", "(Z)V", "dependencies", "getDependencies", "Author", "Companion", "intellij.vcs.git"})
    public static final class Commit
    extends GitObject {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final byte[] body;
        @NotNull
        private final Oid oid;
        @NotNull
        private final Author author;
        @NotNull
        private final Author committer;
        @NotNull
        private final List<Oid> parentsOids;
        @NotNull
        private final Oid treeOid;
        @NotNull
        private final byte[] message;
        @Nullable
        private final byte[] gpgSignature;
        @NotNull
        private final GitObjectType type;
        private boolean persisted;
        @NotNull
        private final List<Oid> dependencies;
        @NonNls
        @NotNull
        private static final String TREE_HEADER = "tree";
        @NonNls
        @NotNull
        private static final String PARENT_HEADER = "parent";
        @NonNls
        @NotNull
        private static final String AUTHOR_HEADER = "author";
        @NonNls
        @NotNull
        private static final String COMMITTER_HEADER = "committer";
        @NonNls
        @NotNull
        private static final String GPGSIG_HEADER = "gpgsig";
        @NonNls
        @NotNull
        private static final Regex NEW_LINE_REGEX = new Regex("\n(?! )");

        public Commit(@NotNull byte[] body, @NotNull Oid oid, @NotNull Author author, @NotNull Author committer, @NotNull List<Oid> parentsOids, @NotNull Oid treeOid, @NotNull byte[] message, @Nullable byte[] gpgSignature) {
            Intrinsics.checkNotNullParameter((Object)body, (String)"body");
            Intrinsics.checkNotNullParameter((Object)oid, (String)"oid");
            Intrinsics.checkNotNullParameter((Object)author, (String)AUTHOR_HEADER);
            Intrinsics.checkNotNullParameter((Object)committer, (String)COMMITTER_HEADER);
            Intrinsics.checkNotNullParameter(parentsOids, (String)"parentsOids");
            Intrinsics.checkNotNullParameter((Object)treeOid, (String)"treeOid");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            super(null);
            this.body = body;
            this.oid = oid;
            this.author = author;
            this.committer = committer;
            this.parentsOids = parentsOids;
            this.treeOid = treeOid;
            this.message = message;
            this.gpgSignature = gpgSignature;
            this.type = GitObjectType.COMMIT;
            this.dependencies = CollectionsKt.plus((Collection)this.parentsOids, (Object)this.treeOid);
        }

        @Override
        @NotNull
        public byte[] getBody() {
            return this.body;
        }

        @Override
        @NotNull
        public Oid getOid() {
            return this.oid;
        }

        @NotNull
        public final Author getAuthor() {
            return this.author;
        }

        @NotNull
        public final Author getCommitter() {
            return this.committer;
        }

        @NotNull
        public final List<Oid> getParentsOids() {
            return this.parentsOids;
        }

        @NotNull
        public final Oid getTreeOid() {
            return this.treeOid;
        }

        @NotNull
        public final byte[] getMessage() {
            return this.message;
        }

        @Nullable
        public final byte[] getGpgSignature() {
            return this.gpgSignature;
        }

        @Override
        @NotNull
        public GitObjectType getType() {
            return this.type;
        }

        @Override
        public boolean getPersisted() {
            return this.persisted;
        }

        @Override
        public void setPersisted(boolean bl) {
            this.persisted = bl;
        }

        @Override
        @NotNull
        public List<Oid> getDependencies() {
            return this.dependencies;
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000  2\u00020\u0001:\u0001 B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u001d\u001a\u00020\u001eH\u00d6\u0081\u0004J\n\u0010\u001f\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0011\u0010\u000e\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\nR\u0011\u0010\u0010\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\nR\u0011\u0010\u0012\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\nR\u0011\u0010\u0014\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\n\u00a8\u0006!"}, d2={"Lgit4idea/inMemory/objects/GitObject$Commit$Author;", "", "nameAndEmail", "", "timestampSeconds", "", "timezone", "<init>", "(Ljava/lang/String;JLjava/lang/String;)V", "getNameAndEmail", "()Ljava/lang/String;", "getTimestampSeconds", "()J", "getTimezone", "gitFormat", "getGitFormat", "name", "getName", "email", "getEmail", "timestamp", "getTimestamp", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "intellij.vcs.git"})
        public static final class Author {
            @NotNull
            public static final Companion Companion = new Companion(null);
            @NotNull
            private final String nameAndEmail;
            private final long timestampSeconds;
            @NotNull
            private final String timezone;
            @NonNls
            @NotNull
            private static final Regex AUTHOR_REGEX = new Regex("(.+) (\\d+) (.+)");

            public Author(@NotNull String nameAndEmail, long timestampSeconds, @NotNull String timezone) {
                Intrinsics.checkNotNullParameter((Object)nameAndEmail, (String)"nameAndEmail");
                Intrinsics.checkNotNullParameter((Object)timezone, (String)"timezone");
                this.nameAndEmail = nameAndEmail;
                this.timestampSeconds = timestampSeconds;
                this.timezone = timezone;
            }

            @NotNull
            public final String getNameAndEmail() {
                return this.nameAndEmail;
            }

            public final long getTimestampSeconds() {
                return this.timestampSeconds;
            }

            @NotNull
            public final String getTimezone() {
                return this.timezone;
            }

            @NotNull
            public final String getGitFormat() {
                return this.nameAndEmail + " " + this.timestampSeconds + " " + this.timezone;
            }

            @NotNull
            public final String getName() {
                return ((Object)StringsKt.trim((CharSequence)StringsKt.substringBeforeLast$default((String)this.nameAndEmail, (char)'<', null, (int)2, null))).toString();
            }

            @NotNull
            public final String getEmail() {
                return ((Object)StringsKt.trim((CharSequence)StringsKt.substringBeforeLast$default((String)StringsKt.substringAfterLast$default((String)this.nameAndEmail, (char)'<', null, (int)2, null), (char)'>', null, (int)2, null))).toString();
            }

            @NotNull
            public final String getTimestamp() {
                return this.timestampSeconds + " " + this.timezone;
            }

            @NotNull
            public final String component1() {
                return this.nameAndEmail;
            }

            public final long component2() {
                return this.timestampSeconds;
            }

            @NotNull
            public final String component3() {
                return this.timezone;
            }

            @NotNull
            public final Author copy(@NotNull String nameAndEmail, long timestampSeconds, @NotNull String timezone) {
                Intrinsics.checkNotNullParameter((Object)nameAndEmail, (String)"nameAndEmail");
                Intrinsics.checkNotNullParameter((Object)timezone, (String)"timezone");
                return new Author(nameAndEmail, timestampSeconds, timezone);
            }

            public static /* synthetic */ Author copy$default(Author author, String string, long l, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    string = author.nameAndEmail;
                }
                if ((n & 2) != 0) {
                    l = author.timestampSeconds;
                }
                if ((n & 4) != 0) {
                    string2 = author.timezone;
                }
                return author.copy(string, l, string2);
            }

            @NotNull
            public String toString() {
                return "Author(nameAndEmail=" + this.nameAndEmail + ", timestampSeconds=" + this.timestampSeconds + ", timezone=" + this.timezone + ")";
            }

            public int hashCode() {
                int result2 = this.nameAndEmail.hashCode();
                result2 = result2 * 31 + Long.hashCode(this.timestampSeconds);
                result2 = result2 * 31 + this.timezone.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Author)) {
                    return false;
                }
                Author author = (Author)other;
                if (!Intrinsics.areEqual((Object)this.nameAndEmail, (Object)author.nameAndEmail)) {
                    return false;
                }
                if (this.timestampSeconds != author.timestampSeconds) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.timezone, (Object)author.timezone);
            }

            @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u0010\u0010\u0004\u001a\u00020\u00058\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lgit4idea/inMemory/objects/GitObject$Commit$Author$Companion;", "", "<init>", "()V", "AUTHOR_REGEX", "Lkotlin/text/Regex;", "parse", "Lgit4idea/inMemory/objects/GitObject$Commit$Author;", "value", "", "intellij.vcs.git"})
            @SourceDebugExtension(value={"SMAP\nGitObject.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitObject.kt\ngit4idea/inMemory/objects/GitObject$Commit$Author$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,343:1\n1#2:344\n*E\n"})
            public static final class Companion {
                private Companion() {
                }

                @NotNull
                public final Author parse(@NotNull String value) {
                    Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                    MatchResult matchResult = AUTHOR_REGEX.matchEntire((CharSequence)value);
                    if (matchResult == null) {
                        boolean bl = false;
                        String string = "Invalid author format: " + value;
                        throw new IllegalArgumentException(string.toString());
                    }
                    MatchResult.Destructured destructured = matchResult.getDestructured();
                    String nameAndEmail = (String)destructured.getMatch().getGroupValues().get(1);
                    String timestamp = (String)destructured.getMatch().getGroupValues().get(2);
                    String timezone = (String)destructured.getMatch().getGroupValues().get(3);
                    return new Author(nameAndEmail, Long.parseLong(timestamp), timezone);
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u001fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ>\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u000f2\b\u0010\u0019\u001a\u0004\u0018\u00010\u000fJ\u0010\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u000fH\u0002J\u0014\u0010\u001b\u001a\u00020\u001c*\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0005H\u0002R\u0010\u0010\u0004\u001a\u00020\u00058\u0002X\u0083T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00058\u0002X\u0083T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00058\u0002X\u0083T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00058\u0002X\u0083T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\u00058\u0002X\u0083T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u000b8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lgit4idea/inMemory/objects/GitObject$Commit$Companion;", "", "<init>", "()V", "TREE_HEADER", "", "PARENT_HEADER", "AUTHOR_HEADER", "COMMITTER_HEADER", "GPGSIG_HEADER", "NEW_LINE_REGEX", "Lkotlin/text/Regex;", "parseBody", "Lgit4idea/inMemory/objects/GitObject$Commit$Companion$ParsedData;", "body", "", "buildBody", "author", "Lgit4idea/inMemory/objects/GitObject$Commit$Author;", "committer", "parentsOids", "", "Lgit4idea/inMemory/objects/Oid;", "treeOid", "message", "gpgSignature", "processGpgSignatureWithLeadingSpace", "write", "", "Ljava/io/ByteArrayOutputStream;", "str", "ParsedData", "intellij.vcs.git"})
        @SourceDebugExtension(value={"SMAP\nGitObject.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitObject.kt\ngit4idea/inMemory/objects/GitObject$Commit$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,343:1\n1#2:344\n1915#3,2:345\n*S KotlinDebug\n*F\n+ 1 GitObject.kt\ngit4idea/inMemory/objects/GitObject$Commit$Companion\n*L\n182#1:345,2\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final ParsedData parseBody(@NotNull byte[] body) {
                byte[] byArray;
                Intrinsics.checkNotNullParameter((Object)body, (String)"body");
                Object object = body;
                Charset charset = Charsets.UTF_8;
                String bodyString = new String((byte[])object, charset);
                Object object2 = new String[]{"\n\n"};
                Object it = object2 = StringsKt.split$default((CharSequence)bodyString, (String[])object2, (boolean)false, (int)2, (int)2, null);
                boolean bl = false;
                Object object3 = it.size() == 2 ? object2 : null;
                if (object3 == null) {
                    object2 = "Invalid commit format: missing message separator";
                    throw new IllegalStateException(object2.toString());
                }
                object = object3;
                String headers = (String)object.get(0);
                String message = (String)object.get(1);
                Oid treeOid = null;
                Author author = null;
                Author committer = null;
                String gpgSignature = null;
                List parentsOids = new ArrayList();
                Object object4 = headers;
                Regex regex = NEW_LINE_REGEX;
                int n = 0;
                List headerLines = regex.split((CharSequence)object4, n);
                for (String header : headerLines) {
                    String[] stringArray;
                    List keyValue = StringsKt.split$default((CharSequence)header, (String[])(stringArray = new String[]{" "}), (boolean)false, (int)2, (int)2, null);
                    if (keyValue.size() < 2) continue;
                    String key = (String)keyValue.get(0);
                    String value = StringsKt.replace$default((String)((String)keyValue.get(1)), (String)"\n ", (String)"\n", (boolean)false, (int)4, null);
                    switch (key) {
                        case "tree": {
                            treeOid = Oid.Companion.fromHex(value);
                            break;
                        }
                        case "parent": {
                            parentsOids.add(Oid.Companion.fromHex(value));
                            break;
                        }
                        case "author": {
                            author = Author.Companion.parse(value);
                            break;
                        }
                        case "committer": {
                            committer = Author.Companion.parse(value);
                            break;
                        }
                        case "gpgsig": {
                            gpgSignature = value;
                        }
                    }
                }
                if (author == null) {
                    boolean $i$a$-requireNotNull-GitObject$Commit$Companion$parseBody$52 = false;
                    String $i$a$-requireNotNull-GitObject$Commit$Companion$parseBody$52 = "Commit author not found";
                    throw new IllegalArgumentException($i$a$-requireNotNull-GitObject$Commit$Companion$parseBody$52.toString());
                }
                if (committer == null) {
                    boolean $i$a$-requireNotNull-GitObject$Commit$Companion$parseBody$62 = false;
                    String $i$a$-requireNotNull-GitObject$Commit$Companion$parseBody$62 = "Committer not found";
                    throw new IllegalArgumentException($i$a$-requireNotNull-GitObject$Commit$Companion$parseBody$62.toString());
                }
                if (treeOid == null) {
                    boolean bl2 = false;
                    String string = "Commit tree not found";
                    throw new IllegalArgumentException(string.toString());
                }
                object4 = message;
                byte[] byArray2 = ((String)object4).getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
                String string = gpgSignature;
                if (string != null) {
                    regex = string;
                    byte[] byArray3 = regex.getBytes(Charsets.UTF_8);
                    byArray = byArray3;
                    Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"getBytes(...)");
                } else {
                    byArray = null;
                }
                return new ParsedData(author, committer, parentsOids, treeOid, byArray2, byArray);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @NotNull
            public final byte[] buildBody(@NotNull Author author, @NotNull Author committer, @NotNull List<Oid> parentsOids, @NotNull Oid treeOid, @NotNull byte[] message, @Nullable byte[] gpgSignature) {
                byte[] byArray;
                Intrinsics.checkNotNullParameter((Object)author, (String)Commit.AUTHOR_HEADER);
                Intrinsics.checkNotNullParameter((Object)committer, (String)Commit.COMMITTER_HEADER);
                Intrinsics.checkNotNullParameter(parentsOids, (String)"parentsOids");
                Intrinsics.checkNotNullParameter((Object)treeOid, (String)"treeOid");
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                Closeable closeable = new ByteArrayOutputStream();
                Throwable throwable = null;
                try {
                    ByteArrayOutputStream baos = (ByteArrayOutputStream)closeable;
                    boolean bl = false;
                    Companion.write(baos, "tree " + treeOid.hex() + "\n");
                    Iterable $this$forEach$iv = parentsOids;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Oid parent = (Oid)element$iv;
                        boolean bl2 = false;
                        Companion.write(baos, "parent " + parent.hex() + "\n");
                    }
                    Companion.write(baos, "author " + author.getGitFormat() + "\n");
                    Companion.write(baos, "committer " + committer.getGitFormat() + "\n");
                    if (gpgSignature != null) {
                        byte[] signature = gpgSignature;
                        boolean bl3 = false;
                        Companion.write(baos, Commit.GPGSIG_HEADER);
                        baos.write(Companion.processGpgSignatureWithLeadingSpace(signature));
                        Companion.write(baos, "\n");
                    }
                    Companion.write(baos, "\n");
                    baos.write(message);
                    byArray = baos.toByteArray();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"use(...)");
                return byArray;
            }

            private final byte[] processGpgSignatureWithLeadingSpace(byte[] gpgSignature) {
                String string = SequencesKt.joinToString$default((Sequence)StringsKt.lineSequence((CharSequence)new String(gpgSignature, Charsets.UTF_8)), (CharSequence)"\n", null, null, (int)0, null, Companion::processGpgSignatureWithLeadingSpace$lambda$0, (int)30, null);
                byte[] byArray = string.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                return byArray;
            }

            private final void write(ByteArrayOutputStream $this$write, String str) {
                String string = str;
                byte[] byArray = string.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                $this$write.write(byArray);
            }

            private static final CharSequence processGpgSignatureWithLeadingSpace$lambda$0(String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return " " + it;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }

            @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u000e\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016\u00a8\u0006\u0018"}, d2={"Lgit4idea/inMemory/objects/GitObject$Commit$Companion$ParsedData;", "", "author", "Lgit4idea/inMemory/objects/GitObject$Commit$Author;", "committer", "parentsOids", "", "Lgit4idea/inMemory/objects/Oid;", "treeOid", "message", "", "gpgSignature", "<init>", "(Lgit4idea/inMemory/objects/GitObject$Commit$Author;Lgit4idea/inMemory/objects/GitObject$Commit$Author;Ljava/util/List;Lgit4idea/inMemory/objects/Oid;[B[B)V", "getAuthor", "()Lgit4idea/inMemory/objects/GitObject$Commit$Author;", "getCommitter", "getParentsOids", "()Ljava/util/List;", "getTreeOid", "()Lgit4idea/inMemory/objects/Oid;", "getMessage", "()[B", "getGpgSignature", "intellij.vcs.git"})
            public static final class ParsedData {
                @NotNull
                private final Author author;
                @NotNull
                private final Author committer;
                @NotNull
                private final List<Oid> parentsOids;
                @NotNull
                private final Oid treeOid;
                @NotNull
                private final byte[] message;
                @Nullable
                private final byte[] gpgSignature;

                public ParsedData(@NotNull Author author, @NotNull Author committer, @NotNull List<Oid> parentsOids, @NotNull Oid treeOid, @NotNull byte[] message, @Nullable byte[] gpgSignature) {
                    Intrinsics.checkNotNullParameter((Object)author, (String)Commit.AUTHOR_HEADER);
                    Intrinsics.checkNotNullParameter((Object)committer, (String)Commit.COMMITTER_HEADER);
                    Intrinsics.checkNotNullParameter(parentsOids, (String)"parentsOids");
                    Intrinsics.checkNotNullParameter((Object)treeOid, (String)"treeOid");
                    Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                    this.author = author;
                    this.committer = committer;
                    this.parentsOids = parentsOids;
                    this.treeOid = treeOid;
                    this.message = message;
                    this.gpgSignature = gpgSignature;
                }

                @NotNull
                public final Author getAuthor() {
                    return this.author;
                }

                @NotNull
                public final Author getCommitter() {
                    return this.committer;
                }

                @NotNull
                public final List<Oid> getParentsOids() {
                    return this.parentsOids;
                }

                @NotNull
                public final Oid getTreeOid() {
                    return this.treeOid;
                }

                @NotNull
                public final byte[] getMessage() {
                    return this.message;
                }

                @Nullable
                public final byte[] getGpgSignature() {
                    return this.gpgSignature;
                }
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0007\u0018\u0000 #2\u00020\u0001:\u0004 !\"#B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0004\b\n\u0010\u000bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0017X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00050\u001dX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006$"}, d2={"Lgit4idea/inMemory/objects/GitObject$Tree;", "Lgit4idea/inMemory/objects/GitObject;", "body", "", "oid", "Lgit4idea/inMemory/objects/Oid;", "entries", "", "Lgit4idea/inMemory/objects/GitObject$Tree$FileName;", "Lgit4idea/inMemory/objects/GitObject$Tree$Entry;", "<init>", "([BLgit4idea/inMemory/objects/Oid;Ljava/util/Map;)V", "getBody", "()[B", "getOid", "()Lgit4idea/inMemory/objects/Oid;", "getEntries", "()Ljava/util/Map;", "type", "Lgit4idea/commands/GitObjectType;", "getType", "()Lgit4idea/commands/GitObjectType;", "persisted", "", "getPersisted", "()Z", "setPersisted", "(Z)V", "dependencies", "", "getDependencies", "()Ljava/util/List;", "FileName", "FileMode", "Entry", "Companion", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nGitObject.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitObject.kt\ngit4idea/inMemory/objects/GitObject$Tree\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,343:1\n777#2:344\n873#2,2:345\n1586#2:347\n1661#2,3:348\n*S KotlinDebug\n*F\n+ 1 GitObject.kt\ngit4idea/inMemory/objects/GitObject$Tree\n*L\n226#1:344\n226#1:345,2\n226#1:347\n226#1:348,3\n*E\n"})
    public static final class Tree
    extends GitObject {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final byte[] body;
        @NotNull
        private final Oid oid;
        @NotNull
        private final Map<FileName, Entry> entries;
        @NotNull
        private final GitObjectType type;
        private boolean persisted;
        @NotNull
        private final List<Oid> dependencies;

        /*
         * WARNING - void declaration
         */
        public Tree(@NotNull byte[] body, @NotNull Oid oid, @NotNull Map<FileName, Entry> entries) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Entry it;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Intrinsics.checkNotNullParameter((Object)body, (String)"body");
            Intrinsics.checkNotNullParameter((Object)oid, (String)"oid");
            Intrinsics.checkNotNullParameter(entries, (String)"entries");
            super(null);
            this.body = body;
            this.oid = oid;
            this.entries = entries;
            this.type = GitObjectType.TREE;
            Iterable iterable = this.entries.values();
            Tree tree = this;
            boolean $i$f$filter = false;
            void var6_7 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Entry)element$iv$iv;
                boolean bl = false;
                if (!(it.getMode() != FileMode.GITLINK)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (Entry)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getOid());
            }
            tree.dependencies = (List)destination$iv$iv;
        }

        @Override
        @NotNull
        public byte[] getBody() {
            return this.body;
        }

        @Override
        @NotNull
        public Oid getOid() {
            return this.oid;
        }

        @NotNull
        public final Map<FileName, Entry> getEntries() {
            return this.entries;
        }

        @Override
        @NotNull
        public GitObjectType getType() {
            return this.type;
        }

        @Override
        public boolean getPersisted() {
            return this.persisted;
        }

        @Override
        public void setPersisted(boolean bl) {
            this.persisted = bl;
        }

        @Override
        @NotNull
        public List<Oid> getDependencies() {
            return this.dependencies;
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\b\u001a\u00020\tJ\u001a\u0010\n\u001a\u00020\t2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005J\u0014\u0010\f\u001a\u00020\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J%\u0010\u0010\u001a\u00020\u0011*\u00020\u00122\u0012\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\u0014\"\u00020\tH\u0002\u00a2\u0006\u0002\u0010\u0015J\u001e\u0010\u0016\u001a\u00020\r*\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\rH\u0002\u00a8\u0006\u001a"}, d2={"Lgit4idea/inMemory/objects/GitObject$Tree$Companion;", "", "<init>", "()V", "parseBody", "", "Lgit4idea/inMemory/objects/GitObject$Tree$FileName;", "Lgit4idea/inMemory/objects/GitObject$Tree$Entry;", "body", "", "buildBody", "entries", "commonPrefixLengthWith", "", "", "other", "writeSequence", "", "Ljava/io/ByteArrayOutputStream;", "arrays", "", "(Ljava/io/ByteArrayOutputStream;[[B)V", "indexOf", "byte", "", "startIndex", "intellij.vcs.git"})
        @SourceDebugExtension(value={"SMAP\nGitObject.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitObject.kt\ngit4idea/inMemory/objects/GitObject$Tree$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,343:1\n1915#2,2:344\n14060#3,2:346\n*S KotlinDebug\n*F\n+ 1 GitObject.kt\ngit4idea/inMemory/objects/GitObject$Tree$Companion\n*L\n310#1:344,2\n332#1:346,2\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Map<FileName, Entry> parseBody(@NotNull byte[] body) {
                Intrinsics.checkNotNullParameter((Object)body, (String)"body");
                Map entries = new LinkedHashMap();
                for (int ptr = 0; ptr < body.length; ptr += 20) {
                    Charset charset;
                    int spacePos = this.indexOf(body, (byte)32, ptr);
                    int n = spacePos - ptr;
                    Intrinsics.checkNotNullExpressionValue((Object)StandardCharsets.UTF_8, (String)"UTF_8");
                    String mode = new String(body, ptr, n, charset);
                    ptr = spacePos + 1;
                    int nullPos = this.indexOf(body, (byte)0, ptr);
                    int n2 = nullPos - ptr;
                    Charset charset2 = StandardCharsets.UTF_8;
                    Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"UTF_8");
                    Object object = charset2;
                    String name = new String(body, ptr, n2, (Charset)object);
                    ptr = nullPos + 1;
                    byte[] hashBytes = ArraysKt.copyOfRange((byte[])body, (int)ptr, (int)(ptr + 20));
                    object = entries;
                    FileName fileName = FileName.box-impl(FileName.constructor-impl(name));
                    FileMode fileMode = FileMode.Companion.fromValue(mode);
                    if (fileMode == null) {
                        throw new IllegalStateException(("Unknown file mode: " + mode).toString());
                    }
                    Entry entry = new Entry(fileMode, Oid.Companion.fromByteArray(hashBytes));
                    object.put(fileName, entry);
                }
                return entries;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @NotNull
            public final byte[] buildBody(@NotNull Map<FileName, Entry> entries) {
                byte[] byArray;
                Intrinsics.checkNotNullParameter(entries, (String)"entries");
                List sortedEntries = CollectionsKt.sortedWith((Iterable)entries.entrySet(), (arg_0, arg_1) -> Companion.buildBody$lambda$1(Companion::buildBody$lambda$0, arg_0, arg_1));
                Closeable closeable = new ByteArrayOutputStream();
                Throwable throwable = null;
                try {
                    ByteArrayOutputStream baos = (ByteArrayOutputStream)closeable;
                    boolean bl = false;
                    Iterable $this$forEach$iv = sortedEntries;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Map.Entry entry = (Map.Entry)element$iv;
                        boolean bl2 = false;
                        String name = ((FileName)entry.getKey()).unbox-impl();
                        Entry entry2 = (Entry)entry.getValue();
                        byte[][] byArrayArray = new byte[5][];
                        Intrinsics.checkNotNullExpressionValue((Object)entry2.getMode().getValue().getBytes(Charsets.UTF_8), (String)"getBytes(...)");
                        Intrinsics.checkNotNullExpressionValue((Object)" ".getBytes(Charsets.UTF_8), (String)"getBytes(...)");
                        Intrinsics.checkNotNullExpressionValue((Object)name.getBytes(Charsets.UTF_8), (String)"getBytes(...)");
                        byte[] byArray2 = new byte[]{0};
                        byArrayArray[3] = byArray2;
                        byArrayArray[4] = entry2.getOid().toByteArray();
                        Companion.writeSequence(baos, byArrayArray);
                    }
                    byArray = baos.toByteArray();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"use(...)");
                return byArray;
            }

            private final int commonPrefixLengthWith(String $this$commonPrefixLengthWith, String other) {
                int minLength = Math.min($this$commonPrefixLengthWith.length(), other.length());
                for (int i = 0; i < minLength; ++i) {
                    if ($this$commonPrefixLengthWith.charAt(i) == other.charAt(i)) continue;
                    return i;
                }
                return minLength;
            }

            private final void writeSequence(ByteArrayOutputStream $this$writeSequence, byte[] ... arrays) {
                Object[] $this$forEach$iv = (Object[])arrays;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    byte[] it = (byte[])element$iv;
                    boolean bl = false;
                    $this$writeSequence.write(it);
                }
            }

            private final int indexOf(byte[] $this$indexOf, byte by, int startIndex) {
                int n = $this$indexOf.length;
                for (int i = startIndex; i < n; ++i) {
                    if ($this$indexOf[i] != by) continue;
                    return i;
                }
                return -1;
            }

            static /* synthetic */ int indexOf$default(Companion companion, byte[] byArray, byte by, int n, int n2, Object object) {
                if ((n2 & 2) != 0) {
                    n = 0;
                }
                return companion.indexOf(byArray, by, n);
            }

            private static final int buildBody$lambda$0(Map.Entry entry1, Map.Entry entry2) {
                int n;
                String name2;
                String name1 = ((FileName)entry1.getKey()).unbox-impl();
                int commonPrefix = Companion.commonPrefixLengthWith(name1, name2 = ((FileName)entry2.getKey()).unbox-impl());
                int n2 = commonPrefix;
                if (n2 == name1.length()) {
                    int effectiveChar = ((Entry)entry1.getValue()).getMode() == FileMode.DIR ? 47 : 0;
                    n = Intrinsics.compare((int)effectiveChar, (int)name2.charAt(commonPrefix));
                } else if (n2 == name2.length()) {
                    int effectiveChar = ((Entry)entry2.getValue()).getMode() == FileMode.DIR ? 47 : 0;
                    n = Intrinsics.compare((int)name1.charAt(commonPrefix), (int)effectiveChar);
                } else {
                    n = Intrinsics.compare((int)name1.charAt(commonPrefix), (int)name2.charAt(commonPrefix));
                }
                return n;
            }

            private static final int buildBody$lambda$1(Function2 $tmp0, Object p0, Object p1) {
                return ((Number)$tmp0.invoke(p0, p1)).intValue();
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0014\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0012\u001a\u00020\u0013H\u00d6\u0081\u0004J\n\u0010\u0014\u001a\u00020\u0015H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lgit4idea/inMemory/objects/GitObject$Tree$Entry;", "", "mode", "Lgit4idea/inMemory/objects/GitObject$Tree$FileMode;", "oid", "Lgit4idea/inMemory/objects/Oid;", "<init>", "(Lgit4idea/inMemory/objects/GitObject$Tree$FileMode;Lgit4idea/inMemory/objects/Oid;)V", "getMode", "()Lgit4idea/inMemory/objects/GitObject$Tree$FileMode;", "getOid", "()Lgit4idea/inMemory/objects/Oid;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.vcs.git"})
        public static final class Entry {
            @NotNull
            private final FileMode mode;
            @NotNull
            private final Oid oid;

            public Entry(@NotNull FileMode mode, @NotNull Oid oid) {
                Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
                Intrinsics.checkNotNullParameter((Object)oid, (String)"oid");
                this.mode = mode;
                this.oid = oid;
            }

            @NotNull
            public final FileMode getMode() {
                return this.mode;
            }

            @NotNull
            public final Oid getOid() {
                return this.oid;
            }

            @NotNull
            public final FileMode component1() {
                return this.mode;
            }

            @NotNull
            public final Oid component2() {
                return this.oid;
            }

            @NotNull
            public final Entry copy(@NotNull FileMode mode, @NotNull Oid oid) {
                Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
                Intrinsics.checkNotNullParameter((Object)oid, (String)"oid");
                return new Entry(mode, oid);
            }

            public static /* synthetic */ Entry copy$default(Entry entry, FileMode fileMode, Oid oid, int n, Object object) {
                if ((n & 1) != 0) {
                    fileMode = entry.mode;
                }
                if ((n & 2) != 0) {
                    oid = entry.oid;
                }
                return entry.copy(fileMode, oid);
            }

            @NotNull
            public String toString() {
                return "Entry(mode=" + this.mode + ", oid=" + this.oid + ")";
            }

            public int hashCode() {
                int result2 = this.mode.hashCode();
                result2 = result2 * 31 + this.oid.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Entry)) {
                    return false;
                }
                Entry entry = (Entry)other;
                if (this.mode != entry.mode) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.oid, (Object)entry.oid);
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0087\u0081\u0002\u0018\u0000 \u000f2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u000fB\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\r\u001a\u00020\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\f\u00a8\u0006\u0010"}, d2={"Lgit4idea/inMemory/objects/GitObject$Tree$FileMode;", "", "value", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getValue", "()Ljava/lang/String;", "GITLINK", "SYMLINK", "DIR", "REGULAR", "EXEC", "isFile", "", "Companion", "intellij.vcs.git"})
        @NonNls
        public static final class FileMode
        extends Enum<FileMode> {
            @NotNull
            public static final Companion Companion;
            @NotNull
            private final String value;
            public static final /* enum */ FileMode GITLINK;
            public static final /* enum */ FileMode SYMLINK;
            public static final /* enum */ FileMode DIR;
            public static final /* enum */ FileMode REGULAR;
            public static final /* enum */ FileMode EXEC;
            private static final /* synthetic */ FileMode[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            private FileMode(String value) {
                this.value = value;
            }

            @NotNull
            public final String getValue() {
                return this.value;
            }

            public final boolean isFile() {
                return this == REGULAR || this == EXEC || this == SYMLINK;
            }

            public static FileMode[] values() {
                return (FileMode[])$VALUES.clone();
            }

            public static FileMode valueOf(String value) {
                return Enum.valueOf(FileMode.class, value);
            }

            @NotNull
            public static EnumEntries<FileMode> getEntries() {
                return $ENTRIES;
            }

            static {
                GITLINK = new FileMode("160000");
                SYMLINK = new FileMode("120000");
                DIR = new FileMode("40000");
                REGULAR = new FileMode("100644");
                EXEC = new FileMode("100755");
                $VALUES = fileModeArray = new FileMode[]{FileMode.GITLINK, FileMode.SYMLINK, FileMode.DIR, FileMode.REGULAR, FileMode.EXEC};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
                Companion = new Companion(null);
            }

            @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lgit4idea/inMemory/objects/GitObject$Tree$FileMode$Companion;", "", "<init>", "()V", "fromValue", "Lgit4idea/inMemory/objects/GitObject$Tree$FileMode;", "value", "", "intellij.vcs.git"})
            @SourceDebugExtension(value={"SMAP\nGitObject.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitObject.kt\ngit4idea/inMemory/objects/GitObject$Tree$FileMode$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,343:1\n1#2:344\n*E\n"})
            public static final class Companion {
                private Companion() {
                }

                @Nullable
                public final FileMode fromValue(@NotNull String value) {
                    Object v0;
                    block1: {
                        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                        Iterable iterable = (Iterable)FileMode.getEntries();
                        for (Object t : iterable) {
                            FileMode it = (FileMode)((Object)t);
                            boolean bl = false;
                            if (!Intrinsics.areEqual((Object)it.getValue(), (Object)value)) continue;
                            v0 = t;
                            break block1;
                        }
                        v0 = null;
                    }
                    return v0;
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        @JvmInline
        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\b\u0087@\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0011\u0010\b\u001a\u00020\u0003H\u0096\u0080\u0004\u00a2\u0006\u0004\b\t\u0010\u0005J\u001b\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0011\u0010\u000f\u001a\u00020\u0010H\u00d6\u0081\u0004\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u0088\u0001\u0002\u00a8\u0006\u0013"}, d2={"Lgit4idea/inMemory/objects/GitObject$Tree$FileName;", "", "value", "", "constructor-impl", "(Ljava/lang/String;)Ljava/lang/String;", "getValue", "()Ljava/lang/String;", "toString", "toString-impl", "equals", "", "other", "equals-impl", "(Ljava/lang/String;Ljava/lang/Object;)Z", "hashCode", "", "hashCode-impl", "(Ljava/lang/String;)I", "intellij.vcs.git"})
        public static final class FileName {
            @NotNull
            private final String value;

            @NotNull
            public final String getValue() {
                return this.value;
            }

            @NotNull
            public static String toString-impl(String arg0) {
                return arg0;
            }

            @NotNull
            public String toString() {
                return FileName.toString-impl(this.value);
            }

            public static int hashCode-impl(String arg0) {
                return arg0.hashCode();
            }

            public int hashCode() {
                return FileName.hashCode-impl(this.value);
            }

            public static boolean equals-impl(String arg0, Object other) {
                if (!(other instanceof FileName)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)arg0, (Object)((FileName)other).unbox-impl());
            }

            public boolean equals(Object other) {
                return FileName.equals-impl(this.value, other);
            }

            private /* synthetic */ FileName(String value) {
                this.value = value;
            }

            @NotNull
            public static String constructor-impl(@NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return value;
            }

            public static final /* synthetic */ FileName box-impl(String v) {
                return new FileName(v);
            }

            public final /* synthetic */ String unbox-impl() {
                return this.value;
            }

            public static final boolean equals-impl0(String p1, String p2) {
                return Intrinsics.areEqual((Object)p1, (Object)p2);
            }
        }
    }
}

