/*
 * Decompiled with CFR 0.152.
 */
package org.cef;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class CefSettings {
    public String browser_subprocess_path = null;
    public boolean windowless_rendering_enabled = true;
    public boolean command_line_args_disabled = false;
    public String cache_path = null;
    public boolean persist_session_cookies = false;
    public String user_agent = null;
    public String user_agent_product = null;
    public String locale = null;
    public String log_file = null;
    public LogSeverity log_severity = LogSeverity.LOGSEVERITY_DEFAULT;
    public String javascript_flags = null;
    public String resources_dir_path = null;
    public String locales_dir_path = null;
    public int remote_debugging_port = 0;
    public int uncaught_exception_stack_size = 0;
    public ColorType background_color = null;
    public String cookieable_schemes_list = null;
    public boolean cookieable_schemes_exclude_defaults = false;
    public boolean no_sandbox = !Boolean.getBoolean("jcef.use_sandbox");

    public CefSettings clone() {
        CefSettings tmp = new CefSettings();
        tmp.browser_subprocess_path = this.browser_subprocess_path;
        tmp.windowless_rendering_enabled = this.windowless_rendering_enabled;
        tmp.command_line_args_disabled = this.command_line_args_disabled;
        tmp.cache_path = this.cache_path;
        tmp.persist_session_cookies = this.persist_session_cookies;
        tmp.user_agent = this.user_agent;
        tmp.user_agent_product = this.user_agent_product;
        tmp.locale = this.locale;
        tmp.log_file = this.log_file;
        tmp.log_severity = this.log_severity;
        tmp.javascript_flags = this.javascript_flags;
        tmp.resources_dir_path = this.resources_dir_path;
        tmp.locales_dir_path = this.locales_dir_path;
        tmp.remote_debugging_port = this.remote_debugging_port;
        tmp.uncaught_exception_stack_size = this.uncaught_exception_stack_size;
        if (this.background_color != null) {
            tmp.background_color = this.background_color.clone();
        }
        tmp.cookieable_schemes_list = this.cookieable_schemes_list;
        tmp.cookieable_schemes_exclude_defaults = this.cookieable_schemes_exclude_defaults;
        tmp.no_sandbox = this.no_sandbox;
        return tmp;
    }

    public String getDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("browser_subprocess_path=" + this.browser_subprocess_path + ", ");
        sb.append("windowless_rendering_enabled=" + this.windowless_rendering_enabled + ", ");
        sb.append("command_line_args_disabled=" + this.command_line_args_disabled + ", ");
        sb.append("cache_path=" + this.cache_path + ", ");
        sb.append("persist_session_cookies=" + this.persist_session_cookies + ", ");
        sb.append("user_agent=" + this.user_agent + ", ");
        sb.append("user_agent_product=" + this.user_agent_product + ", ");
        sb.append("locale=" + this.locale + ", ");
        sb.append("log_file=" + this.log_file + ", ");
        sb.append("log_severity=" + this.log_severity + ", ");
        sb.append("javascript_flags=" + this.javascript_flags + ", ");
        sb.append("resources_dir_path=" + this.resources_dir_path + ", ");
        sb.append("locales_dir_path=" + this.locales_dir_path + ", ");
        sb.append("remote_debugging_port=" + this.remote_debugging_port + ", ");
        sb.append("uncaught_exception_stack_size=" + this.uncaught_exception_stack_size + ", ");
        if (this.background_color != null) {
            sb.append("background_color=" + this.background_color.clone() + ", ");
        }
        sb.append("cookieable_schemes_list=" + this.cookieable_schemes_list + ", ");
        sb.append("cookieable_schemes_exclude_defaults=" + this.cookieable_schemes_exclude_defaults + ", ");
        sb.append("no_sandbox=" + this.no_sandbox);
        return sb.toString();
    }

    private static void putNonEmpty(Map<String, String> result, String key, String value) {
        if (value != null && !value.isEmpty()) {
            result.put(key, value);
        }
    }

    public Map<String, String> toMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        CefSettings.putNonEmpty(result, "browser_subprocess_path", this.browser_subprocess_path);
        CefSettings.putNonEmpty(result, "windowless_rendering_enabled", String.valueOf(this.windowless_rendering_enabled));
        CefSettings.putNonEmpty(result, "command_line_args_disabled", String.valueOf(this.command_line_args_disabled));
        CefSettings.putNonEmpty(result, "cache_path", this.cache_path);
        CefSettings.putNonEmpty(result, "persist_session_cookies", String.valueOf(this.persist_session_cookies));
        CefSettings.putNonEmpty(result, "user_agent", this.user_agent);
        CefSettings.putNonEmpty(result, "user_agent_product", this.user_agent_product);
        CefSettings.putNonEmpty(result, "locale", this.locale);
        CefSettings.putNonEmpty(result, "log_file", this.log_file);
        CefSettings.putNonEmpty(result, "log_severity", String.valueOf((Object)this.log_severity));
        CefSettings.putNonEmpty(result, "javascript_flags", this.javascript_flags);
        CefSettings.putNonEmpty(result, "resources_dir_path", this.resources_dir_path);
        CefSettings.putNonEmpty(result, "locales_dir_path", this.locales_dir_path);
        CefSettings.putNonEmpty(result, "remote_debugging_port", String.valueOf(this.remote_debugging_port));
        CefSettings.putNonEmpty(result, "uncaught_exception_stack_size", String.valueOf(this.uncaught_exception_stack_size));
        if (this.background_color != null) {
            CefSettings.putNonEmpty(result, "background_color", String.valueOf(this.background_color.getColor()));
        }
        CefSettings.putNonEmpty(result, "cookieable_schemes_list", this.cookieable_schemes_list);
        CefSettings.putNonEmpty(result, "cookieable_schemes_exclude_defaults", String.valueOf(this.cookieable_schemes_exclude_defaults));
        CefSettings.putNonEmpty(result, "no_sandbox", String.valueOf(this.no_sandbox));
        return result;
    }

    public boolean isAlmostEqual(CefSettings other) {
        return Objects.equals(this.cache_path, other.cache_path) && Objects.equals(this.persist_session_cookies, other.persist_session_cookies) && Objects.equals(this.user_agent, other.user_agent) && Objects.equals(this.user_agent_product, other.user_agent_product) && Objects.equals(this.locale, other.locale) && Objects.equals(this.javascript_flags, other.javascript_flags) && Objects.equals(this.remote_debugging_port, other.remote_debugging_port) && Objects.equals(this.uncaught_exception_stack_size, other.uncaught_exception_stack_size) && Objects.equals(this.cookieable_schemes_list, other.cookieable_schemes_list) && Objects.equals(this.cookieable_schemes_exclude_defaults, other.cookieable_schemes_exclude_defaults);
    }

    public static enum LogSeverity {
        LOGSEVERITY_DEFAULT,
        LOGSEVERITY_VERBOSE,
        LOGSEVERITY_INFO,
        LOGSEVERITY_WARNING,
        LOGSEVERITY_ERROR,
        LOGSEVERITY_FATAL,
        LOGSEVERITY_DISABLE;

    }

    public class ColorType {
        private long color_value = 0L;

        private ColorType() {
        }

        public ColorType(int alpha, int red, int green, int blue) {
            this.color_value = alpha << 24 | red << 16 | green << 8 | blue << 0;
        }

        public long getColor() {
            return this.color_value;
        }

        public ColorType clone() {
            ColorType res = new ColorType();
            res.color_value = this.color_value;
            return res;
        }
    }
}

