/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.debugger.impl.frontend;

import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.project.Project;
import com.intellij.platform.debugger.impl.frontend.EditorBreakpointLinesInfoMap;
import com.intellij.platform.debugger.impl.frontend.EditorLineBreakpointsInfo;
import com.intellij.platform.debugger.impl.frontend.FrontendEditorLinesBreakpointsInfoManagerKt;
import com.intellij.util.CoroutineScopeKt;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.lang.invoke.LambdaMetafactory;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0001\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\nH\u0002J\u001e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0086@\u00a2\u0006\u0002\u0010\u0012J\u001f\u0010\u0013\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0001\u00a2\u0006\u0002\b\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/platform/debugger/impl/frontend/FrontendEditorLinesBreakpointsInfoManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "editorsMap", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/openapi/editor/Editor;", "Lcom/intellij/platform/debugger/impl/frontend/EditorBreakpointLinesInfoMap;", "putNewLinesInfoMap", "editor", "getBreakpointsInfoForLine", "Lcom/intellij/platform/debugger/impl/frontend/EditorLineBreakpointsInfo;", "line", "", "(Lcom/intellij/openapi/editor/Editor;ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getBreakpointsInfoForLineFast", "getBreakpointsInfoForLineFast$intellij_platform_debugger_impl_frontend", "Companion", "intellij.platform.debugger.impl.frontend"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nFrontendEditorLinesBreakpointsInfoManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendEditorLinesBreakpointsInfoManager.kt\ncom/intellij/platform/debugger/impl/frontend/FrontendEditorLinesBreakpointsInfoManager\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,226:1\n23#2:227\n*S KotlinDebug\n*F\n+ 1 FrontendEditorLinesBreakpointsInfoManager.kt\ncom/intellij/platform/debugger/impl/frontend/FrontendEditorLinesBreakpointsInfoManager\n*L\n104#1:227\n*E\n"})
public final class FrontendEditorLinesBreakpointsInfoManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope cs;
    @NotNull
    private final ConcurrentHashMap<Editor, EditorBreakpointLinesInfoMap> editorsMap;

    public FrontendEditorLinesBreakpointsInfoManager(@NotNull Project project, @NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this.project = project;
        this.cs = cs;
        this.editorsMap = new ConcurrentHashMap();
        EditorFactory.getInstance().addEditorFactoryListener(new EditorFactoryListener(){

            public void editorCreated(EditorFactoryEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Editor editor = event.getEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
                Editor editor2 = editor;
                if (!Intrinsics.areEqual((Object)editor2.getProject(), (Object)project)) {
                    return;
                }
                this.putNewLinesInfoMap(editor2);
            }

            public void editorReleased(EditorFactoryEvent event) {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    Editor editor = event.getEditor();
                    Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
                    Editor editor2 = editor;
                    if (!Intrinsics.areEqual((Object)editor2.getProject(), (Object)project)) {
                        return;
                    }
                    EditorBreakpointLinesInfoMap editorBreakpointLinesInfoMap = (EditorBreakpointLinesInfoMap)editorsMap.remove(editor2);
                    if (editorBreakpointLinesInfoMap == null) break block1;
                    editorBreakpointLinesInfoMap.dispose();
                }
            }
        }, CoroutineScopeKt.asDisposable((CoroutineScope)this.cs));
        BuildersKt.launch$default((CoroutineScope)this.cs, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ FrontendEditorLinesBreakpointsInfoManager this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = CoroutinesKt.readAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$0(com.intellij.platform.debugger.impl.frontend.FrontendEditorLinesBreakpointsInfoManager ), ()Lkotlin/Unit;)((FrontendEditorLinesBreakpointsInfoManager)this.this$0), (Continuation)((Continuation)this));
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        this.label = 2;
                        v1 = CoroutinesKt.readAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$1(com.intellij.platform.debugger.impl.frontend.FrontendEditorLinesBreakpointsInfoManager ), ()Lkotlin/Unit;)((FrontendEditorLinesBreakpointsInfoManager)this.this$0), (Continuation)((Continuation)this));
                        if (v1 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl21
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl21:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Unit invokeSuspend$lambda$0(FrontendEditorLinesBreakpointsInfoManager this$0) {
                Editor[] editorArray = EditorFactory.getInstance().getAllEditors();
                Intrinsics.checkNotNullExpressionValue((Object)editorArray, (String)"getAllEditors(...)");
                for (Editor editor : editorArray) {
                    if (!Intrinsics.areEqual((Object)editor.getProject(), (Object)this$0.project)) continue;
                    Intrinsics.checkNotNull((Object)editor);
                    this$0.putNewLinesInfoMap(editor);
                }
                return Unit.INSTANCE;
            }

            private static final Unit invokeSuspend$lambda$1(FrontendEditorLinesBreakpointsInfoManager this$0) {
                Iterator iterator = ((ConcurrentHashMap.KeySetView)this$0.editorsMap.keySet()).iterator();
                Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
                Iterator iterator2 = iterator;
                while (iterator2.hasNext()) {
                    Editor editor = (Editor)iterator2.next();
                    if (!editor.isDisposed()) continue;
                    EditorBreakpointLinesInfoMap editorBreakpointLinesInfoMap = (EditorBreakpointLinesInfoMap)this$0.editorsMap.remove(editor);
                    if (editorBreakpointLinesInfoMap == null) continue;
                    editorBreakpointLinesInfoMap.dispose();
                }
                return Unit.INSTANCE;
            }
        }), (int)3, null);
    }

    private final EditorBreakpointLinesInfoMap putNewLinesInfoMap(Editor editor) {
        EditorBreakpointLinesInfoMap editorBreakpointLinesInfoMap;
        EditorBreakpointLinesInfoMap newMap = new EditorBreakpointLinesInfoMap(this.cs, editor, this.project);
        EditorBreakpointLinesInfoMap oldMap = this.editorsMap.putIfAbsent(editor, newMap);
        if (oldMap != null) {
            newMap.dispose();
        }
        if ((editorBreakpointLinesInfoMap = oldMap) == null) {
            editorBreakpointLinesInfoMap = newMap;
        }
        return editorBreakpointLinesInfoMap;
    }

    @Nullable
    public final Object getBreakpointsInfoForLine(@NotNull Editor editor, int line, @NotNull Continuation<? super EditorLineBreakpointsInfo> $completion) {
        EditorBreakpointLinesInfoMap editorBreakpointLinesInfoMap = this.editorsMap.get(editor);
        if (editorBreakpointLinesInfoMap == null) {
            editorBreakpointLinesInfoMap = this.putNewLinesInfoMap(editor);
        }
        EditorBreakpointLinesInfoMap editorMap = editorBreakpointLinesInfoMap;
        return editorMap.getBreakpointsInfoForLine(line, $completion);
    }

    @RequiresReadLock
    @Nullable
    public final EditorLineBreakpointsInfo getBreakpointsInfoForLineFast$intellij_platform_debugger_impl_frontend(@NotNull Editor editor, int line) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        if (!FrontendEditorLinesBreakpointsInfoManagerKt.access$getShouldPreloadMap$p()) {
            FrontendEditorLinesBreakpointsInfoManager $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(FrontendEditorLinesBreakpointsInfoManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("getBreakpointsInfoForLineInternal is unsafe to use in monolith mode, use getBreakpointsInfoForLine instead");
        }
        EditorBreakpointLinesInfoMap editorBreakpointLinesInfoMap = this.editorsMap.get(editor);
        if (editorBreakpointLinesInfoMap == null) {
            return null;
        }
        EditorBreakpointLinesInfoMap editorMap = editorBreakpointLinesInfoMap;
        long currentEditorStamp = editor.getDocument().getModificationStamp();
        return editorMap.getBreakpointsInfoForLineInternal(line, currentEditorStamp);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/platform/debugger/impl/frontend/FrontendEditorLinesBreakpointsInfoManager$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/platform/debugger/impl/frontend/FrontendEditorLinesBreakpointsInfoManager;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.debugger.impl.frontend"})
    @SourceDebugExtension(value={"SMAP\nFrontendEditorLinesBreakpointsInfoManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendEditorLinesBreakpointsInfoManager.kt\ncom/intellij/platform/debugger/impl/frontend/FrontendEditorLinesBreakpointsInfoManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,226:1\n30#2,2:227\n*S KotlinDebug\n*F\n+ 1 FrontendEditorLinesBreakpointsInfoManager.kt\ncom/intellij/platform/debugger/impl/frontend/FrontendEditorLinesBreakpointsInfoManager$Companion\n*L\n112#1:227,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FrontendEditorLinesBreakpointsInfoManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<FrontendEditorLinesBreakpointsInfoManager> serviceClass$iv = FrontendEditorLinesBreakpointsInfoManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (FrontendEditorLinesBreakpointsInfoManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

