/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.debugger.impl.shared;

import com.intellij.platform.debugger.impl.rpc.XDebuggerTreeNodeHyperlinkDto;
import com.intellij.platform.debugger.impl.rpc.XFullValueEvaluatorDto;
import com.intellij.platform.debugger.impl.rpc.XValueComputeChildrenEvent;
import com.intellij.platform.debugger.impl.rpc.XValueId;
import com.intellij.platform.debugger.impl.rpc.XValueSerializedPresentation;
import com.intellij.platform.debugger.impl.shared.XValueStateFlows;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0013J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0006R6\u0010\u0004\u001a*\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005j\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R:\u0010\n\u001a.\u0012\u0004\u0012\u00020\u0006\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b0\u0005j\u0016\u0012\u0004\u0012\u00020\u0006\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R:\u0010\r\u001a.\u0012\u0004\u0012\u00020\u0006\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u000b0\u0005j\u0016\u0012\u0004\u0012\u00020\u0006\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u000b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/platform/debugger/impl/shared/XValuesPresentationBuilder;", "", "<init>", "()V", "presentationFlows", "Ljava/util/HashMap;", "Lcom/intellij/platform/debugger/impl/rpc/XValueId;", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "Lcom/intellij/platform/debugger/impl/rpc/XValueSerializedPresentation;", "Lkotlin/collections/HashMap;", "fullValueEvaluatorFlows", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/intellij/platform/debugger/impl/rpc/XFullValueEvaluatorDto;", "additionalLinkFlows", "Lcom/intellij/platform/debugger/impl/rpc/XDebuggerTreeNodeHyperlinkDto;", "consume", "", "event", "Lcom/intellij/platform/debugger/impl/rpc/XValueComputeChildrenEvent$XValuePresentationEvent;", "Lcom/intellij/platform/debugger/impl/rpc/XValueComputeChildrenEvent$XValueFullValueEvaluatorEvent;", "Lcom/intellij/platform/debugger/impl/rpc/XValueComputeChildrenEvent$XValueAdditionalLinkEvent;", "createFlows", "Lcom/intellij/platform/debugger/impl/shared/XValueStateFlows;", "xValueId", "intellij.platform.debugger.impl.shared"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nXValuesPresentationBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XValuesPresentationBuilder.kt\ncom/intellij/platform/debugger/impl/shared/XValuesPresentationBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,55:1\n1#2:56\n*E\n"})
public final class XValuesPresentationBuilder {
    @NotNull
    private final HashMap<XValueId, MutableSharedFlow<XValueSerializedPresentation>> presentationFlows = new HashMap();
    @NotNull
    private final HashMap<XValueId, MutableStateFlow<XFullValueEvaluatorDto>> fullValueEvaluatorFlows = new HashMap();
    @NotNull
    private final HashMap<XValueId, MutableStateFlow<XDebuggerTreeNodeHyperlinkDto>> additionalLinkFlows = new HashMap();

    public final void consume(@NotNull XValueComputeChildrenEvent.XValuePresentationEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        MutableSharedFlow<XValueSerializedPresentation> flow = this.presentationFlows.get(event.getXValueId());
        if (flow == null) {
            boolean bl = false;
            String string = "Presentation event received for unknown XValueId: " + event.getXValueId();
            throw new IllegalStateException(string.toString());
        }
        flow.tryEmit((Object)event.getPresentation());
    }

    public final void consume(@NotNull XValueComputeChildrenEvent.XValueFullValueEvaluatorEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        MutableStateFlow<XFullValueEvaluatorDto> flow = this.fullValueEvaluatorFlows.get(event.getXValueId());
        if (flow == null) {
            boolean bl = false;
            String string = "Full value evaluator event received for unknown XValueId: " + event.getXValueId();
            throw new IllegalStateException(string.toString());
        }
        flow.setValue((Object)event.getFullValueEvaluator());
    }

    public final void consume(@NotNull XValueComputeChildrenEvent.XValueAdditionalLinkEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        MutableStateFlow<XDebuggerTreeNodeHyperlinkDto> flow = this.additionalLinkFlows.get(event.getXValueId());
        if (flow == null) {
            boolean bl = false;
            String string = "Additional link event received for unknown XValueId: " + event.getXValueId();
            throw new IllegalStateException(string.toString());
        }
        flow.setValue((Object)event.getLink());
    }

    @NotNull
    public final XValueStateFlows createFlows(@NotNull XValueId xValueId) {
        Intrinsics.checkNotNullParameter((Object)xValueId, (String)"xValueId");
        MutableSharedFlow presentationFlow = SharedFlowKt.MutableSharedFlow((int)1, (int)1, (BufferOverflow)BufferOverflow.DROP_OLDEST);
        MutableStateFlow fullValueEvaluatorFlow = StateFlowKt.MutableStateFlow(null);
        MutableStateFlow additionalLinkFlow = StateFlowKt.MutableStateFlow(null);
        ((Map)this.presentationFlows).put(xValueId, presentationFlow);
        ((Map)this.fullValueEvaluatorFlows).put(xValueId, fullValueEvaluatorFlow);
        ((Map)this.additionalLinkFlows).put(xValueId, additionalLinkFlow);
        return new XValueStateFlows((Flow<? extends XValueSerializedPresentation>)((Flow)FlowKt.asSharedFlow((MutableSharedFlow)presentationFlow)), (Flow<XFullValueEvaluatorDto>)((Flow)FlowKt.asStateFlow((MutableStateFlow)fullValueEvaluatorFlow)), (Flow<XDebuggerTreeNodeHyperlinkDto>)((Flow)FlowKt.asStateFlow((MutableStateFlow)additionalLinkFlow)));
    }
}

