/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.grpc.endpoints;

import com.intellij.httpClient.grpc.GrpcBundle;
import com.intellij.httpClient.grpc.HttpClientGrpcIcons;
import com.intellij.httpClient.grpc.ProtoFileUtilsKt;
import com.intellij.httpClient.grpc.endpoints.ProtoEndpointsModificationTracker;
import com.intellij.httpClient.grpc.endpoints.ProtoEndpointsProvider;
import com.intellij.httpClient.grpc.endpoints.ProtoUrlTargetInfo;
import com.intellij.httpClient.grpc.model.ProtoRpcModel;
import com.intellij.httpClient.grpc.model.ProtoServiceModel;
import com.intellij.microservices.endpoints.EndpointType;
import com.intellij.microservices.endpoints.EndpointTypes;
import com.intellij.microservices.endpoints.EndpointsFilter;
import com.intellij.microservices.endpoints.EndpointsProvider;
import com.intellij.microservices.endpoints.EndpointsUrlTargetProvider;
import com.intellij.microservices.endpoints.FrameworkPresentation;
import com.intellij.microservices.endpoints.SearchScopeEndpointsFilter;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.protobuf.lang.psi.PbServiceMethod;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u00132\u0006\u0010\u0017\u001a\u00020\u0002H\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u0003H\u0016J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u0003H\u0016J\u001a\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u0003H\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001e\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u00132\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u0003H\u0016J\b\u0010#\u001a\u00020\u0019H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006$"}, d2={"Lcom/intellij/httpClient/grpc/endpoints/ProtoEndpointsProvider;", "Lcom/intellij/microservices/endpoints/EndpointsUrlTargetProvider;", "Lcom/intellij/httpClient/grpc/model/ProtoServiceModel;", "Lcom/intellij/httpClient/grpc/model/ProtoRpcModel;", "<init>", "()V", "endpointType", "Lcom/intellij/microservices/endpoints/EndpointType;", "getEndpointType", "()Lcom/intellij/microservices/endpoints/EndpointType;", "presentation", "Lcom/intellij/microservices/endpoints/FrameworkPresentation;", "getPresentation", "()Lcom/intellij/microservices/endpoints/FrameworkPresentation;", "getStatus", "Lcom/intellij/microservices/endpoints/EndpointsProvider$Status;", "project", "Lcom/intellij/openapi/project/Project;", "getEndpointGroups", "", "filter", "Lcom/intellij/microservices/endpoints/EndpointsFilter;", "getEndpoints", "group", "isValidEndpoint", "", "endpoint", "getEndpointPresentation", "Lcom/intellij/navigation/ItemPresentation;", "getDocumentationElement", "Lcom/intellij/psi/PsiElement;", "getModificationTracker", "Lcom/intellij/openapi/util/ModificationTracker;", "getUrlTargetInfo", "Lcom/intellij/microservices/url/UrlTargetInfo;", "shouldShowOpenApiPanel", "intellij.httpClient.grpc"})
@SourceDebugExtension(value={"SMAP\nProtoEndpointsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProtoEndpointsProvider.kt\ncom/intellij/httpClient/grpc/endpoints/ProtoEndpointsProvider\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,80:1\n30#2,2:81\n*S KotlinDebug\n*F\n+ 1 ProtoEndpointsProvider.kt\ncom/intellij/httpClient/grpc/endpoints/ProtoEndpointsProvider\n*L\n65#1:81,2\n*E\n"})
public final class ProtoEndpointsProvider
implements EndpointsUrlTargetProvider<ProtoServiceModel, ProtoRpcModel> {
    @NotNull
    private final FrameworkPresentation presentation = new FrameworkPresentation("gRPC", GrpcBundle.INSTANCE.message("protobuf.specification", new Object[0]), null);

    @NotNull
    public EndpointType getEndpointType() {
        return EndpointTypes.API_DEFINITION_TYPE;
    }

    @NotNull
    public FrameworkPresentation getPresentation() {
        return this.presentation;
    }

    @NotNull
    public EndpointsProvider.Status getStatus(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"allScope(...)");
        return ProtoFileUtilsKt.hasAnyProtoFiles(globalSearchScope) ? EndpointsProvider.Status.HAS_ENDPOINTS : EndpointsProvider.Status.AVAILABLE;
    }

    @NotNull
    public Iterable<ProtoServiceModel> getEndpointGroups(@NotNull Project project, @NotNull EndpointsFilter filter) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        if (!(filter instanceof SearchScopeEndpointsFilter)) {
            return CollectionsKt.emptyList();
        }
        return SequencesKt.asIterable((Sequence)SequencesKt.flatMap(ProtoFileUtilsKt.getAllProtoFiles(((SearchScopeEndpointsFilter)filter).getContentSearchScope()), (Function1)((Function1)getEndpointGroups.1.INSTANCE)));
    }

    @NotNull
    public Iterable<ProtoRpcModel> getEndpoints(@NotNull ProtoServiceModel group) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        return SequencesKt.asIterable(group.getRpcModels());
    }

    public boolean isValidEndpoint(@NotNull ProtoServiceModel group, @NotNull ProtoRpcModel endpoint) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        return endpoint.isValid();
    }

    @NotNull
    public ItemPresentation getEndpointPresentation(@NotNull ProtoServiceModel group, @NotNull ProtoRpcModel endpoint) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        return new ItemPresentation(endpoint){
            final /* synthetic */ ProtoRpcModel $endpoint;
            {
                this.$endpoint = $endpoint;
            }

            public String getPresentableText() {
                return this.$endpoint.getName();
            }

            public Icon getIcon(boolean unused) {
                Icon icon = HttpClientGrpcIcons.Procedure;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Procedure");
                return icon;
            }

            public String getLocationString() {
                PbServiceMethod pbServiceMethod = this.$endpoint.getSourcePsi();
                return pbServiceMethod != null && (pbServiceMethod = pbServiceMethod.getContainingFile()) != null ? pbServiceMethod.getName() : null;
            }
        };
    }

    @Nullable
    public PsiElement getDocumentationElement(@NotNull ProtoServiceModel group, @NotNull ProtoRpcModel endpoint) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        return (PsiElement)endpoint.getSourcePsi();
    }

    @NotNull
    public ModificationTracker getModificationTracker(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<ProtoEndpointsModificationTracker> serviceClass$iv = ProtoEndpointsModificationTracker.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return (ModificationTracker)object;
    }

    @NotNull
    public Iterable<UrlTargetInfo> getUrlTargetInfo(@NotNull ProtoServiceModel group, @NotNull ProtoRpcModel endpoint) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        return CollectionsKt.listOf((Object)new ProtoUrlTargetInfo(group, endpoint));
    }

    public boolean shouldShowOpenApiPanel() {
        return false;
    }
}

