/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.ejs.file;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.LanguageSubstitutors;
import com.intellij.psi.MultiplePsiFilesPerDocumentFileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.templateLanguages.ConfigurableTemplateLanguageFileViewProvider;
import com.intellij.psi.templateLanguages.TemplateDataElementType;
import com.intellij.psi.templateLanguages.TemplateDataLanguageMappings;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.lang.ejs.EjsLanguage;
import com.jetbrains.lang.ejs.file.EjsJavascriptTemplateDataElementType;
import com.jetbrains.lang.ejs.psi.EjsTokenTypes;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EjsFileViewProvider
extends MultiplePsiFilesPerDocumentFileViewProvider
implements ConfigurableTemplateLanguageFileViewProvider {
    private final Language myTemplateDataLanguage;
    private static final TemplateDataElementType myTemplateDataElementType = new TemplateDataElementType("EJS_TEMPLATE_DATA", (Language)EjsLanguage.INSTANCE, EjsTokenTypes.OUTER_CONTENT, EjsTokenTypes.OUTER_TEMPLATE_ELEMENT);
    private static final EjsJavascriptTemplateDataElementType myJavaScriptTemplateDataElementType = new EjsJavascriptTemplateDataElementType();

    public EjsFileViewProvider(PsiManager manager, VirtualFile file, boolean physical) {
        this(manager, file, physical, EjsFileViewProvider.getTemplateDataLanguage(manager, file));
    }

    private EjsFileViewProvider(PsiManager manager, VirtualFile file, boolean physical, Language templateDataLanguage) {
        super(manager, file, physical);
        this.myTemplateDataLanguage = templateDataLanguage;
    }

    public boolean supportsIncrementalReparse(@NotNull Language rootLanguage) {
        if (rootLanguage == null) {
            EjsFileViewProvider.$$$reportNull$$$0(0);
        }
        return false;
    }

    private static Language getTemplateDataLanguage(PsiManager manager, VirtualFile file) {
        Language dataLang;
        TemplateDataLanguageMappings dataLanguageMappings = TemplateDataLanguageMappings.getInstance((Project)manager.getProject());
        Language language = dataLang = dataLanguageMappings != null ? dataLanguageMappings.getMapping(file) : null;
        if (dataLang == null) {
            dataLang = EjsLanguage.getDefaultTemplateLang().getLanguage();
        }
        Language substituteLang = LanguageSubstitutors.getInstance().substituteLanguage(dataLang, file, manager.getProject());
        if (TemplateDataLanguageMappings.getTemplateableLanguages().contains(substituteLang)) {
            dataLang = substituteLang;
        }
        return dataLang;
    }

    @NotNull
    public Language getBaseLanguage() {
        EjsLanguage ejsLanguage = EjsLanguage.INSTANCE;
        if (ejsLanguage == null) {
            EjsFileViewProvider.$$$reportNull$$$0(1);
        }
        return ejsLanguage;
    }

    @NotNull
    public Language getTemplateDataLanguage() {
        Language language = this.myTemplateDataLanguage;
        if (language == null) {
            EjsFileViewProvider.$$$reportNull$$$0(2);
        }
        return language;
    }

    @NotNull
    public Set<Language> getLanguages() {
        HashSet hashSet = ContainerUtil.newHashSet((Object[])new Language[]{EjsLanguage.INSTANCE, JavascriptLanguage.INSTANCE, this.myTemplateDataLanguage});
        if (hashSet == null) {
            EjsFileViewProvider.$$$reportNull$$$0(3);
        }
        return hashSet;
    }

    @NotNull
    protected MultiplePsiFilesPerDocumentFileViewProvider cloneInner(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            EjsFileViewProvider.$$$reportNull$$$0(4);
        }
        return new EjsFileViewProvider((PsiManager)this.getManager(), virtualFile, false, this.myTemplateDataLanguage);
    }

    protected PsiFile createFile(@NotNull Language lang) {
        ParserDefinition parserDefinition;
        if (lang == null) {
            EjsFileViewProvider.$$$reportNull$$$0(5);
        }
        if ((parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang)) == null) {
            return null;
        }
        if (this.getLanguages().contains(lang)) {
            PsiFileImpl file = (PsiFileImpl)parserDefinition.createFile((FileViewProvider)this);
            IElementType type = this.getContentElementType(lang);
            if (type != null) {
                file.setContentElementType(type);
            }
            return file;
        }
        return null;
    }

    @Nullable
    public IElementType getContentElementType(@NotNull Language language) {
        if (language == null) {
            EjsFileViewProvider.$$$reportNull$$$0(6);
        }
        if (language == this.myTemplateDataLanguage) {
            return myTemplateDataElementType;
        }
        if (language == JavascriptLanguage.INSTANCE) {
            return myJavaScriptTemplateDataElementType;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootLanguage";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/ejs/file/EjsFileViewProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lang";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/ejs/file/EjsFileViewProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseLanguage";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateDataLanguage";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "supportsIncrementalReparse";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "cloneInner";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getContentElementType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }
}

