/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.ejs.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.xml.SyntheticBlock;
import com.intellij.psi.formatter.xml.XmlBlock;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import com.intellij.psi.formatter.xml.XmlTagBlock;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.template.formatter.AbstractXmlTemplateFormattingModelBuilder;
import com.intellij.xml.template.formatter.TemplateXmlTagBlock;
import com.jetbrains.lang.ejs.formatter.EjsBlock;
import com.jetbrains.lang.ejs.formatter.EjsSyntheticBlock;
import com.jetbrains.lang.ejs.formatter.EjsSyntheticGroupBlock;
import com.jetbrains.lang.ejs.formatter.EjsTemplateLanguageBlock;
import com.jetbrains.lang.ejs.formatter.EjsTemplateXmlRootBlock;
import com.jetbrains.lang.ejs.formatter.settings.EjsCustomCodeStyleSettings;
import com.jetbrains.lang.ejs.psi.EjsPsiFile;
import com.jetbrains.lang.ejs.psi.EjsTokenTypes;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EjsFormattingModelBuilder
extends AbstractXmlTemplateFormattingModelBuilder {
    protected boolean isTemplateFile(PsiFile file) {
        return file instanceof EjsPsiFile;
    }

    public boolean isOuterLanguageElement(PsiElement element) {
        IElementType elementType = element.getNode().getElementType();
        return elementType == EjsTokenTypes.OUTER_TEMPLATE_ELEMENT;
    }

    public boolean isMarkupLanguageElement(PsiElement element) {
        return element.getNode().getElementType() == EjsTokenTypes.OUTER_CONTENT;
    }

    protected List<Block> afterMerge(List<Block> originalBlocks, boolean templateOnly, CodeStyleSettings settings, @NotNull XmlFormattingPolicy xmlFormattingPolicy) {
        if (xmlFormattingPolicy == null) {
            EjsFormattingModelBuilder.$$$reportNull$$$0(0);
        }
        EjsCustomCodeStyleSettings ejsSettings = (EjsCustomCodeStyleSettings)settings.getCustomSettings(EjsCustomCodeStyleSettings.class);
        if (!ejsSettings.INDENT_CONTROL_BLOCKS) {
            return originalBlocks;
        }
        ArrayList<Block> result = new ArrayList<Block>();
        ArrayDeque<BlockGroup> openBlocks = new ArrayDeque<BlockGroup>();
        for (Block block : originalBlocks) {
            BlockGroup group = openBlocks.peekFirst();
            TextRange range = EjsFormattingModelBuilder.getJSBlockStatementRange(block);
            while (group != null && !group.myJSBlockStatementRange.contains(block.getTextRange())) {
                Block resultBlock = EjsFormattingModelBuilder.closeGroupBlocks(openBlocks, block);
                ContainerUtil.addIfNotNull(result, (Object)resultBlock);
                group = openBlocks.peekFirst();
            }
            if (!range.isEmpty()) {
                openBlocks.addFirst(new BlockGroup(block, range));
                continue;
            }
            if (group == null) {
                result.add(block);
                continue;
            }
            group.myNestedBlocks.add(block);
        }
        Block lastBlock = EjsFormattingModelBuilder.closeGroupBlocks(openBlocks, null);
        ContainerUtil.addIfNotNull(result, (Object)lastBlock);
        return result;
    }

    private static Block closeGroupBlocks(@NotNull ArrayDeque<BlockGroup> openBlocks, @Nullable Block nextBlock) {
        if (openBlocks == null) {
            EjsFormattingModelBuilder.$$$reportNull$$$0(1);
        }
        while (!openBlocks.isEmpty()) {
            BlockGroup group = openBlocks.peekFirst();
            if (nextBlock != null && group.myJSBlockStatementRange.contains(nextBlock.getTextRange())) {
                return null;
            }
            BlockGroup toClose = openBlocks.removeFirst();
            Block groupBlock = toClose.toBlock();
            BlockGroup prevGroup = openBlocks.peekFirst();
            if (prevGroup == null) {
                return groupBlock;
            }
            ContainerUtil.addIfNotNull(prevGroup.myNestedBlocks, (Object)groupBlock);
        }
        return null;
    }

    public static boolean afterOpenBlock(@NotNull List<? extends Block> blocks, int newChildIndex) {
        if (blocks == null) {
            EjsFormattingModelBuilder.$$$reportNull$$$0(2);
        }
        if (newChildIndex <= 0 || newChildIndex > blocks.size()) {
            return false;
        }
        int prevBlock = newChildIndex - 1;
        Block prev = blocks.get(prevBlock);
        TextRange range = EjsFormattingModelBuilder.getJSBlockStatementRange(prev);
        return !range.isEmpty();
    }

    @NotNull
    public static TextRange getJSBlockStatementRange(@NotNull Block block) {
        if (block == null) {
            EjsFormattingModelBuilder.$$$reportNull$$$0(3);
        }
        if (!(block instanceof EjsTemplateLanguageBlock)) {
            TextRange textRange = TextRange.EMPTY_RANGE;
            if (textRange == null) {
                EjsFormattingModelBuilder.$$$reportNull$$$0(4);
            }
            return textRange;
        }
        ASTNode node = ((EjsTemplateLanguageBlock)block).getNode();
        TextRange textRange = EjsFormattingModelBuilder.getJSBlockStatementRange(node);
        if (textRange == null) {
            EjsFormattingModelBuilder.$$$reportNull$$$0(5);
        }
        return textRange;
    }

    public static TextRange getJSBlockStatementRange(ASTNode node) {
        boolean isBlockLike = EjsFormattingModelBuilder.isSimpleTemplateBlockNode(node);
        if (!isBlockLike) {
            return TextRange.EMPTY_RANGE;
        }
        PsiElement psi = node.getPsi();
        FileViewProvider provider = psi.getContainingFile().getViewProvider();
        Set languages = provider.getLanguages();
        if (languages.size() != 3) {
            return TextRange.EMPTY_RANGE;
        }
        for (Language language : languages) {
            PsiElement parent;
            if (!language.isKindOf((Language)JavascriptLanguage.INSTANCE)) continue;
            int rangeStart = node.getStartOffset() + node.getTextLength();
            PsiElement element = provider.findElementAt(rangeStart, language);
            if (element == null) {
                return TextRange.EMPTY_RANGE;
            }
            PsiElement prev = PsiTreeUtil.skipWhitespacesBackward((PsiElement)element);
            if (prev == null) {
                return TextRange.EMPTY_RANGE;
            }
            if (prev.getNode().getElementType() != JSTokenTypes.LBRACE || !((parent = element.getParent()) instanceof JSBlockStatement)) break;
            return parent.getTextRange();
        }
        return TextRange.EMPTY_RANGE;
    }

    private static boolean isSimpleTemplateBlockNode(@NotNull ASTNode node) {
        if (node == null) {
            EjsFormattingModelBuilder.$$$reportNull$$$0(6);
        }
        ASTNode lastChild = node.getLastChildNode();
        ASTNode firstChild = node.getFirstChildNode();
        boolean isOpen = firstChild != null && firstChild.getElementType() == EjsTokenTypes.OPEN;
        boolean isClose = lastChild != null && lastChild.getElementType() == EjsTokenTypes.CLOSE;
        return isOpen && isClose;
    }

    protected Block createTemplateLanguageBlock(ASTNode node, CodeStyleSettings settings, XmlFormattingPolicy xmlFormattingPolicy, Indent indent, @Nullable Alignment alignment, @Nullable Wrap wrap) {
        return new EjsTemplateLanguageBlock(this, node, wrap, alignment, settings, xmlFormattingPolicy, indent);
    }

    protected XmlBlock createXmlBlock(ASTNode node, @Nullable Wrap wrap, @Nullable Alignment alignment, XmlFormattingPolicy policy, @Nullable Indent indent, @Nullable TextRange textRange) {
        return new EjsTemplateXmlRootBlock(this, node, wrap, alignment, policy, indent, textRange);
    }

    protected XmlTagBlock createXmlTagBlock(ASTNode node, @Nullable Wrap wrap, @Nullable Alignment alignment, XmlFormattingPolicy policy, @Nullable Indent indent) {
        return new EjsTemplateXmlTagBlock(this, node, wrap, alignment, policy, indent);
    }

    protected SyntheticBlock createSyntheticBlock(List<Block> subBlocks, Block parent, Indent indent, XmlFormattingPolicy policy, Indent childIndent) {
        return new EjsSyntheticBlock(subBlocks, parent, indent, policy, childIndent);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlFormattingPolicy";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "openBlocks";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blocks";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/ejs/formatter/EjsFormattingModelBuilder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/ejs/formatter/EjsFormattingModelBuilder";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getJSBlockStatementRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "afterMerge";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "closeGroupBlocks";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "afterOpenBlock";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getJSBlockStatementRange";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isSimpleTemplateBlockNode";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5 -> new IllegalStateException(string);
        };
    }

    static final class BlockGroup {
        @NotNull
        private final Block myOpenBlock;
        @NotNull
        private final List<Block> myNestedBlocks;
        @NotNull
        private final TextRange myJSBlockStatementRange;

        private BlockGroup(@NotNull Block block, @NotNull TextRange range) {
            if (block == null) {
                BlockGroup.$$$reportNull$$$0(0);
            }
            if (range == null) {
                BlockGroup.$$$reportNull$$$0(1);
            }
            this.myOpenBlock = block;
            this.myNestedBlocks = new SmartList();
            this.myJSBlockStatementRange = range;
        }

        @NotNull
        private Block toBlock() {
            if (this.myNestedBlocks.isEmpty()) {
                Block block = this.myOpenBlock;
                if (block == null) {
                    BlockGroup.$$$reportNull$$$0(2);
                }
                return block;
            }
            List<Block> childBlocks = Collections.unmodifiableList(this.myNestedBlocks);
            EjsSyntheticGroupBlock childrenBlock = new EjsSyntheticGroupBlock(childBlocks, Indent.getNormalIndent(), true);
            return new EjsSyntheticGroupBlock(List.of(this.myOpenBlock, childrenBlock), Indent.getNoneIndent(), false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "block";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/lang/ejs/formatter/EjsFormattingModelBuilder$BlockGroup";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/lang/ejs/formatter/EjsFormattingModelBuilder$BlockGroup";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toBlock";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private class EjsTemplateXmlTagBlock
    extends TemplateXmlTagBlock {
        EjsTemplateXmlTagBlock(EjsFormattingModelBuilder ejsFormattingModelBuilder, ASTNode node, Wrap wrap, Alignment alignment, XmlFormattingPolicy policy, Indent indent) {
            super((AbstractXmlTemplateFormattingModelBuilder)ejsFormattingModelBuilder, node, wrap, alignment, policy, indent);
        }

        public Spacing getSpacing(Block child1, @NotNull Block child2) {
            EjsBlock block;
            if (child2 == null) {
                EjsTemplateXmlTagBlock.$$$reportNull$$$0(0);
            }
            if (child1 instanceof EjsSyntheticBlock && ((EjsSyntheticBlock)child1).endsWithEjsBlock() && (block = (EjsBlock)((EjsSyntheticBlock)child1).lastBlock()) != null && !block.startsWithEQ()) {
                return Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)false, (int)1);
            }
            if (child2 instanceof EjsSyntheticBlock && ((EjsSyntheticBlock)child2).startsWithEjsBlock() && (block = (EjsBlock)((EjsSyntheticBlock)child2).firstBlock()) != null && !block.startsWithEQ()) {
                return Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)false, (int)1);
            }
            return super.getSpacing(child1, child2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child2", "com/jetbrains/lang/ejs/formatter/EjsFormattingModelBuilder$EjsTemplateXmlTagBlock", "getSpacing"));
        }
    }
}

