/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates;

import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplatesScheme;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Key;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class FileTemplateManager {
    public static final Key<Properties> DEFAULT_TEMPLATE_PROPERTIES = Key.create((String)"DEFAULT_TEMPLATE_PROPERTIES");
    public static final int RECENT_TEMPLATES_SIZE = 25;
    @NonNls
    public static final String INTERNAL_HTML5_TEMPLATE_NAME = "HTML File";
    @NonNls
    public static final String FILE_HEADER_TEMPLATE_NAME = "File Header";
    public static final String DEFAULT_TEMPLATES_CATEGORY = "Default";
    public static final String INTERNAL_TEMPLATES_CATEGORY = "Internal";
    public static final String INCLUDES_TEMPLATES_CATEGORY = "Includes";
    public static final String CODE_TEMPLATES_CATEGORY = "Code";
    public static final String J2EE_TEMPLATES_CATEGORY = "J2EE";
    public static final String PROJECT_NAME_VARIABLE = "PROJECT_NAME";
    protected static final String PROJECT_CONTEXT_VARIABLE = "__PROJECT__";

    public static FileTemplateManager getInstance(@NotNull Project project) {
        if (project == null) {
            FileTemplateManager.$$$reportNull$$$0(0);
        }
        return ((FileTemplateManager)project.getService(FileTemplateManager.class)).checkInitialized();
    }

    @NotNull
    protected FileTemplateManager checkInitialized() {
        FileTemplateManager fileTemplateManager = this;
        if (fileTemplateManager == null) {
            FileTemplateManager.$$$reportNull$$$0(1);
        }
        return fileTemplateManager;
    }

    @Deprecated
    public static FileTemplateManager getInstance() {
        return FileTemplateManager.getDefaultInstance();
    }

    public static FileTemplateManager getDefaultInstance() {
        return FileTemplateManager.getInstance(ProjectManager.getInstance().getDefaultProject());
    }

    @NotNull
    public abstract FileTemplatesScheme getCurrentScheme();

    public abstract void setCurrentScheme(@NotNull FileTemplatesScheme var1);

    public abstract FileTemplatesScheme getProjectScheme();

    public abstract FileTemplate @NotNull [] getTemplates(@NotNull String var1);

    public abstract FileTemplate @NotNull [] getAllTemplates();

    public abstract FileTemplate getTemplate(@NotNull @NonNls String var1);

    @NotNull
    public abstract Properties getDefaultProperties();

    @NotNull
    public Map<String, Object> getDefaultContextMap() {
        return new HashMap<Object, Object>(this.getDefaultProperties());
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public Properties getDefaultProperties(@NotNull Project project) {
        if (project == null) {
            FileTemplateManager.$$$reportNull$$$0(2);
        }
        Properties properties = this.getDefaultProperties();
        properties.setProperty(PROJECT_NAME_VARIABLE, project.getName());
        Properties properties2 = properties;
        if (properties2 == null) {
            FileTemplateManager.$$$reportNull$$$0(3);
        }
        return properties2;
    }

    @NotNull
    public abstract FileTemplate addTemplate(@NotNull @NonNls String var1, @NotNull @NonNls String var2);

    public abstract void removeTemplate(@NotNull FileTemplate var1);

    @NotNull
    public abstract Collection<String> getRecentNames();

    public abstract void addRecentName(@NotNull @NonNls String var1);

    @NotNull
    public abstract FileTemplate getInternalTemplate(@NotNull @NonNls String var1);

    public abstract FileTemplate findInternalTemplate(@NotNull @NonNls String var1);

    public abstract FileTemplate @NotNull [] getInternalTemplates();

    @NotNull
    public abstract FileTemplate getJ2eeTemplate(@NotNull @NonNls String var1);

    @NotNull
    public abstract FileTemplate getCodeTemplate(@NotNull @NonNls String var1);

    public abstract FileTemplate @NotNull [] getAllPatterns();

    public abstract FileTemplate @NotNull [] getAllCodeTemplates();

    public abstract FileTemplate @NotNull [] getAllJ2eeTemplates();

    @NotNull
    public abstract String internalTemplateToSubject(@NotNull @NonNls String var1);

    public abstract FileTemplate getPattern(@NotNull @NonNls String var1);

    @NotNull
    public abstract FileTemplate getDefaultTemplate(@NotNull @NonNls String var1);

    public abstract void setTemplates(@NotNull String var1, @NotNull Collection<? extends FileTemplate> var2);

    public abstract void saveAllTemplates();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/fileTemplates/FileTemplateManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/fileTemplates/FileTemplateManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "checkInitialized";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultProperties";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3 -> new IllegalStateException(string);
        };
    }
}

