/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.comparison;

import com.intellij.diff.comparison.ByWordRt;
import com.intellij.diff.comparison.CancellationChecker;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.comparison.ComparisonUtil;
import com.intellij.diff.comparison.iterables.FairDiffIterable;
import com.intellij.diff.util.Range;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\n\b\u0000\u0018\u0000 &2\u00020\u0001:\u0003$%&BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J0\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010!\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u0011H\u0002J\u0010\u0010#\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/intellij/diff/comparison/LineFragmentSplitter;", "", "myText1", "", "myText2", "myWords1", "", "Lcom/intellij/diff/comparison/ByWordRt$InlineChunk;", "myWords2", "myIterable", "Lcom/intellij/diff/comparison/iterables/FairDiffIterable;", "myIndicator", "Lcom/intellij/diff/comparison/CancellationChecker;", "<init>", "(Ljava/lang/CharSequence;Ljava/lang/CharSequence;Ljava/util/List;Ljava/util/List;Lcom/intellij/diff/comparison/iterables/FairDiffIterable;Lcom/intellij/diff/comparison/CancellationChecker;)V", "myResult", "", "Lcom/intellij/diff/comparison/LineFragmentSplitter$WordBlock;", "last1", "", "last2", "pendingChunk", "Lcom/intellij/diff/comparison/LineFragmentSplitter$PendingChunk;", "run", "addLineChunk", "", "end1", "end2", "hasEqualWords", "", "createChunk", "start1", "start2", "isEqualsIgnoreWhitespace", "block", "hasWordsInside", "WordBlock", "PendingChunk", "Companion", "intellij.platform.util.diff"})
public final class LineFragmentSplitter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CharSequence myText1;
    @NotNull
    private final CharSequence myText2;
    @NotNull
    private final List<ByWordRt.InlineChunk> myWords1;
    @NotNull
    private final List<ByWordRt.InlineChunk> myWords2;
    @NotNull
    private final FairDiffIterable myIterable;
    @NotNull
    private final CancellationChecker myIndicator;
    @NotNull
    private final List<WordBlock> myResult;
    private int last1;
    private int last2;
    @Nullable
    private PendingChunk pendingChunk;

    public LineFragmentSplitter(@NotNull CharSequence myText1, @NotNull CharSequence myText2, @NotNull List<? extends ByWordRt.InlineChunk> myWords1, @NotNull List<? extends ByWordRt.InlineChunk> myWords2, @NotNull FairDiffIterable myIterable, @NotNull CancellationChecker myIndicator) {
        Intrinsics.checkNotNullParameter((Object)myText1, (String)"myText1");
        Intrinsics.checkNotNullParameter((Object)myText2, (String)"myText2");
        Intrinsics.checkNotNullParameter(myWords1, (String)"myWords1");
        Intrinsics.checkNotNullParameter(myWords2, (String)"myWords2");
        Intrinsics.checkNotNullParameter((Object)myIterable, (String)"myIterable");
        Intrinsics.checkNotNullParameter((Object)myIndicator, (String)"myIndicator");
        this.myText1 = myText1;
        this.myText2 = myText2;
        this.myWords1 = myWords1;
        this.myWords2 = myWords2;
        this.myIterable = myIterable;
        this.myIndicator = myIndicator;
        this.myResult = new ArrayList();
        this.last1 = -1;
        this.last2 = -1;
    }

    @NotNull
    public final List<WordBlock> run() {
        block4: {
            boolean hasEqualWords = false;
            for (Range range : this.myIterable.iterateUnchanged()) {
                int count = range.end1 - range.start1;
                for (int i = 0; i < count; ++i) {
                    int index1 = range.start1 + i;
                    int index2 = range.start2 + i;
                    if (LineFragmentSplitter.Companion.isNewline(this.myWords1, index1) && LineFragmentSplitter.Companion.isNewline(this.myWords2, index2)) {
                        this.addLineChunk(index1, index2, hasEqualWords);
                        hasEqualWords = false;
                        continue;
                    }
                    if (LineFragmentSplitter.Companion.isFirstInLine(this.myWords1, index1) && LineFragmentSplitter.Companion.isFirstInLine(this.myWords2, index2)) {
                        this.addLineChunk(index1 - 1, index2 - 1, hasEqualWords);
                        hasEqualWords = false;
                    }
                    hasEqualWords = true;
                }
            }
            this.addLineChunk(this.myWords1.size(), this.myWords2.size(), hasEqualWords);
            PendingChunk pendingChunk = this.pendingChunk;
            if (pendingChunk == null) break block4;
            PendingChunk it = pendingChunk;
            boolean bl = false;
            this.myResult.add(it.getBlock());
        }
        return this.myResult;
    }

    private final void addLineChunk(int end1, int end2, boolean hasEqualWords) {
        PendingChunk pendingChunk;
        block8: {
            LineFragmentSplitter it;
            LineFragmentSplitter lineFragmentSplitter;
            LineFragmentSplitter lineFragmentSplitter2;
            PendingChunk chunk;
            block7: {
                PendingChunk pendingChunk2;
                if (this.last1 > end1 || this.last2 > end2) {
                    return;
                }
                chunk = this.createChunk(this.last1, this.last2, end1, end2, hasEqualWords);
                if (chunk.getBlock().getOffsets().isEmpty()) {
                    return;
                }
                lineFragmentSplitter2 = this;
                pendingChunk = this.pendingChunk;
                if (pendingChunk == null) break block7;
                PendingChunk pendingChunk3 = pendingChunk;
                lineFragmentSplitter = lineFragmentSplitter2;
                boolean bl = false;
                if (LineFragmentSplitter.Companion.shouldMergeChunks((PendingChunk)((Object)it), chunk)) {
                    pendingChunk2 = LineFragmentSplitter.Companion.mergeChunks((PendingChunk)((Object)it), chunk);
                } else {
                    this.myResult.add(((PendingChunk)((Object)it)).getBlock());
                    pendingChunk2 = chunk;
                }
                lineFragmentSplitter2 = lineFragmentSplitter;
                pendingChunk = pendingChunk2;
                if (pendingChunk2 != null) break block8;
            }
            it = this;
            lineFragmentSplitter = lineFragmentSplitter2;
            boolean bl = false;
            pendingChunk = chunk;
            lineFragmentSplitter2 = lineFragmentSplitter;
        }
        lineFragmentSplitter2.pendingChunk = pendingChunk;
        this.last1 = end1;
        this.last2 = end2;
    }

    private final PendingChunk createChunk(int start1, int start2, int end1, int end2, boolean hasEqualWords) {
        int startOffset1 = LineFragmentSplitter.Companion.getOffset(this.myWords1, this.myText1, start1);
        int startOffset2 = LineFragmentSplitter.Companion.getOffset(this.myWords2, this.myText2, start2);
        int endOffset1 = LineFragmentSplitter.Companion.getOffset(this.myWords1, this.myText1, end1);
        int endOffset2 = LineFragmentSplitter.Companion.getOffset(this.myWords2, this.myText2, end2);
        int start12 = Math.max(0, start1 + 1);
        int start22 = Math.max(0, start2 + 1);
        int end12 = Math.min(end1 + 1, this.myWords1.size());
        int end22 = Math.min(end2 + 1, this.myWords2.size());
        WordBlock block = new WordBlock(new Range(start12, end12, start22, end22), new Range(startOffset1, endOffset1, startOffset2, endOffset2));
        return new PendingChunk(block, hasEqualWords, this.hasWordsInside(block), this.isEqualsIgnoreWhitespace(block));
    }

    private final boolean isEqualsIgnoreWhitespace(WordBlock block) {
        CharSequence sequence1 = this.myText1.subSequence(block.getOffsets().start1, block.getOffsets().end1);
        CharSequence sequence2 = this.myText2.subSequence(block.getOffsets().start2, block.getOffsets().end2);
        return ComparisonUtil.isEquals(sequence1, sequence2, ComparisonPolicy.IGNORE_WHITESPACES);
    }

    private final boolean hasWordsInside(WordBlock block) {
        int i;
        int n = block.getWords().end1;
        for (i = block.getWords().start1; i < n; ++i) {
            if (this.myWords1.get(i) instanceof ByWordRt.NewlineChunk) continue;
            return true;
        }
        n = block.getWords().end2;
        for (i = block.getWords().start2; i < n; ++i) {
            if (this.myWords2.get(i) instanceof ByWordRt.NewlineChunk) continue;
            return true;
        }
        return false;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002J\u0018\u0010\t\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002J&\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000bH\u0002J\u001e\u0010\u0012\u001a\u00020\u00052\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0011\u001a\u00020\u000bH\u0002J\u001e\u0010\u0014\u001a\u00020\u00052\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0011\u001a\u00020\u000bH\u0002\u00a8\u0006\u0015"}, d2={"Lcom/intellij/diff/comparison/LineFragmentSplitter$Companion;", "", "<init>", "()V", "shouldMergeChunks", "", "chunk1", "Lcom/intellij/diff/comparison/LineFragmentSplitter$PendingChunk;", "chunk2", "mergeChunks", "getOffset", "", "words", "", "Lcom/intellij/diff/comparison/ByWordRt$InlineChunk;", "text", "", "index", "isNewline", "words1", "isFirstInLine", "intellij.platform.util.diff"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean shouldMergeChunks(PendingChunk chunk1, PendingChunk chunk2) {
            if (!chunk1.getHasEqualWords() && !chunk2.getHasEqualWords()) {
                return true;
            }
            if (chunk1.isEqualIgnoreWhitespaces() && chunk2.isEqualIgnoreWhitespaces()) {
                return true;
            }
            return !chunk1.getHasWordsInside() || !chunk2.getHasWordsInside();
        }

        private final PendingChunk mergeChunks(PendingChunk chunk1, PendingChunk chunk2) {
            WordBlock block1 = chunk1.getBlock();
            WordBlock block2 = chunk2.getBlock();
            WordBlock newBlock = new WordBlock(new Range(block1.getWords().start1, block2.getWords().end1, block1.getWords().start2, block2.getWords().end2), new Range(block1.getOffsets().start1, block2.getOffsets().end1, block1.getOffsets().start2, block2.getOffsets().end2));
            return new PendingChunk(newBlock, chunk1.getHasEqualWords() || chunk2.getHasEqualWords(), chunk1.getHasWordsInside() || chunk2.getHasWordsInside(), chunk1.isEqualIgnoreWhitespaces() && chunk2.isEqualIgnoreWhitespaces());
        }

        private final int getOffset(List<? extends ByWordRt.InlineChunk> words, CharSequence text, int index) {
            if (index == -1) {
                return 0;
            }
            if (index == words.size()) {
                return text.length();
            }
            ByWordRt.InlineChunk chunk = words.get(index);
            if (!(chunk instanceof ByWordRt.NewlineChunk)) {
                throw new IllegalStateException("Check failed.");
            }
            return ((ByWordRt.NewlineChunk)chunk).getOffset2();
        }

        private final boolean isNewline(List<? extends ByWordRt.InlineChunk> words1, int index) {
            return words1.get(index) instanceof ByWordRt.NewlineChunk;
        }

        private final boolean isFirstInLine(List<? extends ByWordRt.InlineChunk> words1, int index) {
            if (index == 0) {
                return true;
            }
            return words1.get(index - 1) instanceof ByWordRt.NewlineChunk;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\r\u00a8\u0006\u000f"}, d2={"Lcom/intellij/diff/comparison/LineFragmentSplitter$PendingChunk;", "", "block", "Lcom/intellij/diff/comparison/LineFragmentSplitter$WordBlock;", "hasEqualWords", "", "hasWordsInside", "isEqualIgnoreWhitespaces", "<init>", "(Lcom/intellij/diff/comparison/LineFragmentSplitter$WordBlock;ZZZ)V", "getBlock", "()Lcom/intellij/diff/comparison/LineFragmentSplitter$WordBlock;", "getHasEqualWords", "()Z", "getHasWordsInside", "intellij.platform.util.diff"})
    private static final class PendingChunk {
        @NotNull
        private final WordBlock block;
        private final boolean hasEqualWords;
        private final boolean hasWordsInside;
        private final boolean isEqualIgnoreWhitespaces;

        public PendingChunk(@NotNull WordBlock block, boolean hasEqualWords, boolean hasWordsInside, boolean isEqualIgnoreWhitespaces) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            this.block = block;
            this.hasEqualWords = hasEqualWords;
            this.hasWordsInside = hasWordsInside;
            this.isEqualIgnoreWhitespaces = isEqualIgnoreWhitespaces;
        }

        @NotNull
        public final WordBlock getBlock() {
            return this.block;
        }

        public final boolean getHasEqualWords() {
            return this.hasEqualWords;
        }

        public final boolean getHasWordsInside() {
            return this.hasWordsInside;
        }

        public final boolean isEqualIgnoreWhitespaces() {
            return this.isEqualIgnoreWhitespaces;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\n"}, d2={"Lcom/intellij/diff/comparison/LineFragmentSplitter$WordBlock;", "", "words", "Lcom/intellij/diff/util/Range;", "offsets", "<init>", "(Lcom/intellij/diff/util/Range;Lcom/intellij/diff/util/Range;)V", "getWords", "()Lcom/intellij/diff/util/Range;", "getOffsets", "intellij.platform.util.diff"})
    public static final class WordBlock {
        @NotNull
        private final Range words;
        @NotNull
        private final Range offsets;

        public WordBlock(@NotNull Range words, @NotNull Range offsets) {
            Intrinsics.checkNotNullParameter((Object)words, (String)"words");
            Intrinsics.checkNotNullParameter((Object)offsets, (String)"offsets");
            this.words = words;
            this.offsets = offsets;
        }

        @NotNull
        public final Range getWords() {
            return this.words;
        }

        @NotNull
        public final Range getOffsets() {
            return this.offsets;
        }
    }
}

