/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.comparison.iterables;

import com.intellij.diff.comparison.CancellationChecker;
import com.intellij.diff.comparison.DiffTooBigException;
import com.intellij.diff.comparison.TrimUtil;
import com.intellij.diff.comparison.iterables.DiffChangeDiffIterable;
import com.intellij.diff.comparison.iterables.DiffFragmentsDiffIterable;
import com.intellij.diff.comparison.iterables.DiffIterable;
import com.intellij.diff.comparison.iterables.ExpandedDiffIterable;
import com.intellij.diff.comparison.iterables.FairDiffIterable;
import com.intellij.diff.comparison.iterables.FairDiffIterableWrapper;
import com.intellij.diff.comparison.iterables.InvertedDiffIterableWrapper;
import com.intellij.diff.comparison.iterables.RangesDiffIterable;
import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.util.Range;
import com.intellij.util.containers.PeekableIteratorWrapper;
import com.intellij.util.diff.Diff;
import com.intellij.util.diff.FilesTooBigForDiffException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u00056789:B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0007J7\u0010\u0006\u001a\u00020\u0007\"\u0004\b\u0000\u0010\r2\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\r0\u000e2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\r0\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0007\u00a2\u0006\u0002\u0010\u000fJ2\u0010\u0006\u001a\u00020\u0007\"\u0004\b\u0000\u0010\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\r0\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\r0\u00112\u0006\u0010\u000b\u001a\u00020\fH\u0007J\"\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0007J&\u0010\u001a\u001a\u00020\u00142\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0007J+\u0010\u0013\u001a\u00020\u00142\u0011\u0010\u001d\u001a\r\u0012\t\u0012\u00070\u001e\u00a2\u0006\u0002\b\u001f0\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0007J&\u0010 \u001a\u00020\u00142\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0007J\u0010\u0010!\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020\u0014H\u0007J\u0010\u0010#\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u0014H\u0007J0\u0010$\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020\u00142\u0006\u0010%\u001a\u00020\u00182\u0006\u0010&\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0007J\"\u0010'\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u00050)0(2\u0006\u0010\"\u001a\u00020\u0014H\u0007J\u0010\u0010*\u001a\u00020\u00182\u0006\u0010+\u001a\u00020\u001eH\u0007J\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u0005H\u0007J\b\u0010/\u001a\u00020\u0005H\u0002J\u0010\u00100\u001a\u00020-2\u0006\u0010\"\u001a\u00020\u0014H\u0007J\u0010\u00101\u001a\u00020-2\u0006\u0010\"\u001a\u00020\u0014H\u0007J\u0016\u00100\u001a\u00020-2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001e0(H\u0002J\u0010\u00102\u001a\u00020-2\u0006\u0010\"\u001a\u00020\u0014H\u0002J<\u00103\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030504\"\u0004\b\u0000\u0010\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\r0\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\r0\u00112\u0006\u0010\"\u001a\u00020\u0014H\u0007R\u0012\u0010\u0004\u001a\u00020\u00058\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lcom/intellij/diff/comparison/iterables/DiffIterableUtil;", "", "<init>", "()V", "SHOULD_VERIFY_ITERABLE", "", "diff", "Lcom/intellij/diff/comparison/iterables/FairDiffIterable;", "data1", "", "data2", "indicator", "Lcom/intellij/diff/comparison/CancellationChecker;", "T", "", "([Ljava/lang/Object;[Ljava/lang/Object;Lcom/intellij/diff/comparison/CancellationChecker;)Lcom/intellij/diff/comparison/iterables/FairDiffIterable;", "objects1", "", "objects2", "create", "Lcom/intellij/diff/comparison/iterables/DiffIterable;", "change", "Lcom/intellij/util/diff/Diff$Change;", "length1", "", "length2", "createFragments", "fragments", "Lcom/intellij/diff/fragments/DiffFragment;", "ranges", "Lcom/intellij/diff/util/Range;", "Lkotlin/jvm/JvmWildcard;", "createUnchanged", "invert", "iterable", "fair", "expandedIterable", "offset1", "offset2", "iterateAll", "", "Lkotlin/Pair;", "getRangeDelta", "range", "setVerifyEnabled", "", "value", "isVerifyEnabled", "verify", "verifyFair", "verifyFullCover", "extractDataRanges", "", "Lcom/intellij/diff/comparison/iterables/DiffIterableUtil$LineRangeData;", "ChangeBuilderBase", "ChangeBuilder", "ExpandChangeBuilder", "LineRangeData", "AllRangesIterator", "intellij.platform.util.diff"})
@SourceDebugExtension(value={"SMAP\nDiffIterableUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiffIterableUtil.kt\ncom/intellij/diff/comparison/iterables/DiffIterableUtil\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,349:1\n37#2,2:350\n*S KotlinDebug\n*F\n+ 1 DiffIterableUtil.kt\ncom/intellij/diff/comparison/iterables/DiffIterableUtil\n*L\n68#1:350,2\n*E\n"})
public final class DiffIterableUtil {
    @NotNull
    public static final DiffIterableUtil INSTANCE = new DiffIterableUtil();
    @TestOnly
    private static boolean SHOULD_VERIFY_ITERABLE;

    private DiffIterableUtil() {
    }

    @JvmStatic
    @NotNull
    public static final FairDiffIterable diff(@NotNull int[] data1, @NotNull int[] data2, @NotNull CancellationChecker indicator) throws DiffTooBigException {
        Intrinsics.checkNotNullParameter((Object)data1, (String)"data1");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data2");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        indicator.checkCanceled();
        try {
            Diff.Change change = Diff.buildChanges(data1, data2);
            return DiffIterableUtil.fair(DiffIterableUtil.create(change, data1.length, data2.length));
        }
        catch (FilesTooBigForDiffException filesTooBigForDiffException) {
            throw new DiffTooBigException();
        }
    }

    @JvmStatic
    @NotNull
    public static final <T> FairDiffIterable diff(@NotNull T[] data1, @NotNull T[] data2, @NotNull CancellationChecker indicator) throws DiffTooBigException {
        Intrinsics.checkNotNullParameter(data1, (String)"data1");
        Intrinsics.checkNotNullParameter(data2, (String)"data2");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        indicator.checkCanceled();
        try {
            Diff.Change change = Diff.buildChanges(data1, data2);
            return DiffIterableUtil.fair(DiffIterableUtil.create(change, data1.length, data2.length));
        }
        catch (FilesTooBigForDiffException filesTooBigForDiffException) {
            throw new DiffTooBigException();
        }
    }

    @JvmStatic
    @NotNull
    public static final <T> FairDiffIterable diff(@NotNull List<? extends T> objects1, @NotNull List<? extends T> objects2, @NotNull CancellationChecker indicator) throws DiffTooBigException {
        Intrinsics.checkNotNullParameter(objects1, (String)"objects1");
        Intrinsics.checkNotNullParameter(objects2, (String)"objects2");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Collection $this$toTypedArray$iv = objects1;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Object[] objectArray = thisCollection$iv.toArray(new Object[0]);
        $this$toTypedArray$iv = objects2;
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        return DiffIterableUtil.diff(objectArray, thisCollection$iv.toArray(new Object[0]), indicator);
    }

    @JvmStatic
    @NotNull
    public static final DiffIterable create(@Nullable Diff.Change change, int length1, int length2) {
        DiffChangeDiffIterable iterable = new DiffChangeDiffIterable(change, length1, length2);
        DiffIterableUtil.verify(iterable);
        return iterable;
    }

    @JvmStatic
    @NotNull
    public static final DiffIterable createFragments(@NotNull List<? extends DiffFragment> fragments, int length1, int length2) {
        Intrinsics.checkNotNullParameter(fragments, (String)"fragments");
        DiffIterable iterable = new DiffFragmentsDiffIterable((Collection<? extends DiffFragment>)fragments, length1, length2);
        DiffIterableUtil.verify(iterable);
        return iterable;
    }

    @JvmStatic
    @NotNull
    public static final DiffIterable create(@NotNull List<? extends Range> ranges, int length1, int length2) {
        Intrinsics.checkNotNullParameter(ranges, (String)"ranges");
        DiffIterable iterable = new RangesDiffIterable((Collection<Range>)ranges, length1, length2);
        DiffIterableUtil.verify(iterable);
        return iterable;
    }

    @JvmStatic
    @NotNull
    public static final DiffIterable createUnchanged(@NotNull List<Range> ranges, int length1, int length2) {
        Intrinsics.checkNotNullParameter(ranges, (String)"ranges");
        DiffIterable invert = DiffIterableUtil.invert(DiffIterableUtil.create(ranges, length1, length2));
        DiffIterableUtil.verify(invert);
        return invert;
    }

    @JvmStatic
    @NotNull
    public static final DiffIterable invert(@NotNull DiffIterable iterable) {
        Intrinsics.checkNotNullParameter((Object)iterable, (String)"iterable");
        DiffIterable wrapper = new InvertedDiffIterableWrapper(iterable);
        DiffIterableUtil.verify(wrapper);
        return wrapper;
    }

    @JvmStatic
    @NotNull
    public static final FairDiffIterable fair(@NotNull DiffIterable iterable) {
        Intrinsics.checkNotNullParameter((Object)iterable, (String)"iterable");
        if (iterable instanceof FairDiffIterable) {
            return (FairDiffIterable)iterable;
        }
        FairDiffIterable wrapper = new FairDiffIterableWrapper(iterable);
        DiffIterableUtil.verifyFair(wrapper);
        return wrapper;
    }

    @JvmStatic
    @NotNull
    public static final DiffIterable expandedIterable(@NotNull DiffIterable iterable, int offset1, int offset2, int length1, int length2) {
        Intrinsics.checkNotNullParameter((Object)iterable, (String)"iterable");
        if (!(offset1 + iterable.getLength1() <= length1 && offset2 + iterable.getLength2() <= length2)) {
            throw new IllegalStateException("Check failed.");
        }
        return new ExpandedDiffIterable(iterable, offset1, offset2, length1, length2);
    }

    @JvmStatic
    @NotNull
    public static final Iterable<Pair<Range, Boolean>> iterateAll(@NotNull DiffIterable iterable) {
        Intrinsics.checkNotNullParameter((Object)iterable, (String)"iterable");
        return new Iterable<Pair<? extends Range, ? extends Boolean>>(iterable){
            final /* synthetic */ DiffIterable $iterable$inlined;
            {
                this.$iterable$inlined = diffIterable;
            }

            public Iterator<Pair<? extends Range, ? extends Boolean>> iterator() {
                boolean bl = false;
                return new AllRangesIterator(this.$iterable$inlined);
            }
        };
    }

    @JvmStatic
    public static final int getRangeDelta(@NotNull Range range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        int deleted = range.end1 - range.start1;
        int inserted = range.end2 - range.start2;
        return inserted - deleted;
    }

    @JvmStatic
    @TestOnly
    public static final void setVerifyEnabled(boolean value) {
        SHOULD_VERIFY_ITERABLE = value;
    }

    private final boolean isVerifyEnabled() {
        return SHOULD_VERIFY_ITERABLE;
    }

    @JvmStatic
    public static final void verify(@NotNull DiffIterable iterable) {
        Intrinsics.checkNotNullParameter((Object)iterable, (String)"iterable");
        if (!INSTANCE.isVerifyEnabled()) {
            return;
        }
        INSTANCE.verify(iterable.iterateChanges());
        INSTANCE.verify(iterable.iterateUnchanged());
        INSTANCE.verifyFullCover(iterable);
    }

    @JvmStatic
    public static final void verifyFair(@NotNull DiffIterable iterable) {
        Intrinsics.checkNotNullParameter((Object)iterable, (String)"iterable");
        if (!INSTANCE.isVerifyEnabled()) {
            return;
        }
        DiffIterableUtil.verify(iterable);
        for (Range range : iterable.iterateUnchanged()) {
            if (range.end1 - range.start1 == range.end2 - range.start2) continue;
            throw new IllegalStateException("Check failed.");
        }
    }

    private final void verify(Iterable<Range> iterable) {
        for (Range range : iterable) {
            if (!(range.start1 <= range.end1)) {
                throw new IllegalStateException("Check failed.");
            }
            if (!(range.start2 <= range.end2)) {
                throw new IllegalStateException("Check failed.");
            }
            if (range.start1 != range.end1 || range.start2 != range.end2) continue;
            throw new IllegalStateException("Check failed.");
        }
    }

    private final void verifyFullCover(DiffIterable iterable) {
        int last1 = 0;
        int last2 = 0;
        Boolean lastEquals = null;
        for (Pair<Range, Boolean> pair : DiffIterableUtil.iterateAll(iterable)) {
            Range range = (Range)pair.getFirst();
            boolean equal = (Boolean)pair.getSecond();
            if (!(last1 == range.start1)) {
                throw new IllegalStateException("Check failed.");
            }
            if (!(last2 == range.start2)) {
                throw new IllegalStateException("Check failed.");
            }
            if (!(!Intrinsics.areEqual(lastEquals, (Object)equal))) {
                throw new IllegalStateException("Check failed.");
            }
            last1 = range.end1;
            last2 = range.end2;
            lastEquals = equal;
        }
        if (!(last1 == iterable.getLength1())) {
            throw new IllegalStateException("Check failed.");
        }
        if (!(last2 == iterable.getLength2())) {
            throw new IllegalStateException("Check failed.");
        }
    }

    @JvmStatic
    @NotNull
    public static final <T> List<LineRangeData<?>> extractDataRanges(@NotNull List<? extends T> objects1, @NotNull List<? extends T> objects2, @NotNull DiffIterable iterable) {
        Intrinsics.checkNotNullParameter(objects1, (String)"objects1");
        Intrinsics.checkNotNullParameter(objects2, (String)"objects2");
        Intrinsics.checkNotNullParameter((Object)iterable, (String)"iterable");
        List result = new ArrayList();
        for (Pair<Range, Boolean> pair : DiffIterableUtil.iterateAll(iterable)) {
            int i;
            Range range = (Range)pair.getFirst();
            boolean equals = (Boolean)pair.getSecond();
            List data1 = new ArrayList();
            List data2 = new ArrayList();
            int n = range.end1;
            for (i = range.start1; i < n; ++i) {
                data1.add(objects1.get(i));
            }
            n = range.end2;
            for (i = range.start2; i < n; ++i) {
                data2.add(objects2.get(i));
            }
            result.add(new LineRangeData(data1, data2, equals));
        }
        return result;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\b\u0002\u0018\u00002\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\f\u001a\u0004\u0018\u00010\u00032\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eJ\n\u0010\u0010\u001a\u00020\u0004H\u0096\u0082\u0004J\u0016\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002H\u0096\u0082\u0004R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/diff/comparison/iterables/DiffIterableUtil$AllRangesIterator;", "", "Lkotlin/Pair;", "Lcom/intellij/diff/util/Range;", "", "myIterable", "Lcom/intellij/diff/comparison/iterables/DiffIterable;", "<init>", "(Lcom/intellij/diff/comparison/iterables/DiffIterable;)V", "myChanges", "Lcom/intellij/util/containers/PeekableIteratorWrapper;", "myNextUnchanged", "peekNextUnchanged", "start1", "", "start2", "hasNext", "next", "intellij.platform.util.diff"})
    private static final class AllRangesIterator
    implements Iterator<Pair<? extends Range, ? extends Boolean>>,
    KMappedMarker {
        @NotNull
        private final DiffIterable myIterable;
        @NotNull
        private final PeekableIteratorWrapper<Range> myChanges;
        @Nullable
        private Range myNextUnchanged;

        public AllRangesIterator(@NotNull DiffIterable myIterable) {
            Intrinsics.checkNotNullParameter((Object)myIterable, (String)"myIterable");
            this.myIterable = myIterable;
            this.myChanges = new PeekableIteratorWrapper(this.myIterable.changes());
            this.myNextUnchanged = this.peekNextUnchanged(0, 0);
        }

        @Nullable
        public final Range peekNextUnchanged(int start1, int start2) {
            Range range;
            Range nextChange = this.myChanges.hasNext() ? (Range)this.myChanges.peek() : null;
            Range range2 = range = nextChange != null ? new Range(start1, nextChange.start1, start2, nextChange.start2) : new Range(start1, this.myIterable.getLength1(), start2, this.myIterable.getLength2());
            if (range.isEmpty()) {
                return null;
            }
            return range;
        }

        @Override
        public boolean hasNext() {
            return this.myChanges.hasNext() || this.myNextUnchanged != null;
        }

        @Override
        @NotNull
        public Pair<Range, Boolean> next() {
            Range range = this.myNextUnchanged;
            if (range != null) {
                Range result = range;
                boolean bl = false;
                this.myNextUnchanged = null;
                return new Pair((Object)result, (Object)true);
            }
            Range range2 = (Range)this.myChanges.next();
            this.myNextUnchanged = this.peekNextUnchanged(range2.end1, range2.end2);
            return new Pair((Object)range2, (Object)false);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J(\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0003H\u0014J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/diff/comparison/iterables/DiffIterableUtil$ChangeBuilder;", "Lcom/intellij/diff/comparison/iterables/DiffIterableUtil$ChangeBuilderBase;", "length1", "", "length2", "<init>", "(II)V", "myChanges", "", "Lcom/intellij/diff/util/Range;", "addChange", "", "start1", "start2", "end1", "end2", "finish", "Lcom/intellij/diff/comparison/iterables/DiffIterable;", "intellij.platform.util.diff"})
    public static class ChangeBuilder
    extends ChangeBuilderBase {
        @NotNull
        private final List<Range> myChanges = new ArrayList();

        public ChangeBuilder(int length1, int length2) {
            super(length1, length2);
        }

        @Override
        protected void addChange(int start1, int start2, int end1, int end2) {
            this.myChanges.add(new Range(start1, end1, start2, end2));
        }

        @NotNull
        public DiffIterable finish() {
            this.doFinish();
            return DiffIterableUtil.create(this.myChanges, this.getLength1(), this.getLength2());
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\b\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J(\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J\b\u0010\u0015\u001a\u00020\u0011H\u0014J(\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0003H$R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u000e\u0010\n\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\bR\u000e\u0010\r\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\b\u00a8\u0006\u0019"}, d2={"Lcom/intellij/diff/comparison/iterables/DiffIterableUtil$ChangeBuilderBase;", "", "length1", "", "length2", "<init>", "(II)V", "getLength1", "()I", "getLength2", "_index1", "index1", "getIndex1", "_index2", "index2", "getIndex2", "markEqual", "", "count", "end1", "end2", "doFinish", "addChange", "start1", "start2", "intellij.platform.util.diff"})
    public static abstract class ChangeBuilderBase {
        private final int length1;
        private final int length2;
        private int _index1;
        private int _index2;

        public ChangeBuilderBase(int length1, int length2) {
            this.length1 = length1;
            this.length2 = length2;
        }

        public int getLength1() {
            return this.length1;
        }

        public int getLength2() {
            return this.length2;
        }

        public int getIndex1() {
            return this._index1;
        }

        public int getIndex2() {
            return this._index2;
        }

        public void markEqual(int index1, int index2) {
            this.markEqual(index1, index2, 1);
        }

        public void markEqual(int index1, int index2, int count) {
            this.markEqual(index1, index2, index1 + count, index2 + count);
        }

        public void markEqual(int index1, int index2, int end1, int end2) {
            if (index1 == end1 && index2 == end2) {
                return;
            }
            if (!(this.getIndex1() <= index1)) {
                throw new IllegalStateException("Check failed.");
            }
            if (!(this.getIndex2() <= index2)) {
                throw new IllegalStateException("Check failed.");
            }
            if (!(index1 <= end1)) {
                throw new IllegalStateException("Check failed.");
            }
            if (!(index2 <= end2)) {
                throw new IllegalStateException("Check failed.");
            }
            if (this.getIndex1() != index1 || this.getIndex2() != index2) {
                this.addChange(this.getIndex1(), this.getIndex2(), index1, index2);
            }
            this._index1 = end1;
            this._index2 = end2;
        }

        protected void doFinish() {
            if (!(this.getIndex1() <= this.getLength1())) {
                throw new IllegalStateException("Check failed.");
            }
            if (!(this.getIndex2() <= this.getLength2())) {
                throw new IllegalStateException("Check failed.");
            }
            if (this.getLength1() != this.getIndex1() || this.getLength2() != this.getIndex2()) {
                this.addChange(this.getIndex1(), this.getIndex2(), this.getLength1(), this.getLength2());
                this._index1 = this.getLength1();
                this._index2 = this.getLength2();
            }
        }

        protected abstract void addChange(int var1, int var2, int var3, int var4);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u001f\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\nH\u0014R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/diff/comparison/iterables/DiffIterableUtil$ExpandChangeBuilder;", "Lcom/intellij/diff/comparison/iterables/DiffIterableUtil$ChangeBuilder;", "myObjects1", "", "myObjects2", "<init>", "(Ljava/util/List;Ljava/util/List;)V", "addChange", "", "start1", "", "start2", "end1", "end2", "intellij.platform.util.diff"})
    public static class ExpandChangeBuilder
    extends ChangeBuilder {
        @NotNull
        private final List<?> myObjects1;
        @NotNull
        private final List<?> myObjects2;

        public ExpandChangeBuilder(@NotNull List<?> myObjects1, @NotNull List<?> myObjects2) {
            Intrinsics.checkNotNullParameter(myObjects1, (String)"myObjects1");
            Intrinsics.checkNotNullParameter(myObjects2, (String)"myObjects2");
            super(myObjects1.size(), myObjects2.size());
            this.myObjects1 = myObjects1;
            this.myObjects2 = myObjects2;
        }

        @Override
        protected void addChange(int start1, int start2, int end1, int end2) {
            Range range = TrimUtil.expand(this.myObjects1, this.myObjects2, start1, start2, end1, end2);
            if (!range.isEmpty()) {
                super.addChange(range.start1, range.start2, range.end1, range.end2);
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B+\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/diff/comparison/iterables/DiffIterableUtil$LineRangeData;", "T", "", "objects1", "", "objects2", "equals", "", "<init>", "(Ljava/util/List;Ljava/util/List;Z)V", "intellij.platform.util.diff"})
    public static class LineRangeData<T> {
        @JvmField
        @NotNull
        public final List<T> objects1;
        @JvmField
        @NotNull
        public final List<T> objects2;
        @JvmField
        public final boolean equals;

        public LineRangeData(@NotNull List<? extends T> objects1, @NotNull List<? extends T> objects2, boolean equals) {
            Intrinsics.checkNotNullParameter(objects1, (String)"objects1");
            Intrinsics.checkNotNullParameter(objects2, (String)"objects2");
            this.objects1 = objects1;
            this.objects2 = objects2;
            this.equals = equals;
        }
    }
}

