/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.NullableFunction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ListSelection<T> {
    private static final Logger LOG = Logger.getInstance(ListSelection.class);
    @NotNull
    private final List<? extends T> myList;
    private final int mySelectedIndex;
    private final boolean myExplicitSelection;

    private ListSelection(@NotNull List<? extends T> list, int selectedIndex) {
        if (list == null) {
            ListSelection.$$$reportNull$$$0(0);
        }
        this(list, selectedIndex, false);
    }

    private ListSelection(@NotNull List<? extends T> list, int selectedIndex, boolean isExplicit) {
        if (list == null) {
            ListSelection.$$$reportNull$$$0(1);
        }
        this.myList = list;
        this.mySelectedIndex = selectedIndex >= 0 && selectedIndex < list.size() ? selectedIndex : 0;
        this.myExplicitSelection = isExplicit;
    }

    @NotNull
    public static <V> ListSelection<V> createAt(@NotNull List<? extends V> list, int selectedIndex) {
        if (list == null) {
            ListSelection.$$$reportNull$$$0(2);
        }
        if (list.contains(null)) {
            LOG.error("List selection should not contain nulls");
        }
        return new ListSelection<V>(list, selectedIndex);
    }

    @NotNull
    public static <V> ListSelection<V> create(@NotNull List<? extends V> list, @Nullable V selected) {
        if (list == null) {
            ListSelection.$$$reportNull$$$0(3);
        }
        return ListSelection.createAt(list, list.indexOf(selected));
    }

    @NotNull
    public static <V> ListSelection<V> create(V @NotNull [] array, V selected) {
        if (array == null) {
            ListSelection.$$$reportNull$$$0(4);
        }
        return ListSelection.create(Arrays.asList(array), selected);
    }

    @NotNull
    public static <V> ListSelection<V> createSingleton(@NotNull V element) {
        if (element == null) {
            ListSelection.$$$reportNull$$$0(5);
        }
        return ListSelection.createAt(Collections.singletonList(element), 0);
    }

    @NotNull
    public static <V> ListSelection<V> empty() {
        return new ListSelection(Collections.emptyList(), -1);
    }

    @NotNull
    public List<? extends T> getList() {
        List<? extends T> list = this.myList;
        if (list == null) {
            ListSelection.$$$reportNull$$$0(6);
        }
        return list;
    }

    public int getSelectedIndex() {
        return this.mySelectedIndex;
    }

    public boolean isEmpty() {
        return this.myList.isEmpty();
    }

    @NotNull
    public <V> ListSelection<V> map(@NotNull NullableFunction<? super T, ? extends V> convertor) {
        if (convertor == null) {
            ListSelection.$$$reportNull$$$0(7);
        }
        int newSelectionIndex = -1;
        ArrayList<Object> result = new ArrayList<Object>();
        for (int i = 0; i < this.myList.size(); ++i) {
            Object out;
            if (i == this.mySelectedIndex) {
                newSelectionIndex = result.size();
            }
            if ((out = convertor.fun(this.myList.get(i))) == null) continue;
            result.add(out);
        }
        return new ListSelection(result, newSelectionIndex, this.myExplicitSelection);
    }

    @NotNull
    public ListSelection<T> asExplicitSelection() {
        ListSelection<T> listSelection = this.withExplicitSelection(true);
        if (listSelection == null) {
            ListSelection.$$$reportNull$$$0(8);
        }
        return listSelection;
    }

    @NotNull
    public ListSelection<T> withExplicitSelection(boolean value) {
        return new ListSelection<T>(this.myList, this.mySelectedIndex, value);
    }

    @NotNull
    public List<? extends T> getExplicitSelection() {
        if (this.myList.isEmpty()) {
            List list = Collections.emptyList();
            if (list == null) {
                ListSelection.$$$reportNull$$$0(9);
            }
            return list;
        }
        if (this.myExplicitSelection) {
            List<? extends T> list = this.myList;
            if (list == null) {
                ListSelection.$$$reportNull$$$0(10);
            }
            return list;
        }
        List<T> list = Collections.singletonList(this.myList.get(this.mySelectedIndex));
        if (list == null) {
            ListSelection.$$$reportNull$$$0(11);
        }
        return list;
    }

    public boolean isExplicitSelection() {
        return this.myExplicitSelection;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListSelection)) {
            return false;
        }
        ListSelection selection = (ListSelection)o;
        return this.mySelectedIndex == selection.mySelectedIndex && this.myExplicitSelection == selection.myExplicitSelection && Objects.equals(this.myList, selection.myList);
    }

    public int hashCode() {
        return Objects.hash(this.myList, this.mySelectedIndex, this.myExplicitSelection);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 8, 9, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/ListSelection";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "convertor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/ListSelection";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getList";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "asExplicitSelection";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getExplicitSelection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createAt";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createSingleton";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "map";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 8, 9, 10, 11 -> new IllegalStateException(string);
        };
    }
}

