/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webstorm.easterEgg;

import com.intellij.util.ImageLoader;
import com.intellij.util.ui.UIUtil;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.Timer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u001b\u001a\u00020\u001cJ\u0012\u0010\u001d\u001a\u00020\u001c2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0014J\u0012\u0010 \u001a\u00020\u001c2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016R\u000e\u0010\b\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\n \u0016*\u0004\u0018\u00010\u00150\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/webstorm/easterEgg/MovingCreatureAnimation;", "Ljavax/swing/JComponent;", "Ljava/awt/event/ActionListener;", "containerWidth", "", "containerHeight", "<init>", "(II)V", "delay", "animationStep", "animationSpeed", "", "animationDuration", "getAnimationDuration", "()I", "animationY", "frames", "", "Ljava/awt/Image;", "totalFrames", "lastFrameChangeTime", "Ljava/time/Instant;", "kotlin.jvm.PlatformType", "currentFrameNumber", "timer", "Ljavax/swing/Timer;", "startTime", "startAnimation", "", "paintComponent", "g", "Ljava/awt/Graphics;", "actionPerformed", "p0", "Ljava/awt/event/ActionEvent;", "intellij.webstorm.easterEgg"})
@SourceDebugExtension(value={"SMAP\nMovingCreatureAnimation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MovingCreatureAnimation.kt\ncom/intellij/webstorm/easterEgg/MovingCreatureAnimation\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,64:1\n1#2:65\n*E\n"})
public final class MovingCreatureAnimation
extends JComponent
implements ActionListener {
    private final int delay;
    private final int animationStep;
    private float animationSpeed;
    private final int animationDuration;
    private int animationY;
    @NotNull
    private final List<Image> frames;
    private final int totalFrames;
    private Instant lastFrameChangeTime;
    private int currentFrameNumber;
    @NotNull
    private final Timer timer;
    @NotNull
    private Instant startTime;

    public MovingCreatureAnimation(int containerWidth, int containerHeight) {
        this.delay = 20;
        this.animationStep = 4;
        this.animationDuration = containerWidth * this.delay / this.animationStep;
        this.frames = new ArrayList();
        this.totalFrames = 20;
        this.lastFrameChangeTime = Instant.now();
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        this.startTime = instant;
        int n = this.totalFrames;
        for (int i = 0; i < n; ++i) {
            try {
                this.frames.add(ImageLoader.loadFromResource((String)("/frames/100x100" + (120 + i) + ".png"), this.getClass()));
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.animationY = containerHeight / 2;
        this.animationSpeed = (float)containerWidth / (float)this.animationDuration;
        this.timer = new Timer(this.delay, this);
    }

    public final int getAnimationDuration() {
        return this.animationDuration;
    }

    public final void startAnimation() {
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        this.startTime = instant;
        this.timer.start();
    }

    @Override
    protected void paintComponent(@Nullable Graphics g) {
        Intrinsics.checkNotNull((Object)g, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D g2d = (Graphics2D)g;
        float currentX = (float)(Instant.now().toEpochMilli() - this.startTime.toEpochMilli()) * this.animationSpeed;
        Image image = this.frames.get(this.currentFrameNumber);
        if (image != null) {
            Image it = image;
            boolean bl = false;
            UIUtil.drawImage((Graphics)g2d, (Image)it, (int)((int)currentX), (int)400, null);
        }
        super.paintComponent(g);
    }

    @Override
    public void actionPerformed(@Nullable ActionEvent p0) {
        if (Instant.now().toEpochMilli() - this.lastFrameChangeTime.toEpochMilli() > (long)(this.delay * 3)) {
            this.currentFrameNumber = this.currentFrameNumber == this.totalFrames - 1 ? 0 : this.currentFrameNumber + 1;
            this.lastFrameChangeTime = Instant.now();
        }
        this.repaint();
    }
}

