/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.model.typed;

import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.model.Pointer;
import com.intellij.polySymbols.PolySymbol;
import com.intellij.polySymbols.PolySymbolKind;
import com.intellij.polySymbols.refactoring.PolySymbolRenameTarget;
import com.intellij.polySymbols.search.PsiSourcedPolySymbol;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.vuejs.model.VueDirective;
import org.jetbrains.vuejs.model.VueDirectiveModifier;
import org.jetbrains.vuejs.model.VueMode;
import org.jetbrains.vuejs.model.typed.VueTypedContainer;
import org.jetbrains.vuejs.model.typed.VueTypedDirectives;
import org.jetbrains.vuejs.web.VueSymbolQueryConfiguratorKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00000\"H\u0016J\t\u0010#\u001a\u00020\u0005H\u00c6\u0003J\t\u0010$\u001a\u00020\u0007H\u00c6\u0003J\u001d\u0010%\u001a\u00020\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0014\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010)H\u00d6\u0083\u0004J\n\u0010*\u001a\u00020+H\u00d6\u0081\u0004J\n\u0010,\u001a\u00020\u0007H\u00d6\u0081\u0004R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0012\u001a\u0004\u0018\u00010\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0016\u0010\u001d\u001a\u0004\u0018\u00010\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u0006-"}, d2={"Lorg/jetbrains/vuejs/model/typed/VueTypedDirective;", "Lorg/jetbrains/vuejs/model/typed/VueTypedContainer;", "Lorg/jetbrains/vuejs/model/VueDirective;", "Lcom/intellij/polySymbols/search/PsiSourcedPolySymbol;", "source", "Lcom/intellij/lang/javascript/psi/ecma6/TypeScriptPropertySignature;", "name", "", "<init>", "(Lcom/intellij/lang/javascript/psi/ecma6/TypeScriptPropertySignature;Ljava/lang/String;)V", "getSource", "()Lcom/intellij/lang/javascript/psi/ecma6/TypeScriptPropertySignature;", "getName", "()Ljava/lang/String;", "kind", "Lcom/intellij/polySymbols/PolySymbolKind;", "getKind", "()Lcom/intellij/polySymbols/PolySymbolKind;", "type", "Lcom/intellij/lang/javascript/psi/JSType;", "getType", "()Lcom/intellij/lang/javascript/psi/JSType;", "thisType", "getThisType", "directiveModifiers", "", "Lorg/jetbrains/vuejs/model/VueDirectiveModifier;", "getDirectiveModifiers", "()Ljava/util/List;", "renameTarget", "Lcom/intellij/polySymbols/refactoring/PolySymbolRenameTarget;", "getRenameTarget", "()Lcom/intellij/polySymbols/refactoring/PolySymbolRenameTarget;", "createPointer", "Lcom/intellij/model/Pointer;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.vuejs.backend"})
public final class VueTypedDirective
extends VueTypedContainer
implements VueDirective,
PsiSourcedPolySymbol {
    @NotNull
    private final TypeScriptPropertySignature source;
    @NotNull
    private final String name;

    public VueTypedDirective(@NotNull TypeScriptPropertySignature source, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super((PsiElement)source);
        this.source = source;
        this.name = name;
    }

    @NotNull
    public TypeScriptPropertySignature getSource() {
        return this.source;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public PolySymbolKind getKind() {
        return VueSymbolQueryConfiguratorKt.getVUE_GLOBAL_DIRECTIVES();
    }

    @Override
    @Nullable
    public JSType getType() {
        return this.getSource().getJSType();
    }

    @Override
    @NotNull
    public JSType getThisType() {
        JSAnyType.JSAnyTypeImpl jSAnyTypeImpl = JSAnyType.getWithLanguage((JSTypeSource.SourceLanguage)JSTypeSource.SourceLanguage.TS);
        Intrinsics.checkNotNullExpressionValue((Object)jSAnyTypeImpl, (String)"getWithLanguage(...)");
        return (JSType)jSAnyTypeImpl;
    }

    @Override
    @NotNull
    public List<VueDirectiveModifier> getDirectiveModifiers() {
        Object object = CachedValuesManager.getCachedValue((PsiElement)((PsiElement)this.getSource()), () -> VueTypedDirective._get_directiveModifiers_$lambda$0(this));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (List)object;
    }

    @Nullable
    public PolySymbolRenameTarget getRenameTarget() {
        return this.getSource() instanceof JSLiteralExpression ? PolySymbolRenameTarget.Companion.create((PolySymbol)this) : null;
    }

    @NotNull
    public Pointer<VueTypedDirective> createPointer() {
        SmartPsiElementPointer sourcePtr = SmartPointersKt.createSmartPointer((PsiElement)((PsiElement)this.getSource()));
        String defaultName = this.getName();
        return () -> VueTypedDirective.createPointer$lambda$0(sourcePtr, defaultName);
    }

    @NotNull
    public final TypeScriptPropertySignature component1() {
        return this.source;
    }

    @NotNull
    public final String component2() {
        return this.name;
    }

    @NotNull
    public final VueTypedDirective copy(@NotNull TypeScriptPropertySignature source, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new VueTypedDirective(source, name);
    }

    public static /* synthetic */ VueTypedDirective copy$default(VueTypedDirective vueTypedDirective, TypeScriptPropertySignature typeScriptPropertySignature, String string, int n, Object object) {
        if ((n & 1) != 0) {
            typeScriptPropertySignature = vueTypedDirective.source;
        }
        if ((n & 2) != 0) {
            string = vueTypedDirective.name;
        }
        return vueTypedDirective.copy(typeScriptPropertySignature, string);
    }

    @NotNull
    public String toString() {
        return "VueTypedDirective(source=" + this.source + ", name=" + this.name + ")";
    }

    public int hashCode() {
        int result = this.source.hashCode();
        result = result * 31 + this.name.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof VueTypedDirective)) {
            return false;
        }
        VueTypedDirective vueTypedDirective = (VueTypedDirective)other;
        if (!Intrinsics.areEqual((Object)this.source, (Object)vueTypedDirective.source)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.name, (Object)vueTypedDirective.name);
    }

    private static final CachedValueProvider.Result _get_directiveModifiers_$lambda$0(VueTypedDirective this$0) {
        Object[] objectArray = new Object[]{PsiModificationTracker.MODIFICATION_COUNT};
        return CachedValueProvider.Result.create(VueTypedDirectives.INSTANCE.getDirectiveModifiers(this$0.getSource(), VueMode.CLASSIC), (Object[])objectArray);
    }

    private static final VueTypedDirective createPointer$lambda$0(SmartPsiElementPointer $sourcePtr, String $defaultName) {
        TypeScriptPropertySignature typeScriptPropertySignature = (TypeScriptPropertySignature)$sourcePtr.dereference();
        if (typeScriptPropertySignature == null) {
            return null;
        }
        TypeScriptPropertySignature source = typeScriptPropertySignature;
        return new VueTypedDirective(source, $defaultName);
    }
}

