/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.java.hash;

import com.google.common.hash.HashCode;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.intellij.indexing.shared.util.VirtualFileCache;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.vfs.DiskQueryRelay;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0003\u0018\u0000 \n2\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\tH\u0014\u00a8\u0006\u000b"}, d2={"Lcom/intellij/indexing/shared/java/hash/SharedIndexArchiveFileHashStore;", "Lcom/intellij/indexing/shared/util/VirtualFileCache;", "Lcom/google/common/hash/HashCode;", "<init>", "()V", "dispose", "", "computeValue", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "Companion", "intellij.indexing.shared.java"})
@SourceDebugExtension(value={"SMAP\nSharedIndexJarArchiveHash.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SharedIndexJarArchiveHash.kt\ncom/intellij/indexing/shared/java/hash/SharedIndexArchiveFileHashStore\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,95:1\n13#2:96\n*S KotlinDebug\n*F\n+ 1 SharedIndexJarArchiveHash.kt\ncom/intellij/indexing/shared/java/hash/SharedIndexArchiveFileHashStore\n*L\n59#1:96\n*E\n"})
final class SharedIndexArchiveFileHashStore
extends VirtualFileCache<HashCode> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger log;
    @NotNull
    private static final DiskQueryRelay<Path, HashCode> hashCalculator;

    public SharedIndexArchiveFileHashStore() {
        super(false);
    }

    public void dispose() {
    }

    @Nullable
    protected HashCode computeValue(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!file.isValid() || file.isDirectory()) {
            return null;
        }
        if (!(file instanceof VirtualFileWithId)) {
            return null;
        }
        return (HashCode)hashCalculator.accessDiskWithCheckCanceled((Object)file.toNioPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final HashCode hashCalculator$lambda$0(Path it) {
        Hasher hasher = Hashing.sha1().newHasher();
        Intrinsics.checkNotNullExpressionValue((Object)hasher, (String)"newHasher(...)");
        Hasher hash = hasher;
        byte[] buff = new byte[262144];
        try {
            Intrinsics.checkNotNull((Object)it);
            OpenOption[] openOptionArray = new OpenOption[]{};
            InputStream inputStream = Files.newInputStream(it, Arrays.copyOf(openOptionArray, openOptionArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
            Closeable closeable = inputStream;
            Throwable throwable = null;
            try {
                InputStream stream = (InputStream)closeable;
                boolean bl = false;
                while (true) {
                    int sz = stream.read(buff);
                    ProgressManager.checkCanceled();
                    if (sz <= 0) break;
                    hash.putBytes(buff, 0, sz);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException e) {
            log.info((Throwable)e);
            return null;
        }
        return hash.hash();
    }

    private static final HashCode hashCalculator$lambda$1(Function1 $tmp0, Object p0) {
        return (HashCode)$tmp0.invoke(p0);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SharedIndexArchiveFileHashStore.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        log = logger;
        hashCalculator = new DiskQueryRelay(arg_0 -> SharedIndexArchiveFileHashStore.hashCalculator$lambda$1(SharedIndexArchiveFileHashStore::hashCalculator$lambda$0, arg_0));
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/indexing/shared/java/hash/SharedIndexArchiveFileHashStore$Companion;", "", "<init>", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "hashCalculator", "Lcom/intellij/openapi/vfs/DiskQueryRelay;", "Ljava/nio/file/Path;", "Lcom/google/common/hash/HashCode;", "intellij.indexing.shared.java"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

