/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.java.jdk;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkInstaller;
import com.intellij.util.lang.JavaVersion;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nJ\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\f\u001a\u00020\bJ\u0018\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/indexing/shared/java/jdk/JdkAliases;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "computeAliasesForJdk", "", "", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "computeAliasesForJdkVersion", "versionString", "computeAliasesForInstalledJdk", "jdkHome", "intellij.indexing.shared.java"})
@SourceDebugExtension(value={"SMAP\nJdkChunk.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdkChunk.kt\ncom/intellij/indexing/shared/java/jdk/JdkAliases\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,102:1\n13#2:103\n*S KotlinDebug\n*F\n+ 1 JdkChunk.kt\ncom/intellij/indexing/shared/java/jdk/JdkAliases\n*L\n64#1:103\n*E\n"})
public final class JdkAliases {
    @NotNull
    public static final JdkAliases INSTANCE = new JdkAliases();
    @NotNull
    private static final Logger LOG;

    private JdkAliases() {
    }

    @NotNull
    public final List<String> computeAliasesForJdk(@NotNull Sdk sdk) {
        String string;
        Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
        try {
            String string2 = (String)ActionsKt.runReadAction(() -> JdkAliases.computeAliasesForJdk$lambda$0(sdk));
            if (string2 == null) {
                return CollectionsKt.emptyList();
            }
            string = string2;
        }
        catch (Throwable e) {
            LOG.warn("Failed to compute SDK version for: " + sdk + ". " + e.getMessage(), e);
            return CollectionsKt.emptyList();
        }
        String versionString = string;
        return CollectionsKt.distinct((Iterable)CollectionsKt.plus((Collection)this.computeAliasesForInstalledJdk(sdk.getHomePath()), (Iterable)this.computeAliasesForJdkVersion(versionString)));
    }

    @NotNull
    public final List<String> computeAliasesForJdkVersion(@NotNull String versionString) {
        Intrinsics.checkNotNullParameter((Object)versionString, (String)"versionString");
        try {
            JavaVersion javaVersion = JavaVersion.Companion.tryParse(versionString);
            if (javaVersion == null) {
                return CollectionsKt.emptyList();
            }
            JavaVersion version = javaVersion;
            Object[] objectArray = new String[]{version.toFeatureMinorUpdateString(), version.toFeatureString()};
            return CollectionsKt.listOf((Object[])objectArray);
        }
        catch (Throwable e) {
            LOG.warn("Failed to compute aliases for: " + versionString + ". " + e.getMessage(), e);
            return CollectionsKt.emptyList();
        }
    }

    private final List<String> computeAliasesForInstalledJdk(String jdkHome) {
        if (jdkHome == null) {
            return CollectionsKt.emptyList();
        }
        try {
            Object object = JdkInstaller.Companion.getInstance().findJdkItemForInstalledJdk(jdkHome);
            if (object == null || (object = object.getSharedIndexAliases()) == null) {
                return CollectionsKt.emptyList();
            }
            return object;
        }
        catch (Throwable e) {
            LOG.warn("Failed to get installed JDK aliases for: " + jdkHome + ". " + e.getMessage(), e);
            return CollectionsKt.emptyList();
        }
    }

    private static final String computeAliasesForJdk$lambda$0(Sdk $sdk) {
        return $sdk.getVersionString();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(JdkAliases.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

