/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.schemes;

import com.intellij.application.options.schemes.SchemesComboRendererKt;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.editor.colors.Groups;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.SimpleTextAttributes;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.swing.DefaultComboBoxModel;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SchemesCombo<T extends Scheme>
extends ComboBox<MySchemeListItem<T>> {
    static final @NotNull Supplier<@Nls String> PROJECT_LEVEL = IdeBundle.messagePointer((String)"scheme.project", (Object[])new Object[0]);
    static final @NotNull Supplier<@Nls String> IDE_LEVEL = IdeBundle.messagePointer((String)"scheme.ide", (Object[])new Object[0]);
    final Map<@NotNull Scheme, @Nullable @Nls String> schemeSeparators = new HashMap<Scheme, String>();

    public SchemesCombo() {
        super(new DefaultComboBoxModel());
        this.setRenderer(SchemesComboRendererKt.getRenderer(this));
        this.setSwingPopup(false);
    }

    public void resetSchemes(@NotNull Collection<? extends T> schemes) {
        if (schemes == null) {
            SchemesCombo.$$$reportNull$$$0(0);
        }
        DefaultComboBoxModel model2 = (DefaultComboBoxModel)this.getModel();
        model2.removeAllElements();
        this.schemeSeparators.clear();
        if (this.supportsProjectSchemes()) {
            this.addItems(schemes, scheme -> scheme != null && this.isProjectScheme(scheme), IdeBundle.message((String)"separator.scheme.stored.in", (Object[])new Object[]{PROJECT_LEVEL.get()}));
            this.addItems(schemes, scheme -> scheme != null && !this.isProjectScheme(scheme), IdeBundle.message((String)"separator.scheme.stored.in", (Object[])new Object[]{IDE_LEVEL.get()}));
        } else {
            this.addItems(schemes, scheme -> scheme != null, "");
        }
    }

    public void resetGroupedSchemes(@NotNull Groups<? extends T> schemeGroups) {
        if (schemeGroups == null) {
            SchemesCombo.$$$reportNull$$$0(1);
        }
        DefaultComboBoxModel model2 = (DefaultComboBoxModel)this.getModel();
        model2.removeAllElements();
        this.schemeSeparators.clear();
        for (Groups.GroupInfo schemeGroup : schemeGroups.getInfos()) {
            List schemes = schemeGroup.getItems();
            this.addItems(schemes, scheme -> scheme != null, schemeGroup.getTitle());
        }
    }

    public void selectScheme(@Nullable T scheme) {
        for (int i2 = 0; i2 < this.getItemCount(); ++i2) {
            if (((MySchemeListItem)this.getItemAt(i2)).getScheme() != scheme) continue;
            this.setSelectedIndex(i2);
            break;
        }
    }

    @Nullable
    public T getSelectedScheme() {
        Object item = this.getSelectedItem();
        return item != null ? (T)((MySchemeListItem)item).getScheme() : null;
    }

    @Nullable
    public MySchemeListItem<T> getSelectedItem() {
        int i2 = this.getSelectedIndex();
        return i2 >= 0 ? (MySchemeListItem)this.getItemAt(i2) : null;
    }

    protected abstract boolean supportsProjectSchemes();

    protected boolean isProjectScheme(@NotNull T scheme) {
        if (scheme == null) {
            SchemesCombo.$$$reportNull$$$0(2);
        }
        throw new UnsupportedOperationException();
    }

    protected boolean isDefaultScheme(@NotNull T scheme) {
        if (scheme == null) {
            SchemesCombo.$$$reportNull$$$0(3);
        }
        return false;
    }

    protected int getIndent(@NotNull T scheme) {
        if (scheme == null) {
            SchemesCombo.$$$reportNull$$$0(4);
        }
        return 0;
    }

    @NotNull
    protected abstract SimpleTextAttributes getSchemeAttributes(T var1);

    private void addItems(@NotNull Collection<? extends T> schemes, Predicate<? super T> filter2, @Nullable @Nls String separatorTitle) {
        if (schemes == null) {
            SchemesCombo.$$$reportNull$$$0(5);
        }
        MySchemeListItem<Scheme> firstItem = null;
        for (Scheme scheme : schemes) {
            if (!filter2.test(scheme)) continue;
            MySchemeListItem<Scheme> item = new MySchemeListItem<Scheme>(scheme);
            ((DefaultComboBoxModel)this.getModel()).addElement(item);
            if (firstItem != null) continue;
            firstItem = item;
        }
        if (firstItem != null && firstItem.getScheme() != null) {
            this.schemeSeparators.put((Scheme)firstItem.getScheme(), separatorTitle);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemes";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemeGroups";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
        }
        objectArray2[1] = "com/intellij/application/options/schemes/SchemesCombo";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "resetSchemes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "resetGroupedSchemes";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isProjectScheme";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isDefaultScheme";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getIndent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "addItems";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    @ApiStatus.Internal
    public static final class MySchemeListItem<T extends Scheme> {
        @Nullable
        private final T myScheme;

        MySchemeListItem(@Nullable T scheme) {
            this.myScheme = scheme;
        }

        @Nullable
        public String getSchemeName() {
            return this.myScheme != null ? this.myScheme.getName() : null;
        }

        @Nullable
        public T getScheme() {
            return this.myScheme;
        }

        @NlsContexts.ListItem
        @NotNull
        public String getPresentableText() {
            return this.myScheme != null ? this.myScheme.getDisplayName() : "";
        }
    }
}

