/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.featureStatistics.fusCollectors;

import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.idea.AppMode;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.BooleanEventField;
import com.intellij.internal.statistic.eventLog.events.EnumEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.LicensingFacade;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class EAPUsageCollector
extends ApplicationUsagesCollector {
    private static final EventLogGroup GROUP = new EventLogGroup("user.advanced.info", 8);
    private static final EventId1<BuildType> BUILD = GROUP.registerEvent("build", (EventField)EventFields.Enum((String)"value", BuildType.class));
    private static final EnumEventField<LicenceType> LICENSE_VALUE = EventFields.Enum((String)"value", LicenceType.class);
    private static final StringEventField METADATA = EventFields.StringValidatedByRegexpReference((String)"metadata", (String)"license_metadata");
    private static final EventField<String> LOGIN_HASH = EventFields.AnonymizedField((String)"login_hash");
    private static final BooleanEventField IS_JB_TEAM = EventFields.Boolean((String)"is_jb_team");
    private static final VarargEventId LICENSING = GROUP.registerVarargEvent("licencing", new EventField[]{LICENSE_VALUE, METADATA, LOGIN_HASH, IS_JB_TEAM});

    public EventLogGroup getGroup() {
        return GROUP;
    }

    @NotNull
    public Set<MetricEvent> getMetrics() {
        return EAPUsageCollector.collectMetrics();
    }

    @NotNull
    private static Set<MetricEvent> collectMetrics() {
        block12: {
            HashSet<MetricEvent> hashSet;
            try {
                if (AppMode.isHeadless()) break block12;
                HashSet<MetricEvent> result2 = new HashSet<MetricEvent>();
                if (ApplicationInfo.getInstance().isEAP()) {
                    result2.add(BUILD.metric((Object)BuildType.eap));
                } else {
                    result2.add(BUILD.metric((Object)BuildType.release));
                }
                LicensingFacade facade2 = LicensingFacade.getInstance();
                if (facade2 != null) {
                    if (facade2.isEvaluationLicense()) {
                        result2.add(EAPUsageCollector.newLicencingMetric(LicenceType.evaluation, facade2));
                    } else if (!StringUtil.isEmpty((String)facade2.getLicensedToMessage())) {
                        result2.add(EAPUsageCollector.newLicencingMetric(LicenceType.license, facade2));
                    } else if (!EAPUsageCollector.isLicenseRequired()) {
                        result2.add(EAPUsageCollector.newLicencingMetric(LicenceType.noLicenseNeeded, facade2));
                    }
                }
                hashSet = result2;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (hashSet == null) {
                EAPUsageCollector.$$$reportNull$$$0(0);
            }
            return hashSet;
        }
        Set<MetricEvent> set = Collections.emptySet();
        if (set == null) {
            EAPUsageCollector.$$$reportNull$$$0(1);
        }
        return set;
    }

    @ApiStatus.Internal
    public static boolean isJBTeam() {
        LicensingFacade licensingFacade = LicensingFacade.getInstance();
        if (licensingFacade == null) {
            return false;
        }
        String licensedToMessage = licensingFacade.getLicensedToMessage();
        return licensedToMessage != null && licensedToMessage.contains("JetBrains Team");
    }

    @NotNull
    private static MetricEvent newLicencingMetric(@NotNull LicenceType value, @NotNull LicensingFacade licensingFacade) {
        String metadata;
        if (value == null) {
            EAPUsageCollector.$$$reportNull$$$0(2);
        }
        if (licensingFacade == null) {
            EAPUsageCollector.$$$reportNull$$$0(3);
        }
        ArrayList<EventPair> data2 = new ArrayList<EventPair>();
        if (EAPUsageCollector.isJBTeam()) {
            data2.add(IS_JB_TEAM.with((Object)true));
        }
        if (StringUtil.isNotEmpty((String)(metadata = licensingFacade.metadata))) {
            data2.add(METADATA.with((Object)metadata));
        }
        data2.add(LICENSE_VALUE.with((Object)value));
        data2.add(LOGIN_HASH.with((Object)licensingFacade.getLicenseeEmail()));
        MetricEvent metricEvent = LICENSING.metric(data2);
        if (metricEvent == null) {
            EAPUsageCollector.$$$reportNull$$$0(4);
        }
        return metricEvent;
    }

    public static boolean isLicenseRequired() {
        return !PluginManagerCore.isDisabled((PluginId)PluginManagerCore.ULTIMATE_PLUGIN_ID);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/featureStatistics/fusCollectors/EAPUsageCollector";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "licensingFacade";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "collectMetrics";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/featureStatistics/fusCollectors/EAPUsageCollector";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "newLicencingMetric";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "newLicencingMetric";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3 -> new IllegalArgumentException(string);
        };
    }

    private static enum BuildType {
        eap,
        release;

    }

    private static enum LicenceType {
        evaluation,
        license,
        noLicenseNeeded;

    }
}

