/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.formatting.CaretPositionKeeper;
import com.intellij.formatting.CaretRestorationDecider;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.util.text.CharArrayUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/formatting/DefaultCaretRestorationDecider;", "Lcom/intellij/formatting/CaretRestorationDecider;", "<init>", "()V", "shouldRestoreCaret", "", "document", "Lcom/intellij/openapi/editor/Document;", "editor", "Lcom/intellij/openapi/editor/Editor;", "caretOffset", "", "intellij.platform.ide.impl"})
public final class DefaultCaretRestorationDecider
implements CaretRestorationDecider {
    @NotNull
    public static final DefaultCaretRestorationDecider INSTANCE = new DefaultCaretRestorationDecider();

    private DefaultCaretRestorationDecider() {
    }

    public boolean shouldRestoreCaret(@NotNull Document document2, @NotNull Editor editor2, int caretOffset) {
        Intrinsics.checkNotNullParameter((Object)document2, (String)"document");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        int lineStartOffset = CaretPositionKeeper.getLineStartOffsetByTotalOffset(document2, caretOffset);
        int lineEndOffset = CaretPositionKeeper.getLineEndOffsetByTotalOffset(document2, caretOffset);
        return CharArrayUtil.isEmptyOrSpaces((CharSequence)document2.getCharsSequence(), (int)lineStartOffset, (int)lineEndOffset);
    }
}

