/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.formatting.DependentSpacingRule;
import com.intellij.formatting.SpacingImpl;
import com.intellij.formatting.engine.BlockRangesMap;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class DependantSpacingImpl
extends SpacingImpl {
    private static final int DEPENDENCE_CONTAINS_LF_MASK = 16;
    private int myLastLFChangedIteration;
    @NotNull
    private final List<TextRange> myDependentRegionRanges;
    @NotNull
    private final DependentSpacingRule myRule;

    public DependantSpacingImpl(int minSpaces, int maxSpaces, @NotNull TextRange dependency, boolean keepLineBreaks, int keepBlankLines, @NotNull DependentSpacingRule rule) {
        if (dependency == null) {
            DependantSpacingImpl.$$$reportNull$$$0(0);
        }
        if (rule == null) {
            DependantSpacingImpl.$$$reportNull$$$0(1);
        }
        super(minSpaces, maxSpaces, 0, false, false, keepLineBreaks, keepBlankLines, false, 0);
        this.myLastLFChangedIteration = 0;
        this.myDependentRegionRanges = new SmartList((Object)dependency);
        this.myRule = rule;
    }

    public DependantSpacingImpl(int minSpaces, int maxSpaces, @NotNull List<TextRange> dependencyRanges, boolean keepLineBreaks, int keepBlankLines, @NotNull DependentSpacingRule rule) {
        if (dependencyRanges == null) {
            DependantSpacingImpl.$$$reportNull$$$0(2);
        }
        if (rule == null) {
            DependantSpacingImpl.$$$reportNull$$$0(3);
        }
        super(minSpaces, maxSpaces, 0, false, false, keepLineBreaks, keepBlankLines, false, 0);
        this.myLastLFChangedIteration = 0;
        this.myDependentRegionRanges = dependencyRanges;
        this.myRule = rule;
    }

    @Override
    public int getMinLineFeeds() {
        if (!this.isTriggered()) {
            return super.getMinLineFeeds();
        }
        if (this.myRule.hasData(DependentSpacingRule.Anchor.MIN_LINE_FEEDS)) {
            return this.myRule.getData(DependentSpacingRule.Anchor.MIN_LINE_FEEDS);
        }
        if (this.myRule.hasData(DependentSpacingRule.Anchor.MAX_LINE_FEEDS)) {
            return this.myRule.getData(DependentSpacingRule.Anchor.MAX_LINE_FEEDS);
        }
        return super.getMinLineFeeds();
    }

    @Override
    public int getKeepBlankLines() {
        if (!this.isTriggered() || !this.myRule.hasData(DependentSpacingRule.Anchor.MAX_LINE_FEEDS)) {
            return super.getKeepBlankLines();
        }
        return 0;
    }

    public boolean isDependantSpacingChangedAtLeastOnce() {
        return this.myLastLFChangedIteration > 0;
    }

    @Override
    public void refresh(BlockRangesMap helper) {
        if (this.isDependantSpacingChangedAtLeastOnce()) {
            return;
        }
        boolean atLeastOneDependencyRangeContainsLf = false;
        for (TextRange dependency : this.myDependentRegionRanges) {
            atLeastOneDependencyRangeContainsLf |= helper.containsLineFeedsOrTooLong(dependency);
        }
        this.myFlags = atLeastOneDependencyRangeContainsLf ? (this.myFlags |= 0x10) : (this.myFlags &= 0xFFFFFFEF);
    }

    @NotNull
    public List<TextRange> getDependentRegionRanges() {
        List<TextRange> list2 = this.myDependentRegionRanges;
        if (list2 == null) {
            DependantSpacingImpl.$$$reportNull$$$0(4);
        }
        return list2;
    }

    public final boolean isDependentRegionLinefeedStatusChanged(int currentIteration) {
        return currentIteration == this.myLastLFChangedIteration;
    }

    public final void setDependentRegionLinefeedStatusChanged(int currentIteration) {
        this.myLastLFChangedIteration = currentIteration;
        this.myFlags = this.getMinLineFeeds() <= 0 ? (this.myFlags |= 0x10) : (this.myFlags &= 0xFFFFFFEF);
    }

    @Override
    public String toString() {
        String dependencies = StringUtil.join(this.myDependentRegionRanges, (String)", ");
        return "<DependantSpacing: minSpaces=" + this.getMinSpaces() + " maxSpaces=" + this.getMaxSpaces() + " minLineFeeds=" + this.getMinLineFeeds() + " dep=" + dependencies + ">";
    }

    private boolean isTriggered() {
        return this.myRule.getTrigger() == DependentSpacingRule.Trigger.HAS_LINE_FEEDS ^ (this.myFlags & 0x10) == 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rule";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyRanges";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/formatting/DependantSpacingImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/formatting/DependantSpacingImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependentRegionRanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

