/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.engine;

import com.intellij.formatting.DependantSpacingImpl;
import com.intellij.formatting.LeafBlockWrapper;
import com.intellij.formatting.SpacingImpl;
import com.intellij.formatting.WhiteSpace;
import com.intellij.formatting.engine.BlockRangesMap;
import com.intellij.openapi.util.TextRange;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
final class DependentSpacingEngine {
    private int myIteration = 1;
    private final BlockRangesMap myBlockRangesMap;
    private final Set<LeafBlockWrapper> myLeafBlocksToReformat = new HashSet<LeafBlockWrapper>();
    private final SortedMap<TextRange, LeafBlockWrapper> myPreviousDependencies = new TreeMap<TextRange, LeafBlockWrapper>((o1, o2) -> {
        int offsetsDelta = o1.getEndOffset() - o2.getEndOffset();
        if (offsetsDelta == 0) {
            offsetsDelta = o2.getStartOffset() - o1.getStartOffset();
        }
        return offsetsDelta;
    });

    DependentSpacingEngine(BlockRangesMap helper) {
        this.myBlockRangesMap = helper;
    }

    boolean shouldReformatPreviouslyLocatedDependentSpacing(WhiteSpace space) {
        TextRange changed = space.getTextRange();
        SortedMap<TextRange, LeafBlockWrapper> sortedHeadMap = this.myPreviousDependencies.tailMap(changed);
        for (Map.Entry<TextRange, LeafBlockWrapper> entry : sortedHeadMap.entrySet()) {
            boolean containsLineFeeds;
            boolean containedLineFeeds;
            DependantSpacingImpl spacing;
            LeafBlockWrapper currentBlock;
            SpacingImpl spacingImpl;
            TextRange textRange = entry.getKey();
            if (!textRange.contains(changed) || !((spacingImpl = (currentBlock = entry.getValue()).getSpaceProperty()) instanceof DependantSpacingImpl) || (spacing = (DependantSpacingImpl)spacingImpl).isDependentRegionLinefeedStatusChanged(this.myIteration) || (containedLineFeeds = spacing.getMinLineFeeds() > 0) == (containsLineFeeds = this.myBlockRangesMap.containsLineFeedsOrTooLong(textRange))) continue;
            if (!spacing.isDependantSpacingChangedAtLeastOnce()) {
                spacing.setDependentRegionLinefeedStatusChanged(this.myIteration);
                return true;
            }
            if (!containsLineFeeds) continue;
            spacing.setDependentRegionLinefeedStatusChanged(this.myIteration);
            this.myLeafBlocksToReformat.add(currentBlock);
            return false;
        }
        return false;
    }

    void incrementIteration() {
        ++this.myIteration;
    }

    void registerUnresolvedDependentSpacingRanges(LeafBlockWrapper leafBlockWrapper, List<? extends TextRange> unprocessedRanges) {
        Object object = leafBlockWrapper.getSpaceProperty();
        if (!(object instanceof DependantSpacingImpl)) {
            return;
        }
        DependantSpacingImpl dependantSpaceProperty = (DependantSpacingImpl)((Object)object);
        if (dependantSpaceProperty.isDependentRegionLinefeedStatusChanged(this.myIteration)) {
            return;
        }
        for (TextRange textRange : unprocessedRanges) {
            this.myPreviousDependencies.put(textRange, leafBlockWrapper);
        }
    }

    Set<LeafBlockWrapper> getLeafBlocksToReformat() {
        return this.myLeafBlocksToReformat;
    }

    void clear() {
        this.myPreviousDependencies.clear();
    }
}

