/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.ClipboardSynchronizer;
import com.intellij.ide.CopyPasteManagerWithHistory;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class LocalCopyPasteManager
extends CopyPasteManagerWithHistory {
    private static final Logger LOG = Logger.getInstance(LocalCopyPasteManager.class);
    private final ClipboardOwner mySelectionOwner = (clipboard, contents) -> this.lostSelectionOwnership(contents);

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
        ClipboardSynchronizer.getInstance().resetContent();
        super.lostOwnership(clipboard, contents);
    }

    @Override
    public boolean areDataFlavorsAvailable(DataFlavor ... flavors) {
        if (flavors == null) {
            LocalCopyPasteManager.$$$reportNull$$$0(0);
        }
        return flavors.length > 0 && ClipboardSynchronizer.getInstance().areDataFlavorsAvailable(flavors);
    }

    @Override
    public Transferable getContents() {
        return ClipboardSynchronizer.getInstance().getContents();
    }

    @Override
    @Nullable
    public <T> T getContents(@NotNull DataFlavor flavor2) {
        if (flavor2 == null) {
            LocalCopyPasteManager.$$$reportNull$$$0(1);
        }
        if (this.areDataFlavorsAvailable(flavor2)) {
            return (T)ClipboardSynchronizer.getInstance().getData(flavor2);
        }
        return null;
    }

    @Override
    protected void doSetSystemClipboardContent(Transferable content2) {
        ClipboardSynchronizer.getInstance().setContent(content2, this);
    }

    @Override
    public boolean isSystemSelectionSupported() {
        return Toolkit.getDefaultToolkit().getSystemSelection() != null;
    }

    @Override
    @Nullable
    public Transferable getSystemSelectionContents() {
        Clipboard selection = Toolkit.getDefaultToolkit().getSystemSelection();
        if (selection != null) {
            try {
                return selection.getContents(null);
            }
            catch (Exception e) {
                LOG.info((Throwable)e);
            }
        }
        return null;
    }

    @Override
    public void setSystemSelectionContents(@NotNull Transferable content2) {
        Clipboard selection;
        if (content2 == null) {
            LocalCopyPasteManager.$$$reportNull$$$0(2);
        }
        if ((selection = Toolkit.getDefaultToolkit().getSystemSelection()) != null) {
            selection.setContents(content2, this.mySelectionOwner);
        }
    }

    protected void lostSelectionOwnership(Transferable content2) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flavors";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flavor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/LocalCopyPasteManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "areDataFlavorsAvailable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getContents";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setSystemSelectionContents";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

