/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.impl.ModifiableModelCommitter;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

public final class PatchProjectUtil {
    private PatchProjectUtil() {
    }

    public static void patchProject(Project project2) {
        Map<Pattern, Set<Pattern>> excludePatterns = PatchProjectUtil.loadPatterns("idea.exclude.patterns");
        Map<Pattern, Set<Pattern>> includePatterns = PatchProjectUtil.loadPatterns("idea.include.patterns");
        if (excludePatterns.isEmpty() && includePatterns.isEmpty()) {
            return;
        }
        PatchProjectUtil.patchProject(project2, excludePatterns, includePatterns);
    }

    @VisibleForTesting
    public static void patchProject(Project project2, final Map<Pattern, Set<Pattern>> excludePatterns, final Map<Pattern, Set<Pattern>> includePatterns) {
        ModifiableModuleModel modulesModel = ModuleManager.getInstance((Project)project2).getModifiableModel();
        Module[] modules = modulesModel.getModules();
        ModifiableRootModel[] models = new ModifiableRootModel[modules.length];
        for (int i2 = 0; i2 < modules.length; ++i2) {
            ContentEntry[] contentEntries;
            ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)modules[i2]);
            models[i2] = rootManager.getModifiableModel();
            final String moduleName = modules[i2].getName();
            for (final ContentEntry contentEntry : contentEntries = models[i2].getContentEntries()) {
                final VirtualFile contentRoot = contentEntry.getFile();
                if (contentRoot == null) continue;
                final HashSet included = new HashSet();
                VfsUtilCore.visitChildrenRecursively((VirtualFile)contentRoot, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

                    @NotNull
                    public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile fileOrDir) {
                        Set dirPatterns;
                        if (fileOrDir == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        String relativeName = VfsUtilCore.getRelativePath((VirtualFile)fileOrDir, (VirtualFile)contentRoot, (char)'/');
                        for (Pattern module : excludePatterns.keySet()) {
                            if (module != null && !module.matcher(moduleName).matches()) continue;
                            dirPatterns = (Set)excludePatterns.get(module);
                            for (Pattern pattern : dirPatterns) {
                                if (!pattern.matcher(relativeName).matches()) continue;
                                contentEntry.addExcludeFolder(fileOrDir);
                                VirtualFileVisitor.Result result2 = relativeName.isEmpty() ? CONTINUE : SKIP_CHILDREN;
                                if (result2 == null) {
                                    1.$$$reportNull$$$0(1);
                                }
                                return result2;
                            }
                        }
                        if (includePatterns.isEmpty()) {
                            VirtualFileVisitor.Result result3 = CONTINUE;
                            if (result3 == null) {
                                1.$$$reportNull$$$0(2);
                            }
                            return result3;
                        }
                        for (Pattern module : includePatterns.keySet()) {
                            if (module != null && !module.matcher(moduleName).matches()) continue;
                            dirPatterns = (Set)includePatterns.get(module);
                            for (Pattern pattern : dirPatterns) {
                                if (!pattern.matcher(relativeName).matches()) continue;
                                included.add(fileOrDir);
                                VirtualFileVisitor.Result result4 = CONTINUE;
                                if (result4 == null) {
                                    1.$$$reportNull$$$0(3);
                                }
                                return result4;
                            }
                        }
                        VirtualFileVisitor.Result result5 = CONTINUE;
                        if (result5 == null) {
                            1.$$$reportNull$$$0(4);
                        }
                        return result5;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[switch (n) {
                            default -> 3;
                            case 1, 2, 3, 4 -> 2;
                        }];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "fileOrDir";
                                break;
                            }
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "com/intellij/ide/impl/PatchProjectUtil$1";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "com/intellij/ide/impl/PatchProjectUtil$1";
                                break;
                            }
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: {
                                objectArray = objectArray2;
                                objectArray2[1] = "visitFileEx";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray;
                                objectArray[2] = "visitFileEx";
                                break;
                            }
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: {
                                break;
                            }
                        }
                        String string = String.format(v0, objectArray);
                        throw switch (n) {
                            default -> new IllegalArgumentException(string);
                            case 1, 2, 3, 4 -> new IllegalStateException(string);
                        };
                    }
                });
                PatchProjectUtil.processIncluded(contentEntry, included);
            }
        }
        ApplicationManager.getApplication().runWriteAction(() -> ModifiableModelCommitter.multiCommit((ModifiableRootModel[])models, (ModifiableModuleModel)modulesModel));
    }

    public static void processIncluded(ContentEntry contentEntry, Set<? extends VirtualFile> included) {
        if (included.isEmpty()) {
            return;
        }
        HashSet<VirtualFile> parents = new HashSet<VirtualFile>();
        for (VirtualFile virtualFile2 : included) {
            if (Comparing.equal((Object)virtualFile2, (Object)contentEntry.getFile())) {
                return;
            }
            VirtualFile parent = virtualFile2.getParent();
            if (parent == null || parents.contains(parent)) continue;
            parents.add(parent);
            for (VirtualFile toExclude : parent.getChildren()) {
                boolean toExcludeSibling = true;
                for (VirtualFile virtualFile3 : included) {
                    if (!VfsUtilCore.isAncestor((VirtualFile)toExclude, (VirtualFile)virtualFile3, (boolean)false)) continue;
                    toExcludeSibling = false;
                    break;
                }
                if (!toExcludeSibling) continue;
                contentEntry.addExcludeFolder(toExclude);
            }
        }
        PatchProjectUtil.processIncluded(contentEntry, parents);
    }

    public static Map<Pattern, Set<Pattern>> loadPatterns(@NonNls String propertyKey) {
        HashMap<Pattern, Set<Pattern>> result2 = new HashMap<Pattern, Set<Pattern>>();
        String patterns = System.getProperty(propertyKey);
        if (patterns != null) {
            String[] pathPatterns;
            for (String excludedPattern : pathPatterns = patterns.split(";")) {
                String module = null;
                int idx = 0;
                if (excludedPattern.startsWith("[")) {
                    idx = excludedPattern.indexOf("]") + 1;
                    module = excludedPattern.substring(1, idx - 1);
                }
                Pattern modulePattern = module != null ? Pattern.compile(StringUtil.replace(module, (String)"*", (String)".*")) : null;
                Pattern pattern = Pattern.compile(FileUtil.convertAntToRegexp((String)excludedPattern.substring(idx)));
                HashSet<Pattern> dirPatterns = (HashSet<Pattern>)result2.get(modulePattern);
                if (dirPatterns == null) {
                    dirPatterns = new HashSet<Pattern>();
                    result2.put(modulePattern, dirPatterns);
                }
                dirPatterns.add(pattern);
            }
        }
        return result2;
    }
}

