/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.ListPluginModel;
import com.intellij.ide.plugins.PluginsGroupType;
import com.intellij.ide.plugins.newui.PluginModelFacade;
import com.intellij.ide.plugins.newui.PluginUiModel;
import com.intellij.ide.plugins.newui.PluginUiModelAdapter;
import com.intellij.ide.plugins.newui.UIPluginGroup;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class PluginsGroup {
    @Nls
    protected final String myTitlePrefix;
    @Nls
    public String title;
    public JLabel titleLabel;
    public LinkLabel<Object> rightAction;
    public List<JComponent> rightActions;
    public UIPluginGroup ui;
    public Runnable clearCallback;
    public PluginsGroupType type;
    private final List<PluginUiModel> models;
    private final ListPluginModel preloadedModel;

    public PluginsGroup(@NotNull @Nls String title2, @NotNull PluginsGroupType type) {
        if (title2 == null) {
            PluginsGroup.$$$reportNull$$$0(0);
        }
        if (type == null) {
            PluginsGroup.$$$reportNull$$$0(1);
        }
        this.models = new ArrayList<PluginUiModel>();
        this.preloadedModel = new ListPluginModel();
        this.myTitlePrefix = title2;
        this.title = title2;
        this.type = type;
    }

    public void clear() {
        this.ui = null;
        this.models.clear();
        this.titleLabel = null;
        this.rightAction = null;
        this.rightActions = null;
        if (this.clearCallback != null) {
            this.clearCallback.run();
            this.clearCallback = null;
        }
    }

    public void addRightAction(@NotNull JComponent component2) {
        if (component2 == null) {
            PluginsGroup.$$$reportNull$$$0(2);
        }
        if (this.rightActions == null) {
            this.rightActions = new ArrayList<JComponent>();
        }
        this.rightActions.add(component2);
    }

    public void titleWithCount() {
        this.title = this.myTitlePrefix + " (" + this.models.size() + ")";
        this.updateTitle();
    }

    public void titleWithEnabled(@NotNull PluginModelFacade pluginModelFacade) {
        if (pluginModelFacade == null) {
            PluginsGroup.$$$reportNull$$$0(3);
        }
        int enabled2 = 0;
        for (PluginUiModel descriptor2 : this.models) {
            if (!pluginModelFacade.isLoaded(descriptor2) || !pluginModelFacade.isEnabled(descriptor2) || descriptor2.isIncompatible()) continue;
            ++enabled2;
        }
        this.titleWithCount(enabled2);
    }

    public void titleWithCount(int enabled2) {
        this.title = IdeBundle.message((String)"plugins.configurable.title.with.count", (Object[])new Object[]{this.myTitlePrefix, enabled2, this.models.size()});
        this.updateTitle();
    }

    public int getPluginIndex(@NotNull PluginId pluginId) {
        if (pluginId == null) {
            PluginsGroup.$$$reportNull$$$0(4);
        }
        for (int i2 = 0; i2 < this.models.size(); ++i2) {
            if (!this.models.get(i2).getPluginId().equals((Object)pluginId)) continue;
            return i2;
        }
        return -1;
    }

    public ListPluginModel getPreloadedModel() {
        return this.preloadedModel;
    }

    protected void updateTitle() {
        if (this.titleLabel != null) {
            this.titleLabel.setText(this.title);
        }
    }

    public int addWithIndex(@NotNull PluginUiModel model2) {
        if (model2 == null) {
            PluginsGroup.$$$reportNull$$$0(5);
        }
        this.models.add(model2);
        this.sortByName();
        return this.models.indexOf(model2);
    }

    @Deprecated
    public void addDescriptor(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            PluginsGroup.$$$reportNull$$$0(6);
        }
        this.models.add(new PluginUiModelAdapter(descriptor2));
    }

    public void addModel(@NotNull PluginUiModel model2) {
        if (model2 == null) {
            PluginsGroup.$$$reportNull$$$0(7);
        }
        this.models.add(model2);
    }

    @Deprecated
    public void addDescriptors(@NotNull Collection<? extends IdeaPluginDescriptor> descriptors2) {
        if (descriptors2 == null) {
            PluginsGroup.$$$reportNull$$$0(8);
        }
        this.models.addAll(ContainerUtil.map(descriptors2, PluginUiModelAdapter::new));
    }

    public void addModels(@NotNull Collection<? extends PluginUiModel> models) {
        if (models == null) {
            PluginsGroup.$$$reportNull$$$0(9);
        }
        this.models.addAll(models);
    }

    public void addModels(int index, @NotNull Collection<PluginUiModel> models) {
        if (models == null) {
            PluginsGroup.$$$reportNull$$$0(10);
        }
        this.models.addAll(index, models);
    }

    public void removeDescriptor(@NotNull PluginUiModel model2) {
        if (model2 == null) {
            PluginsGroup.$$$reportNull$$$0(11);
        }
        this.models.remove(model2);
    }

    @Deprecated
    @NotNull
    public List<IdeaPluginDescriptor> getDescriptors() {
        List list2 = ContainerUtil.map(this.models, it -> it.getDescriptor());
        if (list2 == null) {
            PluginsGroup.$$$reportNull$$$0(12);
        }
        return list2;
    }

    @NotNull
    public List<PluginUiModel> getModels() {
        List<PluginUiModel> list2 = this.models;
        if (list2 == null) {
            PluginsGroup.$$$reportNull$$$0(13);
        }
        return list2;
    }

    public void removeDuplicates() {
        ContainerUtil.removeDuplicates(this.models);
    }

    public void sortByName() {
        PluginsGroup.sortByName(this.models);
    }

    public static void sortByName(@NotNull List<PluginUiModel> models) {
        if (models == null) {
            PluginsGroup.$$$reportNull$$$0(14);
        }
        ContainerUtil.sort(models, (o1, o2) -> StringUtil.compare((String)o1.getName(), (String)o2.getName(), (boolean)true));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginModelFacade";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginId";
                break;
            }
            case 5: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 9: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "models";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/newui/PluginsGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/newui/PluginsGroup";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptors";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getModels";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addRightAction";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "titleWithEnabled";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPluginIndex";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addWithIndex";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addDescriptor";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addModel";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addDescriptors";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addModels";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "removeDescriptor";
                break;
            }
            case 12: 
            case 13: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "sortByName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12, 13 -> new IllegalStateException(string);
        };
    }
}

