/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.newui.SearchPopupCallback;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindow;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.ScreenReader;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class SearchPopup
extends ComponentAdapter
implements CaretListener {
    public final Type type;
    private final JBPopupListener myListener;
    private final JBTextField myEditor;
    private JBPopup myPopup;
    private LightweightWindowEvent myEvent;
    private Component myDialogComponent;
    public final CollectionListModel<Object> model;
    public JList<Object> list;
    public int caretPosition;
    public SearchPopupCallback callback;
    public boolean skipCaretEvent;
    public Object data;

    public SearchPopup(@NotNull SearchTextField searchTextField, @NotNull JBPopupListener listener2, @NotNull Type type, @NotNull CollectionListModel<Object> model2, int caretPosition) {
        if (searchTextField == null) {
            SearchPopup.$$$reportNull$$$0(0);
        }
        if (listener2 == null) {
            SearchPopup.$$$reportNull$$$0(1);
        }
        if (type == null) {
            SearchPopup.$$$reportNull$$$0(2);
        }
        if (model2 == null) {
            SearchPopup.$$$reportNull$$$0(3);
        }
        this.myEditor = searchTextField.getTextEditor();
        this.myListener = listener2;
        this.type = type;
        this.model = model2;
        this.caretPosition = caretPosition;
    }

    public void createAndShow(@NotNull Consumer callback, @NotNull ColoredListCellRenderer renderer2, boolean async2) {
        if (callback == null) {
            SearchPopup.$$$reportNull$$$0(4);
        }
        if (renderer2 == null) {
            SearchPopup.$$$reportNull$$$0(5);
        }
        if (callback instanceof SearchPopupCallback) {
            this.callback = (SearchPopupCallback)callback;
        }
        Insets ipad = renderer2.getIpad();
        ipad.left = ipad.right = SearchPopup.getXOffset();
        renderer2.setFont(this.myEditor.getFont());
        this.list = new JBList(this.model);
        this.myPopup = JBPopupFactory.getInstance().createListPopupBuilder((JList)this.list).setMovable(false).setResizable(false).setRequestFocus(ScreenReader.isActive()).setAccessibleName(IdeBundle.message((String)"plugin.manager.search.filters.popup.accessible.name", (Object[])new Object[0])).setItemChosenCallback(callback).setFont(this.myEditor.getFont()).setRenderer((ListCellRenderer)renderer2).createPopup();
        this.myEvent = new LightweightWindowEvent((LightweightWindow)this.myPopup);
        this.skipCaretEvent = true;
        this.myPopup.addListener(this.myListener);
        this.myEditor.addCaretListener((CaretListener)this);
        this.myDialogComponent = this.myEditor.getRootPane().getParent();
        if (this.myDialogComponent != null) {
            this.myDialogComponent.addComponentListener(this);
        }
        if (async2) {
            SwingUtilities.invokeLater(this::show);
        } else {
            this.show();
        }
    }

    private static int getXOffset() {
        int i2 = UIUtil.isUnderWin10LookAndFeel() ? 5 : UIUtil.getListCellHPadding();
        return JBUIScale.scale((int)i2);
    }

    @NotNull
    private Point getPopupLocation() {
        Point location;
        try {
            Rectangle view2 = this.myEditor.modelToView(this.caretPosition);
            location = new Point((int)view2.getMaxX(), (int)view2.getMaxY());
        }
        catch (BadLocationException ignore) {
            location = this.myEditor.getCaret().getMagicCaretPosition();
        }
        SwingUtilities.convertPointToScreen(location, (Component)this.myEditor);
        location.x -= SearchPopup.getXOffset() + JBUIScale.scale((int)2);
        location.y += 2;
        Point point = location;
        if (point == null) {
            SearchPopup.$$$reportNull$$$0(6);
        }
        return point;
    }

    public boolean isValid() {
        return this.myPopup.isVisible() && this.myPopup.getContent().getParent() != null;
    }

    public void update() {
        this.skipCaretEvent = true;
        this.myPopup.setLocation(this.getPopupLocation());
        this.myPopup.pack(true, true);
    }

    private void show() {
        if (this.myPopup != null) {
            if (!ScreenReader.isActive()) {
                this.list.clearSelection();
            }
            this.myPopup.showInScreenCoordinates((Component)this.myEditor, this.getPopupLocation());
        }
    }

    public void hide() {
        this.myEditor.removeCaretListener((CaretListener)this);
        if (this.myDialogComponent != null) {
            this.myDialogComponent.removeComponentListener(this);
            this.myDialogComponent = null;
        }
        if (this.myPopup != null) {
            this.myPopup.cancel();
            this.myPopup = null;
        }
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        if (this.skipCaretEvent) {
            this.skipCaretEvent = false;
        } else {
            this.hide();
            this.myListener.onClosed(this.myEvent);
        }
    }

    @Override
    public void componentMoved(ComponentEvent e) {
        if (this.myPopup != null && this.isValid()) {
            this.update();
        }
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.componentMoved(e);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchTextField";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/newui/SearchPopup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/newui/SearchPopup";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPopupLocation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createAndShow";
                break;
            }
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }

    public static enum Type {
        AttributeName,
        AttributeValue,
        SearchQuery;

    }
}

