/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.ide.ui.LicenseRelatedStatusBarWidgetFactory;
import com.intellij.ide.ui.LicenseRelatedStatusBarWidgetProjectService;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.WidgetLabel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.impl.InternalUICustomization;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.wm.CustomStatusBarWidget;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarListener;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.ui.ClickListener;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.TextIcon;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b'\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nH\u0015J\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012J\b\u0010 \u001a\u00020!H$J\b\u0010\"\u001a\u00020\fH\u0007J\b\u0010#\u001a\u00020\nH\u0002J\r\u0010$\u001a\u00070%\u00a2\u0006\u0002\b&H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0013\u001a\u00020\u0007X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u0007X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015R\u0012\u0010\u0018\u001a\u00020\u0019X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0016\u0010\u001c\u001a\u0004\u0018\u00010\u0019X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001bR\u0012\u0010\u001e\u001a\u00020\u0019X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001b\u00a8\u0006'"}, d2={"Lcom/intellij/ide/ui/LicenseRelatedStatusBarWidget;", "Lcom/intellij/openapi/wm/CustomStatusBarWidget;", "factory", "Lcom/intellij/ide/ui/LicenseRelatedStatusBarWidgetFactory;", "<init>", "(Lcom/intellij/ide/ui/LicenseRelatedStatusBarWidgetFactory;)V", "ID", "", "lazyLabel", "Lkotlin/Lazy;", "Ljavax/swing/JLabel;", "onComponentCreated", "", "label", "getComponent", "Ljavax/swing/JComponent;", "install", "statusBar", "Lcom/intellij/openapi/wm/StatusBar;", "text", "getText", "()Ljava/lang/String;", "tooltip", "getTooltip", "foreground", "Ljava/awt/Color;", "getForeground", "()Ljava/awt/Color;", "background", "getBackground", "borderColor", "getBorderColor", "createClickListener", "Lcom/intellij/ui/ClickListener;", "updateWidget", "createLabel", "getStatusFont", "Lcom/intellij/util/ui/JBFont;", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public abstract class LicenseRelatedStatusBarWidget
implements CustomStatusBarWidget {
    @NotNull
    private final LicenseRelatedStatusBarWidgetFactory factory;
    @NotNull
    private final Lazy<JLabel> lazyLabel;
    @Nullable
    private final String tooltip;
    @Nullable
    private final Color background;

    public LicenseRelatedStatusBarWidget(@NotNull LicenseRelatedStatusBarWidgetFactory factory2) {
        Intrinsics.checkNotNullParameter((Object)factory2, (String)"factory");
        this.factory = factory2;
        this.lazyLabel = LazyKt.lazy(() -> LicenseRelatedStatusBarWidget.lazyLabel$lambda$0(this));
    }

    @NotNull
    public final String ID() {
        String string = this.factory.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        return string;
    }

    @RequiresEdt
    protected void onComponentCreated(@NotNull JLabel label2) {
        Intrinsics.checkNotNullParameter((Object)label2, (String)"label");
    }

    @NotNull
    public final JComponent getComponent() {
        return (JComponent)this.lazyLabel.getValue();
    }

    public final void install(@NotNull StatusBar statusBar) {
        Intrinsics.checkNotNullParameter((Object)statusBar, (String)"statusBar");
        Project project2 = statusBar.getProject();
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        statusBar.addListener(new StatusBarListener(statusBar, this, project3){
            final /* synthetic */ StatusBar $statusBar;
            final /* synthetic */ LicenseRelatedStatusBarWidget this$0;
            final /* synthetic */ Project $project;
            {
                this.$statusBar = $statusBar;
                this.this$0 = $receiver;
                this.$project = $project;
            }

            public void widgetAdded(StatusBarWidget addedWidget, String anchor) {
                int rightmostLicenseUnrelated;
                Intrinsics.checkNotNullParameter((Object)addedWidget, (String)"addedWidget");
                if (addedWidget instanceof LicenseRelatedStatusBarWidget) {
                    return;
                }
                Collection collection = this.$statusBar.getAllWidgets();
                int myIndex = collection != null ? CollectionsKt.lastIndexOf((Iterable)collection, (Object)this.this$0) : 0;
                Collection collection2 = this.$statusBar.getAllWidgets();
                if (collection2 != null) {
                    Iterable $this$indexOfLast$iv = collection2;
                    boolean $i$f$indexOfLast = false;
                    int lastIndex$iv = -1;
                    int index$iv = 0;
                    for (T item$iv : $this$indexOfLast$iv) {
                        if (index$iv < 0) {
                            CollectionsKt.throwIndexOverflow();
                        }
                        StatusBarWidget it = (StatusBarWidget)item$iv;
                        boolean bl = false;
                        if (!(it instanceof LicenseRelatedStatusBarWidget)) {
                            lastIndex$iv = index$iv;
                        }
                        ++index$iv;
                    }
                    v2 = lastIndex$iv;
                } else {
                    v2 = rightmostLicenseUnrelated = 0;
                }
                if (myIndex < rightmostLicenseUnrelated) {
                    this.$statusBar.removeWidget(this.this$0.ID());
                    ComponentManager $this$service$iv = (ComponentManager)this.$project;
                    boolean $i$f$service = false;
                    Class<LicenseRelatedStatusBarWidgetProjectService> serviceClass$iv = LicenseRelatedStatusBarWidgetProjectService.class;
                    Object object = $this$service$iv.getService(serviceClass$iv);
                    if (object == null) {
                        throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                    }
                    CoroutineScope cs = ((LicenseRelatedStatusBarWidgetProjectService)object).getCs();
                    StatusBarWidget statusBarWidget = LicenseRelatedStatusBarWidget.access$getFactory$p(this.this$0).createWidget(this.$project, cs);
                    Intrinsics.checkNotNullExpressionValue((Object)statusBarWidget, (String)"createWidget(...)");
                    StatusBarWidget widget2 = statusBarWidget;
                    this.$statusBar.addWidget(widget2, "last");
                }
            }
        }, (Disposable)this);
    }

    @NotNull
    protected abstract String getText();

    @Nullable
    protected String getTooltip() {
        return this.tooltip;
    }

    @NotNull
    protected abstract Color getForeground();

    @Nullable
    protected Color getBackground() {
        return this.background;
    }

    @NotNull
    protected abstract Color getBorderColor();

    @NotNull
    protected abstract ClickListener createClickListener();

    @RequiresEdt
    public final void updateWidget() {
        TextIcon icon2;
        if (!this.lazyLabel.isInitialized()) {
            return;
        }
        JLabel label2 = (JLabel)this.lazyLabel.getValue();
        String text2 = this.getText();
        Icon icon3 = label2.getIcon();
        TextIcon textIcon = icon2 = icon3 instanceof TextIcon ? (TextIcon)icon3 : null;
        if (textIcon != null) {
            textIcon.setText(text2);
        }
        TextIcon textIcon2 = icon2;
        if (textIcon2 != null) {
            textIcon2.setForeground(this.getForeground());
        }
        TextIcon textIcon3 = icon2;
        if (textIcon3 != null) {
            textIcon3.setBackground(this.getBackground());
        }
        TextIcon textIcon4 = icon2;
        if (textIcon4 != null) {
            textIcon4.setBorderColor(this.getBorderColor());
        }
        label2.setToolTipText(this.getTooltip());
        label2.putClientProperty("AccessibleName", text2);
        label2.revalidate();
        label2.repaint();
    }

    private final JLabel createLabel() {
        UISettings uiSettings = UISettings.Companion.getInstance();
        String text2 = this.getText();
        TextIcon icon2 = new TextIcon(text2, this.getForeground(), this.getBackground(), this.getBorderColor(), 0, true);
        icon2.setFont((Font)this.getStatusFont());
        icon2.setRound(18);
        icon2.setInsets((Insets)JBUI.insets((int)(!ExperimentalUI.Companion.isNewUI() || uiSettings.getCompactMode() ? 3 : 4), (int)8));
        WidgetLabel label2 = ExperimentalUI.Companion.isNewUI() ? (WidgetLabel)new WidgetLabel(uiSettings, icon2, this){
            private boolean compactMode;
            private float scale;
            private Font oldFont;
            final /* synthetic */ UISettings $uiSettings;
            final /* synthetic */ TextIcon $icon;
            final /* synthetic */ LicenseRelatedStatusBarWidget this$0;
            {
                this.$uiSettings = $uiSettings;
                this.$icon = $icon;
                this.this$0 = $receiver;
                super($icon);
                this.compactMode = $uiSettings.getCompactMode();
                this.scale = $uiSettings.getIdeScale();
                this.oldFont = this.getFont();
            }

            public final boolean getCompactMode() {
                return this.compactMode;
            }

            public final void setCompactMode(boolean bl) {
                this.compactMode = bl;
            }

            public final float getScale() {
                return this.scale;
            }

            public final void setScale(float f) {
                this.scale = f;
            }

            public final Font getOldFont() {
                return this.oldFont;
            }

            public final void setOldFont(Font font) {
                this.oldFont = font;
            }

            public void paint(Graphics g) {
                Object object;
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                boolean newValue = this.$uiSettings.getCompactMode();
                float newScale = this.$uiSettings.getIdeScale();
                if (this.compactMode != newValue || !(this.scale == newScale) || !Intrinsics.areEqual((Object)this.oldFont, (Object)this.getFont())) {
                    this.compactMode = newValue;
                    this.scale = newScale;
                    this.oldFont = this.getFont();
                    this.$icon.setInsets((Insets)JBUI.insets((int)(newValue ? 3 : 4), (int)8));
                    this.$icon.setFont((Font)LicenseRelatedStatusBarWidget.access$getStatusFont(this.this$0));
                    this.$icon.setFontTransform(this.getFontMetrics(this.$icon.getFont()).getFontRenderContext().getTransform());
                    this.getParent().revalidate();
                }
                if ((object = InternalUICustomization.Companion.getInstance()) == null || (object = ((InternalUICustomization)object).preserveGraphics(g)) == null) {
                    object = g;
                }
                super.paint((Graphics)object);
            }
        } : new WidgetLabel(icon2);
        icon2.setFontTransform(label2.getFontMetrics(icon2.getFont()).getFontRenderContext().getTransform());
        label2.putClientProperty("AccessibleName", text2);
        ClickListener popup2 = this.createClickListener();
        label2.setClickListener(popup2);
        popup2.installOn((Component)label2);
        label2.setToolTipText(this.getTooltip());
        return label2;
    }

    private final JBFont getStatusFont() {
        JBFont jBFont = SystemInfoRt.isMac && !ExperimentalUI.Companion.isNewUI() ? JBFont.small() : JBFont.medium();
        Intrinsics.checkNotNull((Object)jBFont);
        return jBFont;
    }

    private static final JLabel lazyLabel$lambda$0(LicenseRelatedStatusBarWidget this$0) {
        JLabel jLabel;
        JLabel it = jLabel = this$0.createLabel();
        boolean bl = false;
        this$0.onComponentCreated(it);
        return jLabel;
    }

    public static final /* synthetic */ LicenseRelatedStatusBarWidgetFactory access$getFactory$p(LicenseRelatedStatusBarWidget $this) {
        return $this.factory;
    }

    public static final /* synthetic */ JBFont access$getStatusFont(LicenseRelatedStatusBarWidget $this) {
        return $this.getStatusFont();
    }
}

