/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.customization;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.customization.ActionUrl;
import com.intellij.ide.ui.customization.CustomActionsListener;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.ide.ui.customization.CustomisedActionGroup;
import com.intellij.ide.ui.customization.CustomizableActionsPanel;
import com.intellij.internal.statistic.collectors.fus.actions.persistence.ActionIdProvider;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.ActionWithDelegate;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.ex.QuickList;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.impl.ui.ActionsTreeUtil;
import com.intellij.openapi.keymap.impl.ui.Group;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.PopupMenuListenerAdapter;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.TreeTraversal;
import com.intellij.util.diff.Diff;
import com.intellij.util.diff.FilesTooBigForDiffException;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CustomizationUtil {
    private static final Logger LOG = Logger.getInstance(CustomizationUtil.class);
    public static final Key<Boolean> DISABLE_CUSTOMIZE_POPUP_KEY = Key.create((String)"CustomizationUtil.DisablePopup");

    private CustomizationUtil() {
    }

    public static ActionGroup correctActionGroup(ActionGroup group2, CustomActionsSchema schema, String defaultGroupName, String rootGroupName, boolean force) {
        int index;
        if (!force && !schema.isCorrectActionGroup(group2, defaultGroupName)) {
            return group2;
        }
        Object text2 = group2.getTemplatePresentation().getText(true);
        if (text2 != null && 0 <= (index = group2.getTemplatePresentation().getDisplayedMnemonicIndex()) && index <= ((String)text2).length()) {
            text2 = ((String)text2).substring(0, index) + "\u001b" + ((String)text2).substring(index);
        }
        CustomisedActionGroup correctedGroup = new CustomisedActionGroup((String)text2, group2, schema, defaultGroupName, rootGroupName);
        String groupId = ActionManager.getInstance().getId((AnAction)group2);
        for (ActionUrl actionUrl : schema.getActions()) {
            Group g;
            Object object = actionUrl.getComponent();
            Group g1 = object instanceof Group ? (g = (Group)object) : null;
            if (g1 == null || !Objects.equals(g1.getId(), groupId)) continue;
            if (!g1.isForceShowAsPopup()) break;
            correctedGroup.setPopup(true);
            break;
        }
        return correctedGroup;
    }

    static AnAction @NotNull [] getReordableChildren(@NotNull ActionGroup group2, AnAction @NotNull [] children2, @NotNull CustomActionsSchema schema, String defaultGroupName, String rootGroupName) {
        String pg;
        if (group2 == null) {
            CustomizationUtil.$$$reportNull$$$0(0);
        }
        if (schema == null) {
            CustomizationUtil.$$$reportNull$$$0(1);
        }
        if (children2 == null) {
            CustomizationUtil.$$$reportNull$$$0(2);
        }
        String text2 = group2.getTemplatePresentation().getText();
        ActionManager actionManager = ActionManager.getInstance();
        ArrayList<Object> reorderedChildren = new ArrayList<Object>();
        ContainerUtil.addAll(reorderedChildren, (Object[])children2);
        for (ActionUrl actionUrl : schema.getActions()) {
            AnAction ca;
            pg = actionUrl.getParentGroup();
            if (pg == null || !pg.equals(text2) && !pg.equals(defaultGroupName) && (!pg.equals(actionManager.getId((AnAction)group2)) || !actionUrl.getRootGroup().equals(rootGroupName)) || (ca = actionUrl.getComponentAction()) == null) continue;
            int position2 = actionUrl.getAbsolutePosition();
            if (actionUrl.getActionType() == 1) {
                if (ca == group2) {
                    LOG.error("Attempt to add group to itself; group ID=" + actionManager.getId((AnAction)group2));
                    continue;
                }
                if (position2 < reorderedChildren.size()) {
                    reorderedChildren.add(position2, ca);
                    continue;
                }
                reorderedChildren.add(ca);
                continue;
            }
            if (actionUrl.getActionType() != -1 || reorderedChildren.remove(ca) || position2 >= reorderedChildren.size()) continue;
            AnAction ra = (AnAction)reorderedChildren.get(position2);
            Presentation rt = ra.getTemplatePresentation();
            Presentation ct = ca.getTemplatePresentation();
            if (!(rt.getText() == null ? StringUtil.isEmpty((String)ct.getText()) : rt.getText().equals(ct.getText()))) continue;
            reorderedChildren.remove(position2);
        }
        for (int i2 = 0; i2 < reorderedChildren.size(); ++i2) {
            pg = reorderedChildren.get(i2);
            if (!(pg instanceof ActionGroup)) continue;
            ActionGroup groupToCorrect = (ActionGroup)pg;
            ActionGroup correctedAction = CustomizationUtil.correctActionGroup(groupToCorrect, schema, "", rootGroupName, false);
            reorderedChildren.set(i2, correctedAction);
        }
        AnAction[] anActionArray = reorderedChildren.toArray(AnAction.EMPTY_ARRAY);
        if (anActionArray == null) {
            CustomizationUtil.$$$reportNull$$$0(3);
        }
        return anActionArray;
    }

    public static void optimizeSchema(JTree tree2, CustomActionsSchema schema) {
        Group rootGroup = new Group("root");
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(rootGroup);
        root.removeAllChildren();
        schema.fillActionGroups(root);
        Tree defaultTree = new Tree((TreeModel)new DefaultTreeModel(root));
        ArrayList<ActionUrl> actions = new ArrayList<ActionUrl>();
        TreeUtil.treeNodeTraverser((TreeNode)((TreeNode)tree2.getModel().getRoot())).traverse(TreeTraversal.PRE_ORDER_DFS).processEach(arg_0 -> CustomizationUtil.lambda$optimizeSchema$0((JTree)defaultTree, actions, schema, arg_0));
        schema.setActions(actions);
    }

    private static void computeDiff(ActionUrl[] defaultUserObjects, ActionUrl[] currentUserObjects, @NotNull List<? super ActionUrl> actions) {
        if (actions == null) {
            CustomizationUtil.$$$reportNull$$$0(4);
        }
        Diff.Change change = null;
        try {
            change = Diff.buildChanges((Object[])defaultUserObjects, (Object[])currentUserObjects);
        }
        catch (FilesTooBigForDiffException e) {
            LOG.info((Throwable)e);
        }
        while (change != null) {
            ActionUrl currentUserObject;
            int idx;
            int i2;
            for (i2 = 0; i2 < change.deleted; ++i2) {
                idx = change.line0 + i2;
                currentUserObject = defaultUserObjects[idx];
                currentUserObject.setActionType(-1);
                currentUserObject.setAbsolutePosition(idx);
                actions.add(currentUserObject);
            }
            for (i2 = 0; i2 < change.inserted; ++i2) {
                idx = change.line1 + i2;
                currentUserObject = currentUserObjects[idx];
                currentUserObject.setActionType(1);
                currentUserObject.setAbsolutePosition(idx);
                actions.add(currentUserObject);
            }
            change = change.link;
        }
    }

    public static TreePath getPathByUserObjects(JTree tree2, TreePath treePath) {
        ArrayList<String> path = new ArrayList<String>();
        for (int i2 = 0; i2 < treePath.getPath().length; ++i2) {
            Group group2 = CustomizationUtil.getGroupForNode((DefaultMutableTreeNode)treePath.getPath()[i2]);
            if (group2 == null) continue;
            path.add(group2.getName());
        }
        return CustomizationUtil.getTreePath(0, path, tree2.getModel().getRoot());
    }

    @ApiStatus.Internal
    public static ActionUrl getActionUrl(TreePath treePath, int actionType) {
        Object object;
        ActionUrl url = new ActionUrl();
        for (int i2 = 0; i2 < treePath.getPath().length - 1; ++i2) {
            Group group2 = CustomizationUtil.getGroupForNode((DefaultMutableTreeNode)treePath.getPath()[i2]);
            if (group2 == null) continue;
            url.getGroupPath().add(group2.getName());
        }
        DefaultMutableTreeNode component2 = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        Object userObj = component2.getUserObject();
        if (userObj instanceof Pair) {
            Pair pair = (Pair)userObj;
            object = pair.first;
        } else {
            object = userObj;
        }
        url.setComponent(object);
        TreeNode parent = component2.getParent();
        url.setAbsolutePosition(parent != null ? parent.getIndex(component2) : 0);
        url.setActionType(actionType);
        return url;
    }

    @ApiStatus.Internal
    public static TreePath getTreePath(JTree tree2, ActionUrl url) {
        return CustomizationUtil.getTreePath(0, url.getGroupPath(), tree2.getModel().getRoot());
    }

    @Nullable
    private static TreePath getTreePath(int positionInPath, List<String> path, Object root) {
        TreeNode child;
        if (!(root instanceof DefaultMutableTreeNode)) {
            return null;
        }
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)root;
        if (path.size() <= positionInPath) {
            return null;
        }
        String pathElement = path.get(positionInPath);
        if (pathElement == null) {
            return null;
        }
        Group group2 = CustomizationUtil.getGroupForNode(treeNode);
        if (group2 == null) {
            return null;
        }
        if (!pathElement.equals(group2.getName())) {
            return null;
        }
        TreePath currentPath = new TreePath(treeNode.getPath());
        if (positionInPath == path.size() - 1) {
            return currentPath;
        }
        for (int j = 0; j < treeNode.getChildCount() && (currentPath = CustomizationUtil.getTreePath(positionInPath + 1, path, child = treeNode.getChildAt(j))) == null; ++j) {
        }
        return currentPath;
    }

    @Nullable
    public static Group getGroupForNode(@NotNull DefaultMutableTreeNode node) {
        Group group2;
        Object object;
        Object userObj;
        if (node == null) {
            CustomizationUtil.$$$reportNull$$$0(5);
        }
        if ((userObj = node.getUserObject()) instanceof Pair) {
            Pair pair = (Pair)userObj;
            object = pair.first;
        } else {
            object = userObj;
        }
        Object value = object;
        return value instanceof Group ? (group2 = (Group)value) : null;
    }

    private static ActionUrl[] getChildUserObjects(DefaultMutableTreeNode node, ActionUrl parent) {
        ArrayList<ActionUrl> result2 = new ArrayList<ActionUrl>();
        ArrayList<String> groupPath = new ArrayList<String>(parent.getGroupPath());
        for (int i2 = 0; i2 < node.getChildCount(); ++i2) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i2);
            ActionUrl url = new ActionUrl();
            url.setGroupPath(groupPath);
            Object userObject = child.getUserObject();
            url.setComponent(userObject instanceof Pair ? ((Pair)userObject).first : userObject);
            result2.add(url);
        }
        return result2.toArray(new ActionUrl[0]);
    }

    @NotNull
    public static MouseListener installPopupHandler(@NotNull JComponent component2, @NotNull String groupId, @NotNull String place) {
        if (component2 == null) {
            CustomizationUtil.$$$reportNull$$$0(6);
        }
        if (groupId == null) {
            CustomizationUtil.$$$reportNull$$$0(7);
        }
        if (place == null) {
            CustomizationUtil.$$$reportNull$$$0(8);
        }
        Supplier<ActionGroup> actionGroupSupplier = () -> (ActionGroup)CustomActionsSchema.getInstance().getCorrectedAction(groupId);
        PopupHandler popupHandler2 = PopupHandler.installPopupMenu((JComponent)component2, (ActionGroup)new PopupComputableActionGroup(actionGroupSupplier), (String)place);
        if (popupHandler2 == null) {
            CustomizationUtil.$$$reportNull$$$0(9);
        }
        return popupHandler2;
    }

    public static void acceptObjectIconAndText(@Nullable Object obj2, @NotNull CustomPresentationConsumer consumer) {
        String text2;
        if (consumer == null) {
            CustomizationUtil.$$$reportNull$$$0(10);
        }
        @Nullable String description = null;
        Icon icon2 = null;
        if (obj2 instanceof Group) {
            Group group2 = (Group)obj2;
            String name2 = group2.getName();
            @NlsSafe String id2 = group2.getId();
            text2 = name2 != null ? name2 : Objects.requireNonNullElse(id2, IdeBundle.message((String)"action.group.name.unnamed.group", (Object[])new Object[0]));
            icon2 = group2.getIcon();
            if (UISettings.getInstance().getShowInplaceCommentsInternal()) {
                description = id2;
            }
        } else if (obj2 instanceof String) {
            Icon actionIcon;
            String actionId = (String)obj2;
            AnAction action2 = ActionManager.getInstance().getAction(actionId);
            String name3 = action2 != null ? action2.getTemplatePresentation().getText() : null;
            String string = text2 = !StringUtil.isEmptyOrSpaces((String)name3) ? name3 : actionId;
            if (action2 != null && (actionIcon = action2.getTemplatePresentation().getIcon()) != null) {
                icon2 = actionIcon;
            }
            if (UISettings.getInstance().getShowInplaceCommentsInternal()) {
                description = actionId;
            }
        } else if (obj2 instanceof Pair) {
            String string;
            Pair pair = (Pair)obj2;
            Object actionIdOrGroup = pair.first;
            if (actionIdOrGroup instanceof Group) {
                Group group3 = (Group)actionIdOrGroup;
                string = group3.getId();
            } else {
                string = (String)actionIdOrGroup;
            }
            String actionId = string;
            AnAction action3 = actionId == null ? null : ActionManager.getInstance().getAction(actionId);
            String t = action3 != null ? action3.getTemplatePresentation().getText() : null;
            text2 = Strings.isNotEmpty((String)t) ? t : Objects.requireNonNullElse(actionId, IdeBundle.message((String)"action.group.name.unnamed.group", (Object[])new Object[0]));
            Icon actionIcon = (Icon)pair.second;
            if (actionIcon == null && action3 != null) {
                actionIcon = (Icon)action3.getTemplatePresentation().getClientProperty(CustomActionsSchema.PROP_ORIGINAL_ICON);
            }
            icon2 = actionIcon;
            if (UISettings.getInstance().getShowInplaceCommentsInternal()) {
                description = actionId;
            }
        } else if (obj2 instanceof Separator) {
            text2 = "-------------";
        } else if (obj2 instanceof QuickList) {
            QuickList quickList = (QuickList)((Object)obj2);
            text2 = quickList.getDisplayName();
            if (UISettings.getInstance().getShowInplaceCommentsInternal()) {
                description = quickList.getActionId();
            }
        } else if (obj2 == null) {
            text2 = "null";
        } else {
            throw new IllegalArgumentException("unknown obj: " + String.valueOf(obj2));
        }
        consumer.accept(text2, description, icon2);
    }

    @NotNull
    public static List<Object> getGroupActions(@NotNull String groupId, @NotNull CustomActionsSchema schema) {
        Group group2;
        if (groupId == null) {
            CustomizationUtil.$$$reportNull$$$0(11);
        }
        if (schema == null) {
            CustomizationUtil.$$$reportNull$$$0(12);
        }
        if ((group2 = CustomizationUtil.getGroup(groupId, schema)) == null) {
            throw new IllegalStateException("ActionGroup[" + groupId + "] is not found");
        }
        ArrayList<Object> arrayList = group2.getChildren();
        if (arrayList == null) {
            CustomizationUtil.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    @Nullable
    public static Group getGroup(@NotNull String groupId, @NotNull CustomActionsSchema schema) {
        AnAction obj2;
        ActionGroup group2;
        if (groupId == null) {
            CustomizationUtil.$$$reportNull$$$0(14);
        }
        if (schema == null) {
            CustomizationUtil.$$$reportNull$$$0(15);
        }
        ActionGroup actionGroup = group2 = (obj2 = schema.getCorrectedAction(groupId)) instanceof ActionGroup ? (ActionGroup)obj2 : null;
        if (group2 == null) {
            return null;
        }
        @NlsSafe String displayName = schema.getDisplayName(groupId);
        return ActionsTreeUtil.createGroup(group2, displayName, null, false, (Condition<? super AnAction>)((Condition)action2 -> true));
    }

    public static void updateActionGroup(@NotNull List<Object> actions, @NotNull String groupId) {
        if (actions == null) {
            CustomizationUtil.$$$reportNull$$$0(16);
        }
        if (groupId == null) {
            CustomizationUtil.$$$reportNull$$$0(17);
        }
        List<Object> defaultActionList = CustomizationUtil.getGroupActions(groupId, new CustomActionsSchema(null));
        ArrayList diff = new ArrayList();
        ArrayList<String> groupPath = new ArrayList<String>(Arrays.asList("root", CustomActionsSchema.getInstance().getDisplayName(groupId)));
        CustomizationUtil.computeDiff(CustomizationUtil.toActionUrls(groupPath, defaultActionList), CustomizationUtil.toActionUrls(groupPath, actions), diff);
        CustomActionsSchema globalSchema = CustomActionsSchema.getInstance();
        CustomActionsSchema tmpSchema = new CustomActionsSchema(null);
        tmpSchema.copyFrom(globalSchema);
        ArrayList<ActionUrl> tmpActions = new ArrayList<ActionUrl>(tmpSchema.getActions());
        tmpActions.removeIf(url -> Objects.equals(groupPath, url.getGroupPath()));
        tmpActions.addAll(diff);
        tmpSchema.setActions(tmpActions);
        globalSchema.copyFrom(tmpSchema);
        CustomActionsListener.fireSchemaChanged();
    }

    private static ActionUrl @NotNull [] toActionUrls(@NotNull ArrayList<String> groupPath, @NotNull List<Object> objects) {
        if (groupPath == null) {
            CustomizationUtil.$$$reportNull$$$0(18);
        }
        if (objects == null) {
            CustomizationUtil.$$$reportNull$$$0(19);
        }
        ActionUrl[] actionUrlArray = (ActionUrl[])objects.stream().map(o -> new ActionUrl(groupPath, o, 0, -1)).toArray(ActionUrl[]::new);
        if (actionUrlArray == null) {
            CustomizationUtil.$$$reportNull$$$0(20);
        }
        return actionUrlArray;
    }

    @Nullable
    public static PopupHandler installToolbarCustomizationHandler(@NotNull ActionToolbar toolbar2) {
        ActionGroup actionGroup;
        String groupID;
        if (toolbar2 == null) {
            CustomizationUtil.$$$reportNull$$$0(21);
        }
        if ((groupID = CustomizationUtil.getGroupID(actionGroup = toolbar2.getActionGroup())) == null) {
            return null;
        }
        return CustomizationUtil.installToolbarCustomizationHandler(actionGroup, groupID, toolbar2.getComponent(), toolbar2.getPlace());
    }

    @Nullable
    public static PopupHandler installToolbarCustomizationHandler(@NotNull ActionGroup actionGroup, @Nullable String groupID, @NotNull JComponent component2, @NotNull String place) {
        PopupHandler popupHandler2;
        if (actionGroup == null) {
            CustomizationUtil.$$$reportNull$$$0(22);
        }
        if (component2 == null) {
            CustomizationUtil.$$$reportNull$$$0(23);
        }
        if (place == null) {
            CustomizationUtil.$$$reportNull$$$0(24);
        }
        if ((popupHandler2 = CustomizationUtil.createToolbarCustomizationHandler(actionGroup, groupID, component2, place)) != null) {
            component2.addMouseListener((MouseListener)popupHandler2);
        }
        return popupHandler2;
    }

    @Nullable
    public static PopupHandler createToolbarCustomizationHandler(@NotNull ActionGroup actionGroup, @Nullable String groupID, final @NotNull JComponent component2, final @NotNull String place) {
        if (actionGroup == null) {
            CustomizationUtil.$$$reportNull$$$0(25);
        }
        if (component2 == null) {
            CustomizationUtil.$$$reportNull$$$0(26);
        }
        if (place == null) {
            CustomizationUtil.$$$reportNull$$$0(27);
        }
        if (groupID == null) {
            return null;
        }
        final Ref popupInvoker = new Ref();
        final ActionGroup customizationGroup = CustomizationUtil.createToolbarCustomizationGroup(actionGroup, groupID, (Ref<? extends Component>)popupInvoker);
        if (customizationGroup == null) {
            return null;
        }
        return new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                if (Boolean.TRUE.equals(ClientProperty.get((Component)comp, DISABLE_CUSTOMIZE_POPUP_KEY))) {
                    return;
                }
                String popupPlace = ActionPlaces.getPopupPlace((String)place);
                ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu(popupPlace, customizationGroup);
                popupMenu.setTargetComponent(component2);
                JPopupMenu menu = popupMenu.getComponent();
                menu.addPopupMenuListener((PopupMenuListener)new PopupMenuListenerAdapter(){

                    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                        Object obj2 = e.getSource();
                        JBPopupMenu menu = obj2 instanceof JBPopupMenu ? (JBPopupMenu)obj2 : null;
                        popupInvoker.set((Object)(menu == null ? null : menu.getInvoker()));
                    }

                    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                        ApplicationManager.getApplication().invokeLater(() -> popupInvoker.set(null));
                    }
                });
                menu.show(comp, x, y);
            }
        };
    }

    @Nullable
    public static ActionGroup createToolbarCustomizationGroup(@NotNull ActionGroup actionGroup, String groupID, Ref<? extends Component> popupInvoker) {
        String groupName;
        if (actionGroup == null) {
            CustomizationUtil.$$$reportNull$$$0(28);
        }
        if ((groupName = CustomizationUtil.getGroupName((AnAction)actionGroup, groupID)) == null) {
            return null;
        }
        String actionID = "customize.toolbar." + groupID;
        DefaultActionGroup customizationGroup = new DefaultActionGroup(new AnAction[]{new MyDumbAction(actionID, IdeBundle.messagePointer((String)"action.customizations.customize.action", (Object[])new Object[0]), () -> AllIcons.General.GearPlain, event -> {
            Component src = (Component)popupInvoker.get();
            AnAction targetAction = src instanceof ActionButton ? ((ActionButton)src).getAction() : null;
            DialogWrapper dialogWrapper = CustomizationUtil.createCustomizeGroupDialog(event.getProject(), groupID, groupName, targetAction);
            dialogWrapper.show();
        })});
        ActionManager actionManager = ActionManager.getInstance();
        AnAction rollbackAction = actionManager.getAction("RunToolbarRollbackToPrevious");
        if (rollbackAction != null) {
            customizationGroup.add(rollbackAction);
        }
        customizationGroup.addAll((ActionGroup)actionManager.getAction("ToolbarPopupActions"));
        AnAction additionalActions = actionManager.getAction("ToolbarPopupActions." + groupID);
        if (additionalActions instanceof ActionGroup) {
            customizationGroup.add(additionalActions);
        }
        return customizationGroup;
    }

    @NotNull
    public static DialogWrapper createCustomizeGroupDialog(@Nullable Project project2, @NotNull String groupID, final @NlsContexts.DialogTitle String groupName, final @Nullable AnAction targetAction) {
        if (groupID == null) {
            CustomizationUtil.$$$reportNull$$$0(29);
        }
        final ToolbarCustomizableActionsPanel panel2 = new ToolbarCustomizableActionsPanel(groupID, groupName);
        return new DialogWrapper(project2, true){
            {
                super(arg0, arg1);
                this.setTitle(IdeBundle.message((String)"dialog.title.customize.0", (Object[])new Object[]{groupName}));
                this.init();
                this.setSize(600, 600);
            }

            @Nullable
            public JComponent getPreferredFocusedComponent() {
                return panel2.getPreferredFocusedComponent();
            }

            @Nullable
            protected JComponent createCenterPanel() {
                String id2;
                panel2.reset();
                String string = id2 = targetAction == null ? null : ActionManager.getInstance().getId(targetAction);
                if (id2 != null) {
                    panel2.selectAction(id2);
                }
                return panel2.getPanel();
            }

            protected Action @NotNull [] createActions() {
                ArrayList<Action> actions = new ArrayList<Action>(Arrays.asList(super.createActions()));
                DialogWrapper.DialogWrapperAction applyAction = new DialogWrapper.DialogWrapperAction(IdeBundle.message((String)"dialog.apply", (Object[])new Object[0])){

                    protected void doAction(ActionEvent e) {
                        this.apply();
                        this.setEnabled(false);
                    }
                };
                actions.add((Action)applyAction);
                panel2.setApplyAction((Action)applyAction);
                Action[] actionArray = (Action[])actions.toArray(Action[]::new);
                if (actionArray == null) {
                    2.$$$reportNull$$$0(0);
                }
                return actionArray;
            }

            private void apply() {
                try {
                    panel2.apply();
                }
                catch (ConfigurationException ex) {
                    LOG.error((Throwable)ex);
                }
            }

            protected void doOKAction() {
                this.apply();
                this.close(0);
            }

            public void doCancelAction() {
                panel2.reset();
                super.doCancelAction();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/ui/customization/CustomizationUtil$2", "createActions"));
            }
        };
    }

    @Nullable
    private static String getGroupID(ActionGroup actionGroup) {
        AnAction actionForId = ActionUtil.getDelegateChainRootAction((AnAction)actionGroup);
        return ActionManager.getInstance().getId(actionForId);
    }

    @Nls
    @Nullable
    private static String getGroupName(AnAction action2, String groupID) {
        String templateText = action2.getTemplateText();
        return Strings.isEmpty((String)templateText) ? CustomActionsSchema.getInstance().getDisplayName(groupID) : templateText;
    }

    private static /* synthetic */ boolean lambda$optimizeSchema$0(JTree defaultTree, List actions, CustomActionsSchema schema, TreeNode node) {
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)node;
        Group group2 = CustomizationUtil.getGroupForNode(treeNode);
        if (treeNode.isLeaf() && group2 == null) {
            return true;
        }
        ActionUrl url = CustomizationUtil.getActionUrl(new TreePath(treeNode.getPath()), 0);
        String groupName = group2.getName();
        url.getGroupPath().add(groupName);
        TreePath treePath = CustomizationUtil.getTreePath(defaultTree, url);
        if (treePath != null) {
            DefaultMutableTreeNode visited = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            ActionUrl[] defaultUserObjects = CustomizationUtil.getChildUserObjects(visited, url);
            ActionUrl[] currentUserObjects = CustomizationUtil.getChildUserObjects(treeNode, url);
            CustomizationUtil.computeDiff(defaultUserObjects, currentUserObjects, actions);
        } else {
            url.getGroupPath().remove(url.getParentGroup());
            if (actions.contains(url)) {
                url.getGroupPath().add(groupName);
                actions.addAll(schema.getChildActions(url));
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 9, 13, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 1: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schema";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 3: 
            case 9: 
            case 13: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/ui/customization/CustomizationUtil";
                break;
            }
            case 4: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 6: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 7: 
            case 11: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 8: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupPath";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolbar";
                break;
            }
            case 22: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionGroup";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupID";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/ui/customization/CustomizationUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getReordableChildren";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "installPopupHandler";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupActions";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "toActionUrls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReordableChildren";
                break;
            }
            case 3: 
            case 9: 
            case 13: 
            case 20: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "computeDiff";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getGroupForNode";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "installPopupHandler";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "acceptObjectIconAndText";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getGroupActions";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getGroup";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "updateActionGroup";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "toActionUrls";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "installToolbarCustomizationHandler";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createToolbarCustomizationHandler";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "createToolbarCustomizationGroup";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createCustomizeGroupDialog";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 9, 13, 20 -> new IllegalStateException(string);
        };
    }

    private static final class PopupComputableActionGroup
    extends ActionGroup
    implements ActionWithDelegate<ActionGroup> {
        private final Supplier<? extends @Nullable ActionGroup> myActionGroupSupplier;

        PopupComputableActionGroup(Supplier<? extends @Nullable ActionGroup> actionGroupSupplier) {
            this.myActionGroupSupplier = actionGroupSupplier;
        }

        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            ActionGroup group2 = this.myActionGroupSupplier.get();
            AnAction[] anActionArray = group2 == null ? EMPTY_ARRAY : group2.getChildren(e);
            if (anActionArray == null) {
                PopupComputableActionGroup.$$$reportNull$$$0(0);
            }
            return anActionArray;
        }

        @NotNull
        public ActionGroup getDelegate() {
            ActionGroup actionGroup = Objects.requireNonNullElse(this.myActionGroupSupplier.get(), ActionGroup.EMPTY_GROUP);
            if (actionGroup == null) {
                PopupComputableActionGroup.$$$reportNull$$$0(1);
            }
            return actionGroup;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/ide/ui/customization/CustomizationUtil$PopupComputableActionGroup";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDelegate";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    public static interface CustomPresentationConsumer {
        public void accept(@NotNull @Nls String var1, @Nullable @Nls String var2, @Nullable Icon var3);
    }

    private static final class MyDumbAction
    extends DumbAwareAction
    implements ActionIdProvider,
    ActionWithDelegate<Consumer<? super AnActionEvent>> {
        @NotNull
        private final String id;
        @NotNull
        private final Consumer<? super AnActionEvent> myActionPerformed;

        private MyDumbAction(@NotNull String id2, @NotNull Supplier<@NlsActions.ActionText String> text2, @Nullable @Nullable Supplier<? extends @Nullable Icon> icon2, @NotNull Consumer<? super AnActionEvent> actionPerformed2) {
            if (id2 == null) {
                MyDumbAction.$$$reportNull$$$0(0);
            }
            if (text2 == null) {
                MyDumbAction.$$$reportNull$$$0(1);
            }
            if (actionPerformed2 == null) {
                MyDumbAction.$$$reportNull$$$0(2);
            }
            super(text2, null, icon2);
            this.id = id2;
            this.myActionPerformed = actionPerformed2;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MyDumbAction.$$$reportNull$$$0(3);
            }
            this.myActionPerformed.accept((AnActionEvent)e);
        }

        @NotNull
        public String getId() {
            String string = this.id;
            if (string == null) {
                MyDumbAction.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NotNull
        public Consumer<? super AnActionEvent> getDelegate() {
            Consumer<? super AnActionEvent> consumer = this.myActionPerformed;
            if (consumer == null) {
                MyDumbAction.$$$reportNull$$$0(5);
            }
            return consumer;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionPerformed";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/ui/customization/CustomizationUtil$MyDumbAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/ui/customization/CustomizationUtil$MyDumbAction";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getId";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDelegate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 5 -> new IllegalStateException(string);
            };
        }
    }

    private static final class ToolbarCustomizableActionsPanel
    extends CustomizableActionsPanel {
        @NotNull
        private final String myGroupID;
        @Nls
        @NotNull
        private final String myGroupName;
        @Nullable
        private Action myApplyAction;

        private ToolbarCustomizableActionsPanel(@NotNull String groupID, @Nls @NotNull String groupName) {
            if (groupID == null) {
                ToolbarCustomizableActionsPanel.$$$reportNull$$$0(0);
            }
            if (groupName == null) {
                ToolbarCustomizableActionsPanel.$$$reportNull$$$0(1);
            }
            this.myGroupID = groupID;
            this.myGroupName = groupName;
        }

        @Override
        public void apply() throws ConfigurationException {
            super.apply();
            ActionToolbarImpl.updateAllToolbarsImmediately();
            this.onModified();
        }

        private void setApplyAction(@Nullable Action applyAction) {
            this.myApplyAction = applyAction;
            if (applyAction != null) {
                applyAction.setEnabled(this.isModified(false));
            }
        }

        @Override
        protected void onModified() {
            if (this.myApplyAction != null) {
                this.myApplyAction.setEnabled(CustomActionsSchema.getInstance().isModified(this.mySelectedSchema));
            }
        }

        @Override
        @NotNull
        protected ActionGroup getRestoreGroup() {
            return new DefaultActionGroup(new AnAction[]{new DumbAwareAction(IdeBundle.messagePointer((String)"button.restore.last.state", (Object[])new Object[0])){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    this.reset();
                }

                public void update(@NotNull AnActionEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    e.getPresentation().setEnabled(mySelectedSchema.isModified(CustomActionsSchema.getInstance()));
                }

                @NotNull
                public ActionUpdateThread getActionUpdateThread() {
                    ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                    if (actionUpdateThread == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return actionUpdateThread;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 2 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "e";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/ide/ui/customization/CustomizationUtil$ToolbarCustomizableActionsPanel$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/ide/ui/customization/CustomizationUtil$ToolbarCustomizableActionsPanel$1";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getActionUpdateThread";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "actionPerformed";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray;
                            objectArray[2] = "update";
                            break;
                        }
                        case 2: {
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string);
                        case 2 -> new IllegalStateException(string);
                    };
                }
            }, new DumbAwareAction(IdeBundle.messagePointer((String)"button.restore.defaults", (Object[])new Object[0])){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    this.resetToDefaults();
                }

                public void update(@NotNull AnActionEvent e) {
                    if (e == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    CustomActionsSchema cleanScheme = new CustomActionsSchema(null);
                    this.updateLocalSchema(cleanScheme);
                    e.getPresentation().setEnabled(mySelectedSchema.isModified(cleanScheme));
                }

                @NotNull
                public ActionUpdateThread getActionUpdateThread() {
                    ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                    if (actionUpdateThread == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    return actionUpdateThread;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 2 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "e";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/ide/ui/customization/CustomizationUtil$ToolbarCustomizableActionsPanel$2";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/ide/ui/customization/CustomizationUtil$ToolbarCustomizableActionsPanel$2";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getActionUpdateThread";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "actionPerformed";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray;
                            objectArray[2] = "update";
                            break;
                        }
                        case 2: {
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string);
                        case 2 -> new IllegalStateException(string);
                    };
                }
            }}){
                {
                    super(arg0);
                    this.getTemplatePresentation().setPopupGroup(true);
                    this.getTemplatePresentation().setIcon(AllIcons.Actions.Rollback);
                    this.getTemplatePresentation().setText(IdeBundle.message((String)"group.customizations.restore.action.group", (Object[])new Object[0]));
                }

                public void update(@NotNull AnActionEvent e) {
                    if (e == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    CustomActionsSchema cleanScheme = new CustomActionsSchema(null);
                    this.updateLocalSchema(cleanScheme);
                    e.getPresentation().setEnabled(mySelectedSchema.isModified(CustomActionsSchema.getInstance()) || mySelectedSchema.isModified(cleanScheme));
                }

                @NotNull
                public ActionUpdateThread getActionUpdateThread() {
                    ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                    if (actionUpdateThread == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    return actionUpdateThread;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 1 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "e";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/ide/ui/customization/CustomizationUtil$ToolbarCustomizableActionsPanel$3";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/ide/ui/customization/CustomizationUtil$ToolbarCustomizableActionsPanel$3";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getActionUpdateThread";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "update";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string);
                        case 1 -> new IllegalStateException(string);
                    };
                }
            };
        }

        JComponent getPreferredFocusedComponent() {
            return this.myActionsTree;
        }

        @Override
        protected boolean needExpandAll() {
            return true;
        }

        @Override
        protected void updateGlobalSchema() {
            this.updateLocalSchema(this.mySelectedSchema);
            super.updateGlobalSchema();
        }

        @Override
        protected void updateLocalSchema(CustomActionsSchema localSchema) {
            CustomActionsSchema.getInstance().getActions().forEach(url -> {
                if (!url.getGroupPath().contains(this.myGroupName)) {
                    localSchema.addAction(url.copy());
                }
            });
        }

        @Override
        protected void patchActionsTreeCorrespondingToSchema(DefaultMutableTreeNode root) {
            if (this.myGroupID == null) {
                return;
            }
            this.fillTreeFromActions(root, (ActionGroup)ActionManager.getInstance().getAction(this.myGroupID));
        }

        private void fillTreeFromActions(@Nullable DefaultMutableTreeNode root, @Nullable ActionGroup actionGroup) {
            List selectedPaths = TreeUtil.collectSelectedPaths((JTree)this.myActionsTree);
            if (this.mySelectedSchema != null && actionGroup != null && root != null) {
                root.removeAllChildren();
                root.add(ActionsTreeUtil.createNode(ActionsTreeUtil.createCorrectedGroup(actionGroup, this.myGroupName, new ArrayList(), this.mySelectedSchema.getActions())));
                ((DefaultTreeModel)this.myActionsTree.getModel()).reload();
                TreeUtil.selectPaths((JTree)this.myActionsTree, (Collection)selectedPaths);
            }
        }

        private void selectAction(final String actionID) {
            TreeUtil.promiseSelect((JTree)this.myActionsTree, (TreeVisitor)new TreeVisitor(){

                @NotNull
                public TreeVisitor.Action visit(@NotNull TreePath path) {
                    Object obj2;
                    Object obj22;
                    String userObjectString;
                    if (path == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    if ((userObjectString = (obj22 = path.getLastPathComponent()) instanceof DefaultMutableTreeNode ? ((obj2 = ((DefaultMutableTreeNode)obj22).getUserObject()) instanceof String ? (String)obj2 : null) : null) == null) {
                        Object obj1;
                        obj2 = path.getLastPathComponent();
                        Group group2 = obj2 instanceof DefaultMutableTreeNode ? ((obj1 = ((DefaultMutableTreeNode)obj2).getUserObject()) instanceof Group ? (Group)obj1 : null) : null;
                        String string = userObjectString = group2 == null ? null : group2.getName();
                    }
                    if (Objects.equals(userObjectString, actionID)) {
                        TreeUtil.selectPath((JTree)myActionsTree, (TreePath)path);
                        TreeVisitor.Action action2 = TreeVisitor.Action.INTERRUPT;
                        if (action2 == null) {
                            4.$$$reportNull$$$0(1);
                        }
                        return action2;
                    }
                    TreeVisitor.Action action3 = TreeVisitor.Action.CONTINUE;
                    if (action3 == null) {
                        4.$$$reportNull$$$0(2);
                    }
                    return action3;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 1, 2 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "path";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/ide/ui/customization/CustomizationUtil$ToolbarCustomizableActionsPanel$4";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/ide/ui/customization/CustomizationUtil$ToolbarCustomizableActionsPanel$4";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "visit";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "visit";
                            break;
                        }
                        case 1: 
                        case 2: {
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string);
                        case 1, 2 -> new IllegalStateException(string);
                    };
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "groupID";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "groupName";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ide/ui/customization/CustomizationUtil$ToolbarCustomizableActionsPanel";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

