/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf;

import com.intellij.ide.ui.UITheme;
import com.intellij.ide.ui.laf.UIThemeLookAndFeelInfo;
import com.intellij.ide.ui.laf.UIThemeLookAndFeelInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.impl.EditorColorsManagerImpl;
import com.intellij.openapi.util.IconPathPatcher;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class TempUIThemeLookAndFeelInfo
extends UIThemeLookAndFeelInfoImpl {
    private static final Logger LOG = Logger.getInstance(TempUIThemeLookAndFeelInfo.class);
    @NonNls
    private static final String ID = "Temp theme";
    @Nullable
    private final UIThemeLookAndFeelInfo previousLaf;

    public TempUIThemeLookAndFeelInfo(@NotNull UITheme theme, @Nullable UIThemeLookAndFeelInfo previousLaf) {
        if (theme == null) {
            TempUIThemeLookAndFeelInfo.$$$reportNull$$$0(0);
        }
        super(theme);
        assert (ID.equals(theme.getId()));
        this.previousLaf = previousLaf instanceof TempUIThemeLookAndFeelInfo ? ((TempUIThemeLookAndFeelInfo)previousLaf).getPreviousLaf() : previousLaf;
    }

    @Nullable
    public UIThemeLookAndFeelInfo getPreviousLaf() {
        return this.previousLaf;
    }

    @Override
    @Nullable
    protected InputStream getResourceAsStream(@NotNull String path) {
        Path file2;
        if (path == null) {
            TempUIThemeLookAndFeelInfo.$$$reportNull$$$0(1);
        }
        if (Files.exists(file2 = Path.of(path, new String[0]), new LinkOption[0])) {
            try {
                return Files.newInputStream(file2, new OpenOption[0]);
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        return null;
    }

    @Override
    public void installEditorScheme(@Nullable EditorColorsScheme previousEditorColorSchemeForLaf) {
        String schemeId = this.getEditorSchemeId();
        if (schemeId == null) {
            return;
        }
        EditorColorsManagerImpl editorColorSchemeManager = (EditorColorsManagerImpl)EditorColorsManager.getInstance();
        editorColorSchemeManager.reloadKeepingActiveScheme();
        editorColorSchemeManager.setGlobalScheme(editorColorSchemeManager.getScheme(schemeId));
    }

    @NotNull
    public static UITheme loadTempTheme(@NotNull InputStream stream, final @NotNull IconPathPatcher patcher) throws IOException {
        if (stream == null) {
            TempUIThemeLookAndFeelInfo.$$$reportNull$$$0(2);
        }
        if (patcher == null) {
            TempUIThemeLookAndFeelInfo.$$$reportNull$$$0(3);
        }
        UITheme theme = UITheme.Companion.loadTempThemeFromJson(stream, ID);
        final IconPathPatcher oldPatcher = theme.patcher;
        if (oldPatcher == null) {
            UITheme uITheme = theme;
            if (uITheme == null) {
                TempUIThemeLookAndFeelInfo.$$$reportNull$$$0(4);
            }
            return uITheme;
        }
        theme.patcher = new IconPathPatcher(){

            @Nullable
            public String patchPath(@NotNull String path, @Nullable ClassLoader classLoader) {
                String result2;
                if (path == null) {
                    1.$$$reportNull$$$0(0);
                }
                return (result2 = oldPatcher.patchPath(path, classLoader)) == null ? null : patcher.patchPath(result2, classLoader);
            }

            @Nullable
            public ClassLoader getContextClassLoader(@NotNull String path, @Nullable ClassLoader originalClassLoader) {
                if (path == null) {
                    1.$$$reportNull$$$0(1);
                }
                return patcher.getContextClassLoader(path, originalClassLoader);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "path";
                objectArray2[1] = "com/intellij/ide/ui/laf/TempUIThemeLookAndFeelInfo$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "patchPath";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getContextClassLoader";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        UITheme uITheme = theme;
        if (uITheme == null) {
            TempUIThemeLookAndFeelInfo.$$$reportNull$$$0(5);
        }
        return uITheme;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "theme";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patcher";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/ui/laf/TempUIThemeLookAndFeelInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/ui/laf/TempUIThemeLookAndFeelInfo";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "loadTempTheme";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getResourceAsStream";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadTempTheme";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5 -> new IllegalStateException(string);
        };
    }
}

