/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.impl.NotificationCollector;
import com.intellij.notification.impl.NotificationsConfigurable;
import com.intellij.notification.impl.NotificationsConfigurationImpl;
import com.intellij.notification.impl.NotificationsManagerImpl;
import com.intellij.notification.impl.RemindLaterManager;
import com.intellij.notification.impl.ui.DropDownActionLayout;
import com.intellij.notification.impl.ui.MoreAction;
import com.intellij.notification.impl.ui.MyDropDownAction;
import com.intellij.notification.impl.ui.NotificationComponent;
import com.intellij.notification.impl.ui.NotificationWrapper;
import com.intellij.notification.impl.ui.NotificationsPanelKt;
import com.intellij.notification.impl.ui.NotificationsUtil;
import com.intellij.notification.impl.ui.PreferredSizeCache;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.ex.TooltipDescriptionProvider;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ContextHelpLabel;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.NotificationBalloonRoundShadowBorderProvider;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.SingleEdtTaskScheduler;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.SingleTextSelectionHandler;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.JTextComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000 U2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0002UVB-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u00101\u001a\u0002022\u0006\u00103\u001a\u000204H\u0002J\u0010\u00105\u001a\u0002022\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\b\u00106\u001a\u00020\u001fH\u0002J\u0018\u00107\u001a\u00020\u001f2\u0006\u00103\u001a\u0002042\u0006\u00108\u001a\u000209H\u0002J\u0006\u0010:\u001a\u00020\u001fJ\u0006\u0010;\u001a\u00020\u001fJ\b\u0010<\u001a\u00020\u001fH\u0002J\u0015\u0010=\u001a\u00020>2\u000b\u0010?\u001a\u00070@\u00a2\u0006\u0002\bAH\u0002J\u0006\u0010B\u001a\u00020\u001fJ\u001a\u0010C\u001a\u00020\u001f2\u0012\u0010D\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u001f0\u001eJ\u0014\u0010E\u001a\u00020\u001f2\f\u0010F\u001a\b\u0012\u0004\u0012\u00020\u00050!J\u0006\u0010G\u001a\u00020\u0016J\u000e\u0010H\u001a\u00020\u001f2\u0006\u0010I\u001a\u00020\u0016J\u000e\u0010J\u001a\u00020\u001f2\u0006\u0010I\u001a\u00020\u0016J\b\u0010K\u001a\u00020\u001fH\u0002J\u0010\u0010L\u001a\u00020\u001f2\u0006\u0010M\u001a\u00020\u001cH\u0002J\u0010\u0010N\u001a\u00020\u001f2\u0006\u0010O\u001a\u00020PH\u0014J\u0010\u0010Q\u001a\u00020\u00162\b\u0010R\u001a\u0004\u0018\u00010@J\u0015\u0010S\u001a\u00020\u00162\u000b\u0010R\u001a\u00070@\u00a2\u0006\u0002\bTH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u001f0\u001eX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00050!X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010$\u001a\u0004\u0018\u00010%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u001c\u0010*\u001a\u0004\u0018\u00010%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010'\"\u0004\b,\u0010)R\u0010\u0010-\u001a\u00020.8\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010/\u001a\u0004\u0018\u000100X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006W"}, d2={"Lcom/intellij/notification/impl/ui/NotificationComponent;", "Lcom/intellij/ui/components/JBPanel;", "project", "Lcom/intellij/openapi/project/Project;", "notification", "Lcom/intellij/notification/Notification;", "timeComponents", "Ljava/util/ArrayList;", "Ljavax/swing/JLabel;", "singleSelectionHandler", "Lcom/intellij/util/ui/SingleTextSelectionHandler;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/notification/Notification;Ljava/util/ArrayList;Lcom/intellij/util/ui/SingleTextSelectionHandler;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getSingleSelectionHandler", "()Lcom/intellij/util/ui/SingleTextSelectionHandler;", "myNotificationWrapper", "Lcom/intellij/notification/impl/ui/NotificationWrapper;", "getMyNotificationWrapper", "()Lcom/intellij/notification/impl/ui/NotificationWrapper;", "myIsNew", "", "myHoverState", "myMoreButton", "Ljava/awt/Component;", "myMorePopupVisible", "myRoundColor", "Ljava/awt/Color;", "myDoNotAskHandler", "Lkotlin/Function1;", "", "myRemoveCallback", "Ljava/util/function/Consumer;", "myMorePopup", "Lcom/intellij/openapi/ui/popup/JBPopup;", "myMoreAwtPopup", "Ljavax/swing/JPopupMenu;", "getMyMoreAwtPopup", "()Ljavax/swing/JPopupMenu;", "setMyMoreAwtPopup", "(Ljavax/swing/JPopupMenu;)V", "myDropDownPopup", "getMyDropDownPopup", "setMyDropDownPopup", "popupAlarm", "Lcom/intellij/util/SingleEdtTaskScheduler;", "myLafUpdater", "Ljava/lang/Runnable;", "createAction", "Ljavax/swing/JComponent;", "action", "Lcom/intellij/openapi/actionSystem/AnAction;", "createPopupAction", "doShowSettings", "runAction", "component", "", "expire", "removeFromParent", "closePopups", "createTextComponent", "Ljavax/swing/JEditorPane;", "text", "", "Lorg/jetbrains/annotations/Nls;", "updateLaf", "setDoNotAskHandler", "handler", "setRemoveCallback", "callback", "isHover", "setNew", "state", "setHover", "updateColor", "setColor", "color", "paintComponent", "g", "Ljava/awt/Graphics;", "applySearchQuery", "query", "matchQuery", "Lcom/intellij/openapi/util/NlsSafe;", "Companion", "MyActionGroup", "intellij.platform.ide.impl"})
final class NotificationComponent
extends JBPanel<NotificationComponent> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final SingleTextSelectionHandler singleSelectionHandler;
    @NotNull
    private final NotificationWrapper myNotificationWrapper;
    private boolean myIsNew;
    private boolean myHoverState;
    @Nullable
    private final Component myMoreButton;
    private boolean myMorePopupVisible;
    @NotNull
    private Color myRoundColor;
    private Function1<? super Boolean, Unit> myDoNotAskHandler;
    private Consumer<Notification> myRemoveCallback;
    @Nullable
    private JBPopup myMorePopup;
    @Nullable
    private JPopupMenu myMoreAwtPopup;
    @Nullable
    private JPopupMenu myDropDownPopup;
    @JvmField
    @NotNull
    public final SingleEdtTaskScheduler popupAlarm;
    @Nullable
    private Runnable myLafUpdater;
    @NotNull
    private static final JBColor INFO_COLOR;
    @NotNull
    public static final String NEW_COLOR_NAME = "NotificationsToolwindow.newNotification.background";
    @NotNull
    private static final JBColor NEW_DEFAULT_COLOR;
    @NotNull
    private static final JBColor NEW_COLOR;
    @NotNull
    private static final JBColor NEW_HOVER_COLOR;
    @NotNull
    private static final JBColor HOVER_COLOR;
    @NotNull
    public static final String TIME_KEY = "TimestampKey";

    public NotificationComponent(@NotNull Project project2, @NotNull Notification notification2, @NotNull ArrayList<JLabel> timeComponents, @NotNull SingleTextSelectionHandler singleSelectionHandler) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)notification2, (String)"notification");
        Intrinsics.checkNotNullParameter(timeComponents, (String)"timeComponents");
        Intrinsics.checkNotNullParameter((Object)singleSelectionHandler, (String)"singleSelectionHandler");
        this.project = project2;
        this.singleSelectionHandler = singleSelectionHandler;
        this.myNotificationWrapper = new NotificationWrapper(notification2);
        this.myRoundColor = Companion.getBG_COLOR();
        this.popupAlarm = SingleEdtTaskScheduler.Companion.createSingleEdtTaskScheduler$default((SingleEdtTaskScheduler.Companion)SingleEdtTaskScheduler.Companion, null, (int)1, null);
        this.setOpaque(true);
        this.setBackground(Companion.getBG_COLOR());
        this.setBorder((Border)JBUI.Borders.empty((int)10, (int)10, (int)10, (int)0));
        int n = JBUI.scale((int)7);
        this.setLayout(new BorderLayout(n){
            private Component myEastComponent;

            @Override
            public void addLayoutComponent(String name2, Component comp) {
                Intrinsics.checkNotNullParameter((Object)comp, (String)"comp");
                if (Intrinsics.areEqual((Object)"East", (Object)name2)) {
                    this.myEastComponent = comp;
                } else {
                    super.addLayoutComponent(name2, comp);
                }
            }

            @Override
            public void layoutContainer(Container target) {
                Intrinsics.checkNotNullParameter((Object)target, (String)"target");
                super.layoutContainer(target);
                if (this.myEastComponent != null) {
                    Component component2 = this.myEastComponent;
                    Intrinsics.checkNotNull((Object)component2);
                    if (component2.isVisible()) {
                        Insets insets = target.getInsets();
                        int height = target.getHeight() - insets.bottom - insets.top;
                        Component component3 = this.myEastComponent;
                        Intrinsics.checkNotNull((Object)component3);
                        Component component4 = component3;
                        component4.setSize(component4.getWidth(), height);
                        Dimension d = component4.getPreferredSize();
                        component4.setBounds(target.getWidth() - insets.right - d.width, insets.top, d.width, height);
                    }
                }
            }
        });
        JPanel iconPanel = new JPanel(new BorderLayout());
        iconPanel.setOpaque(false);
        iconPanel.add((Component)new JBLabel(NotificationsUtil.getIcon(notification2)), "North");
        this.add(iconPanel, "West");
        JPanel centerPanel = new JPanel((LayoutManager)new VerticalLayout(JBUI.scale((int)8)));
        centerPanel.setOpaque(false);
        centerPanel.setBorder((Border)JBUI.Borders.emptyRight((int)10));
        JPanel titlePanel = null;
        if (notification2.hasTitle()) {
            String string = NotificationsUtil.buildHtml(notification2, null, false, null, null);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"buildHtml(...)");
            String titleContent = string;
            JBLabel title2 = new JBLabel(titleContent, this){
                private final PreferredSizeCache mySizeCache;
                final /* synthetic */ NotificationComponent this$0;
                {
                    this.this$0 = $receiver;
                    super($titleContent);
                    this.mySizeCache = new PreferredSizeCache((Function0<? extends Dimension>)((Function0)() -> title.1.mySizeCache$lambda$0(this)));
                }

                public void updateUI() {
                    JEditorPane oldEditor = (JEditorPane)UIUtil.findComponentOfType((JComponent)((JComponent)((Object)this)), JEditorPane.class);
                    if (oldEditor != null) {
                        this.this$0.getSingleSelectionHandler().remove((JTextComponent)oldEditor);
                    }
                    super.updateUI();
                    JEditorPane newEditor = (JEditorPane)UIUtil.findComponentOfType((JComponent)((JComponent)((Object)this)), JEditorPane.class);
                    if (newEditor != null) {
                        this.this$0.getSingleSelectionHandler().add((JTextComponent)newEditor, true);
                    }
                }

                public Dimension getPreferredSize() {
                    return this.mySizeCache.getSize((Component)((Object)this));
                }

                protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
                    if (this.skipUpdateGraphicsConfiguration(propertyName, oldValue, newValue)) {
                        return;
                    }
                    super.firePropertyChange(propertyName, oldValue, newValue);
                }

                private final boolean skipUpdateGraphicsConfiguration(String propertyName, Object oldValue, Object newValue) {
                    if (Intrinsics.areEqual((Object)"graphicsConfiguration", (Object)propertyName)) {
                        if (oldValue != null && newValue == null) {
                            return true;
                        }
                        if (oldValue == null && newValue != null) {
                            Object basicHtml = this.getClientProperty("html");
                            Object accessibleName = this.getClientProperty("AccessibleName");
                            if (basicHtml != null && accessibleName != null) {
                                this.putClientProperty("html", basicHtml);
                                this.putClientProperty("AccessibleName", accessibleName);
                                return true;
                            }
                        }
                    }
                    return false;
                }

                private static final Dimension mySizeCache$lambda$0(title.1 this$0) {
                    Dimension dimension = super.getPreferredSize();
                    Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getPreferredSize(...)");
                    return dimension;
                }
            };
            title2.setVerticalTextPosition(1);
            try {
                title2.setCopyable(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            NotificationsManagerImpl.setTextAccessibleName((JComponent)title2, titleContent);
            JEditorPane editor2 = (JEditorPane)UIUtil.findComponentOfType((JComponent)((JComponent)title2), JEditorPane.class);
            if (editor2 != null) {
                this.singleSelectionHandler.add((JTextComponent)editor2, true);
            }
            if (notification2.isSuggestionType()) {
                v1 = centerPanel.add((Component)title2);
            } else {
                titlePanel = new JPanel(new BorderLayout());
                titlePanel.setOpaque(false);
                titlePanel.add((Component)title2);
                v1 = centerPanel.add(titlePanel);
            }
        }
        if (notification2.hasContent()) {
            String string = NotificationsUtil.buildFullContent(notification2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"buildFullContent(...)");
            String textContent = string;
            JEditorPane textComponent = this.createTextComponent(textContent);
            NotificationsManagerImpl.setTextAccessibleName(textComponent, textContent);
            this.singleSelectionHandler.add((JTextComponent)textComponent, true);
            if (!notification2.hasTitle() && !notification2.isSuggestionType()) {
                titlePanel = new JPanel(new BorderLayout());
                titlePanel.setOpaque(false);
                titlePanel.add(textComponent);
                v3 = centerPanel.add(titlePanel);
            } else {
                v3 = centerPanel.add(textComponent);
            }
        }
        List list2 = notification2.getActions();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getActions(...)");
        List actions = list2;
        int actionsSize = actions.size();
        AnAction helpAction = notification2.getContextHelpAction();
        if (actionsSize > 0 || helpAction != null) {
            HorizontalLayout layout2 = new HorizontalLayout(JBUIScale.scale((int)16), 0, 2, null);
            JPanel actionPanel = new JPanel(!notification2.isSuggestionType() && actions.size() > 1 ? (LayoutManager2)((Object)new DropDownActionLayout((LayoutManager2)layout2)) : (LayoutManager2)layout2);
            actionPanel.setOpaque(false);
            if (notification2.isSuggestionType()) {
                if (actionsSize > 0) {
                    JButton button2 = new JButton(((AnAction)actions.get(0)).getTemplateText());
                    button2.setOpaque(false);
                    button2.addActionListener(arg_0 -> NotificationComponent._init_$lambda$0(this, actions, arg_0));
                    actionPanel.add(button2);
                    if (actionsSize == 2) {
                        Object e = actions.get(1);
                        Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
                        actionPanel.add(this.createAction((AnAction)e));
                    } else if (actionsSize > 2) {
                        if (notification2.isAddExtraAction()) {
                            Object e = actions.get(1);
                            Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
                            actionPanel.add(this.createAction((AnAction)e));
                            if (actionsSize == 3) {
                                Object e2 = actions.get(2);
                                Intrinsics.checkNotNullExpressionValue(e2, (String)"get(...)");
                                v8 = actionPanel.add(this.createAction((AnAction)e2));
                            } else {
                                v8 = actionPanel.add((Component)((Object)new MoreAction(this, actions, 2)));
                            }
                        } else {
                            v8 = actionPanel.add((Component)((Object)new MoreAction(this, actions, 1)));
                        }
                    }
                }
            } else {
                if (actionsSize > 1 && notification2.getCollapseDirection() == Notification.CollapseActionsDirection.KEEP_RIGHTMOST) {
                    actionPanel.add((Component)((Object)new MyDropDownAction(this)));
                }
                for (AnAction action2 : actions) {
                    Intrinsics.checkNotNull((Object)action2);
                    actionPanel.add(this.createAction(action2));
                }
                if (actionsSize > 1 && notification2.getCollapseDirection() == Notification.CollapseActionsDirection.KEEP_LEFTMOST) {
                    actionPanel.add((Component)((Object)new MyDropDownAction(this)));
                }
            }
            if (helpAction != null) {
                Presentation presentation2 = helpAction.getTemplatePresentation();
                Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"getTemplatePresentation(...)");
                Presentation presentation3 = presentation2;
                ContextHelpLabel contextHelpLabel = ContextHelpLabel.create((String)StringUtil.defaultIfEmpty((String)presentation3.getText(), (String)""), (String)presentation3.getDescription());
                Intrinsics.checkNotNullExpressionValue((Object)contextHelpLabel, (String)"create(...)");
                ContextHelpLabel helpLabel = contextHelpLabel;
                helpLabel.setForeground(UIUtil.getLabelDisabledForeground());
                actionPanel.add((Component)helpLabel);
            }
            if (!(notification2.hasTitle() || notification2.hasContent() || notification2.isSuggestionType())) {
                titlePanel = new JPanel(new BorderLayout());
                titlePanel.setOpaque(false);
                actionPanel.add((Component)titlePanel, "RIGHT");
            }
            centerPanel.add(actionPanel);
        }
        this.add(UiDataProvider.Companion.wrapComponent((JComponent)centerPanel, arg_0 -> NotificationComponent._init_$lambda$1(notification2, arg_0)));
        if (notification2.isSuggestionType()) {
            JComponent button3 = this.createPopupAction(notification2);
            button3.setBorder((Border)JBUI.Borders.emptyRight((int)5));
            button3.setVisible(false);
            this.myMoreButton = button3;
            JPanel eastPanel = new JPanel(new BorderLayout());
            eastPanel.setOpaque(false);
            eastPanel.add((Component)button3, "North");
            this.add(eastPanel, "East");
            this.setComponentZOrder(eastPanel, 0);
        } else {
            JBLabel timeComponent = new JBLabel(DateFormatUtil.formatPrettyDateTime((long)notification2.getTimestamp()));
            timeComponent.putClientProperty((Object)TIME_KEY, (Object)notification2.getTimestamp());
            timeComponent.setToolTipText(DateFormatUtil.formatDateTime((long)notification2.getTimestamp()));
            timeComponent.setBorder((Border)JBUI.Borders.emptyRight((int)10));
            NotificationsPanelKt.access$smallFontFunction((JComponent)timeComponent);
            timeComponent.setForeground((Color)INFO_COLOR);
            timeComponents.add((JLabel)timeComponent);
            if (NotificationsConfigurationImpl.getInstanceImpl().isRegistered(notification2.getGroupId())) {
                JComponent button4 = this.createPopupAction(notification2);
                this.myMoreButton = button4;
                JPanel buttonWrapper2 = new JPanel(new BorderLayout());
                buttonWrapper2.setOpaque(false);
                buttonWrapper2.setBorder((Border)JBUI.Borders.emptyRight((int)10));
                buttonWrapper2.add((Component)button4, "North");
                buttonWrapper2.setPreferredSize(buttonWrapper2.getPreferredSize());
                button4.setVisible(false);
                JPanel timeWrapper = new JPanel(new BorderLayout());
                timeWrapper.setOpaque(false);
                timeWrapper.setBorder((Border)JBUI.Borders.emptyTop((int)3));
                timeWrapper.add((Component)timeComponent, "North");
                JPanel eastPanel = new JPanel(new BorderLayout());
                eastPanel.setOpaque(false);
                eastPanel.add((Component)buttonWrapper2, "West");
                eastPanel.add((Component)timeWrapper, "East");
                JPanel jPanel = titlePanel;
                if (jPanel != null) {
                    jPanel.add((Component)eastPanel, "East");
                }
            } else {
                JPanel jPanel = titlePanel;
                if (jPanel != null) {
                    jPanel.add((Component)timeComponent, "East");
                }
                this.myMoreButton = null;
            }
        }
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final SingleTextSelectionHandler getSingleSelectionHandler() {
        return this.singleSelectionHandler;
    }

    @NotNull
    public final NotificationWrapper getMyNotificationWrapper() {
        return this.myNotificationWrapper;
    }

    @Nullable
    public final JPopupMenu getMyMoreAwtPopup() {
        return this.myMoreAwtPopup;
    }

    public final void setMyMoreAwtPopup(@Nullable JPopupMenu jPopupMenu) {
        this.myMoreAwtPopup = jPopupMenu;
    }

    @Nullable
    public final JPopupMenu getMyDropDownPopup() {
        return this.myDropDownPopup;
    }

    public final void setMyDropDownPopup(@Nullable JPopupMenu jPopupMenu) {
        this.myDropDownPopup = jPopupMenu;
    }

    private final JComponent createAction(AnAction action2) {
        String string = action2.getTemplateText();
        Icon icon2 = action2.getTemplatePresentation().getIcon();
        LinkListener linkListener2 = (arg_0, arg_1) -> NotificationComponent.createAction$lambda$0(this, arg_0, arg_1);
        return (JComponent)new LinkLabel<AnAction>(action2, string, icon2, (LinkListener<AnAction>)linkListener2){

            protected Color getTextColor() {
                Color color = JBUI.CurrentTheme.Link.Foreground.ENABLED;
                Intrinsics.checkNotNullExpressionValue((Object)color, (String)"ENABLED");
                return color;
            }
        };
    }

    private final JComponent createPopupAction(Notification notification2) {
        Object remindAction;
        MyActionGroup group2 = new MyActionGroup();
        if (NotificationsConfigurationImpl.getInstanceImpl().isRegistered(notification2.getGroupId())) {
            String string = IdeBundle.message((String)"notification.settings.action.text", (Object[])new Object[0]);
            group2.add((AnAction)new DumbAwareAction(this, string){
                final /* synthetic */ NotificationComponent this$0;
                {
                    this.this$0 = $receiver;
                    super($super_call_param$1);
                }

                public void actionPerformed(AnActionEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    NotificationComponent.access$doShowSettings(this.this$0);
                }
            });
            group2.addSeparator();
        }
        if (notification2.isSuggestionType()) {
            remindAction = RemindLaterManager.Companion.createAction-HG0u8IE(notification2, DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.DAYS));
            if (remindAction != null) {
                String string = IdeBundle.message((String)"notifications.toolwindow.remind.tomorrow", (Object[])new Object[0]);
                group2.add((AnAction)new DumbAwareAction((Runnable)remindAction, this, string){
                    final /* synthetic */ Runnable $remindAction;
                    final /* synthetic */ NotificationComponent this$0;
                    {
                        this.$remindAction = $remindAction;
                        this.this$0 = $receiver;
                        super($super_call_param$1);
                    }

                    public void actionPerformed(AnActionEvent e) {
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        this.$remindAction.run();
                        Consumer consumer = NotificationComponent.access$getMyRemoveCallback$p(this.this$0);
                        if (consumer == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"myRemoveCallback");
                            consumer = null;
                        }
                        Notification notification2 = this.this$0.getMyNotificationWrapper().getNotification();
                        Intrinsics.checkNotNull((Object)notification2);
                        consumer.accept(notification2);
                        Notification notification3 = this.this$0.getMyNotificationWrapper().getNotification();
                        Intrinsics.checkNotNull((Object)notification3);
                        notification3.hideBalloon();
                    }
                });
            }
        }
        remindAction = IdeBundle.message((String)"notifications.toolwindow.dont.show.again.for.this.project", (Object[])new Object[0]);
        group2.add((AnAction)new DumbAwareAction(this, (String)remindAction){
            final /* synthetic */ NotificationComponent this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Function1 function1 = NotificationComponent.access$getMyDoNotAskHandler$p(this.this$0);
                if (function1 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"myDoNotAskHandler");
                    function1 = null;
                }
                function1.invoke((Object)true);
            }
        });
        remindAction = IdeBundle.message((String)"notifications.toolwindow.dont.show.again", (Object[])new Object[0]);
        group2.add((AnAction)new DumbAwareAction(this, (String)remindAction){
            final /* synthetic */ NotificationComponent this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Function1 function1 = NotificationComponent.access$getMyDoNotAskHandler$p(this.this$0);
                if (function1 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"myDoNotAskHandler");
                    function1 = null;
                }
                function1.invoke((Object)false);
            }
        });
        Presentation presentation2 = new Presentation();
        presentation2.setDescription(IdeBundle.message((String)"tooltip.turn.notification.off", (Object[])new Object[0]));
        presentation2.setPopupGroup(true);
        presentation2.setIcon(AllIcons.Actions.More);
        presentation2.putClientProperty(ActionUtil.HIDE_DROPDOWN_ICON, (Object)true);
        Dimension dimension = ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE;
        ActionButton button2 = new ActionButton(group2, presentation2, this, dimension){
            final /* synthetic */ NotificationComponent this$0;
            {
                this.this$0 = $receiver;
                super((AnAction)$group, $presentation, "unknown", $super_call_param$1);
            }

            protected JBPopup createAndShowActionGroupPopup(ActionGroup actionGroup, AnActionEvent event) {
                Intrinsics.checkNotNullParameter((Object)actionGroup, (String)"actionGroup");
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                NotificationComponent.access$setMyMorePopupVisible$p(this.this$0, true);
                JBPopup jBPopup = super.createAndShowActionGroupPopup(actionGroup, event);
                Intrinsics.checkNotNullExpressionValue((Object)jBPopup, (String)"createAndShowActionGroupPopup(...)");
                JBPopup popup2 = jBPopup;
                NotificationComponent.access$setMyMorePopup$p(this.this$0, popup2);
                popup2.addListener(new JBPopupListener(this.this$0, this){
                    final /* synthetic */ NotificationComponent this$0;
                    final /* synthetic */ createPopupAction.button.1 this$1;
                    {
                        this.this$0 = $receiver;
                        this.this$1 = $receiver2;
                    }

                    public void onClosed(LightweightWindowEvent event) {
                        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                        NotificationComponent.access$setMyMorePopup$p(this.this$0, null);
                        ApplicationManager.getApplication().invokeLater(() -> createPopupAction.button.createAndShowActionGroupPopup.1.onClosed$lambda$0(this.this$0, this.this$1));
                    }

                    private static final void onClosed$lambda$0(NotificationComponent this$0, createPopupAction.button.1 this$1) {
                        NotificationComponent.access$setMyMorePopupVisible$p(this$0, false);
                        this$1.setVisible(NotificationComponent.access$getMyHoverState$p(this$0));
                    }
                });
                return popup2;
            }
        };
        return button2;
    }

    private final void doShowSettings() {
        NotificationCollector.getInstance().logNotificationSettingsClicked(this.myNotificationWrapper.getId(), this.myNotificationWrapper.getDisplayId(), this.myNotificationWrapper.getGroupId());
        NotificationsConfigurable configurable = new NotificationsConfigurable();
        ShowSettingsUtil.getInstance().editConfigurable(this.project, (Configurable)configurable, () -> NotificationComponent.doShowSettings$lambda$0(configurable, this));
    }

    private final void runAction(AnAction action2, Object component2) {
        this.setNew(false);
        NotificationCollector notificationCollector = NotificationCollector.getInstance();
        Notification notification2 = this.myNotificationWrapper.getNotification();
        Intrinsics.checkNotNull((Object)notification2);
        notificationCollector.logNotificationActionInvoked(null, notification2, action2, NotificationCollector.NotificationPlace.ACTION_CENTER);
        Notification notification3 = this.myNotificationWrapper.getNotification();
        Intrinsics.checkNotNull((Object)notification3);
        DataManager dataManager = DataManager.getInstance();
        Intrinsics.checkNotNull((Object)component2, (String)"null cannot be cast to non-null type java.awt.Component");
        Notification.fire((Notification)notification3, (AnAction)action2, (DataContext)dataManager.getDataContext((Component)component2));
    }

    public final void expire() {
        this.closePopups();
        this.myNotificationWrapper.setNotification(null);
        this.setNew(false);
        for (LinkLabel component2 : UIUtil.findComponentsOfType((JComponent)((JComponent)((Object)this)), LinkLabel.class)) {
            component2.setEnabled(false);
        }
        if (this.myMoreButton != null) {
            this.myMoreButton.setVisible(false);
        }
    }

    public final void removeFromParent() {
        this.closePopups();
        for (JTextComponent component2 : UIUtil.findComponentsOfType((JComponent)((JComponent)((Object)this)), JTextComponent.class)) {
            Intrinsics.checkNotNull((Object)component2);
            this.singleSelectionHandler.remove(component2);
        }
    }

    private final void closePopups() {
        JBPopup jBPopup = this.myMorePopup;
        if (jBPopup != null) {
            jBPopup.cancel();
        }
        JPopupMenu jPopupMenu = this.myMoreAwtPopup;
        if (jPopupMenu != null) {
            jPopupMenu.setVisible(false);
        }
        JPopupMenu jPopupMenu2 = this.myDropDownPopup;
        if (jPopupMenu2 != null) {
            jPopupMenu2.setVisible(false);
        }
        this.popupAlarm.cancel();
    }

    private final JEditorPane createTextComponent(String text2) {
        JEditorPane component2 = new JEditorPane(){
            private final PreferredSizeCache sizeCache;
            {
                this.sizeCache = new PreferredSizeCache((Function0<? extends Dimension>)((Function0)() -> createTextComponent.component.1.sizeCache$lambda$0(this)));
            }

            public final PreferredSizeCache getSizeCache() {
                return this.sizeCache;
            }

            public Dimension getPreferredSize() {
                return this.sizeCache.getSize(this);
            }

            private static final Dimension sizeCache$lambda$0(createTextComponent.component.1 this$0) {
                Dimension dimension = super.getPreferredSize();
                Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getPreferredSize(...)");
                return dimension;
            }
        };
        component2.setEditable(false);
        component2.putClientProperty("JEditorPane.honorDisplayProperties", true);
        component2.setContentType("text/html");
        component2.setOpaque(false);
        component2.setBorder(null);
        NotificationsUtil.configureHtmlEditorKit(component2, false);
        Notification notification2 = this.myNotificationWrapper.getNotification();
        Intrinsics.checkNotNull((Object)notification2);
        if (notification2.getListener() != null) {
            component2.addHyperlinkListener(arg_0 -> NotificationComponent.createTextComponent$lambda$0(this, arg_0));
        }
        component2.putClientProperty("AccessibleName", StringUtil.unescapeXmlEntities((String)StringUtil.stripHtml((String)text2, (String)" ")));
        component2.setText(text2);
        component2.setEditable(false);
        if (component2.getCaret() != null) {
            component2.setCaretPosition(0);
        }
        this.myLafUpdater = () -> NotificationComponent.createTextComponent$lambda$1(component2, text2);
        return component2;
    }

    public final void updateLaf() {
        Runnable runnable2 = this.myLafUpdater;
        if (runnable2 != null) {
            runnable2.run();
        }
        this.updateColor();
    }

    public final void setDoNotAskHandler(@NotNull Function1<? super Boolean, Unit> handler2) {
        Intrinsics.checkNotNullParameter(handler2, (String)"handler");
        this.myDoNotAskHandler = handler2;
    }

    public final void setRemoveCallback(@NotNull Consumer<Notification> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.myRemoveCallback = callback;
    }

    public final boolean isHover() {
        return this.myHoverState;
    }

    public final void setNew(boolean state2) {
        if (this.myIsNew != state2) {
            this.myIsNew = state2;
            this.updateColor();
        }
    }

    public final void setHover(boolean state2) {
        this.myHoverState = state2;
        if (this.myMoreButton != null && !this.myMorePopupVisible) {
            this.myMoreButton.setVisible(state2 && this.myNotificationWrapper.getNotification() != null);
        }
        this.updateColor();
    }

    private final void updateColor() {
        if (this.myHoverState) {
            if (this.myIsNew) {
                this.setColor((Color)NEW_HOVER_COLOR);
            } else {
                this.setColor((Color)HOVER_COLOR);
            }
        } else if (this.myIsNew) {
            if (UIManager.getColor(NEW_COLOR_NAME) != null) {
                this.setColor((Color)NEW_COLOR);
            } else {
                this.setColor((Color)NEW_DEFAULT_COLOR);
            }
        } else {
            this.setColor(Companion.getBG_COLOR());
        }
    }

    private final void setColor(Color color) {
        this.myRoundColor = color;
        this.repaint();
    }

    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        super.paintComponent(g);
        if (this.myRoundColor != Companion.getBG_COLOR()) {
            g.setColor(this.myRoundColor);
            GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g);
            int cornerRadius = NotificationBalloonRoundShadowBorderProvider.CORNER_RADIUS.get();
            g.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), cornerRadius, cornerRadius);
            config.restore();
        }
    }

    public final boolean applySearchQuery(@Nullable String query) {
        if (query == null) {
            this.setVisible(true);
            return true;
        }
        boolean result2 = this.matchQuery(query);
        this.setVisible(result2);
        return result2;
    }

    private final boolean matchQuery(String query) {
        if (StringsKt.contains((CharSequence)this.myNotificationWrapper.getTitle(), (CharSequence)query, (boolean)true)) {
            return true;
        }
        String subtitle = this.myNotificationWrapper.getSubtitle();
        if (subtitle != null && StringsKt.contains((CharSequence)subtitle, (CharSequence)query, (boolean)true)) {
            return true;
        }
        if (StringsKt.contains((CharSequence)this.myNotificationWrapper.getContent(), (CharSequence)query, (boolean)true)) {
            return true;
        }
        for (String action2 : this.myNotificationWrapper.getActions()) {
            if (action2 == null || !StringsKt.contains((CharSequence)action2, (CharSequence)query, (boolean)true)) continue;
            return true;
        }
        return false;
    }

    private static final void _init_$lambda$0(NotificationComponent this$0, List $actions, ActionEvent it) {
        Object e = $actions.get(0);
        Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
        AnAction anAction = (AnAction)e;
        Object object = it.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSource(...)");
        this$0.runAction(anAction, object);
    }

    private static final void _init_$lambda$1(Notification $notification, DataSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        DataKey dataKey = Notification.KEY;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"KEY");
        sink.set(dataKey, (Object)$notification);
    }

    private static final void createAction$lambda$0(NotificationComponent this$0, LinkLabel lnk, AnAction act) {
        Intrinsics.checkNotNull((Object)act);
        Intrinsics.checkNotNull((Object)lnk);
        this$0.runAction(act, lnk);
    }

    private static final void doShowSettings$lambda$0(NotificationsConfigurable $configurable, NotificationComponent this$0) {
        block0: {
            Runnable runnable2;
            Runnable runnable3 = runnable2 = $configurable.enableSearch(this$0.myNotificationWrapper.getGroupId());
            if (runnable3 == null) break block0;
            runnable3.run();
        }
    }

    private static final void createTextComponent$lambda$0(NotificationComponent this$0, HyperlinkEvent e) {
        NotificationListener listener2;
        Notification notification2 = this$0.myNotificationWrapper.getNotification();
        if (notification2 != null && Intrinsics.areEqual((Object)e.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED) && (listener2 = notification2.getListener()) != null) {
            NotificationCollector.getInstance().logHyperlinkClicked(notification2);
            listener2.hyperlinkUpdate(notification2, e);
        }
    }

    private static final void createTextComponent$lambda$1(createTextComponent.component.1 $component, String $text) {
        NotificationsUtil.configureHtmlEditorKit($component, false);
        $component.getSizeCache().clearCache();
        $component.setText($text);
        $component.revalidate();
        $component.repaint();
    }

    public static final /* synthetic */ void access$doShowSettings(NotificationComponent $this) {
        $this.doShowSettings();
    }

    public static final /* synthetic */ Consumer access$getMyRemoveCallback$p(NotificationComponent $this) {
        return $this.myRemoveCallback;
    }

    public static final /* synthetic */ Function1 access$getMyDoNotAskHandler$p(NotificationComponent $this) {
        return $this.myDoNotAskHandler;
    }

    public static final /* synthetic */ void access$setMyMorePopupVisible$p(NotificationComponent $this, boolean bl) {
        $this.myMorePopupVisible = bl;
    }

    public static final /* synthetic */ void access$setMyMorePopup$p(NotificationComponent $this, JBPopup jBPopup) {
        $this.myMorePopup = jBPopup;
    }

    public static final /* synthetic */ boolean access$getMyHoverState$p(NotificationComponent $this) {
        return $this.myHoverState;
    }

    static {
        JBColor jBColor = JBColor.namedColor((String)"Label.infoForeground", (Color)((Color)new JBColor((Color)Gray.x80, (Color)Gray.x8C)));
        Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"namedColor(...)");
        INFO_COLOR = jBColor;
        NEW_DEFAULT_COLOR = new JBColor(15134455, 4540746);
        JBColor jBColor2 = JBColor.namedColor((String)NEW_COLOR_NAME, (Color)((Color)NEW_DEFAULT_COLOR));
        Intrinsics.checkNotNullExpressionValue((Object)jBColor2, (String)"namedColor(...)");
        NEW_COLOR = jBColor2;
        JBColor jBColor3 = JBColor.namedColor((String)"NotificationsToolwindow.newNotification.hoverBackground", (Color)((Color)new JBColor(15134455, 4540746)));
        Intrinsics.checkNotNullExpressionValue((Object)jBColor3, (String)"namedColor(...)");
        NEW_HOVER_COLOR = jBColor3;
        JBColor jBColor4 = JBColor.namedColor((String)"NotificationsToolwindow.Notification.hoverBackground", (Color)Companion.getBG_COLOR());
        Intrinsics.checkNotNullExpressionValue((Object)jBColor4, (String)"namedColor(...)");
        HOVER_COLOR = jBColor4;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0080T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0016\u0010\u0011\u001a\u00070\t\u00a2\u0006\u0002\b\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\fR\u0016\u0010\u0013\u001a\u00070\t\u00a2\u0006\u0002\b\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\fR\u0016\u0010\u0015\u001a\u00070\t\u00a2\u0006\u0002\b\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\fR\u000e\u0010\u0017\u001a\u00020\u000eX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/notification/impl/ui/NotificationComponent$Companion;", "", "<init>", "()V", "BG_COLOR", "Ljava/awt/Color;", "getBG_COLOR", "()Ljava/awt/Color;", "INFO_COLOR", "Lcom/intellij/ui/JBColor;", "Lorg/jetbrains/annotations/NotNull;", "getINFO_COLOR", "()Lcom/intellij/ui/JBColor;", "NEW_COLOR_NAME", "", "NEW_DEFAULT_COLOR", "getNEW_DEFAULT_COLOR$intellij_platform_ide_impl", "NEW_COLOR", "getNEW_COLOR", "NEW_HOVER_COLOR", "getNEW_HOVER_COLOR", "HOVER_COLOR", "getHOVER_COLOR", "TIME_KEY", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Color getBG_COLOR() {
            if (ExperimentalUI.Companion.isNewUI()) {
                Color color = JBUI.CurrentTheme.ToolWindow.background();
                Intrinsics.checkNotNullExpressionValue((Object)color, (String)"background(...)");
                return color;
            }
            Color color = UIUtil.getListBackground();
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getListBackground(...)");
            return color;
        }

        @NotNull
        public final JBColor getINFO_COLOR() {
            return INFO_COLOR;
        }

        @NotNull
        public final JBColor getNEW_DEFAULT_COLOR$intellij_platform_ide_impl() {
            return NEW_DEFAULT_COLOR;
        }

        @NotNull
        public final JBColor getNEW_COLOR() {
            return NEW_COLOR;
        }

        @NotNull
        public final JBColor getNEW_HOVER_COLOR() {
            return NEW_HOVER_COLOR;
        }

        @NotNull
        public final JBColor getHOVER_COLOR() {
            return HOVER_COLOR;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/intellij/notification/impl/ui/NotificationComponent$MyActionGroup;", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "Lcom/intellij/openapi/actionSystem/ex/TooltipDescriptionProvider;", "<init>", "()V", "intellij.platform.ide.impl"})
    public static final class MyActionGroup
    extends DefaultActionGroup
    implements TooltipDescriptionProvider {
        public MyActionGroup() {
            this.setPopup(true);
        }
    }
}

