/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.EditorModificationUtilEx;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.actionSystem.LatencyAwareEditorAction;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.editor.actions.TextComponentEditorAction;
import com.intellij.openapi.editor.ex.util.EditorUIUtil;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageEditorUtil;
import com.intellij.util.DocumentUtil;
import org.jetbrains.annotations.NotNull;

public final class BackspaceAction
extends TextComponentEditorAction
implements LatencyAwareEditorAction,
HintManagerImpl.ActionToIgnore {
    public BackspaceAction() {
        super((EditorActionHandler)new Handler());
    }

    private static void doBackSpaceAtCaret(@NotNull Editor editor2) {
        if (editor2 == null) {
            BackspaceAction.$$$reportNull$$$0(0);
        }
        VisualPosition caretPosition = editor2.getCaretModel().getVisualPosition();
        if (caretPosition.column > 0 && editor2.getInlayModel().hasInlineElementAt(new VisualPosition(caretPosition.line, caretPosition.column - 1))) {
            editor2.getCaretModel().moveCaretRelatively(-1, 0, false, false, EditorUtil.isCurrentCaretPrimary(editor2));
            return;
        }
        int lineNumber = editor2.getCaretModel().getLogicalPosition().line;
        int colNumber = editor2.getCaretModel().getLogicalPosition().column;
        Document document2 = editor2.getDocument();
        int offset = editor2.getCaretModel().getOffset();
        if (colNumber > 0) {
            if (EditorModificationUtil.calcAfterLineEnd((Editor)editor2) > 0) {
                int columnShift = -1;
                editor2.getCaretModel().moveCaretRelatively(columnShift, 0, false, false, true);
            } else {
                editor2.getSelectionModel().removeSelection();
                Runnable runnable2 = () -> {
                    FoldRegion region = editor2.getFoldingModel().getCollapsedRegionAtOffset(offset - 1);
                    if (region != null && region.shouldNeverExpand()) {
                        document2.deleteString(region.getStartOffset(), region.getEndOffset());
                        editor2.getCaretModel().moveToOffset(region.getStartOffset());
                    } else {
                        int prevOffset = DocumentUtil.getPreviousCodePointOffset((Document)document2, (int)offset);
                        if (prevOffset >= 0) {
                            document2.deleteString(prevOffset, offset);
                        }
                    }
                    EditorModificationUtilEx.scrollToCaret((Editor)editor2);
                };
                EditorUtil.runWithAnimationDisabled(editor2, runnable2);
            }
        } else if (lineNumber > 0) {
            int separatorLength = document2.getLineSeparatorLength(lineNumber - 1);
            int lineEnd = document2.getLineEndOffset(lineNumber - 1) + separatorLength;
            document2.deleteString(lineEnd - separatorLength, lineEnd);
            editor2.getCaretModel().moveToOffset(lineEnd - separatorLength);
            EditorModificationUtil.scrollToCaret((Editor)editor2);
            editor2.getSelectionModel().removeSelection();
            CommandProcessor commandProcessor = CommandProcessor.getInstance();
            commandProcessor.setCurrentCommandGroupId(null);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/actions/BackspaceAction", "doBackSpaceAtCaret"));
    }

    private static final class Handler
    extends EditorWriteActionHandler.ForEachCaret {
        private Handler() {
        }

        public void executeWriteAction(@NotNull Editor editor2, @NotNull Caret caret, DataContext dataContext2) {
            if (editor2 == null) {
                Handler.$$$reportNull$$$0(0);
            }
            if (caret == null) {
                Handler.$$$reportNull$$$0(1);
            }
            EditorUIUtil.hideCursorInEditor(editor2);
            CommandProcessor.getInstance().setCurrentCommandGroupId(EditorActionUtil.DELETE_COMMAND_GROUP);
            editor2 = InjectedLanguageEditorUtil.getTopLevelEditor((Editor)editor2);
            BackspaceAction.doBackSpaceAtCaret(editor2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "caret";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/editor/actions/BackspaceAction$Handler";
            objectArray[2] = "executeWriteAction";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

