/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionStub;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionResult;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.impl.EditorImpl;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@ApiStatus.Internal
public final class EditorLastActionTracker {
    private String myLastActionId;
    private Editor myCurrentEditor;
    private Editor myLastEditor;

    @NotNull
    public static EditorLastActionTracker getInstance() {
        EditorLastActionTracker editorLastActionTracker = (EditorLastActionTracker)ApplicationManager.getApplication().getService(EditorLastActionTracker.class);
        if (editorLastActionTracker == null) {
            EditorLastActionTracker.$$$reportNull$$$0(0);
        }
        return editorLastActionTracker;
    }

    @Nullable
    public String getLastActionId() {
        return this.myLastActionId;
    }

    private static String getActionId(AnAction action2) {
        return action2 instanceof ActionStub ? ((ActionStub)action2).getId() : ActionManager.getInstance().getId(action2);
    }

    private void doResetLastAction() {
        this.myLastActionId = null;
        this.myLastEditor = null;
    }

    @Nullable
    private static EditorLastActionTracker getTrackerIfCreated() {
        return (EditorLastActionTracker)ApplicationManager.getApplication().getServiceIfCreated(EditorLastActionTracker.class);
    }

    private static void resetLastAction() {
        EditorLastActionTracker tracker2 = EditorLastActionTracker.getTrackerIfCreated();
        if (tracker2 != null) {
            tracker2.doResetLastAction();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/EditorLastActionTracker", "getInstance"));
    }

    static final class MyEditorMouseListener
    implements EditorMouseListener {
        MyEditorMouseListener() {
        }

        public void mousePressed(@NotNull EditorMouseEvent e) {
            if (e == null) {
                MyEditorMouseListener.$$$reportNull$$$0(0);
            }
            EditorLastActionTracker.resetLastAction();
        }

        public void mouseClicked(@NotNull EditorMouseEvent e) {
            if (e == null) {
                MyEditorMouseListener.$$$reportNull$$$0(1);
            }
            EditorLastActionTracker.resetLastAction();
        }

        public void mouseReleased(@NotNull EditorMouseEvent e) {
            if (e == null) {
                MyEditorMouseListener.$$$reportNull$$$0(2);
            }
            EditorLastActionTracker.resetLastAction();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/openapi/editor/impl/EditorLastActionTracker$MyEditorMouseListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mousePressed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseClicked";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseReleased";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class MyAnActionListener
    implements AnActionListener {
        MyAnActionListener() {
        }

        public void beforeActionPerformed(@NotNull AnAction action2, @NotNull AnActionEvent event) {
            Editor editor2;
            EditorLastActionTracker tracker2;
            if (action2 == null) {
                MyAnActionListener.$$$reportNull$$$0(0);
            }
            if (event == null) {
                MyAnActionListener.$$$reportNull$$$0(1);
            }
            EditorLastActionTracker editorLastActionTracker = tracker2 = (editor2 = (Editor)event.getData(CommonDataKeys.HOST_EDITOR)) == null ? EditorLastActionTracker.getTrackerIfCreated() : EditorLastActionTracker.getInstance();
            if (tracker2 == null) {
                return;
            }
            tracker2.myCurrentEditor = editor2;
            if (tracker2.myCurrentEditor != tracker2.myLastEditor) {
                tracker2.doResetLastAction();
            }
        }

        public void afterActionPerformed(@NotNull AnAction action2, @NotNull AnActionEvent event, @NotNull AnActionResult result2) {
            if (action2 == null) {
                MyAnActionListener.$$$reportNull$$$0(2);
            }
            if (event == null) {
                MyAnActionListener.$$$reportNull$$$0(3);
            }
            if (result2 == null) {
                MyAnActionListener.$$$reportNull$$$0(4);
            }
            EditorLastActionTracker tracker2 = EditorLastActionTracker.getInstance();
            tracker2.myLastActionId = EditorLastActionTracker.getActionId(action2);
            tracker2.myLastEditor = tracker2.myCurrentEditor;
            tracker2.myCurrentEditor = null;
        }

        public void beforeEditorTyping(char c, @NotNull DataContext dataContext2) {
            if (dataContext2 == null) {
                MyAnActionListener.$$$reportNull$$$0(5);
            }
            EditorLastActionTracker.resetLastAction();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataContext";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/editor/impl/EditorLastActionTracker$MyAnActionListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeActionPerformed";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "afterActionPerformed";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeEditorTyping";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class MyEditorFactoryListener
    implements EditorFactoryListener {
        MyEditorFactoryListener() {
        }

        public void editorReleased(@NotNull EditorFactoryEvent event) {
            if (event == null) {
                MyEditorFactoryListener.$$$reportNull$$$0(0);
            }
            EditorLastActionTracker tracker2 = EditorLastActionTracker.getInstance();
            EditorImpl killedEditor = (EditorImpl)event.getEditor();
            if (tracker2.myCurrentEditor == killedEditor) {
                tracker2.myCurrentEditor = null;
            }
            if (tracker2.myLastEditor == killedEditor) {
                tracker2.myLastEditor = null;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/editor/impl/EditorLastActionTracker$MyEditorFactoryListener", "editorReleased"));
        }
    }
}

