/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.openapi.editor.CustomFoldRegion;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.impl.FoldRegionImpl;
import com.intellij.openapi.editor.impl.RangeMarkerTree;
import com.intellij.openapi.editor.impl.SweepProcessor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.IntPair;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class FoldRegionsTree {
    @NotNull
    private final RangeMarkerTree<? extends FoldRegionImpl> myMarkerTree;
    private volatile CachedData myCachedData;
    private static final Comparator<? super FoldRegion> BY_END_OFFSET = Comparator.comparingInt(region -> region.getEndOffset());
    private static final Comparator<? super FoldRegion> BY_END_OFFSET_REVERSE = Collections.reverseOrder(BY_END_OFFSET);

    FoldRegionsTree(@NotNull RangeMarkerTree<? extends FoldRegionImpl> markerTree) {
        if (markerTree == null) {
            FoldRegionsTree.$$$reportNull$$$0(0);
        }
        this.myMarkerTree = markerTree;
    }

    void clear() {
        this.clearCachedValues();
        this.myMarkerTree.clear();
    }

    void clearCachedValues() {
        this.myCachedData = null;
    }

    void clearCachedInlayValues() {
        CachedData data2 = this.myCachedData;
        if (data2 != null) {
            this.myCachedData = data2.clearCachedInlayValues();
        }
    }

    protected abstract boolean isFoldingEnabled();

    protected abstract boolean hasBlockInlays();

    protected abstract int getFoldedBlockInlaysHeight(int var1, int var2);

    protected abstract int getLineHeight();

    @NotNull
    CachedData rebuild() {
        final ArrayList<FoldRegion> visible = new ArrayList<FoldRegion>(this.myMarkerTree.size());
        SweepProcessor.Generator generator2 = processor2 -> this.myMarkerTree.processOverlappingWith(0, Integer.MAX_VALUE, processor2);
        SweepProcessor.sweep((SweepProcessor.Generator)generator2, (SweepProcessor)new SweepProcessor<FoldRegionImpl>(this){
            FoldRegionImpl lastCollapsedRegion;

            public boolean process(int offset, @NotNull FoldRegionImpl region, boolean atStart, @NotNull Collection<? extends FoldRegionImpl> overlapping) {
                if (region == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (overlapping == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (atStart && (this.lastCollapsedRegion == null || region.getEndOffset() > this.lastCollapsedRegion.getEndOffset() || region instanceof CustomFoldRegion && region.getStartOffset() == this.lastCollapsedRegion.getStartOffset() && region.getEndOffset() == this.lastCollapsedRegion.getEndOffset())) {
                    if (!region.isExpanded()) {
                        this.hideContainedRegions(region);
                        this.lastCollapsedRegion = region;
                    }
                    visible.add(region);
                }
                return true;
            }

            private void hideContainedRegions(FoldRegion region) {
                for (int i2 = visible.size() - 1; i2 >= 0 && region.getStartOffset() == ((FoldRegion)visible.get(i2)).getStartOffset(); --i2) {
                    visible.remove(i2);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "region";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "overlapping";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/editor/impl/FoldRegionsTree$1";
                objectArray[2] = "process";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        FoldRegion[] visibleRegions = FoldRegionsTree.toFoldArray(visible);
        Arrays.sort(visibleRegions, BY_END_OFFSET_REVERSE);
        return this.updateCachedAndSortOffsets(visibleRegions, true);
    }

    @NotNull
    private static @NotNull FoldRegion @NotNull [] toFoldArray(@NotNull List<FoldRegion> topLevels) {
        if (topLevels == null) {
            FoldRegionsTree.$$$reportNull$$$0(1);
        }
        FoldRegion[] foldRegionArray = topLevels.isEmpty() ? FoldRegion.EMPTY_ARRAY : topLevels.toArray(FoldRegion.EMPTY_ARRAY);
        if (foldRegionArray == null) {
            FoldRegionsTree.$$$reportNull$$$0(2);
        }
        return foldRegionArray;
    }

    void updateCachedOffsets() {
        if (this.isFoldingEnabled()) {
            CachedData data2 = this.myCachedData;
            if (data2 == null) {
                this.rebuild();
            } else {
                this.updateCachedAndSortOffsets(data2.visibleRegions, false);
            }
        }
    }

    @NotNull
    private CachedData updateCachedAndSortOffsets(@NotNull @NotNull FoldRegion @NotNull [] visibleRegions, boolean fromRebuild) {
        CachedData data2;
        if (visibleRegions == null) {
            FoldRegionsTree.$$$reportNull$$$0(3);
        }
        ArrayList<FoldRegion> topLevel = new ArrayList<FoldRegion>(visibleRegions.length / 2);
        for (FoldRegion region : visibleRegions) {
            if (!region.isValid()) {
                if (fromRebuild) {
                    throw new RuntimeExceptionWithAttachments("FoldRegionsTree.rebuild() failed", new Attachment[]{new Attachment("visibleRegions.txt", Arrays.toString(visibleRegions))});
                }
                CachedData cachedData = this.rebuild();
                if (cachedData == null) {
                    FoldRegionsTree.$$$reportNull$$$0(4);
                }
                return cachedData;
            }
            if (region.isExpanded()) continue;
            topLevel.add(region);
        }
        FoldRegion[] topLevelRegions = topLevel.toArray(FoldRegion.EMPTY_ARRAY);
        Arrays.sort(topLevelRegions, BY_END_OFFSET);
        int[] startOffsets = ArrayUtil.newIntArray((int)topLevelRegions.length);
        int[] endOffsets = ArrayUtil.newIntArray((int)topLevelRegions.length);
        int[] foldedLines = ArrayUtil.newIntArray((int)topLevelRegions.length);
        int[] customYAdjustment = ArrayUtil.newIntArray((int)topLevelRegions.length);
        int foldedLinesSum = 0;
        int currentCustomYAdjustment = 0;
        int lineHeight = this.getLineHeight();
        for (int i2 = 0; i2 < topLevelRegions.length; ++i2) {
            FoldRegion region = topLevelRegions[i2];
            startOffsets[i2] = region.getStartOffset();
            endOffsets[i2] = region.getEndOffset() - 1;
            Document document2 = region.getDocument();
            foldedLines[i2] = foldedLinesSum += document2.getLineNumber(region.getEndOffset()) - document2.getLineNumber(region.getStartOffset());
            if (region instanceof CustomFoldRegion) {
                currentCustomYAdjustment += ((CustomFoldRegion)region).getHeightInPixels() - lineHeight;
            }
            customYAdjustment[i2] = currentCustomYAdjustment;
        }
        this.myCachedData = data2 = new CachedData(visibleRegions, topLevelRegions, startOffsets, endOffsets, foldedLines, customYAdjustment, this.computeTopFoldedInlaysHeight(topLevelRegions, startOffsets, endOffsets));
        CachedData cachedData = data2;
        if (cachedData == null) {
            FoldRegionsTree.$$$reportNull$$$0(5);
        }
        return cachedData;
    }

    boolean checkIfValidToCreate(int start2, int end, boolean custom, FoldRegion toIgnore) {
        int length = end - start2;
        return this.myMarkerTree.processOverlappingWith(start2, end, region -> {
            if (region == toIgnore || !region.isValid()) {
                return true;
            }
            int rStart = region.getStartOffset();
            int rEnd = region.getEndOffset();
            int rLength = rEnd - rStart;
            boolean rCustom = region instanceof CustomFoldRegion;
            int overlapLength = Math.min(end, rEnd) - Math.max(start2, rStart);
            if (overlapLength == 0) {
                return !custom && !rCustom;
            }
            if (overlapLength < length && overlapLength < rLength) {
                return false;
            }
            if (length == rLength) {
                return custom != rCustom;
            }
            return start2 != rStart && end != rEnd || (length < rLength ? !custom || rCustom : !rCustom || custom);
        });
    }

    @Nullable
    private CachedData ensureAvailableDataIfPossible() {
        CachedData cachedData = this.myCachedData;
        if (cachedData == null && ApplicationManager.getApplication().isDispatchThread()) {
            return this.rebuild();
        }
        return cachedData;
    }

    @Nullable
    FoldRegion fetchOutermost(int offset) {
        if (!this.isFoldingEnabled()) {
            return null;
        }
        CachedData cachedData = this.ensureAvailableDataIfPossible();
        if (cachedData == null) {
            return null;
        }
        int[] ends = cachedData.topEndOffsets;
        int[] starts = cachedData.topStartOffsets;
        int i2 = ObjectUtils.binarySearch((int)0, (int)ends.length, mid -> ends[mid] < offset ? -1 : (starts[mid] > offset ? 1 : 0));
        return i2 < 0 ? null : cachedData.topLevelRegions[i2];
    }

    @NotNull FoldRegion @Nullable [] fetchVisible() {
        if (!this.isFoldingEnabled()) {
            return null;
        }
        CachedData cachedData = this.ensureAvailableDataIfPossible();
        if (cachedData == null) {
            return null;
        }
        return cachedData.visibleRegions;
    }

    @NotNull FoldRegion @Nullable [] fetchTopLevel() {
        if (!this.isFoldingEnabled()) {
            return null;
        }
        CachedData cachedData = this.ensureAvailableDataIfPossible();
        if (cachedData == null) {
            return null;
        }
        return cachedData.topLevelRegions;
    }

    static boolean containsStrict(@NotNull FoldRegion region, int offset) {
        if (region == null) {
            FoldRegionsTree.$$$reportNull$$$0(6);
        }
        return region.getStartOffset() < offset && offset < region.getEndOffset();
    }

    @NotNull
    @NotNull FoldRegion @NotNull [] fetchCollapsedAt(int offset) {
        if (!this.isFoldingEnabled()) {
            if (FoldRegion.EMPTY_ARRAY == null) {
                FoldRegionsTree.$$$reportNull$$$0(7);
            }
            return FoldRegion.EMPTY_ARRAY;
        }
        ArrayList<FoldRegion> allCollapsed = new ArrayList<FoldRegion>();
        this.myMarkerTree.processContaining(offset, region -> {
            if (!region.isExpanded() && FoldRegionsTree.containsStrict(region, offset)) {
                allCollapsed.add((FoldRegion)region);
            }
            return true;
        });
        return FoldRegionsTree.toFoldArray(allCollapsed);
    }

    boolean intersectsRegion(int startOffset, int endOffset) {
        if (!this.isFoldingEnabled()) {
            return true;
        }
        return !this.myMarkerTree.processAll(region -> {
            boolean contains2;
            boolean contains1 = FoldRegionsTree.containsStrict(region, startOffset);
            return contains1 == (contains2 = FoldRegionsTree.containsStrict(region, endOffset));
        });
    }

    @NotNull
    @NotNull FoldRegion @NotNull [] fetchAllRegions() {
        if (!this.isFoldingEnabled()) {
            if (FoldRegion.EMPTY_ARRAY == null) {
                FoldRegionsTree.$$$reportNull$$$0(8);
            }
            return FoldRegion.EMPTY_ARRAY;
        }
        ArrayList<FoldRegion> regions = new ArrayList<FoldRegion>();
        this.myMarkerTree.processOverlappingWith(0, Integer.MAX_VALUE, (Processor)new CommonProcessors.CollectProcessor(regions));
        return FoldRegionsTree.toFoldArray(regions);
    }

    @NotNull
    List<FoldRegion> fetchOverlapping(int startOffset, int endOffset) {
        if (!this.isFoldingEnabled()) {
            List<FoldRegion> list2 = Collections.emptyList();
            if (list2 == null) {
                FoldRegionsTree.$$$reportNull$$$0(9);
            }
            return list2;
        }
        ArrayList<FoldRegion> regions = new ArrayList<FoldRegion>();
        this.myMarkerTree.processOverlappingWith(startOffset, endOffset, (Processor)new CommonProcessors.CollectProcessor(regions));
        ArrayList<FoldRegion> arrayList = regions;
        if (arrayList == null) {
            FoldRegionsTree.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    int getFoldedLinesCountBefore(int offset) {
        if (!this.isFoldingEnabled()) {
            return 0;
        }
        CachedData cachedData = this.ensureAvailableDataIfPossible();
        if (cachedData == null) {
            return 0;
        }
        int idx = FoldRegionsTree.getLastTopLevelIndexBefore(cachedData, offset);
        if (idx == -1) {
            return 0;
        }
        return cachedData.topFoldedLines[idx];
    }

    int getTotalNumberOfFoldedLines() {
        if (!this.isFoldingEnabled()) {
            return 0;
        }
        CachedData cachedData = this.ensureAvailableDataIfPossible();
        if (cachedData == null) {
            return 0;
        }
        int[] foldedLines = cachedData.topFoldedLines;
        if (foldedLines.length == 0) {
            return 0;
        }
        return foldedLines[foldedLines.length - 1];
    }

    int getHeightOfFoldedBlockInlaysBefore(int idx) {
        if (!this.isFoldingEnabled() || idx == -1) {
            return 0;
        }
        CachedData cachedData = this.ensureInlayDataAvailableIfPossible();
        if (cachedData == null) {
            return 0;
        }
        int[] topFoldedInlaysHeight = cachedData.topFoldedInlaysHeight;
        return topFoldedInlaysHeight.length <= idx || topFoldedInlaysHeight == CachedData.NOT_YET_COMPUTED ? 0 : topFoldedInlaysHeight[idx];
    }

    int getTotalHeightOfFoldedBlockInlays() {
        if (!this.isFoldingEnabled()) {
            return 0;
        }
        CachedData cachedData = this.ensureInlayDataAvailableIfPossible();
        if (cachedData == null) {
            return 0;
        }
        int[] foldedInlaysHeight = cachedData.topFoldedInlaysHeight;
        return foldedInlaysHeight.length == 0 || foldedInlaysHeight == CachedData.NOT_YET_COMPUTED ? 0 : foldedInlaysHeight[foldedInlaysHeight.length - 1];
    }

    @NotNull
    IntPair getCustomRegionsYAdjustment(int offset, int idx) {
        if (!this.isFoldingEnabled()) {
            return new IntPair(0, 0);
        }
        CachedData cachedData = this.ensureAvailableDataIfPossible();
        if (cachedData == null) {
            return new IntPair(0, 0);
        }
        int prevAdjustment = idx == -1 ? 0 : cachedData.topCustomYAdjustment[idx];
        int curAdjustment = idx + 1 < cachedData.topStartOffsets.length && cachedData.topStartOffsets[idx + 1] == offset ? cachedData.topCustomYAdjustment[idx + 1] - prevAdjustment : 0;
        return new IntPair(prevAdjustment, curAdjustment);
    }

    int getLastTopLevelIndexBefore(int offset) {
        if (!this.isFoldingEnabled()) {
            return -1;
        }
        CachedData cachedData = this.ensureAvailableDataIfPossible();
        if (cachedData == null) {
            return -1;
        }
        return FoldRegionsTree.getLastTopLevelIndexBefore(cachedData, offset);
    }

    private static int getLastTopLevelIndexBefore(@NotNull CachedData cachedData, int offset) {
        int[] endOffsets;
        int i2;
        if (cachedData == null) {
            FoldRegionsTree.$$$reportNull$$$0(11);
        }
        return (i2 = Arrays.binarySearch(endOffsets = cachedData.topEndOffsets, --offset)) < 0 ? -i2 - 2 : i2;
    }

    @Nullable
    FoldRegion getRegionAt(int startOffset, int endOffset) {
        FoldRegionImpl[] found = new FoldRegionImpl[]{null};
        this.myMarkerTree.processOverlappingWith(startOffset, endOffset, region -> {
            if (region.getStartOffset() == startOffset && region.getEndOffset() == endOffset) {
                found[0] = region;
                return false;
            }
            return true;
        });
        return found[0];
    }

    void clearDocumentRangesModificationStatus() {
        this.myMarkerTree.processAll(region -> {
            region.resetDocumentRegionChanged();
            return true;
        });
    }

    @Nullable
    private CachedData ensureInlayDataAvailableIfPossible() {
        CachedData newData;
        CachedData data2 = this.ensureAvailableDataIfPossible();
        if (data2 == null) {
            return null;
        }
        if (data2.topFoldedInlaysHeight != CachedData.NOT_YET_COMPUTED || !ApplicationManager.getApplication().isDispatchThread()) {
            return data2;
        }
        int[] topFoldedInlaysHeight = this.computeTopFoldedInlaysHeight(data2.topLevelRegions, data2.topStartOffsets, data2.topEndOffsets);
        this.myCachedData = newData = new CachedData(data2.visibleRegions, data2.topLevelRegions, data2.topStartOffsets, data2.topEndOffsets, data2.topFoldedLines, data2.topCustomYAdjustment, topFoldedInlaysHeight);
        return newData;
    }

    private int @NotNull [] computeTopFoldedInlaysHeight(@NotNull FoldRegion[] topLevelRegions, int @NotNull [] topStartOffsets, int @NotNull [] topEndOffsets) {
        if (topStartOffsets == null) {
            FoldRegionsTree.$$$reportNull$$$0(12);
        }
        if (topEndOffsets == null) {
            FoldRegionsTree.$$$reportNull$$$0(13);
        }
        if (topLevelRegions == null) {
            FoldRegionsTree.$$$reportNull$$$0(14);
        }
        int count = this.hasBlockInlays() ? topLevelRegions.length : 0;
        int[] topFoldedInlaysHeight = ArrayUtil.newIntArray((int)count);
        int inlaysHeightSum = 0;
        for (int i2 = 0; i2 < count; ++i2) {
            topFoldedInlaysHeight[i2] = inlaysHeightSum += this.getFoldedBlockInlaysHeight(topStartOffsets[i2], topEndOffsets[i2] + 1);
        }
        if (topFoldedInlaysHeight == null) {
            FoldRegionsTree.$$$reportNull$$$0(15);
        }
        return topFoldedInlaysHeight;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 5, 7, 8, 9, 10, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "markerTree";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topLevels";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/FoldRegionsTree";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibleRegions";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "region";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cachedData";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topStartOffsets";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topEndOffsets";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topLevelRegions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/FoldRegionsTree";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "toFoldArray";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "updateCachedAndSortOffsets";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchCollapsedAt";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchAllRegions";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchOverlapping";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "computeTopFoldedInlaysHeight";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "toFoldArray";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateCachedAndSortOffsets";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "containsStrict";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getLastTopLevelIndexBefore";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "computeTopFoldedInlaysHeight";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 5, 7, 8, 9, 10, 15 -> new IllegalStateException(string);
        };
    }

    private record CachedData(@NotNull @NotNull FoldRegion @NotNull [] visibleRegions, @NotNull @NotNull FoldRegion @NotNull [] topLevelRegions, int @NotNull [] topStartOffsets, int @NotNull [] topEndOffsets, int @NotNull [] topFoldedLines, int @NotNull [] topCustomYAdjustment, int @NotNull [] topFoldedInlaysHeight) {
        @NotNull
        private final @NotNull FoldRegion @NotNull [] visibleRegions;
        @NotNull
        private final @NotNull FoldRegion @NotNull [] topLevelRegions;
        private final int @NotNull [] topStartOffsets;
        private final int @NotNull [] topEndOffsets;
        private final int @NotNull [] topFoldedLines;
        private final int @NotNull [] topCustomYAdjustment;
        private final int @NotNull [] topFoldedInlaysHeight;
        private static final int[] NOT_YET_COMPUTED = new int[1];

        private CachedData(@NotNull @NotNull FoldRegion @NotNull [] visibleRegions, @NotNull @NotNull FoldRegion @NotNull [] topLevelRegions, int @NotNull [] topStartOffsets, int @NotNull [] topEndOffsets, int @NotNull [] topFoldedLines, int @NotNull [] topCustomYAdjustment, int @NotNull [] topFoldedInlaysHeight) {
            if (visibleRegions == null) {
                CachedData.$$$reportNull$$$0(0);
            }
            if (topLevelRegions == null) {
                CachedData.$$$reportNull$$$0(1);
            }
            if (topStartOffsets == null) {
                CachedData.$$$reportNull$$$0(2);
            }
            if (topEndOffsets == null) {
                CachedData.$$$reportNull$$$0(3);
            }
            if (topFoldedLines == null) {
                CachedData.$$$reportNull$$$0(4);
            }
            if (topCustomYAdjustment == null) {
                CachedData.$$$reportNull$$$0(5);
            }
            if (topFoldedInlaysHeight == null) {
                CachedData.$$$reportNull$$$0(6);
            }
        }

        @NotNull
        private CachedData clearCachedInlayValues() {
            return this.topFoldedInlaysHeight == NOT_YET_COMPUTED ? this : new CachedData(this.visibleRegions, this.topLevelRegions, this.topStartOffsets, this.topEndOffsets, this.topFoldedLines, this.topCustomYAdjustment, NOT_YET_COMPUTED);
        }

        @NotNull
        public @NotNull FoldRegion @NotNull [] visibleRegions() {
            if (this.visibleRegions == null) {
                CachedData.$$$reportNull$$$0(7);
            }
            return this.visibleRegions;
        }

        @NotNull
        public @NotNull FoldRegion @NotNull [] topLevelRegions() {
            if (this.topLevelRegions == null) {
                CachedData.$$$reportNull$$$0(8);
            }
            return this.topLevelRegions;
        }

        public int @NotNull [] topStartOffsets() {
            if (this.topStartOffsets == null) {
                CachedData.$$$reportNull$$$0(9);
            }
            return this.topStartOffsets;
        }

        public int @NotNull [] topEndOffsets() {
            if (this.topEndOffsets == null) {
                CachedData.$$$reportNull$$$0(10);
            }
            return this.topEndOffsets;
        }

        public int @NotNull [] topFoldedLines() {
            if (this.topFoldedLines == null) {
                CachedData.$$$reportNull$$$0(11);
            }
            return this.topFoldedLines;
        }

        public int @NotNull [] topCustomYAdjustment() {
            if (this.topCustomYAdjustment == null) {
                CachedData.$$$reportNull$$$0(12);
            }
            return this.topCustomYAdjustment;
        }

        public int @NotNull [] topFoldedInlaysHeight() {
            if (this.topFoldedInlaysHeight == null) {
                CachedData.$$$reportNull$$$0(13);
            }
            return this.topFoldedInlaysHeight;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 7, 8, 9, 10, 11, 12, 13 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visibleRegions";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "topLevelRegions";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "topStartOffsets";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "topEndOffsets";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "topFoldedLines";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "topCustomYAdjustment";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "topFoldedInlaysHeight";
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/editor/impl/FoldRegionsTree$CachedData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/editor/impl/FoldRegionsTree$CachedData";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "visibleRegions";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "topLevelRegions";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "topStartOffsets";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "topEndOffsets";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "topFoldedLines";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "topCustomYAdjustment";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "topFoldedInlaysHeight";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 7, 8, 9, 10, 11, 12, 13 -> new IllegalStateException(string);
            };
        }
    }
}

