/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.featureStatistics.fusCollectors.InspectionWidgetUsageCollector;
import com.intellij.icons.AllIcons;
import com.intellij.ide.HelpTooltip;
import com.intellij.ide.PowerSaveMode;
import com.intellij.ide.actions.ActionsCollector;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.InspectionPopupLevelChangePolicy;
import com.intellij.openapi.editor.markup.AnalyzerStatus;
import com.intellij.openapi.editor.markup.AnalyzingType;
import com.intellij.openapi.editor.markup.InspectionsLevel;
import com.intellij.openapi.editor.markup.LanguageHighlightLevel;
import com.intellij.openapi.editor.markup.PassWrapper;
import com.intellij.openapi.editor.markup.StatusItem;
import com.intellij.openapi.editor.markup.UIController;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.StackingPopupDispatcher;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AncestorListenerAdapter;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.DropDownLink;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.dsl.listCellRenderer.BuilderKt;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.SingleEdtTaskScheduler;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

final class TrafficLightPopup {
    private final ExtensionPointName<InspectionPopupLevelChangePolicy> EP_NAME;
    private static final int DELTA_X = 6;
    private static final int DELTA_Y = 6;
    private final Editor myEditor;
    private final AnAction compactViewAction;
    private final JPanel myContent;
    private final Map<String, JProgressBar> myProgressBarMap;
    private final AncestorListener myAncestorListener;
    private final SingleEdtTaskScheduler popupAlarm;
    private JBPopup myPopup;
    private boolean insidePopup;

    TrafficLightPopup(@NotNull Editor editor2, @NotNull AnAction compactViewAction) {
        if (editor2 == null) {
            TrafficLightPopup.$$$reportNull$$$0(0);
        }
        if (compactViewAction == null) {
            TrafficLightPopup.$$$reportNull$$$0(1);
        }
        this.EP_NAME = new ExtensionPointName("com.intellij.inspectionPopupLevelChangePolicy");
        this.myContent = new JPanel(new GridBagLayout());
        this.myProgressBarMap = new HashMap<String, JProgressBar>();
        this.popupAlarm = SingleEdtTaskScheduler.createSingleEdtTaskScheduler();
        this.myEditor = editor2;
        this.compactViewAction = compactViewAction;
        this.myContent.setOpaque(true);
        this.myContent.setBackground(ExperimentalUI.isNewUI() ? JBUI.CurrentTheme.Editor.Tooltip.BACKGROUND : UIUtil.getToolTipBackground());
        this.myAncestorListener = new AncestorListenerAdapter(){

            public void ancestorMoved(AncestorEvent event) {
                TrafficLightPopup.this.hidePopup();
            }
        };
        this.myContent.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent event) {
                TrafficLightPopup.this.insidePopup = true;
            }

            @Override
            public void mouseExited(MouseEvent event) {
                Point point = event.getPoint();
                if (!TrafficLightPopup.this.myContent.getBounds().contains(point) || point.x == 0 || point.y == 0) {
                    TrafficLightPopup.this.insidePopup = false;
                    if (TrafficLightPopup.this.canClose()) {
                        TrafficLightPopup.this.hidePopup();
                    }
                }
            }
        });
    }

    private boolean canClose() {
        return !this.insidePopup && !StackingPopupDispatcher.getInstance().isPopupFocused();
    }

    void updateUI() {
        IJSwingUtilities.updateComponentTreeUI(this.myContent);
    }

    void scheduleShow(@NotNull InputEvent event, @NotNull AnalyzerStatus analyzerStatus) {
        if (event == null) {
            TrafficLightPopup.$$$reportNull$$$0(2);
        }
        if (analyzerStatus == null) {
            TrafficLightPopup.$$$reportNull$$$0(3);
        }
        this.popupAlarm.cancelAndRequest((long)Registry.intValue((String)"ide.tooltip.initialReshowDelay"), () -> this.showPopup(event, analyzerStatus));
    }

    void scheduleHide() {
        this.popupAlarm.cancelAndRequest((long)Registry.intValue((String)"ide.tooltip.initialDelay.highlighter"), () -> {
            if (this.canClose()) {
                this.hidePopup();
            }
        });
    }

    private void showPopup(@NotNull InputEvent event, final @NotNull AnalyzerStatus analyzerStatus) {
        if (event == null) {
            TrafficLightPopup.$$$reportNull$$$0(4);
        }
        if (analyzerStatus == null) {
            TrafficLightPopup.$$$reportNull$$$0(5);
        }
        this.hidePopup();
        if (analyzerStatus.isEmpty()) {
            return;
        }
        this.updateContentPanel(analyzerStatus);
        ComponentPopupBuilder myPopupBuilder = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)this.myContent, null).setCancelOnClickOutside(true).setCancelCallback(() -> analyzerStatus.getController().canClosePopup());
        JBPopupListener myPopupListener = new JBPopupListener(){

            public void onClosed(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                analyzerStatus.getController().onClosePopup();
                TrafficLightPopup.this.myEditor.getComponent().removeAncestorListener(TrafficLightPopup.this.myAncestorListener);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/editor/impl/TrafficLightPopup$3", "onClosed"));
            }
        };
        this.myPopup = myPopupBuilder.createPopup();
        this.myPopup.addListener(myPopupListener);
        this.myEditor.getComponent().addAncestorListener(this.myAncestorListener);
        JComponent owner = (JComponent)event.getComponent();
        Dimension size2 = this.myContent.getPreferredSize();
        size2.width = Math.max(size2.width, JBUIScale.scale((int)296));
        RelativePoint point = new RelativePoint((Component)owner, new Point(owner.getWidth() - owner.getInsets().right + JBUIScale.scale((int)6) - size2.width, owner.getHeight() + JBUIScale.scale((int)6)));
        this.myPopup.setSize(size2);
        InspectionWidgetUsageCollector.logPopupShown(this.myEditor.getProject());
        this.myPopup.show(point);
    }

    void hidePopup() {
        if (this.myPopup != null && !this.myPopup.isDisposed()) {
            this.myPopup.cancel();
        }
        this.myPopup = null;
    }

    private void updateContentPanel(@NotNull AnalyzerStatus analyzerStatus) {
        if (analyzerStatus == null) {
            TrafficLightPopup.$$$reportNull$$$0(6);
        }
        UIController controller = analyzerStatus.getController();
        List<PassWrapper> passes = analyzerStatus.getPasses();
        Set presentableNames = ContainerUtil.map2Set(passes, p -> p.getPresentableName());
        if (!presentableNames.isEmpty() && this.myProgressBarMap.keySet().equals(presentableNames)) {
            for (PassWrapper pass : passes) {
                this.myProgressBarMap.get(pass.getPresentableName()).setValue(pass.getPercent());
            }
            return;
        }
        this.myContent.removeAll();
        GridBag gc = new GridBag().nextLine().next().anchor(21).weightx(1.0).fillCellHorizontally().insets(10, 10, 10, 0);
        boolean hasTitle = StringUtil.isNotEmpty((String)analyzerStatus.getTitle());
        if (hasTitle) {
            this.myContent.add((Component)new JLabel(XmlStringUtil.wrapInHtml((CharSequence)analyzerStatus.getTitle())), gc);
        } else if (StringUtil.isNotEmpty((String)analyzerStatus.getDetails())) {
            this.myContent.add((Component)new JLabel(XmlStringUtil.wrapInHtml((CharSequence)analyzerStatus.getDetails())), gc);
        } else if (!analyzerStatus.getExpandedStatus().isEmpty() && analyzerStatus.getAnalyzingType() != AnalyzingType.EMPTY) {
            this.myContent.add((Component)TrafficLightPopup.createDetailsPanel(analyzerStatus), gc);
        }
        List<AnAction> actions = controller.getActions();
        if (!actions.isEmpty()) {
            ActionButton menuButton = new ActionButton((AnAction)new MenuAction(actions, this.compactViewAction), null, "EditorPopup", ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE){

                @Override
                protected DataContext getDataContext() {
                    return ((EditorEx)TrafficLightPopup.this.myEditor).getDataContext();
                }
            };
            this.myContent.add((Component)menuButton, gc.next().anchor(22).weightx(0.0).insets(10, 6, 10, 6));
        }
        this.myProgressBarMap.clear();
        NonOpaquePanel myProgressPanel = new NonOpaquePanel((LayoutManager)new GridBagLayout());
        GridBag progressGC = new GridBag();
        for (PassWrapper pass : passes) {
            myProgressPanel.add((Component)new JLabel(pass.getPresentableName() + ": "), progressGC.nextLine().next().anchor(21).weightx(0.0).insets(0, 10, 0, 6));
            JProgressBar pb = new JProgressBar(0, 100);
            pb.setValue(pass.getPercent());
            myProgressPanel.add((Component)pb, progressGC.next().anchor(21).weightx(1.0).fillCellHorizontally().insets(0, 0, 0, 6));
            this.myProgressBarMap.put(pass.getPresentableName(), pb);
        }
        this.myContent.add((Component)myProgressPanel, gc.nextLine().next().anchor(21).fillCellHorizontally().coverLine().weightx(1.0));
        if (hasTitle) {
            int topIndent = !this.myProgressBarMap.isEmpty() ? 10 : 0;
            gc.nextLine().next().anchor(21).fillCellHorizontally().coverLine().weightx(1.0).insets(topIndent, 10, 10, 6);
            if (StringUtil.isNotEmpty((String)analyzerStatus.getDetails())) {
                this.myContent.add((Component)new JLabel(XmlStringUtil.wrapInHtml((CharSequence)analyzerStatus.getDetails())), gc);
            } else if (!analyzerStatus.getExpandedStatus().isEmpty() && analyzerStatus.getAnalyzingType() != AnalyzingType.EMPTY) {
                this.myContent.add((Component)TrafficLightPopup.createDetailsPanel(analyzerStatus), gc);
            } else if (!passes.isEmpty()) {
                myProgressPanel.setBorder((Border)JBUI.Borders.emptyBottom((int)12));
            }
        }
        this.myContent.add((Component)this.createLowerPanel(controller), gc.nextLine().next().anchor(21).fillCellHorizontally().coverLine().weightx(1.0));
    }

    void updateVisiblePopup(@NotNull AnalyzerStatus analyzerStatus) {
        if (analyzerStatus == null) {
            TrafficLightPopup.$$$reportNull$$$0(7);
        }
        if (this.myPopup != null && this.myPopup.isVisible()) {
            this.updateContentPanel(analyzerStatus);
            Dimension size2 = this.myContent.getPreferredSize();
            size2.width = Math.max(size2.width, JBUIScale.scale((int)296));
            this.myPopup.setSize(size2);
        }
    }

    @NotNull
    private static JComponent createDetailsPanel(@NotNull AnalyzerStatus analyzerStatus) {
        if (analyzerStatus == null) {
            TrafficLightPopup.$$$reportNull$$$0(8);
        }
        @Nls StringBuilder text2 = new StringBuilder();
        List<StatusItem> expandedStatus = analyzerStatus.getExpandedStatus();
        for (int i2 = 0; i2 < expandedStatus.size(); ++i2) {
            boolean last = i2 == expandedStatus.size() - 1;
            StatusItem item = expandedStatus.get(i2);
            String detailsText = item.getDetailsText();
            text2.append(detailsText != null ? detailsText : item.getText());
            if (!last) {
                text2.append(", ");
                continue;
            }
            if (analyzerStatus.getAnalyzingType() == AnalyzingType.COMPLETE) continue;
            text2.append(" ").append(EditorBundle.message((String)"iw.found.so.far.suffix", (Object[])new Object[0]));
        }
        return new JLabel(text2.toString());
    }

    @NotNull
    private JPanel createLowerPanel(@NotNull UIController controller) {
        if (controller == null) {
            TrafficLightPopup.$$$reportNull$$$0(9);
        }
        JPanel panel2 = new JPanel(new GridBagLayout());
        GridBag gc = new GridBag().nextLine();
        if (PowerSaveMode.isEnabled()) {
            panel2.add((Component)((Object)new TrackableLinkLabel(EditorBundle.message((String)"iw.disable.powersave", (Object[])new Object[0]), () -> {
                PowerSaveMode.setEnabled((boolean)false);
                this.hidePopup();
            })), gc.next().anchor(21));
        } else {
            InspectionPopupLevelChangePolicy extension;
            List<LanguageHighlightLevel> levels = controller.getHighlightLevels();
            String msg = null;
            Iterator<Object> iterator2 = this.EP_NAME.getExtensionList().iterator();
            while (iterator2.hasNext() && (msg = (extension = (InspectionPopupLevelChangePolicy)iterator2.next()).getUnavailabilityReason(this.myEditor)) == null) {
            }
            if (levels.size() == 1) {
                String prefix = EditorBundle.message((String)"iw.highlight.label", (Object[])new Object[0]) + " ";
                GridBag constrains = gc.next();
                if (msg == null) {
                    DropDownLink<InspectionsLevel> link = this.createDropDownLink(levels.get(0), controller, prefix);
                    panel2.add((Component)link, constrains);
                } else {
                    JLabel noAccessLabel = TrafficLightPopup.createNoChangeLabel(levels.get(0), prefix, msg);
                    panel2.add((Component)noAccessLabel, constrains);
                }
            } else if (levels.size() > 1) {
                for (LanguageHighlightLevel level : levels) {
                    GridBag constrains;
                    String prefix = level.getLangID() + ": ";
                    GridBag gridBag = constrains = gc.next().anchor((int)21).gridx > 0 ? gc.insetLeft(8) : gc;
                    if (msg == null) {
                        DropDownLink<InspectionsLevel> link = this.createDropDownLink(level, controller, prefix);
                        panel2.add((Component)link, constrains);
                        continue;
                    }
                    JLabel noAccessLabel = TrafficLightPopup.createNoChangeLabel(level, prefix, msg);
                    panel2.add((Component)noAccessLabel, constrains);
                }
            }
        }
        panel2.add(Box.createHorizontalGlue(), gc.next().fillCellHorizontally().weightx(1.0));
        controller.fillHectorPanels(panel2, gc);
        panel2.setOpaque(true);
        panel2.setBackground(UIUtil.getToolTipActionBackground());
        panel2.setBorder((Border)JBUI.Borders.empty((int)4, (int)10));
        JPanel jPanel = panel2;
        if (jPanel == null) {
            TrafficLightPopup.$$$reportNull$$$0(10);
        }
        return jPanel;
    }

    @NotNull
    private DropDownLink<InspectionsLevel> createDropDownLink(@NotNull LanguageHighlightLevel level, @NotNull UIController controller, final @NotNull @Nls String prefix) {
        if (level == null) {
            TrafficLightPopup.$$$reportNull$$$0(11);
        }
        if (controller == null) {
            TrafficLightPopup.$$$reportNull$$$0(12);
        }
        if (prefix == null) {
            TrafficLightPopup.$$$reportNull$$$0(13);
        }
        return new DropDownLink<InspectionsLevel>(level.getLevel(), controller.getAvailableLevels(), inspectionsLevel -> {
            controller.setHighLightLevel(new LanguageHighlightLevel(level.getLangID(), (InspectionsLevel)inspectionsLevel));
            InspectionWidgetUsageCollector.logHighlightLevelChangedFromPopup(this.myEditor.getProject(), Language.findLanguageByID((String)level.getLangID()), inspectionsLevel);
            this.myContent.revalidate();
            Dimension size2 = this.myContent.getPreferredSize();
            size2.width = Math.max(size2.width, JBUIScale.scale((int)296));
            this.myPopup.setSize(size2);
        }, true){

            @NotNull
            protected String itemToString(@NotNull InspectionsLevel item) {
                if (item == null) {
                    5.$$$reportNull$$$0(0);
                }
                String string = prefix + String.valueOf(item);
                if (string == null) {
                    5.$$$reportNull$$$0(1);
                }
                return string;
            }

            @NotNull
            public ListCellRenderer<? super InspectionsLevel> createRenderer() {
                ListCellRenderer listCellRenderer = BuilderKt.textListCellRenderer(level -> level.toString());
                if (listCellRenderer == null) {
                    5.$$$reportNull$$$0(2);
                }
                return listCellRenderer;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "item";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/editor/impl/TrafficLightPopup$5";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/editor/impl/TrafficLightPopup$5";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "itemToString";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createRenderer";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "itemToString";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 2 -> new IllegalStateException(string);
                };
            }
        };
    }

    @NotNull
    private static JLabel createNoChangeLabel(@NotNull LanguageHighlightLevel level, @NotNull @Nls String prefix, @NotNull @Nls String msg) {
        if (level == null) {
            TrafficLightPopup.$$$reportNull$$$0(14);
        }
        if (prefix == null) {
            TrafficLightPopup.$$$reportNull$$$0(15);
        }
        if (msg == null) {
            TrafficLightPopup.$$$reportNull$$$0(16);
        }
        JLabel label2 = new JLabel(prefix + String.valueOf(level.getLevel()));
        new HelpTooltip().setDescription(msg).installOn((JComponent)label2);
        JLabel jLabel = label2;
        if (jLabel == null) {
            TrafficLightPopup.$$$reportNull$$$0(17);
        }
        return jLabel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compactViewAction";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "analyzerStatus";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 10: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/TrafficLightPopup";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "msg";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/TrafficLightPopup";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createLowerPanel";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createNoChangeLabel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "scheduleShow";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "showPopup";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updateContentPanel";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateVisiblePopup";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createDetailsPanel";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createLowerPanel";
                break;
            }
            case 10: 
            case 17: {
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createDropDownLink";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createNoChangeLabel";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 17 -> new IllegalStateException(string);
        };
    }

    private static final class MenuAction
    extends DefaultActionGroup
    implements HintManagerImpl.ActionToIgnore {
        private MenuAction(@NotNull List<? extends AnAction> actions, @NotNull AnAction compactViewAction) {
            if (actions == null) {
                MenuAction.$$$reportNull$$$0(0);
            }
            if (compactViewAction == null) {
                MenuAction.$$$reportNull$$$0(1);
            }
            this.getTemplatePresentation().setPopupGroup(true);
            this.getTemplatePresentation().setIcon(AllIcons.Actions.More);
            this.getTemplatePresentation().putClientProperty(ActionUtil.HIDE_DROPDOWN_ICON, (Object)true);
            this.addAll(actions);
            this.add(compactViewAction);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "actions";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "compactViewAction";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/editor/impl/TrafficLightPopup$MenuAction";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class TrackableLinkLabel
    extends LinkLabel<Object> {
        private InputEvent myEvent;

        private TrackableLinkLabel(@NlsContexts.LinkLabel @NotNull String text2, @NotNull Runnable action2) {
            if (text2 == null) {
                TrackableLinkLabel.$$$reportNull$$$0(0);
            }
            if (action2 == null) {
                TrackableLinkLabel.$$$reportNull$$$0(1);
            }
            super(text2, null);
            this.setListener((__, ___) -> {
                action2.run();
                ActionsCollector.getInstance().record(null, this.myEvent, ((Object)((Object)this)).getClass());
            }, null);
        }

        public void doClick(InputEvent e) {
            this.myEvent = e;
            super.doClick(e);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "action";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/editor/impl/TrafficLightPopup$TrackableLinkLabel";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

