/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.fileEditor.impl.EditorTabbedContainer;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.fileEditor.impl.SplitterService;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.AbstractPainter;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.tabs.TabsUtil;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.NamedColorUtil;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.function.Function;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0018\u001a\u00020\u0005H\u0016J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0018\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0015\u0010 \u001a\u00070!\u00a2\u0006\u0002\b\"2\u0006\u0010#\u001a\u00020!H\u0002J\u000e\u0010$\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010%\u001a\u00020\u001aR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006&"}, d2={"Lcom/intellij/openapi/fileEditor/impl/MySplitPainter;", "Lcom/intellij/openapi/ui/AbstractPainter;", "project", "Lcom/intellij/openapi/project/Project;", "showInfoPanel", "", "tabbedPane", "Lcom/intellij/openapi/fileEditor/impl/EditorTabbedContainer;", "owner", "Lcom/intellij/openapi/fileEditor/impl/EditorsSplitters;", "<init>", "(Lcom/intellij/openapi/project/Project;ZLcom/intellij/openapi/fileEditor/impl/EditorTabbedContainer;Lcom/intellij/openapi/fileEditor/impl/EditorsSplitters;)V", "rectangle", "Ljava/awt/Shape;", "getRectangle", "()Ljava/awt/Shape;", "setRectangle", "(Ljava/awt/Shape;)V", "position", "Lcom/intellij/openapi/fileEditor/impl/EditorWindow$RelativePosition;", "getPosition", "()Lcom/intellij/openapi/fileEditor/impl/EditorWindow$RelativePosition;", "setPosition", "(Lcom/intellij/openapi/fileEditor/impl/EditorWindow$RelativePosition;)V", "needsRepaint", "executePaint", "", "component", "Ljava/awt/Component;", "g", "Ljava/awt/Graphics2D;", "drawInfoPanel", "getShortcut", "", "Lcom/intellij/openapi/util/NlsSafe;", "actionId", "positionChanged", "updateRectangleAndRepaint", "intellij.platform.ide.impl"})
final class MySplitPainter
extends AbstractPainter {
    @NotNull
    private final Project project;
    private boolean showInfoPanel;
    @NotNull
    private final EditorTabbedContainer tabbedPane;
    @NotNull
    private final EditorsSplitters owner;
    @Nullable
    private Shape rectangle;
    @NotNull
    private EditorWindow.RelativePosition position;

    public MySplitPainter(@NotNull Project project2, boolean showInfoPanel, @NotNull EditorTabbedContainer tabbedPane, @NotNull EditorsSplitters owner) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)tabbedPane, (String)"tabbedPane");
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        this.project = project2;
        this.showInfoPanel = showInfoPanel;
        this.tabbedPane = tabbedPane;
        this.owner = owner;
        this.rectangle = this.tabbedPane.getTabs().getDropArea();
        this.position = EditorWindow.RelativePosition.CENTER;
    }

    @Nullable
    public final Shape getRectangle() {
        return this.rectangle;
    }

    public final void setRectangle(@Nullable Shape shape) {
        this.rectangle = shape;
    }

    @NotNull
    public final EditorWindow.RelativePosition getPosition() {
        return this.position;
    }

    public final void setPosition(@NotNull EditorWindow.RelativePosition relativePosition) {
        Intrinsics.checkNotNullParameter((Object)((Object)relativePosition), (String)"<set-?>");
        this.position = relativePosition;
    }

    public boolean needsRepaint() {
        return this.rectangle != null;
    }

    public void executePaint(@NotNull Component component2, @NotNull Graphics2D g) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        if (this.rectangle == null) {
            return;
        }
        GraphicsUtil.setupAAPainting((Graphics)g);
        g.setColor(JBUI.CurrentTheme.DragAndDrop.Area.BACKGROUND);
        g.fill(this.rectangle);
        if (this.position == EditorWindow.RelativePosition.CENTER && this.showInfoPanel) {
            this.drawInfoPanel(component2, g);
        }
    }

    private final void drawInfoPanel(Component component2, Graphics2D g) {
        String string;
        Object[] objectArray;
        Shape shape = this.rectangle;
        Intrinsics.checkNotNull((Object)shape);
        Shape rectangle = shape;
        int centerX = rectangle.getBounds().x + rectangle.getBounds().width / 2;
        int centerY = rectangle.getBounds().y + rectangle.getBounds().height / 2;
        int height = Registry.Companion.intValue("ide.splitter.chooser.info.panel.height");
        int width = Registry.Companion.intValue("ide.splitter.chooser.info.panel.width");
        int arc = Registry.Companion.intValue("ide.splitter.chooser.info.panel.arc");
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = this.getShortcut("SplitChooser.Split");
        if (SplitterService.Companion.getInstance(this.project).getInitialEditorWindow() != null) {
            objectArray = new Object[]{this.getShortcut("SplitChooser.Duplicate")};
            string = IdeBundle.message((String)"split.with.chooser.duplicate.tab", (Object[])objectArray);
        } else {
            string = "";
        }
        objectArray2[1] = string;
        String string2 = IdeBundle.message((String)"split.with.chooser.move.tab", (Object[])objectArray2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        String openShortcuts = string2;
        objectArray = new Object[]{this.getShortcut("SplitChooser.NextWindow")};
        String string3 = IdeBundle.message((String)"split.with.chooser.switch.tab", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        String switchShortcuts = string3;
        Font font = StartupUiUtil.getLabelFont();
        FontMetrics fontMetrics = g.getFontMetrics(font);
        int openShortcutsWidth = fontMetrics.stringWidth(openShortcuts);
        int switchShortcutsWidth = fontMetrics.stringWidth(switchShortcuts);
        width = RangesKt.coerceAtLeast((int)width, (int)MathKt.roundToInt((float)((float)RangesKt.coerceAtLeast((int)openShortcutsWidth, (int)switchShortcutsWidth) * 1.2f)));
        if ((float)rectangle.getBounds().height < (float)height * 1.2f || (float)rectangle.getBounds().width < (float)width * 1.2f) {
            return;
        }
        RoundRectangle2D.Double shape2 = new RoundRectangle2D.Double((double)centerX - (double)width / 2.0, (double)centerY - (double)height / 2.0, width, height, arc, arc);
        g.setColor(UIUtil.getLabelBackground());
        g.fill(shape2);
        int arrowCenterVShift = Registry.Companion.intValue("ide.splitter.chooser.info.panel.arrows.shift.center");
        int arrowsVShift = Registry.Companion.intValue("ide.splitter.chooser.info.panel.arrows.shift.vertical");
        int arrowsHShift = Registry.Companion.intValue("ide.splitter.chooser.info.panel.arrows.shift.horizontal");
        Function<Icon, Point> function = arg_0 -> MySplitPainter.drawInfoPanel$lambda$0(centerX, centerY, arrowCenterVShift, arg_0);
        Point point = function.apply(AllIcons.Chooser.Top);
        Intrinsics.checkNotNullExpressionValue((Object)point, (String)"apply(...)");
        Point forUpDownIcons = point;
        AllIcons.Chooser.Top.paintIcon(component2, g, forUpDownIcons.x, forUpDownIcons.y - arrowsVShift);
        AllIcons.Chooser.Bottom.paintIcon(component2, g, forUpDownIcons.x, forUpDownIcons.y + arrowsVShift);
        Point point2 = function.apply(AllIcons.Chooser.Right);
        Intrinsics.checkNotNullExpressionValue((Object)point2, (String)"apply(...)");
        Point forLeftRightIcons = point2;
        AllIcons.Chooser.Right.paintIcon(component2, g, forLeftRightIcons.x + arrowsHShift, forLeftRightIcons.y);
        AllIcons.Chooser.Left.paintIcon(component2, g, forLeftRightIcons.x - arrowsHShift, forLeftRightIcons.y);
        int textVShift = Registry.Companion.intValue("ide.splitter.chooser.info.panel.text.shift");
        int textY = forUpDownIcons.y + AllIcons.Chooser.Bottom.getIconHeight() + textVShift;
        g.setColor(NamedColorUtil.getInactiveTextColor());
        g.setFont(font);
        g.drawString(openShortcuts, centerX - openShortcutsWidth / 2, textY);
        if (SequencesKt.count(this.owner.windows()) > 1) {
            g.drawString(switchShortcuts, centerX - switchShortcutsWidth / 2, textY + fontMetrics.getHeight());
        }
    }

    private final String getShortcut(String actionId) {
        KeyboardShortcut shortcut;
        KeyboardShortcut keyboardShortcut = shortcut = ActionManager.getInstance().getKeyboardShortcut(actionId);
        String string = KeymapUtil.getKeystrokeText((KeyStroke)(keyboardShortcut != null ? keyboardShortcut.getFirstKeyStroke() : null));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getKeystrokeText(...)");
        return string;
    }

    public final void positionChanged(@NotNull EditorWindow.RelativePosition position2) {
        Intrinsics.checkNotNullParameter((Object)((Object)position2), (String)"position");
        if (this.position == position2) {
            return;
        }
        this.showInfoPanel = false;
        this.position = position2;
        this.updateRectangleAndRepaint();
    }

    public final void updateRectangleAndRepaint() {
        this.rectangle = null;
        this.setNeedsRepaint(true);
        Rectangle rectangle = this.tabbedPane.getTabs().getDropArea();
        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getDropArea(...)");
        Rectangle r = rectangle;
        TabsUtil.updateBoundsWithDropSide((Rectangle)r, (int)this.position.swingConstant);
        this.rectangle = new Rectangle2D.Double(r.x, r.y, r.width, r.height);
    }

    private static final Point drawInfoPanel$lambda$0(int $centerX, int $centerY, int $arrowCenterVShift, Icon icon2) {
        Intrinsics.checkNotNullParameter((Object)icon2, (String)"icon");
        return new Point($centerX - icon2.getIconWidth() / 2, $centerY - icon2.getIconHeight() / 2 + $arrowCenterVShift);
    }
}

