/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl.tabActions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.fileEditor.impl.EditorComposite;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.tabActions.CloseTabKt;
import com.intellij.openapi.fileEditor.impl.tabActions.DotIcon;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.ui.ShadowAction;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.TextWithMnemonic;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.BadgeDotProvider;
import com.intellij.ui.BadgeIcon;
import com.intellij.ui.BadgeShapeProvider;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.tabs.impl.JBEditorTabs;
import com.intellij.ui.tabs.impl.MorePopupAware;
import com.intellij.ui.tabs.impl.TabLabel;
import com.intellij.util.BitUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0014H\u0002J\b\u0010\u0016\u001a\u00020\u0014H\u0002J\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/openapi/fileEditor/impl/tabActions/CloseTab;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/project/DumbAware;", "component", "Ljavax/swing/JComponent;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "editorWindow", "Lcom/intellij/openapi/fileEditor/impl/EditorWindow;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Ljavax/swing/JComponent;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/fileEditor/impl/EditorWindow;Lcom/intellij/openapi/Disposable;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "isPinned", "", "isModified", "isCloseActionRestricted", "actionPerformed", "getIcon", "Ljavax/swing/Icon;", "isHovered", "intellij.platform.ide.impl"})
public final class CloseTab
extends AnAction
implements DumbAware {
    @NotNull
    private final VirtualFile file;
    @NotNull
    private final EditorWindow editorWindow;

    public CloseTab(@NotNull JComponent component2, @NotNull VirtualFile file2, @NotNull EditorWindow editorWindow, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editorWindow, (String)"editorWindow");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.file = file2;
        this.editorWindow = editorWindow;
        new ShadowAction((AnAction)this, "CloseContent", component2, parentDisposable);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        boolean pinned = this.isPinned();
        boolean modified = this.isModified();
        e.getPresentation().putClientProperty(JBEditorTabs.MARK_MODIFIED_KEY, (Object)modified);
        e.getPresentation().setVisible(UISettings.Companion.getInstance().getShowCloseButton() || pinned || ExperimentalUI.Companion.isNewUI() && modified);
        e.getPresentation().setIcon(this.getIcon(false));
        e.getPresentation().setHoveredIcon(this.getIcon(true));
        if (pinned && !Registry.Companion.get("ide.editor.tabs.interactive.pin.button").asBoolean() || this.isCloseActionRestricted()) {
            e.getPresentation().setText("");
            this.setShortcutSet((ShortcutSet)CustomShortcutSet.EMPTY);
        } else if (pinned) {
            this.setShortcutSet((ShortcutSet)CustomShortcutSet.EMPTY);
            e.getPresentation().setText(TextWithMnemonic.parse((String)IdeBundle.message((String)"action.unpin.tab", (Object[])new Object[0])).dropMnemonic(true).getText());
        } else {
            this.setShortcutSet(KeymapUtil.getActiveKeymapShortcuts((String)"CloseContent"));
            Object[] objectArray = new Object[]{SystemInfo.isMac ? "\u2325" : "Alt+"};
            e.getPresentation().setText(IdeBundle.messagePointer((String)"action.presentation.EditorTabbedContainer.text", (Object[])objectArray));
        }
    }

    private final boolean isPinned() {
        return this.editorWindow.isFilePinned(this.file);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isModified() {
        if (!UISettings.Companion.getInstance().getMarkModifiedTabsWithAsterisk()) return false;
        EditorComposite editorComposite = this.editorWindow.getComposite(this.file);
        if (editorComposite == null) return false;
        if (!editorComposite.isModified()) return false;
        return true;
    }

    private final boolean isCloseActionRestricted() {
        return ExperimentalUI.Companion.isNewUI() && !UISettings.Companion.getInstance().getShowCloseButton() && !this.isPinned() && this.isModified();
    }

    /*
     * Unable to fully structure code
     */
    public void actionPerformed(@NotNull AnActionEvent e) {
        block8: {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (this.isCloseActionRestricted()) {
                return;
            }
            if (this.isPinned() && Intrinsics.areEqual((Object)e.getPlace(), (Object)"EditorTab")) {
                if (Registry.Companion.is("ide.editor.tabs.interactive.pin.button")) {
                    this.editorWindow.setFilePinned(this.file, false);
                    v0 = e.getInputEvent();
                    v1 = (TabLabel)ComponentUtil.getParentOfType(TabLabel.class, (Component)(v0 != null ? v0.getComponent() : null));
                    if (v1 != null) {
                        v1.updateTabActions();
                    }
                }
                return;
            }
            fileEditorManager = this.editorWindow.getManager();
            v2 = window = Intrinsics.areEqual((Object)"EditorTab", (Object)e.getPlace()) != false ? this.editorWindow : fileEditorManager.getCurrentWindow();
            if (window == null) break block8;
            if (!(e.getInputEvent() instanceof MouseEvent)) ** GOTO lbl-1000
            v3 = e.getInputEvent();
            Intrinsics.checkNotNull((Object)v3);
            if (BitUtil.isSet((int)v3.getModifiersEx(), (int)512)) {
                window.closeAllExcept(this.file);
            } else lbl-1000:
            // 2 sources

            {
                fileEditorManager.closeFile(this.file, window);
            }
        }
        v4 = this.editorWindow.getTabbedPane().getTabs();
        Intrinsics.checkNotNull((Object)v4, (String)"null cannot be cast to non-null type com.intellij.ui.tabs.impl.MorePopupAware");
        it = (MorePopupAware)v4;
        $i$a$-let-CloseTab$actionPerformed$1 = false;
        v5 = e.getInputEvent();
        popup = PopupUtil.getPopupContainerFor((Component)(v5 != null ? v5.getComponent() : null));
        if (popup != null) {
            popup.cancel();
            if (it.canShowMorePopup()) {
                it.showMorePopup();
            }
        }
    }

    @NotNull
    public final Icon getIcon(boolean isHovered) {
        Icon icon2;
        boolean pinned = this.isPinned();
        if (!ExperimentalUI.Companion.isNewUI()) {
            if (pinned) {
                Icon icon3 = AllIcons.Actions.PinTab;
                icon2 = icon3;
                Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"PinTab");
            } else {
                icon2 = isHovered ? CloseTabKt.access$getCLOSE_HOVERED_ICON() : CloseTabKt.access$getCLOSE_ICON();
            }
        } else if (isHovered && !pinned && UISettings.Companion.getInstance().getShowCloseButton()) {
            icon2 = CloseTabKt.access$getCLOSE_HOVERED_ICON();
        } else {
            boolean showModifiedIcon = this.isModified();
            if (showModifiedIcon) {
                if (pinned) {
                    Icon icon4 = AllIcons.Actions.PinTab;
                    Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"PinTab");
                    Icon pinIcon = icon4;
                    BadgeDotProvider provider = new BadgeDotProvider(0.7, 0.2, 3.0 / (double)pinIcon.getIconWidth(), 0.0, 8, null);
                    Color color = JBUI.CurrentTheme.IconBadge.INFORMATION;
                    Intrinsics.checkNotNullExpressionValue((Object)color, (String)"INFORMATION");
                    icon2 = (Icon)new BadgeIcon(pinIcon, (Paint)color, (BadgeShapeProvider)provider);
                } else {
                    Color color = JBUI.CurrentTheme.IconBadge.INFORMATION;
                    Intrinsics.checkNotNullExpressionValue((Object)color, (String)"INFORMATION");
                    icon2 = new DotIcon(color);
                }
            } else if (pinned) {
                Icon icon5 = AllIcons.Actions.PinTab;
                icon2 = icon5;
                Intrinsics.checkNotNullExpressionValue((Object)icon5, (String)"PinTab");
            } else {
                icon2 = CloseTabKt.access$getCLOSE_ICON();
            }
        }
        return icon2;
    }
}

