/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.newEditor.settings;

import com.intellij.CommonBundle;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerKeys;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerBase;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ex.ConfigurableExtensionPointUtil;
import com.intellij.openapi.options.ex.ConfigurableVisitor;
import com.intellij.openapi.options.newEditor.AbstractEditor;
import com.intellij.openapi.options.newEditor.OptionsEditorColleague;
import com.intellij.openapi.options.newEditor.SettingsDialog;
import com.intellij.openapi.options.newEditor.SettingsDialogListener;
import com.intellij.openapi.options.newEditor.SettingsEditor;
import com.intellij.openapi.options.newEditor.settings.SettingsFileSystem;
import com.intellij.openapi.options.newEditor.settings.SettingsVirtualFileHolderKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.UiUtils;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.ApplicationKt;
import com.intellij.util.concurrency.SynchronizedClearableLazy;
import com.intellij.util.messages.MessageBusConnection;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0001\u0018\u0000 \u00142\u00020\u0001:\u0003\u0014\u0015\u0016B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\t\u001a\u0004\u0018\u00010\bJ&\u0010\n\u001a\u00020\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0086@\u00a2\u0006\u0002\u0010\u0010J\u000f\u0010\u0011\u001a\u0004\u0018\u00010\bH\u0000\u00a2\u0006\u0002\b\u0012J\b\u0010\u0013\u001a\u0004\u0018\u00010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/openapi/options/newEditor/settings/SettingsVirtualFileHolder;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "settingsFileRef", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/openapi/options/newEditor/settings/SettingsVirtualFileHolder$SettingsVirtualFile;", "getIfExists", "getOrCreate", "toSelect", "Lcom/intellij/openapi/options/Configurable;", "initializer", "Lkotlin/Function0;", "Lcom/intellij/openapi/options/newEditor/SettingsDialog;", "(Lcom/intellij/openapi/options/Configurable;Lkotlin/jvm/functions/Function0;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getVirtualFileIfExists", "getVirtualFileIfExists$intellij_platform_ide_impl", "invalidate", "Companion", "SettingsVirtualFile", "SettingsFileType", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class SettingsVirtualFileHolder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final AtomicReference<SettingsVirtualFile> settingsFileRef;

    private SettingsVirtualFileHolder(Project project2) {
        this.project = project2;
        this.settingsFileRef = new AtomicReference<Object>(null);
    }

    @Nullable
    public final SettingsVirtualFile getIfExists() {
        return this.settingsFileRef.get();
    }

    @Nullable
    public final Object getOrCreate(@Nullable Configurable toSelect, @NotNull Function0<? extends SettingsDialog> initializer, @NotNull Continuation<? super SettingsVirtualFile> $completion) {
        return BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super SettingsVirtualFile>, Object>(this, toSelect, initializer, null){
            int label;
            final /* synthetic */ SettingsVirtualFileHolder this$0;
            final /* synthetic */ Configurable $toSelect;
            final /* synthetic */ Function0<SettingsDialog> $initializer;
            {
                this.this$0 = $receiver;
                this.$toSelect = $toSelect;
                this.$initializer = $initializer;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        SettingsVirtualFile settingsVirtualFile = (SettingsVirtualFile)SettingsVirtualFileHolder.access$getSettingsFileRef$p(this.this$0).get();
                        if (settingsVirtualFile != null) {
                            SettingsDialog dialogIfCreated = settingsVirtualFile.getIfCreated();
                            if (dialogIfCreated != null) {
                                if (this.$toSelect != null) {
                                    AbstractEditor abstractEditor = dialogIfCreated.getEditor();
                                    SettingsEditor settingsEditor = abstractEditor instanceof SettingsEditor ? (SettingsEditor)abstractEditor : null;
                                    if (settingsEditor != null) {
                                        settingsEditor.select(this.$toSelect);
                                    }
                                }
                            } else {
                                settingsVirtualFile.setInitializer$intellij_platform_ide_impl(this.$initializer);
                            }
                            return settingsVirtualFile;
                        }
                        SettingsVirtualFile newVirtualFile = new SettingsVirtualFile(SettingsVirtualFileHolder.access$getProject$p(this.this$0), this.$initializer);
                        SettingsVirtualFileHolder.access$getSettingsFileRef$p(this.this$0).compareAndSet(null, newVirtualFile);
                        return newVirtualFile;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super SettingsVirtualFile> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    @Nullable
    public final SettingsVirtualFile getVirtualFileIfExists$intellij_platform_ide_impl() {
        return this.settingsFileRef.get();
    }

    @Nullable
    public final SettingsVirtualFile invalidate() {
        return this.settingsFileRef.getAndSet(null);
    }

    @JvmStatic
    @NotNull
    public static final SettingsVirtualFileHolder getInstance(@NotNull Project project2) {
        return Companion.getInstance(project2);
    }

    public static final /* synthetic */ AtomicReference access$getSettingsFileRef$p(SettingsVirtualFileHolder $this) {
        return $this.settingsFileRef;
    }

    public static final /* synthetic */ Project access$getProject$p(SettingsVirtualFileHolder $this) {
        return $this.project;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\t"}, d2={"Lcom/intellij/openapi/options/newEditor/settings/SettingsVirtualFileHolder$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/openapi/options/newEditor/settings/SettingsVirtualFileHolder;", "project", "Lcom/intellij/openapi/project/Project;", "getInstanceIfExists", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final SettingsVirtualFileHolder getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Object object = project2.getService(SettingsVirtualFileHolder.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (SettingsVirtualFileHolder)object;
        }

        @Nullable
        public final SettingsVirtualFileHolder getInstanceIfExists(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            return (SettingsVirtualFileHolder)project2.getServiceIfCreated(SettingsVirtualFileHolder.class);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006H\u0016J\r\u0010\u0007\u001a\u00070\u0005\u00a2\u0006\u0002\b\bH\u0016J\b\u0010\t\u001a\u00020\u0005H\u0016J\r\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/intellij/openapi/options/newEditor/settings/SettingsVirtualFileHolder$SettingsFileType;", "Lcom/intellij/openapi/fileTypes/FileType;", "<init>", "()V", "getName", "", "Lorg/jetbrains/annotations/NonNls;", "getDescription", "Lcom/intellij/openapi/util/NlsContexts$Label;", "getDefaultExtension", "getIcon", "Ljavax/swing/Icon;", "Lorg/jetbrains/annotations/NotNull;", "isBinary", "", "isReadOnly", "intellij.platform.ide.impl"})
    private static final class SettingsFileType
    implements FileType {
        @NotNull
        public static final SettingsFileType INSTANCE = new SettingsFileType();

        private SettingsFileType() {
        }

        @NotNull
        public String getName() {
            return "settingsType";
        }

        @NotNull
        public String getDescription() {
            return "SettingsFile";
        }

        @NotNull
        public String getDefaultExtension() {
            return "";
        }

        @NotNull
        public Icon getIcon() {
            Icon icon2 = AllIcons.General.Settings;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Settings");
            return icon2;
        }

        public boolean isBinary() {
            return true;
        }

        public boolean isReadOnly() {
            return true;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\r\u0010\u0014\u001a\u00070\u0015\u00a2\u0006\u0002\b\u0016H\u0016J\u001a\u0010\u0017\u001a\u0014 \u0019*\t\u0018\u00010\u0015\u00a2\u0006\u0002\b\u00180\u0015\u00a2\u0006\u0002\b\u0018H\u0016J\u0006\u0010\u001a\u001a\u00020\u0007J\b\u0010\u001b\u001a\u0004\u0018\u00010\u0007J\u0006\u0010\u001c\u001a\u00020\u001dJ\u0010\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u001f\u001a\u00020\u001dH\u0016J\b\u0010 \u001a\u00020\u001dH\u0016J\b\u0010!\u001a\u00020\"H\u0016J\u0006\u0010#\u001a\u00020$J\b\u0010%\u001a\u0004\u0018\u00010\u0015J\u0010\u0010&\u001a\u00020$2\b\u0010'\u001a\u0004\u0018\u00010\u0015R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR \u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/intellij/openapi/options/newEditor/settings/SettingsVirtualFileHolder$SettingsVirtualFile;", "Lcom/intellij/testFramework/LightVirtualFile;", "Lcom/intellij/openapi/fileEditor/impl/EditorHistoryManager$OptionallyIncluded;", "project", "Lcom/intellij/openapi/project/Project;", "initializer", "Lkotlin/Function0;", "Lcom/intellij/openapi/options/newEditor/SettingsDialog;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlin/jvm/functions/Function0;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getInitializer$intellij_platform_ide_impl", "()Lkotlin/jvm/functions/Function0;", "setInitializer$intellij_platform_ide_impl", "(Lkotlin/jvm/functions/Function0;)V", "wasModified", "Ljava/util/concurrent/atomic/AtomicBoolean;", "dialogLazy", "Lcom/intellij/util/concurrency/SynchronizedClearableLazy;", "getPresentableUrl", "", "Lcom/intellij/openapi/util/NlsSafe;", "getPresentableName", "Lcom/intellij/openapi/util/NlsContexts$DialogTitle;", "kotlin.jvm.PlatformType", "getOrCreateDialog", "getIfCreated", "isModified", "", "isIncludedInEditorHistory", "isPersistedInEditorHistory", "shouldSkipEventSystem", "getFileSystem", "Lcom/intellij/openapi/vfs/VirtualFileSystem;", "disposeDialog", "", "getConfigurableId", "setConfigurableId", "configurableId", "intellij.platform.ide.impl"})
    @SourceDebugExtension(value={"SMAP\nSettingsVirtualFileHolder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SettingsVirtualFileHolder.kt\ncom/intellij/openapi/options/newEditor/settings/SettingsVirtualFileHolder$SettingsVirtualFile\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,290:1\n1#2:291\n*E\n"})
    public static final class SettingsVirtualFile
    extends LightVirtualFile
    implements EditorHistoryManager.OptionallyIncluded {
        @NotNull
        private final Project project;
        @NotNull
        private Function0<? extends SettingsDialog> initializer;
        @NotNull
        private final AtomicBoolean wasModified;
        @NotNull
        private final SynchronizedClearableLazy<SettingsDialog> dialogLazy;

        public SettingsVirtualFile(@NotNull Project project2, @NotNull Function0<? extends SettingsDialog> initializer) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter(initializer, (String)"initializer");
            super(SettingsVirtualFileHolderKt.access$settingsFileName(project2), (FileType)SettingsFileType.INSTANCE, (CharSequence)"");
            this.project = project2;
            this.initializer = initializer;
            this.wasModified = new AtomicBoolean();
            this.dialogLazy = new SynchronizedClearableLazy(() -> SettingsVirtualFile.dialogLazy$lambda$0(this));
            this.putUserData(FileEditorManagerKeys.FORBID_TAB_SPLIT, true);
            this.putUserData(FileDocumentManagerBase.TRACK_NON_PHYSICAL, true);
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @NotNull
        public final Function0<SettingsDialog> getInitializer$intellij_platform_ide_impl() {
            return this.initializer;
        }

        public final void setInitializer$intellij_platform_ide_impl(@NotNull Function0<? extends SettingsDialog> function0) {
            Intrinsics.checkNotNullParameter(function0, (String)"<set-?>");
            this.initializer = function0;
        }

        @NotNull
        public String getPresentableUrl() {
            return "settings://" + CommonBundle.settingsTitle();
        }

        public String getPresentableName() {
            return CommonBundle.settingsTitle();
        }

        @NotNull
        public final SettingsDialog getOrCreateDialog() {
            return (SettingsDialog)((Object)this.dialogLazy.getValue());
        }

        @Nullable
        public final SettingsDialog getIfCreated() {
            return (SettingsDialog)((Object)this.dialogLazy.getValueIfInitialized());
        }

        public final boolean isModified() {
            SettingsDialog settingsDialog = (SettingsDialog)((Object)this.dialogLazy.getValueIfInitialized());
            if (settingsDialog == null) {
                return false;
            }
            SettingsDialog dialog2 = settingsDialog;
            AbstractEditor abstractEditor = dialog2.getEditor();
            SettingsEditor settingsEditor = abstractEditor instanceof SettingsEditor ? (SettingsEditor)abstractEditor : null;
            if (settingsEditor == null) {
                return false;
            }
            SettingsEditor settingsEditor2 = settingsEditor;
            return settingsEditor2.isModified();
        }

        @Override
        public boolean isIncludedInEditorHistory(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            return true;
        }

        @Override
        public boolean isPersistedInEditorHistory() {
            return false;
        }

        public boolean shouldSkipEventSystem() {
            return true;
        }

        @NotNull
        public VirtualFileSystem getFileSystem() {
            VirtualFileSystem virtualFileSystem;
            SettingsFileSystem settingsFileSystem = SettingsFileSystem.Companion.getInstance();
            if (settingsFileSystem != null) {
                virtualFileSystem = (VirtualFileSystem)settingsFileSystem;
            } else {
                VirtualFileSystem virtualFileSystem2 = super.getFileSystem();
                virtualFileSystem = virtualFileSystem2;
                Intrinsics.checkNotNullExpressionValue((Object)virtualFileSystem2, (String)"getFileSystem(...)");
            }
            return virtualFileSystem;
        }

        public final void disposeDialog() {
            SettingsDialog settingsDialog = (SettingsDialog)((Object)this.dialogLazy.getValueIfInitialized());
            if (settingsDialog != null) {
                SettingsDialog settingsDialog2;
                SettingsDialog $this$disposeDialog_u24lambda_u240 = settingsDialog2 = settingsDialog;
                boolean bl = false;
                Disposer.dispose((Disposable)$this$disposeDialog_u24lambda_u240.getDisposable());
            }
            this.dialogLazy.drop();
        }

        @Nullable
        public final String getConfigurableId() {
            SettingsDialog settingsDialog = (SettingsDialog)((Object)this.dialogLazy.getValueIfInitialized());
            if (settingsDialog == null) {
                return null;
            }
            SettingsDialog dialog2 = settingsDialog;
            AbstractEditor abstractEditor = dialog2.getEditor();
            SettingsEditor settingsEditor = abstractEditor instanceof SettingsEditor ? (SettingsEditor)abstractEditor : null;
            if (settingsEditor == null) {
                return null;
            }
            SettingsEditor settingsEditor2 = settingsEditor;
            return settingsEditor2.getSelectedConfigurableId();
        }

        public final void setConfigurableId(@Nullable String configurableId) {
            if (configurableId == null) {
                return;
            }
            SettingsDialog settingsDialog = (SettingsDialog)((Object)this.dialogLazy.getValueIfInitialized());
            if (settingsDialog == null) {
                return;
            }
            SettingsDialog dialog2 = settingsDialog;
            AbstractEditor abstractEditor = dialog2.getEditor();
            SettingsEditor settingsEditor = abstractEditor instanceof SettingsEditor ? (SettingsEditor)abstractEditor : null;
            if (settingsEditor == null) {
                return;
            }
            SettingsEditor settingsEditor2 = settingsEditor;
            AbstractEditor it = abstractEditor = ConfigurableExtensionPointUtil.getConfigurableGroup(this.project, true);
            boolean bl = false;
            Configurable[] configurableArray = it.getConfigurables();
            Intrinsics.checkNotNullExpressionValue((Object)configurableArray, (String)"getConfigurables(...)");
            AbstractEditor group2 = !(((Object[])configurableArray).length == 0) ? abstractEditor : null;
            Configurable configurable = ConfigurableVisitor.findById(configurableId, CollectionsKt.listOf((Object)group2));
            if (configurable == null) {
                return;
            }
            Configurable configurableToSelect = configurable;
            settingsEditor2.setNavigatingNow();
            settingsEditor2.select(configurableToSelect);
        }

        private static final void dialogLazy$lambda$0$0(SettingsVirtualFile this$0) {
            block0: {
                FileStatusManager manager2;
                FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this$0.project);
                Intrinsics.checkNotNull((Object)fileEditorManager, (String)"null cannot be cast to non-null type com.intellij.openapi.fileEditor.ex.FileEditorManagerEx");
                FileEditorManagerEx fileEditorManager2 = (FileEditorManagerEx)fileEditorManager;
                fileEditorManager2.closeFile((VirtualFile)this$0);
                this$0.wasModified.set(false);
                FileStatusManager fileStatusManager = manager2 = (FileStatusManager)this$0.project.getServiceIfCreated(FileStatusManager.class);
                if (fileStatusManager == null) break block0;
                fileStatusManager.fileStatusChanged((VirtualFile)this$0);
            }
        }

        private static final SettingsDialog dialogLazy$lambda$0(SettingsVirtualFile this$0) {
            SettingsDialog dialog2 = (SettingsDialog)((Object)this$0.initializer.invoke());
            Disposable disposable = () -> SettingsVirtualFile.dialogLazy$lambda$0$0(this$0);
            Disposer.register((Disposable)dialog2.getDisposable(), (Disposable)disposable);
            AbstractEditor abstractEditor = dialog2.getEditor();
            SettingsEditor settingsEditor = abstractEditor instanceof SettingsEditor ? (SettingsEditor)abstractEditor : null;
            if (settingsEditor == null) {
                return dialog2;
            }
            SettingsEditor settingsEditor2 = settingsEditor;
            settingsEditor2.addOptionsListener(new OptionsEditorColleague.Adapter(settingsEditor2, this$0){
                final /* synthetic */ SettingsEditor $settingsEditor;
                final /* synthetic */ SettingsVirtualFile this$0;
                {
                    this.$settingsEditor = $settingsEditor;
                    this.this$0 = $receiver;
                }

                public Promise<? super Object> onModifiedAdded(Configurable configurable) {
                    this.updateIsModified();
                    return Promises.resolvedPromise();
                }

                public Promise<? super Object> onModifiedRemoved(Configurable configurable) {
                    this.updateIsModified();
                    return Promises.resolvedPromise();
                }

                private final void updateIsModified() {
                    block1: {
                        FileStatusManager manager2;
                        boolean modified = this.$settingsEditor.isModified();
                        if (SettingsVirtualFile.access$getWasModified$p(this.this$0).get() == modified) break block1;
                        SettingsVirtualFile.access$getWasModified$p(this.this$0).set(modified);
                        FileStatusManager fileStatusManager = manager2 = (FileStatusManager)this.this$0.getProject().getServiceIfCreated(FileStatusManager.class);
                        if (fileStatusManager != null) {
                            fileStatusManager.fileStatusChanged((VirtualFile)this.this$0);
                        }
                    }
                }
            });
            MessageBusConnection connection = ApplicationKt.getApplication().getMessageBus().connect(disposable);
            connection.subscribe(SettingsDialogListener.TOPIC, (Object)new SettingsDialogListener(settingsEditor2, this$0){
                final /* synthetic */ SettingsEditor $settingsEditor;
                final /* synthetic */ SettingsVirtualFile this$0;
                {
                    this.$settingsEditor = $settingsEditor;
                    this.this$0 = $receiver;
                }

                public void afterApply(SettingsEditor editor2, Set<String> modifiedConfigurableIds) {
                    Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
                    Intrinsics.checkNotNullParameter(modifiedConfigurableIds, (String)"modifiedConfigurableIds");
                    if (!Intrinsics.areEqual((Object)editor2, (Object)this.$settingsEditor)) {
                        UiUtils.putUserData((JComponent)this.$settingsEditor, (Key)SettingsVirtualFileHolderKt.access$getKEY$p(), modifiedConfigurableIds);
                        EditorNotifications.getInstance((Project)this.this$0.getProject()).updateNotifications((VirtualFile)this.this$0);
                    }
                }
            });
            return dialog2;
        }

        public static final /* synthetic */ AtomicBoolean access$getWasModified$p(SettingsVirtualFile $this) {
            return $this.wasModified;
        }
    }
}

