/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project.impl.shared;

import com.dynatrace.hash4j.hashing.Hasher64;
import com.dynatrace.hash4j.hashing.Hashing;
import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.impl.shared.ConfigFilesUpdatedByThisProcessKt;
import com.intellij.openapi.project.impl.shared.SavedFileData;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0006J\u0006\u0010\u0014\u001a\u00020\u000fJ\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0006R3\u0010\u0004\u001a'\u0012\u000e\u0012\f0\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\b\u0012\u000e\u0012\f0\t\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\b0\u0005\u00a2\u0006\u0002\b\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R3\u0010\n\u001a'\u0012\u000e\u0012\f0\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\b\u0012\u000e\u0012\f0\t\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\b0\u0005\u00a2\u0006\u0002\b\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/openapi/project/impl/shared/ConfigFilesUpdatedByThisProcess;", "", "<init>", "()V", "savedFiles", "Ljava/util/concurrent/ConcurrentMap;", "", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "Lcom/intellij/openapi/project/impl/shared/SavedFileData;", "oldSavedFiles", "hasher64", "Lcom/dynatrace/hash4j/hashing/Hasher64;", "kotlin.jvm.PlatformType", "saved", "", "fileSpec", "content", "", "deleted", "cleanUpOldData", "wasWritten", "", "file", "Ljava/nio/file/Path;", "wasDeleted", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nConfigFilesUpdatedByThisProcess.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigFilesUpdatedByThisProcess.kt\ncom/intellij/openapi/project/impl/shared/ConfigFilesUpdatedByThisProcess\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,90:1\n67#2,4:91\n67#2,4:95\n*S KotlinDebug\n*F\n+ 1 ConfigFilesUpdatedByThisProcess.kt\ncom/intellij/openapi/project/impl/shared/ConfigFilesUpdatedByThisProcess\n*L\n63#1:91,4\n68#1:95,4\n*E\n"})
public final class ConfigFilesUpdatedByThisProcess {
    @NotNull
    private volatile ConcurrentMap<String, SavedFileData> savedFiles;
    @NotNull
    private volatile ConcurrentMap<String, SavedFileData> oldSavedFiles;
    private final Hasher64 hasher64;

    public ConfigFilesUpdatedByThisProcess() {
        ConcurrentMap concurrentMap = ConcurrentCollectionFactory.createConcurrentMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentMap(...)");
        this.savedFiles = concurrentMap;
        ConcurrentMap concurrentMap2 = ConcurrentCollectionFactory.createConcurrentMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap2, (String)"createConcurrentMap(...)");
        this.oldSavedFiles = concurrentMap2;
        this.hasher64 = Hashing.komihash5_0();
    }

    public final void saved(@NotNull String fileSpec, @NotNull byte[] content2) {
        Intrinsics.checkNotNullParameter((Object)fileSpec, (String)"fileSpec");
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        ((Map)this.savedFiles).put(fileSpec, new SavedFileData(this.hasher64.hashBytesToLong(content2), content2.length));
    }

    public final void deleted(@NotNull String fileSpec) {
        Intrinsics.checkNotNullParameter((Object)fileSpec, (String)"fileSpec");
        ((Map)this.savedFiles).put(fileSpec, ConfigFilesUpdatedByThisProcessKt.access$getDeletedData$p());
    }

    public final void cleanUpOldData() {
        if (!((Map)this.oldSavedFiles).isEmpty() || !((Map)this.savedFiles).isEmpty()) {
            ConfigFilesUpdatedByThisProcessKt.access$getLOG$p().trace("old data cleaned up");
            this.oldSavedFiles = this.savedFiles;
            ConcurrentMap concurrentMap = ConcurrentCollectionFactory.createConcurrentMap();
            Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentMap(...)");
            this.savedFiles = concurrentMap;
        }
    }

    public final boolean wasWritten(@NotNull String fileSpec, @NotNull Path file2) {
        Intrinsics.checkNotNullParameter((Object)fileSpec, (String)"fileSpec");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        SavedFileData savedFileData = (SavedFileData)this.savedFiles.get(fileSpec);
        if (savedFileData == null && (savedFileData = (SavedFileData)this.oldSavedFiles.get(fileSpec)) == null) {
            return false;
        }
        SavedFileData savedData = savedFileData;
        try {
            long actualSize = Files.size(file2);
            if ((long)savedData.getSize() != actualSize) {
                Logger $this$trace$iv = ConfigFilesUpdatedByThisProcessKt.access$getLOG$p();
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    Logger logger2 = $this$trace$iv;
                    boolean bl = false;
                    logger2.trace("file " + fileSpec + ": stored size " + savedData.getSize() + ", but actual size is " + actualSize);
                }
                return false;
            }
            byte[] byArray = Files.readAllBytes(file2);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
            long actualHash = this.hasher64.hashBytesToLong(byArray);
            if (savedData.getHash() != actualHash) {
                Logger $this$trace$iv = ConfigFilesUpdatedByThisProcessKt.access$getLOG$p();
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    Logger logger3 = $this$trace$iv;
                    boolean bl = false;
                    logger3.trace("file " + fileSpec + ": stored hash " + savedData.getHash() + ", but actual hash is " + actualHash);
                }
                return false;
            }
            return true;
        }
        catch (IOException e) {
            ConfigFilesUpdatedByThisProcessKt.access$getLOG$p().trace((Throwable)e);
            return false;
        }
    }

    public final boolean wasDeleted(@NotNull String fileSpec) {
        SavedFileData savedData;
        Intrinsics.checkNotNullParameter((Object)fileSpec, (String)"fileSpec");
        SavedFileData savedFileData = (SavedFileData)this.savedFiles.get(fileSpec);
        if (savedFileData == null) {
            savedFileData = (SavedFileData)this.oldSavedFiles.get(fileSpec);
        }
        return (savedData = savedFileData) == ConfigFilesUpdatedByThisProcessKt.access$getDeletedData$p();
    }
}

