/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.ex.lineNumber;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LineNumberConverter;
import com.intellij.openapi.editor.impl.RelativeLineHelper;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u001d\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010\u000bJ\u0015\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/intellij/openapi/ui/ex/lineNumber/RelativeLineNumberConverter;", "Lcom/intellij/openapi/editor/LineNumberConverter;", "<init>", "()V", "shouldRepaintOnCaretMovement", "", "convert", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "lineNumber", "(Lcom/intellij/openapi/editor/Editor;I)Ljava/lang/Integer;", "getMaxLineNumber", "(Lcom/intellij/openapi/editor/Editor;)Ljava/lang/Integer;", "intellij.platform.ide.impl"})
public final class RelativeLineNumberConverter
implements LineNumberConverter {
    @NotNull
    public static final RelativeLineNumberConverter INSTANCE = new RelativeLineNumberConverter();

    private RelativeLineNumberConverter() {
    }

    public boolean shouldRepaintOnCaretMovement() {
        return true;
    }

    @NotNull
    public Integer convert(@NotNull Editor editor2, int lineNumber) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        int caretLine = editor2.getCaretModel().getLogicalPosition().line;
        return Math.abs(RelativeLineHelper.INSTANCE.getRelativeLine(editor2, caretLine, lineNumber - 1));
    }

    @NotNull
    public Integer getMaxLineNumber(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        return editor2.getDocument().getLineCount();
    }
}

