/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.impl;

import com.intellij.diagnostic.LoadingState;
import com.intellij.ide.DataManager;
import com.intellij.ide.RemoteDesktopService;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.DialogWrapperDialog;
import com.intellij.openapi.ui.DialogWrapperPeer;
import com.intellij.openapi.ui.impl.DialogWrapperPeerImpl;
import com.intellij.openapi.ui.impl.ShadowBorderPainter;
import com.intellij.openapi.ui.popup.StackingPopupDispatcher;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.IdeGlassPaneEx;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.ShadowJava2DPainter;
import com.intellij.ui.components.JBLayeredPane;
import com.intellij.ui.jcef.HwFacadeJPanel;
import com.intellij.util.MathUtil;
import com.intellij.util.ui.EDT;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.lang.ref.WeakReference;
import java.util.concurrent.CompletableFuture;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class GlassPaneDialogWrapperPeer
extends DialogWrapperPeer {
    private static final Logger LOG = Logger.getInstance(GlassPaneDialogWrapperPeer.class);
    private final DialogWrapper myWrapper;
    private MyDialog myDialog;

    public GlassPaneDialogWrapperPeer(@Nullable Project project2, DialogWrapper wrapper2) throws GlasspanePeerUnavailableException {
        this.myWrapper = wrapper2;
        Window window = null;
        if (LoadingState.APP_STARTED.isOccurred()) {
            Window focusedWindow;
            WindowManagerEx windowManager;
            if (project2 == null) {
                project2 = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext());
            }
            if ((window = (windowManager = WindowManagerEx.getInstanceEx()).suggestParentWindow(project2)) == null && (focusedWindow = windowManager.getMostRecentFocusedWindow()) instanceof IdeFrameImpl) {
                window = focusedWindow;
            }
        }
        this.createDialog(window == null ? JOptionPane.getRootFrame() : window);
    }

    public GlassPaneDialogWrapperPeer(@NotNull DialogWrapper wrapper2) throws GlasspanePeerUnavailableException {
        if (wrapper2 == null) {
            GlassPaneDialogWrapperPeer.$$$reportNull$$$0(0);
        }
        this(null, wrapper2);
    }

    public GlassPaneDialogWrapperPeer(DialogWrapper wrapper2, @NotNull Component parent) throws GlasspanePeerUnavailableException {
        if (parent == null) {
            GlassPaneDialogWrapperPeer.$$$reportNull$$$0(1);
        }
        this.myWrapper = wrapper2;
        if (!parent.isShowing() && parent != JOptionPane.getRootFrame()) {
            throw new IllegalArgumentException("parent must be showing: " + String.valueOf(parent));
        }
        Window owner = ComponentUtil.getWindow((Component)parent);
        if (owner == null || UIUtil.isSimpleWindow((Window)owner)) {
            owner = JOptionPane.getRootFrame();
        }
        this.myDialog = this.createDialog(owner);
    }

    @ApiStatus.Internal
    public GlassPaneDialogWrapperPeer(@NotNull DialogWrapper wrapper2, @NotNull IdeGlassPaneEx glassPane) throws GlasspanePeerUnavailableException {
        if (wrapper2 == null) {
            GlassPaneDialogWrapperPeer.$$$reportNull$$$0(2);
        }
        if (glassPane == null) {
            GlassPaneDialogWrapperPeer.$$$reportNull$$$0(3);
        }
        this.myWrapper = wrapper2;
        this.myDialog = new MyDialog(glassPane, this.myWrapper);
    }

    @NotNull
    private MyDialog createDialog(@NotNull Window owner) throws GlasspanePeerUnavailableException {
        Component glassPane;
        Window active;
        if (owner == null) {
            GlassPaneDialogWrapperPeer.$$$reportNull$$$0(4);
        }
        if ((active = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow()) instanceof JDialog || !(owner instanceof IdeFrame)) {
            throw new GlasspanePeerUnavailableException();
        }
        if (owner instanceof JFrame) {
            glassPane = ((JFrame)owner).getGlassPane();
        } else if (owner instanceof JDialog) {
            glassPane = ((JDialog)owner).getGlassPane();
        } else {
            throw new IllegalStateException("Cannot find glass pane for " + owner.getClass().getName());
        }
        assert (glassPane instanceof IdeGlassPaneEx) : "GlassPane should be instance of IdeGlassPane!";
        return new MyDialog((IdeGlassPaneEx)((Object)glassPane), this.myWrapper);
    }

    public void setUndecorated(boolean undecorated) {
        LOG.assertTrue(undecorated, (Object)"Decorated dialogs are not supported!");
    }

    public void addMouseListener(MouseListener listener2) {
        throw new UnsupportedOperationException("Not implemented in " + ((Object)((Object)this)).getClass().getCanonicalName());
    }

    public void addMouseListener(MouseMotionListener listener2) {
        throw new UnsupportedOperationException("Not implemented in " + ((Object)((Object)this)).getClass().getCanonicalName());
    }

    public void addKeyListener(KeyListener listener2) {
        throw new UnsupportedOperationException("Not implemented in " + ((Object)((Object)this)).getClass().getCanonicalName());
    }

    public void toFront() {
        throw new UnsupportedOperationException("Not implemented in " + ((Object)((Object)this)).getClass().getCanonicalName());
    }

    public void toBack() {
        throw new UnsupportedOperationException("Not implemented in " + ((Object)((Object)this)).getClass().getCanonicalName());
    }

    public void dispose() {
        LOG.assertTrue(EventQueue.isDispatchThread(), (Object)"Access is allowed from event dispatch thread only");
        if (this.myDialog != null) {
            Disposer.dispose((Disposable)this.myDialog);
            this.myDialog = null;
        }
    }

    public Container getContentPane() {
        return this.myDialog.getContentPane();
    }

    public Window getOwner() {
        throw new UnsupportedOperationException("Not implemented in " + ((Object)((Object)this)).getClass().getCanonicalName());
    }

    public Window getWindow() {
        return null;
    }

    public JRootPane getRootPane() {
        if (this.myDialog == null) {
            return null;
        }
        return this.myDialog.getRootPane();
    }

    public Dimension getSize() {
        return this.myDialog.getSize();
    }

    public String getTitle() {
        return "";
    }

    public Dimension getPreferredSize() {
        return this.myDialog.getPreferredSize();
    }

    public void setModal(boolean modal) {
        LOG.assertTrue(modal, (Object)"Can't be non modal!");
    }

    public boolean isModal() {
        return true;
    }

    public boolean isVisible() {
        return this.myDialog != null && this.myDialog.isVisible();
    }

    public boolean isShowing() {
        return this.myDialog != null && this.myDialog.isShowing();
    }

    public void setSize(int width, int height) {
        this.myDialog.setSize(width, height);
    }

    public void setTitle(String title2) {
    }

    public boolean isResizable() {
        throw new UnsupportedOperationException("Not implemented in " + ((Object)((Object)this)).getClass().getCanonicalName());
    }

    public void setResizable(boolean resizable) {
        throw new UnsupportedOperationException("Not implemented in " + ((Object)((Object)this)).getClass().getCanonicalName());
    }

    @NotNull
    public Point getLocation() {
        Point point = this.myDialog.getLocation();
        if (point == null) {
            GlassPaneDialogWrapperPeer.$$$reportNull$$$0(5);
        }
        return point;
    }

    public void setLocation(@NotNull Point p) {
        if (p == null) {
            GlassPaneDialogWrapperPeer.$$$reportNull$$$0(6);
        }
        this.setLocation(p.x, p.y);
    }

    public void setLocation(int x, int y) {
        if (this.myDialog == null || !this.myDialog.isShowing()) {
            return;
        }
        Point _p = new Point(x, y);
        JRootPane pane2 = SwingUtilities.getRootPane(this.myDialog);
        SwingUtilities.convertPointFromScreen(_p, pane2);
        this.myDialog.setLocation(_p.x, _p.y);
    }

    public CompletableFuture<?> show() {
        LOG.assertTrue(EDT.isCurrentThreadEdt(), (Object)"Access is allowed from event dispatch thread only");
        this.hidePopupsIfNeeded();
        this.myDialog.setVisible(true);
        return CompletableFuture.completedFuture(null);
    }

    public void setContentPane(JComponent content2) {
        this.myDialog.setContentPane(content2);
    }

    public void centerInParent() {
        if (this.myDialog != null) {
            this.myDialog.center();
        }
    }

    public void validate() {
        if (this.myDialog != null) {
            this.myDialog.resetSizeCache();
            this.myDialog.invalidate();
        }
    }

    public void repaint() {
        if (this.myDialog != null) {
            this.myDialog.repaint();
        }
    }

    public void pack() {
    }

    public void setAppIcons() {
        throw new UnsupportedOperationException("Not implemented in " + ((Object)((Object)this)).getClass().getCanonicalName());
    }

    public boolean isHeadless() {
        return DialogWrapperPeerImpl.isHeadlessEnv();
    }

    public void setOnDeactivationAction(@NotNull Disposable disposable, @NotNull Runnable onDialogDeactivated) {
        if (disposable == null) {
            GlassPaneDialogWrapperPeer.$$$reportNull$$$0(7);
        }
        if (onDialogDeactivated == null) {
            GlassPaneDialogWrapperPeer.$$$reportNull$$$0(8);
        }
        throw new UnsupportedOperationException("Not implemented in " + ((Object)((Object)this)).getClass().getCanonicalName());
    }

    private void hidePopupsIfNeeded() {
        if (!SystemInfoRt.isMac) {
            return;
        }
        final StackingPopupDispatcher stackingPopupDispatcher = StackingPopupDispatcher.getInstance();
        stackingPopupDispatcher.hidePersistentPopups();
        Disposer.register((Disposable)this.myDialog, (Disposable)new Disposable(){

            public void dispose() {
                stackingPopupDispatcher.restorePersistentPopups();
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrapper";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "glassPane";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/ui/impl/GlassPaneDialogWrapperPeer";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onDialogDeactivated";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/ui/impl/GlassPaneDialogWrapperPeer";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createDialog";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setLocation";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setOnDeactivationAction";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }

    private static final class MyDialog
    extends HwFacadeJPanel
    implements Disposable,
    DialogWrapperDialog,
    UiDataProvider {
        private final WeakReference<DialogWrapper> myDialogWrapper;
        private final IdeGlassPaneEx myPane;
        private JComponent myContentPane;
        private MyRootPane myRootPane;
        private BufferedImage shadow;
        private int shadowWidth;
        private int shadowHeight;
        private final JLayeredPane myTransparentPane;
        private final Container myWrapperPane;
        private Component myPreviouslyFocusedComponent;
        private Dimension myCachedSize = null;

        private MyDialog(IdeGlassPaneEx pane2, DialogWrapper wrapper2) {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            Insets insets = ShadowJava2DPainter.Type.IDE.getInsets();
            this.setBorder(BorderFactory.createEmptyBorder(insets.top, insets.left, insets.bottom, insets.right));
            this.myPane = pane2;
            this.myDialogWrapper = new WeakReference<DialogWrapper>(wrapper2);
            this.myRootPane = new MyRootPane(this);
            Disposer.register((Disposable)this, (Disposable)this.myRootPane);
            this.myContentPane = new JPanel();
            this.myContentPane.setOpaque(true);
            this.add((Component)this.myContentPane, "Center");
            this.myTransparentPane = this.createTransparentPane();
            this.myWrapperPane = this.createWrapperPane();
            this.myWrapperPane.add(this);
            this.setFocusCycleRoot(true);
        }

        public void resetSizeCache() {
            this.myCachedSize = null;
        }

        private Container createWrapperPane() {
            JPanel result2 = new JPanel(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void doLayout() {
                    Object object = this.getTreeLock();
                    synchronized (object) {
                        Container container = this.getParent();
                        if (container != null) {
                            Component[] components = this.getComponents();
                            LOG.assertTrue(components.length == 1);
                            for (Component c : components) {
                                Point location;
                                if (myCachedSize == null) {
                                    myCachedSize = c.getPreferredSize();
                                    location = this.getLocationInCenter(myCachedSize, c.getLocation());
                                } else {
                                    location = c.getLocation();
                                }
                                double _width = myCachedSize.getWidth();
                                double _height = myCachedSize.getHeight();
                                DialogWrapper dialogWrapper = (DialogWrapper)myDialogWrapper.get();
                                if (dialogWrapper != null) {
                                    int width = (int)(_width * (double)dialogWrapper.getHorizontalStretch());
                                    int height = (int)(_height * (double)dialogWrapper.getVerticalStretch());
                                    c.setBounds((int)location.getX(), (int)location.getY(), width, height);
                                    continue;
                                }
                                c.setBounds((int)location.getX(), (int)location.getY(), (int)_width, (int)_height);
                            }
                        }
                    }
                    super.doLayout();
                }
            };
            result2.setLayout(null);
            result2.setOpaque(false);
            result2.addMouseListener(new MouseAdapter(this){});
            result2.addMouseMotionListener(new MouseMotionAdapter(this){});
            return result2;
        }

        private TransparentLayeredPane getExistingTransparentPane() {
            for (int i2 = 0; i2 < this.myPane.getComponentCount(); ++i2) {
                Component c = this.myPane.getComponent(i2);
                if (!(c instanceof TransparentLayeredPane)) continue;
                return (TransparentLayeredPane)((Object)c);
            }
            return null;
        }

        private boolean isTransparentPaneExist() {
            for (int i2 = 0; i2 < this.myPane.getComponentCount(); ++i2) {
                Component c = this.myPane.getComponent(i2);
                if (!(c instanceof TransparentLayeredPane)) continue;
                return true;
            }
            return false;
        }

        @Override
        public void setVisible(boolean show2) {
            if (show2) {
                if (!this.isTransparentPaneExist()) {
                    this.myPane.add(this.myTransparentPane);
                } else {
                    this.myPreviouslyFocusedComponent = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                }
                this.myTransparentPane.add(this.myWrapperPane);
                this.myTransparentPane.setLayer(this.myWrapperPane, this.myTransparentPane.getComponentCount() - 1);
                if (!this.myTransparentPane.isVisible()) {
                    this.myTransparentPane.setVisible(true);
                }
            }
            super.setVisible(show2);
            if (show2) {
                this.myTransparentPane.revalidate();
                this.myTransparentPane.repaint();
            } else {
                this.myTransparentPane.remove(this.myWrapperPane);
                this.myTransparentPane.revalidate();
                this.myTransparentPane.repaint();
                if (this.myPreviouslyFocusedComponent != null) {
                    Component component2 = this.myPreviouslyFocusedComponent;
                    IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(component2, true));
                    this.myPreviouslyFocusedComponent = null;
                }
                if (this.myTransparentPane.getComponentCount() == 0) {
                    this.myTransparentPane.setVisible(false);
                    this.myPane.remove(this.myTransparentPane);
                }
            }
        }

        @Override
        public void paint(Graphics g) {
            UISettings.setupAntialiasing((Graphics)g);
            super.paint(g);
        }

        private JLayeredPane createTransparentPane() {
            TransparentLayeredPane pane2 = this.getExistingTransparentPane();
            if (pane2 == null) {
                pane2 = new TransparentLayeredPane();
            }
            return pane2;
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            if (this.shadow != null) {
                UIUtil.drawImage((Graphics)g2, (Image)this.shadow, (int)0, (int)0, null);
            }
            super.paintComponent(g);
        }

        @Override
        public void setBounds(int x, int y, int width, int height) {
            JLayeredPane p = this.myTransparentPane;
            if (p != null) {
                Rectangle bounds = new Rectangle(((Component)p).getWidth() - width, ((Component)p).getHeight() - height);
                JBInsets.removeFrom((Rectangle)bounds, (Insets)this.getInsets());
                x = bounds.width < 0 ? bounds.width / 2 : MathUtil.clamp((int)x, (int)bounds.x, (int)(bounds.x + bounds.width));
                y = bounds.height < 0 ? bounds.height / 2 : MathUtil.clamp((int)y, (int)bounds.y, (int)(bounds.y + bounds.height));
            }
            super.setBounds(x, y, width, height);
            if (RemoteDesktopService.isRemoteSession()) {
                this.shadow = null;
            } else if (this.shadow == null || this.shadowWidth != width || this.shadowHeight != height) {
                this.shadow = ShadowBorderPainter.createShadow(this, width, height);
                this.shadowWidth = width;
                this.shadowHeight = height;
            }
        }

        public void dispose() {
            this.remove(this.getContentPane());
            this.setVisible(false);
            this.myRootPane = null;
        }

        public void setContentPane(JComponent content2) {
            if (this.myContentPane != null) {
                this.remove(this.myContentPane);
            }
            this.myContentPane = content2;
            this.myContentPane.setOpaque(true);
            this.add((Component)this.myContentPane, "Center");
        }

        public JComponent getContentPane() {
            return this.myContentPane;
        }

        @Override
        public JRootPane getRootPane() {
            return this.myRootPane;
        }

        public DialogWrapper getDialogWrapper() {
            return (DialogWrapper)this.myDialogWrapper.get();
        }

        public void uiDataSnapshot(@NotNull DataSink sink) {
            if (sink == null) {
                MyDialog.$$$reportNull$$$0(0);
            }
            DialogWrapper wrapper2 = (DialogWrapper)this.myDialogWrapper.get();
            DataSink.uiDataSnapshot((DataSink)sink, (Object)wrapper2);
        }

        @Override
        public void setSize(int width, int height) {
            Point location = this.getLocation();
            Rectangle rect = new Rectangle(location.x, location.y, width, height);
            ScreenUtil.fitToScreen((Rectangle)rect);
            if (location.x != rect.x || location.y != rect.y) {
                this.setLocation(rect.x, rect.y);
            }
            super.setSize(rect.width, rect.height);
        }

        @Contract(value="_,!null->!null")
        private Point getLocationInCenter(@NotNull Dimension size2, @Nullable Point _default) {
            if (size2 == null) {
                MyDialog.$$$reportNull$$$0(1);
            }
            if (this.myTransparentPane != null) {
                Dimension d = this.myTransparentPane.getSize();
                return new Point((d.width - size2.width) / 2, (d.height - size2.height) / 2);
            }
            return _default;
        }

        public void center() {
            Point location = this.getLocationInCenter(this.getSize(), null);
            if (location != null) {
                this.setLocation(location);
                this.repaint();
            }
        }

        public void setDefaultButton(JButton defaultButton) {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sink";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "size";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/ui/impl/GlassPaneDialogWrapperPeer$MyDialog";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "uiDataSnapshot";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getLocationInCenter";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class GlasspanePeerUnavailableException
    extends Exception {
    }

    public static final class TransparentLayeredPane
    extends JBLayeredPane {
        private TransparentLayeredPane() {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            this.addMouseListener(new MouseAdapter(this){});
            this.addMouseMotionListener(new MouseMotionAdapter(this){});
        }

        public void addNotify() {
            Container container = this.getParent();
            if (container != null) {
                this.setBounds(0, 0, container.getWidth(), container.getHeight());
            }
            super.addNotify();
        }

        public boolean isOptimizedDrawingEnabled() {
            return this.getComponentCount() <= 1;
        }
    }

    private static final class MyRootPane
    extends JRootPane
    implements Disposable {
        private MyDialog myDialog;

        private MyRootPane(MyDialog dialog2) {
            this.myDialog = dialog2;
        }

        @Override
        protected JLayeredPane createLayeredPane() {
            JBLayeredPane p = new JBLayeredPane();
            p.setName(this.getName() + ".layeredPane");
            return p;
        }

        public void dispose() {
            DialogWrapper.cleanupRootPane((JRootPane)this);
            this.myDialog = null;
        }

        @Override
        public void registerKeyboardAction(ActionListener anAction, String aCommand, KeyStroke aKeyStroke, int aCondition) {
            this.myDialog.registerKeyboardAction(anAction, aCommand, aKeyStroke, aCondition);
        }

        @Override
        public void unregisterKeyboardAction(KeyStroke aKeyStroke) {
            this.myDialog.unregisterKeyboardAction(aKeyStroke);
        }

        @Override
        public void setDefaultButton(JButton defaultButton) {
            this.myDialog.setDefaultButton(defaultButton);
        }

        @Override
        public void setContentPane(Container contentPane) {
            super.setContentPane(contentPane);
            contentPane.addMouseMotionListener(new MouseMotionAdapter(this){});
        }
    }
}

