/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl.upgradeToUltimate.installation.mac;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.SuggestedIde;
import com.intellij.openapi.updateSettings.impl.upgradeToUltimate.installation.install.DownloadResult;
import com.intellij.openapi.updateSettings.impl.upgradeToUltimate.installation.install.InstallationResult;
import com.intellij.openapi.updateSettings.impl.upgradeToUltimate.installation.install.UltimateInstallationInfo;
import com.intellij.openapi.updateSettings.impl.upgradeToUltimate.installation.install.UltimateInstaller;
import com.intellij.openapi.updateSettings.impl.upgradeToUltimate.installation.install.UltimateInstallerKt;
import com.intellij.openapi.util.io.NioPathUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.system.CpuArch;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\tH\u0002J\u0010\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u0010H\u0016J\n\u0010\u001c\u001a\u0004\u0018\u00010\rH\u0016R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/openapi/updateSettings/impl/upgradeToUltimate/installation/mac/MacOsInstaller;", "Lcom/intellij/openapi/updateSettings/impl/upgradeToUltimate/installation/install/UltimateInstaller;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;Lcom/intellij/openapi/project/Project;)V", "postfix", "", "getPostfix", "()Ljava/lang/String;", "mountDirectory", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "installUltimate", "Lcom/intellij/openapi/updateSettings/impl/upgradeToUltimate/installation/install/InstallationResult;", "downloadResult", "Lcom/intellij/openapi/updateSettings/impl/upgradeToUltimate/installation/install/DownloadResult;", "copyApp", "appPath", "suggestedIde", "Lcom/intellij/openapi/updateSettings/impl/pluginsAdvertisement/SuggestedIde;", "runDetach", "", "mounterDirectory", "startUltimate", "installationResult", "getUltimateInstallationDirectory", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nMacOsInstaller.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MacOsInstaller.kt\ncom/intellij/openapi/updateSettings/impl/upgradeToUltimate/installation/mac/MacOsInstaller\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,69:1\n296#2,2:70\n*S KotlinDebug\n*F\n+ 1 MacOsInstaller.kt\ncom/intellij/openapi/updateSettings/impl/upgradeToUltimate/installation/mac/MacOsInstaller\n*L\n31#1:70,2\n*E\n"})
public final class MacOsInstaller
extends UltimateInstaller {
    @NotNull
    private final String postfix;
    private final Path mountDirectory;

    public MacOsInstaller(@NotNull CoroutineScope scope, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        super(scope, project2);
        this.postfix = CpuArch.isArm64() ? "-aarch64.dmg" : ".dmg";
        this.mountDirectory = this.getUpdateTempDirectory().resolve("mount");
    }

    @Override
    @NotNull
    public String getPostfix() {
        return this.postfix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public InstallationResult installUltimate(@NotNull DownloadResult downloadResult2) {
        Path path;
        Path mountDir;
        block7: {
            InstallationResult installationResult2;
            block5: {
                Intrinsics.checkNotNullParameter((Object)downloadResult2, (String)"downloadResult");
                mountDir = this.mountDirectory.resolve(downloadResult2.getBuildVersion());
                Intrinsics.checkNotNull((Object)mountDir);
                FileAttribute[] fileAttributeArray = new FileAttribute[]{};
                Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(mountDir, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
                String[] stringArray = new String[]{"hdiutil", "attach", "-readonly", "-noautoopen", "-noautofsck", "-nobrowse", "-mountpoint", ((Object)mountDir).toString(), ((Object)downloadResult2.getDownloadPath()).toString()};
                GeneralCommandLine command = new GeneralCommandLine(stringArray);
                if (UltimateInstallerKt.runCommand(command)) break block5;
                stringArray = null;
                this.runDetach(((Object)mountDir).toString());
                this.deleteInBackground(mountDir);
                return stringArray;
            }
            try {
                Object v1;
                block6: {
                    Iterable $this$firstOrNull$iv = PathsKt.listDirectoryEntries$default((Path)mountDir, null, (int)1, null);
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        Path entry = (Path)element$iv;
                        boolean bl = false;
                        if (!StringsKt.endsWith$default((String)((Object)entry).toString(), (String)".app", (boolean)false, (int)2, null)) continue;
                        v1 = element$iv;
                        break block6;
                    }
                    v1 = null;
                }
                if ((Path)v1 != null) break block7;
                installationResult2 = null;
                this.runDetach(((Object)mountDir).toString());
            }
            catch (Throwable throwable) {
                Intrinsics.checkNotNull((Object)mountDir);
                this.runDetach(((Object)mountDir).toString());
                this.deleteInBackground(mountDir);
                throw throwable;
            }
            this.deleteInBackground(mountDir);
            return installationResult2;
        }
        Path app = path;
        InstallationResult installationResult3 = this.copyApp(app, downloadResult2.getSuggestedIde());
        this.runDetach(((Object)mountDir).toString());
        this.deleteInBackground(mountDir);
        return installationResult3;
    }

    private final InstallationResult copyApp(Path appPath, SuggestedIde suggestedIde) {
        InstallationResult installationResult2;
        try {
            Path path = this.getUltimateInstallationDirectory();
            if (path == null || (path = path.resolve(appPath.getFileName())) == null) {
                return null;
            }
            Path newAppPath = path;
            PathsKt.copyToRecursively$default((Path)appPath, (Path)newAppPath, null, (boolean)true, (boolean)true, (int)2, null);
            installationResult2 = new InstallationResult(newAppPath, new UltimateInstallationInfo(suggestedIde));
        }
        catch (Exception e) {
            this.deleteInBackground(appPath);
            throw e;
        }
        return installationResult2;
    }

    private final boolean runDetach(String mounterDirectory) {
        String[] stringArray = new String[]{"hdiutil", "detach", "-force", mounterDirectory};
        GeneralCommandLine detachCommand = new GeneralCommandLine(stringArray);
        return UltimateInstallerKt.runCommand(detachCommand);
    }

    @Override
    public boolean startUltimate(@NotNull InstallationResult installationResult2) {
        Intrinsics.checkNotNullParameter((Object)installationResult2, (String)"installationResult");
        String[] stringArray = new String[]{"/usr/bin/open", "-n", ((Object)installationResult2.getAppPath()).toString(), "--args", this.getProject().getBasePath(), this.getTrialParameter()};
        GeneralCommandLine start2 = new GeneralCommandLine(stringArray);
        return UltimateInstallerKt.runCommand(start2);
    }

    @Override
    @Nullable
    public Path getUltimateInstallationDirectory() {
        String string = SystemProperties.getUserHome();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUserHome(...)");
        Path path = NioPathUtil.toNioPathOrNull((String)string);
        return path != null ? path.resolve("Applications") : null;
    }
}

