/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.icons.AllIcons;
import com.intellij.ide.HelpTooltip;
import com.intellij.ide.actions.ActivateToolWindowAction;
import com.intellij.ide.actions.ToolWindowMoveAction;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.ActionButtonComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ex.ActionButtonLook;
import com.intellij.openapi.util.ScalableIcon;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.impl.AbstractDroppableStripe;
import com.intellij.openapi.wm.impl.AbstractSquareStripeButton;
import com.intellij.openapi.wm.impl.SquareAnActionButton;
import com.intellij.openapi.wm.impl.SquareStripeButtonKt;
import com.intellij.openapi.wm.impl.SquareStripeButtonLook;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.toolWindow.ResizeStripeManager;
import com.intellij.toolWindow.StripeButtonUi;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.MouseDragHelper;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.icons.StrokeKt;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 02\u00020\u0001:\u00010B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0010\b\u0002\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t\u00a2\u0006\u0004\b\u000b\u0010\fB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u000b\u0010\rB\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u000b\u0010\u000eJ\b\u0010\u0013\u001a\u00020\u0014H\u0002J\u0013\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u0016H\u0002\u00a2\u0006\u0002\u0010\u0017J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\b\u0010\u001c\u001a\u00020\u0019H\u0016J\u0006\u0010\u001d\u001a\u00020\u0019J\u0006\u0010\u001e\u001a\u00020\u0012J\u0006\u0010\u001f\u001a\u00020\u0012J\u0006\u0010 \u001a\u00020\u0019J\b\u0010!\u001a\u00020\u0019H\u0014J\u0010\u0010\"\u001a\u00020\u00122\u0006\u0010#\u001a\u00020$H\u0014J\u0018\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0012H\u0002J\u000e\u0010*\u001a\u00020\u00192\u0006\u0010+\u001a\u00020\u0012J\b\u0010,\u001a\u00020\nH\u0016J\u0010\u0010-\u001a\n /*\u0004\u0018\u00010.0.H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/intellij/openapi/wm/impl/SquareStripeButton;", "Lcom/intellij/openapi/wm/impl/AbstractSquareStripeButton;", "action", "Lcom/intellij/openapi/wm/impl/SquareAnActionButton;", "toolWindow", "Lcom/intellij/openapi/wm/impl/ToolWindowImpl;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "minimumSize", "Ljava/util/function/Supplier;", "Ljava/awt/Dimension;", "<init>", "(Lcom/intellij/openapi/wm/impl/SquareAnActionButton;Lcom/intellij/openapi/wm/impl/ToolWindowImpl;Lcom/intellij/openapi/actionSystem/Presentation;Ljava/util/function/Supplier;)V", "(Lcom/intellij/openapi/wm/impl/SquareAnActionButton;Lcom/intellij/openapi/wm/impl/ToolWindowImpl;)V", "(Lcom/intellij/openapi/wm/impl/ToolWindowImpl;)V", "getToolWindow", "()Lcom/intellij/openapi/wm/impl/ToolWindowImpl;", "myShowName", "", "getStripeText", "", "getStripeSplitText", "", "()[Ljava/lang/String;", "paintButtonLook", "", "g", "Ljava/awt/Graphics;", "updateUI", "updatePresentation", "isHovered", "isFocused", "resetDrop", "updateToolTipText", "checkSkipPressForEvent", "e", "Ljava/awt/event/MouseEvent;", "getAlignment", "Lcom/intellij/ide/HelpTooltip$Alignment;", "anchor", "Lcom/intellij/openapi/wm/ToolWindowAnchor;", "splitMode", "setOrUpdateShowName", "value", "getPreferredSize", "getTextFont", "Ljava/awt/Font;", "kotlin.jvm.PlatformType", "Companion", "intellij.platform.ide.impl"})
public final class SquareStripeButton
extends AbstractSquareStripeButton {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ToolWindowImpl toolWindow;
    private boolean myShowName;

    public SquareStripeButton(@NotNull SquareAnActionButton action2, @NotNull ToolWindowImpl toolWindow2, @NotNull Presentation presentation2, @Nullable Supplier<Dimension> minimumSize) {
        Intrinsics.checkNotNullParameter((Object)((Object)action2), (String)"action");
        Intrinsics.checkNotNullParameter((Object)toolWindow2, (String)"toolWindow");
        Intrinsics.checkNotNullParameter((Object)presentation2, (String)"presentation");
        super((AnAction)action2, presentation2, minimumSize);
        this.toolWindow = toolWindow2;
        this.doInit((Function0<? extends ActionGroup>)((Function0)() -> SquareStripeButton._init_$lambda$0(this)));
        MouseDragHelper.setComponentDraggable((JComponent)this, (boolean)true);
        this.setLook(new SquareStripeButtonLook(){
            private Color myPressedColor;
            private String myPressedColorKey;

            private final Color getBackgroundColor() {
                if (this.isFocused()) {
                    return StripeButtonUi.Companion.getSELECTED_BACKGROUND_COLOR();
                }
                if (this.getToolWindow().isVisible()) {
                    Color color = JBUI.CurrentTheme.ActionButton.pressedBackground();
                    Intrinsics.checkNotNullExpressionValue((Object)color, (String)"pressedBackground(...)");
                    return color;
                }
                if (this.isHovered()) {
                    Color color = JBUI.CurrentTheme.ActionButton.hoverBackground();
                    Intrinsics.checkNotNullExpressionValue((Object)color, (String)"hoverBackground(...)");
                    return color;
                }
                Color color = this.getBackground();
                Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getBackground(...)");
                return color;
            }

            private final Color getForegroundColor() {
                return this.getToolWindow().isActive() ? StripeButtonUi.Companion.getSELECTED_FOREGROUND_COLOR() : StripeButtonUi.Companion.getFOREGROUND_COLOR();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void paintIcon(Graphics g, ActionButtonComponent actionButton, Icon icon2) {
                Intrinsics.checkNotNullParameter((Object)icon2, (String)"icon");
                if (!myShowName) {
                    super.paintIcon(g, actionButton, icon2);
                } else {
                    ActionButtonComponent buttonWrapper2 = new ActionButtonComponent(actionButton, this){
                        final /* synthetic */ ActionButtonComponent $actionButton;
                        final /* synthetic */ SquareStripeButton this$0;
                        {
                            this.$actionButton = $actionButton;
                            this.this$0 = $receiver;
                        }

                        public int getPopState() {
                            ActionButtonComponent actionButtonComponent = this.$actionButton;
                            Intrinsics.checkNotNull((Object)actionButtonComponent);
                            return actionButtonComponent.getPopState();
                        }

                        public int getWidth() {
                            ActionButtonComponent actionButtonComponent = this.$actionButton;
                            Intrinsics.checkNotNull((Object)actionButtonComponent);
                            return actionButtonComponent.getWidth();
                        }

                        public int getHeight() {
                            return SquareStripeButton.access$getPreferredSize$s-665947266((SquareStripeButton)this.this$0).height;
                        }

                        public Insets getInsets() {
                            ActionButtonComponent actionButtonComponent = this.$actionButton;
                            Intrinsics.checkNotNull((Object)actionButtonComponent);
                            return actionButtonComponent.getInsets();
                        }
                    };
                    Color color = UIManager.getColor("ToolWindow.Button.selectedForeground");
                    Point iconPosition = null;
                    if (!this.getToolWindow().isActive() || color == null) {
                        super.paintIcon(g, buttonWrapper2, icon2);
                        iconPosition = this.getIconPosition(buttonWrapper2, icon2);
                        iconPosition.y += icon2.getIconHeight();
                    } else {
                        Icon strokeIcon = StrokeKt.toStrokeIcon((Icon)icon2, (Color)color);
                        super.paintIcon(g, buttonWrapper2, strokeIcon);
                        iconPosition = this.getIconPosition(buttonWrapper2, strokeIcon);
                        iconPosition.y += strokeIcon.getIconHeight();
                    }
                    Font f = this.getTextFont();
                    FontMetrics fm = this.getFontMetrics(f);
                    String[] texts = this.getStripeSplitText();
                    SquareStripeButton button2 = this;
                    Insets insets = button2.getInsets();
                    int textPadding = UISettings.Companion.getInstance().getCompactMode() ? 4 : 6;
                    int textOffset = JBUI.CurrentTheme.Toolbar.stripeToolbarTextOffset((boolean)SquareStripeButtonKt.isOnTheLeftStripe(button2));
                    int x = insets.left + JBUI.scale((int)(textPadding + textOffset));
                    int y = iconPosition.y + JBUI.scale((int)3);
                    int totalWidth = button2.getWidth() - insets.left - insets.right - JBUI.scale((int)(textPadding * 2));
                    int textHeight = fm.getHeight();
                    Integer firstX = null;
                    int n = texts.length;
                    for (int j = 0; j < n; ++j) {
                        String text2 = texts[j];
                        int textWidth = UIUtil.computeStringWidth((JComponent)this, (FontMetrics)fm, (String)text2);
                        Graphics graphics = g;
                        Intrinsics.checkNotNull((Object)graphics);
                        Graphics graphics2 = graphics.create();
                        Intrinsics.checkNotNull((Object)graphics2, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
                        Graphics2D g2d = (Graphics2D)graphics2;
                        try {
                            g2d.setColor(this.getForegroundColor());
                            g2d.setFont(f);
                            UISettings.Companion.setupAntialiasing((Graphics)g2d);
                            if (firstX == null || texts[0].length() != texts[1].length()) {
                                UIUtil.drawCenteredString((Graphics2D)g2d, (Rectangle)new Rectangle(x, y, totalWidth, textHeight), (String)text2);
                                firstX = RangesKt.coerceAtLeast((int)x, (int)(x + (totalWidth - fm.stringWidth(text2) - 1) / 2));
                            } else {
                                g2d.drawString(text2, (int)firstX, RangesKt.coerceAtLeast((int)y, (int)(y + textHeight / 2 + fm.getAscent() * 2 / 5)));
                            }
                            if (textWidth > totalWidth) {
                                int gradientWidth = JBUI.scale((int)3);
                                int gradientX = x + totalWidth - gradientWidth;
                                Color bgColor = this.getBackgroundColor();
                                if ((bgColor.getRed() == 0 && bgColor.getGreen() == 0 && bgColor.getBlue() == 0 || bgColor.getRed() == 255 && bgColor.getGreen() == 255 && bgColor.getBlue() == 255) && bgColor.getAlpha() < 255) {
                                    String pressedColorKey = button2.getBackground().getRGB() + ":" + bgColor.getRGB();
                                    if (this.myPressedColor == null || !Intrinsics.areEqual((Object)pressedColorKey, (Object)this.myPressedColorKey)) {
                                        BufferedImage image2;
                                        Intrinsics.checkNotNullExpressionValue((Object)UIUtil.createImage((Component)button2, (int)4, (int)4, (int)2), (String)"createImage(...)");
                                        Graphics2D imageG = image2.createGraphics();
                                        try {
                                            imageG.setColor(button2.getBackground());
                                            imageG.fill(new Rectangle(0, 0, 4, 4));
                                            imageG.setColor(bgColor);
                                            imageG.fill(new Rectangle(0, 0, 4, 4));
                                        }
                                        finally {
                                            imageG.dispose();
                                        }
                                        this.myPressedColor = new Color(image2.getRGB(2, 2));
                                        this.myPressedColorKey = pressedColorKey;
                                    }
                                    Color color2 = this.myPressedColor;
                                    Intrinsics.checkNotNull((Object)color2);
                                    bgColor = color2;
                                }
                                g2d.setPaint(new GradientPaint(gradientX, y, ColorUtil.withAlpha((Color)bgColor, (double)0.4), gradientX + gradientWidth, y, bgColor));
                                g2d.fill(new Rectangle(gradientX, y, gradientWidth, textHeight));
                            }
                            y += textHeight;
                            continue;
                        }
                        finally {
                            g2d.dispose();
                        }
                    }
                }
            }
        });
    }

    public /* synthetic */ SquareStripeButton(SquareAnActionButton squareAnActionButton, ToolWindowImpl toolWindowImpl, Presentation presentation2, Supplier supplier, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            supplier = null;
        }
        this(squareAnActionButton, toolWindowImpl, presentation2, supplier);
    }

    @NotNull
    public final ToolWindowImpl getToolWindow() {
        return this.toolWindow;
    }

    public SquareStripeButton(@NotNull SquareAnActionButton action2, @NotNull ToolWindowImpl toolWindow2) {
        Intrinsics.checkNotNullParameter((Object)((Object)action2), (String)"action");
        Intrinsics.checkNotNullParameter((Object)toolWindow2, (String)"toolWindow");
        this(action2, toolWindow2, SquareStripeButtonKt.access$createPresentation(toolWindow2), null, 8, null);
    }

    public SquareStripeButton(@NotNull ToolWindowImpl toolWindow2) {
        Intrinsics.checkNotNullParameter((Object)toolWindow2, (String)"toolWindow");
        this(new SquareAnActionButton(toolWindow2), toolWindow2);
    }

    private final String getStripeText() {
        Supplier<String> supplier = this.toolWindow.getStripeShortTitleProvider();
        if (supplier == null || (supplier = supplier.get()) == null) {
            String string = this.toolWindow.getStripeTitleProvider().get();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(...)");
            supplier = string;
        }
        return ((Object)StringsKt.trim((CharSequence)((CharSequence)((Object)supplier)))).toString();
    }

    private final String[] getStripeSplitText() {
        String text2 = this.getStripeText();
        int index = StringsKt.indexOf$default((CharSequence)text2, (char)' ', (int)0, (boolean)false, (int)6, null);
        if (index == -1) {
            String[] stringArray = new String[]{text2};
            return stringArray;
        }
        String[] stringArray = new String[2];
        Intrinsics.checkNotNullExpressionValue((Object)text2.substring(0, index), (String)"substring(...)");
        Intrinsics.checkNotNullExpressionValue((Object)text2.substring(index + 1), (String)"substring(...)");
        return stringArray;
    }

    @Override
    protected void paintButtonLook(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        ActionButtonLook look = this.getButtonLook();
        if (!this.myShowName) {
            super.paintButtonLook(g);
            return;
        }
        look.paintBackground(g, (JComponent)this);
        look.paintIcon(g, this, this.getIcon());
        Color color = this.getPopState() == -1 ? JBUI.CurrentTheme.ActionButton.pressedBorder() : JBUI.CurrentTheme.ActionButton.hoverBorder();
        Intrinsics.checkNotNull((Object)color);
        Color color2 = color;
        if (color2.getAlpha() == 255) {
            look.paintBorder(g, (JComponent)this);
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        Icon icon2 = this.toolWindow.getIcon$intellij_platform_ide_impl();
        if (icon2 == null) {
            Icon icon3 = AllIcons.Toolbar.Unknown;
            icon2 = icon3;
            Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"Unknown");
        }
        this.myPresentation.setIcon(SquareStripeButtonKt.access$scaleIcon((ScalableIcon)icon2));
        this.myPresentation.setEnabledAndVisible(true);
    }

    public final void updatePresentation() {
        this.updateToolTipText();
        Icon icon2 = this.toolWindow.getIcon$intellij_platform_ide_impl();
        if (icon2 == null) {
            Icon icon3 = AllIcons.Toolbar.Unknown;
            icon2 = icon3;
            Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"Unknown");
        }
        this.myPresentation.setIcon(SquareStripeButtonKt.access$scaleIcon((ScalableIcon)icon2));
    }

    public final boolean isHovered() {
        return this.myRollover;
    }

    public final boolean isFocused() {
        return this.toolWindow.isActive();
    }

    public final void resetDrop() {
        this.resetMouseState();
    }

    @Override
    protected void updateToolTipText() {
        new HelpTooltip().setTitle(this.toolWindow.getStripeTitleProvider()).setLocation(this.getAlignment(this.toolWindow.getAnchor(), this.toolWindow.isSplitMode())).setShortcut((Shortcut)ActionManager.getInstance().getKeyboardShortcut(ActivateToolWindowAction.Manager.getActionIdForToolWindow(this.toolWindow.getId()))).setInitialDelay(0).setHideDelay(0).installOn((JComponent)this);
        HelpTooltip.setMasterPopupOpenCondition((Component)this, () -> SquareStripeButton.updateToolTipText$lambda$0(this));
        this.setOrUpdateShowName(ResizeStripeManager.Companion.isShowNames());
    }

    @Override
    protected boolean checkSkipPressForEvent(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return e.getButton() != 1;
    }

    private final HelpTooltip.Alignment getAlignment(ToolWindowAnchor anchor, boolean splitMode) {
        ToolWindowAnchor toolWindowAnchor = anchor;
        return Intrinsics.areEqual((Object)toolWindowAnchor, (Object)ToolWindowAnchor.RIGHT) ? HelpTooltip.Alignment.LEFT : (Intrinsics.areEqual((Object)toolWindowAnchor, (Object)ToolWindowAnchor.TOP) ? HelpTooltip.Alignment.LEFT : (Intrinsics.areEqual((Object)toolWindowAnchor, (Object)ToolWindowAnchor.LEFT) ? HelpTooltip.Alignment.RIGHT : (Intrinsics.areEqual((Object)toolWindowAnchor, (Object)ToolWindowAnchor.BOTTOM) ? (splitMode ? HelpTooltip.Alignment.LEFT : HelpTooltip.Alignment.RIGHT) : HelpTooltip.Alignment.RIGHT)));
    }

    public final void setOrUpdateShowName(boolean value) {
        if (this.myShowName != value) {
            this.myShowName = value;
            this.revalidate();
            this.repaint();
        }
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        Dimension size2 = super.getPreferredSize();
        if (this.myShowName) {
            int lines = StringsKt.contains$default((CharSequence)this.getStripeText(), (char)' ', (boolean)false, (int)2, null) ? 2 : 1;
            size2.height += JBUI.scale((int)3) + this.getFontMetrics(this.getTextFont()).getHeight() * lines;
        }
        Intrinsics.checkNotNull((Object)size2);
        return size2;
    }

    private final Font getTextFont() {
        return RelativeFont.TINY.derive(this.getFont());
    }

    private static final ActionGroup _init_$lambda$0(SquareStripeButton this$0) {
        return (ActionGroup)SquareStripeButtonKt.access$createPopupGroup(this$0.toolWindow);
    }

    private static final boolean updateToolTipText$lambda$0(SquareStripeButton this$0) {
        Container container = this$0.getParent();
        AbstractDroppableStripe abstractDroppableStripe = container instanceof AbstractDroppableStripe ? (AbstractDroppableStripe)((Object)container) : null;
        return !(abstractDroppableStripe != null ? abstractDroppableStripe.isDroppingButton() : false);
    }

    public static final /* synthetic */ Dimension access$getPreferredSize$s-665947266(SquareStripeButton $this) {
        return super.getPreferredSize();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/openapi/wm/impl/SquareStripeButton$Companion;", "", "<init>", "()V", "createMoveGroup", "Lcom/intellij/ide/actions/ToolWindowMoveAction$Group;", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ToolWindowMoveAction.Group createMoveGroup() {
            return new ToolWindowMoveAction.Group();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

