/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ijent.community.impl.nio;

import com.intellij.platform.eel.fs.EelFileInfo;
import com.intellij.platform.eel.fs.EelPosixFileInfo;
import com.intellij.platform.eel.fs.EelWindowsFileInfo;
import com.intellij.platform.ijent.community.impl.nio.EelUnixFileKey;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.time.chrono.ChronoZonedDateTime;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0000\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\u0007H\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016J\b\u0010\r\u001a\u00020\u000bH\u0016J\b\u0010\u000e\u001a\u00020\u000bH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/platform/ijent/community/impl/nio/IjentNioBasicFileAttributes;", "Ljava/nio/file/attribute/BasicFileAttributes;", "fileInfo", "Lcom/intellij/platform/eel/fs/EelFileInfo;", "<init>", "(Lcom/intellij/platform/eel/fs/EelFileInfo;)V", "lastModifiedTime", "Ljava/nio/file/attribute/FileTime;", "lastAccessTime", "creationTime", "isRegularFile", "", "isDirectory", "isSymbolicLink", "isOther", "size", "", "fileKey", "", "intellij.platform.ijent.community.impl"})
public final class IjentNioBasicFileAttributes
implements BasicFileAttributes {
    @NotNull
    private final EelFileInfo fileInfo;

    public IjentNioBasicFileAttributes(@NotNull EelFileInfo fileInfo) {
        Intrinsics.checkNotNullParameter((Object)fileInfo, (String)"fileInfo");
        this.fileInfo = fileInfo;
    }

    @Override
    @NotNull
    public FileTime lastModifiedTime() {
        Comparable<ChronoZonedDateTime<?>> comparable = this.fileInfo.getLastModifiedTime();
        if (comparable == null || (comparable = comparable.toInstant()) == null) {
            comparable = Instant.MIN;
        }
        FileTime fileTime = FileTime.from((Instant)comparable);
        Intrinsics.checkNotNullExpressionValue((Object)fileTime, (String)"from(...)");
        return fileTime;
    }

    @Override
    @NotNull
    public FileTime lastAccessTime() {
        Comparable<ChronoZonedDateTime<?>> comparable = this.fileInfo.getLastAccessTime();
        if (comparable == null || (comparable = comparable.toInstant()) == null) {
            comparable = Instant.MIN;
        }
        FileTime fileTime = FileTime.from((Instant)comparable);
        Intrinsics.checkNotNullExpressionValue((Object)fileTime, (String)"from(...)");
        return fileTime;
    }

    @Override
    @NotNull
    public FileTime creationTime() {
        Comparable<ChronoZonedDateTime<?>> comparable = this.fileInfo.getCreationTime();
        if (comparable == null || (comparable = comparable.toInstant()) == null) {
            comparable = Instant.MIN;
        }
        FileTime fileTime = FileTime.from((Instant)comparable);
        Intrinsics.checkNotNullExpressionValue((Object)fileTime, (String)"from(...)");
        return fileTime;
    }

    @Override
    public boolean isRegularFile() {
        boolean bl;
        EelFileInfo.Type type = this.fileInfo.getType();
        if (type instanceof EelFileInfo.Type.Regular) {
            bl = true;
        } else if (type instanceof EelFileInfo.Type.Directory || type instanceof EelFileInfo.Type.Other || type instanceof EelPosixFileInfo.Type.Symlink) {
            bl = false;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    @Override
    public boolean isDirectory() {
        boolean bl;
        EelFileInfo.Type type = this.fileInfo.getType();
        if (type instanceof EelFileInfo.Type.Directory) {
            bl = true;
        } else if (type instanceof EelFileInfo.Type.Other || type instanceof EelFileInfo.Type.Regular || type instanceof EelPosixFileInfo.Type.Symlink) {
            bl = false;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    @Override
    public boolean isSymbolicLink() {
        boolean bl;
        EelFileInfo.Type type = this.fileInfo.getType();
        if (type instanceof EelPosixFileInfo.Type.Symlink) {
            bl = true;
        } else if (type instanceof EelFileInfo.Type.Directory || type instanceof EelFileInfo.Type.Other || type instanceof EelFileInfo.Type.Regular) {
            bl = false;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    @Override
    public boolean isOther() {
        boolean bl;
        EelFileInfo.Type type = this.fileInfo.getType();
        if (type instanceof EelFileInfo.Type.Other) {
            bl = true;
        } else if (type instanceof EelFileInfo.Type.Directory || type instanceof EelFileInfo.Type.Regular || type instanceof EelPosixFileInfo.Type.Symlink) {
            bl = false;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    @Override
    public long size() {
        long l;
        EelFileInfo.Type t = this.fileInfo.getType();
        if (t instanceof EelFileInfo.Type.Regular) {
            l = ((EelFileInfo.Type.Regular)t).getSize();
        } else if (t instanceof EelFileInfo.Type.Directory || t instanceof EelFileInfo.Type.Other || t instanceof EelPosixFileInfo.Type.Symlink.Resolved || t instanceof EelPosixFileInfo.Type.Symlink.Unresolved) {
            l = 0L;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return l;
    }

    @Override
    @NotNull
    public Object fileKey() {
        EelFileInfo eelFileInfo = this.fileInfo;
        if (!(eelFileInfo instanceof EelPosixFileInfo)) {
            if (eelFileInfo instanceof EelWindowsFileInfo) {
                throw new NotImplementedError(null, 1, null);
            }
            throw new NoWhenBranchMatchedException();
        }
        return new EelUnixFileKey(((EelPosixFileInfo)this.fileInfo).getInodeDev(), ((EelPosixFileInfo)this.fileInfo).getInodeIno());
    }
}

