/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.syntax.util.lexer;

import com.intellij.platform.syntax.SyntaxElementType;
import com.intellij.platform.syntax.SyntaxElementTypeSet;
import com.intellij.platform.syntax.lexer.Lexer;
import com.intellij.platform.syntax.lexer.LexerPosition;
import com.intellij.platform.syntax.util.lexer.DelegateLexer;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0018\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001:\u0002\u001e\u001fB'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ(\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u000bH\u0016J\b\u0010\u0018\u001a\u00020\u0012H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001aH\u0016J\u0006\u0010\u001d\u001a\u00020\u0012R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006 "}, d2={"Lcom/intellij/platform/syntax/util/lexer/FilterLexer;", "Lcom/intellij/platform/syntax/util/lexer/DelegateLexer;", "original", "Lcom/intellij/platform/syntax/lexer/Lexer;", "filter", "Lcom/intellij/platform/syntax/util/lexer/FilterLexer$Filter;", "stateFilter", "", "<init>", "(Lcom/intellij/platform/syntax/lexer/Lexer;Lcom/intellij/platform/syntax/util/lexer/FilterLexer$Filter;[Z)V", "value", "", "prevTokenEnd", "getPrevTokenEnd", "()I", "getOriginal", "()Lcom/intellij/platform/syntax/lexer/Lexer;", "start", "", "buffer", "", "startOffset", "endOffset", "initialState", "advance", "getCurrentPosition", "Lcom/intellij/platform/syntax/lexer/LexerPosition;", "restore", "position", "locateToken", "Filter", "SetFilter", "intellij.platform.syntax.util"})
@ApiStatus.Experimental
public final class FilterLexer
extends DelegateLexer {
    @Nullable
    private final Filter filter;
    @Nullable
    private final boolean[] stateFilter;
    private int prevTokenEnd;

    @JvmOverloads
    public FilterLexer(@NotNull Lexer original, @Nullable Filter filter2, @Nullable boolean[] stateFilter) {
        super(original);
        this.filter = filter2;
        this.stateFilter = stateFilter;
    }

    public /* synthetic */ FilterLexer(Lexer lexer, Filter filter2, boolean[] blArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            blArray = null;
        }
        this(lexer, filter2, blArray);
    }

    public final int getPrevTokenEnd() {
        return this.prevTokenEnd;
    }

    @NotNull
    public final Lexer getOriginal() {
        return this.getDelegate();
    }

    @Override
    public void start(@NotNull CharSequence buffer2, int startOffset, int endOffset, int initialState) {
        super.start(buffer2, startOffset, endOffset, initialState);
        this.prevTokenEnd = -1;
        this.locateToken();
    }

    @Override
    public void advance() {
        this.prevTokenEnd = this.getDelegate().getTokenEnd();
        super.advance();
        this.locateToken();
    }

    @Override
    @NotNull
    public LexerPosition getCurrentPosition() {
        return this.getDelegate().getCurrentPosition();
    }

    @Override
    public void restore(@NotNull LexerPosition position2) {
        this.getDelegate().restore(position2);
        this.prevTokenEnd = -1;
    }

    public final void locateToken() {
        SyntaxElementType tokenType;
        Lexer delegate;
        while ((delegate = this.getDelegate()).getTokenType() != null && (this.filter != null && this.filter.reject(tokenType) || this.stateFilter != null && this.stateFilter[delegate.getState()])) {
            delegate.advance();
        }
    }

    @JvmOverloads
    public FilterLexer(@NotNull Lexer original, @Nullable Filter filter2) {
        this(original, filter2, null, 4, null);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lcom/intellij/platform/syntax/util/lexer/FilterLexer$Filter;", "", "reject", "", "type", "Lcom/intellij/platform/syntax/SyntaxElementType;", "intellij.platform.syntax.util"})
    public static interface Filter {
        public boolean reject(@NotNull SyntaxElementType var1);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/platform/syntax/util/lexer/FilterLexer$SetFilter;", "Lcom/intellij/platform/syntax/util/lexer/FilterLexer$Filter;", "set", "Lcom/intellij/platform/syntax/SyntaxElementTypeSet;", "<init>", "(Lcom/intellij/platform/syntax/SyntaxElementTypeSet;)V", "reject", "", "type", "Lcom/intellij/platform/syntax/SyntaxElementType;", "intellij.platform.syntax.util"})
    public static final class SetFilter
    implements Filter {
        @NotNull
        private final SyntaxElementTypeSet set;

        public SetFilter(@NotNull SyntaxElementTypeSet set) {
            this.set = set;
        }

        @Override
        public boolean reject(@NotNull SyntaxElementType type) {
            return this.set.contains((Object)type);
        }
    }
}

