/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.IndentHelper;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class IndentHelperImpl
extends IndentHelper {
    public static final int INDENT_FACTOR = 10000;
    public static final int TOO_BIG_WALK_THRESHOLD = 450;

    public int getIndent(@NotNull PsiFile file2, @NotNull ASTNode element) {
        if (file2 == null) {
            IndentHelperImpl.$$$reportNull$$$0(0);
        }
        if (element == null) {
            IndentHelperImpl.$$$reportNull$$$0(1);
        }
        return this.getIndent(file2, element, false);
    }

    public int getIndent(@NotNull PsiFile file2, @NotNull ASTNode element, boolean includeNonSpace) {
        if (file2 == null) {
            IndentHelperImpl.$$$reportNull$$$0(2);
        }
        if (element == null) {
            IndentHelperImpl.$$$reportNull$$$0(3);
        }
        return this.getIndentInner(file2, element, includeNonSpace, 0);
    }

    protected int getIndentInner(@NotNull PsiFile file2, @NotNull ASTNode element, boolean includeNonSpace, int recursionLevel) {
        if (file2 == null) {
            IndentHelperImpl.$$$reportNull$$$0(4);
        }
        if (element == null) {
            IndentHelperImpl.$$$reportNull$$$0(5);
        }
        if (recursionLevel > 450) {
            return 0;
        }
        if (element.getTreePrev() != null) {
            ASTNode parent;
            ASTNode prev = element.getTreePrev();
            while (prev instanceof CompositeElement && !TreeUtil.isStrongWhitespaceHolder((IElementType)prev.getElementType())) {
                ASTNode lastCompositePrev = prev;
                if ((prev = prev.getLastChildNode()) != null) continue;
                return this.getIndentInner(file2, lastCompositePrev, includeNonSpace, recursionLevel + 1);
            }
            String text2 = prev.getText();
            int index = Math.max(text2.lastIndexOf(10), text2.lastIndexOf(13));
            if (index >= 0) {
                return IndentHelperImpl.getIndent(file2, text2.substring(index + 1), includeNonSpace);
            }
            if (includeNonSpace) {
                return this.getIndentInner(file2, prev, true, recursionLevel + 1) + IndentHelperImpl.getIndent(file2, text2, true);
            }
            ASTNode child = prev;
            for (parent = prev.getTreeParent(); parent != null && child.getTreePrev() == null; parent = parent.getTreeParent()) {
                child = parent;
            }
            if (parent == null) {
                return IndentHelperImpl.getIndent(file2, text2, false);
            }
            return this.getIndentInner(file2, prev, false, recursionLevel + 1);
        }
        if (element.getTreeParent() == null) {
            return 0;
        }
        return this.getIndentInner(file2, element.getTreeParent(), includeNonSpace, recursionLevel + 1);
    }

    @Deprecated
    static String fillIndent(Project project2, FileType fileType2, int indent) {
        return IndentHelperImpl.fillIndent(CodeStyle.getProjectOrDefaultSettings((Project)project2).getIndentOptions(fileType2), indent);
    }

    public static String fillIndent(@NotNull CommonCodeStyleSettings.IndentOptions indentOptions, int indent) {
        if (indentOptions == null) {
            IndentHelperImpl.$$$reportNull$$$0(6);
        }
        int indentLevel = (indent + 5000) / 10000;
        int spaceCount = indent - indentLevel * 10000;
        int indentLevelSize = indentLevel * indentOptions.INDENT_SIZE;
        int totalSize = indentLevelSize + spaceCount;
        StringBuilder buffer2 = new StringBuilder();
        if (indentOptions.USE_TAB_CHARACTER) {
            if (indentOptions.SMART_TABS) {
                int i2;
                int tabCount = indentLevelSize / indentOptions.TAB_SIZE;
                int leftSpaces = indentLevelSize - tabCount * indentOptions.TAB_SIZE;
                for (i2 = 0; i2 < tabCount; ++i2) {
                    buffer2.append('\t');
                }
                for (i2 = 0; i2 < leftSpaces + spaceCount; ++i2) {
                    buffer2.append(' ');
                }
            } else {
                int size2 = totalSize;
                while (size2 > 0) {
                    if (size2 >= indentOptions.TAB_SIZE) {
                        buffer2.append('\t');
                        size2 -= indentOptions.TAB_SIZE;
                        continue;
                    }
                    buffer2.append(' ');
                    --size2;
                }
            }
        } else {
            for (int i3 = 0; i3 < totalSize; ++i3) {
                buffer2.append(' ');
            }
        }
        return buffer2.toString();
    }

    public static int getIndent(@NotNull PsiFile file2, String text2, boolean includeNonSpace) {
        if (file2 == null) {
            IndentHelperImpl.$$$reportNull$$$0(7);
        }
        return IndentHelperImpl.getIndent(CodeStyle.getIndentOptions((PsiFile)file2), text2, includeNonSpace);
    }

    public static int getIndent(@NotNull CommonCodeStyleSettings.IndentOptions indentOptions, String text2, boolean includeNonSpace) {
        char c;
        if (indentOptions == null) {
            IndentHelperImpl.$$$reportNull$$$0(8);
        }
        for (int i2 = text2.length() - 1; i2 >= 0 && (c = text2.charAt(i2)) != '\n' && c != '\r'; --i2) {
        }
        int spaceCount = 0;
        int tabCount = 0;
        for (int j = ++i2; j < text2.length(); ++j) {
            char c2 = text2.charAt(j);
            if (c2 != '\t') {
                if (!includeNonSpace && c2 != ' ') break;
                ++spaceCount;
                continue;
            }
            ++tabCount;
        }
        if (tabCount == 0) {
            return spaceCount;
        }
        int tabSize2 = indentOptions.TAB_SIZE;
        int indentSize = indentOptions.INDENT_SIZE;
        if (indentSize <= 0) {
            indentSize = 1;
        }
        int indentLevel = tabCount * tabSize2 / indentSize;
        return indentLevel * 10000 + spaceCount;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indentOptions";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/source/codeStyle/IndentHelperImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getIndent";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getIndentInner";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "fillIndent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

