/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.charts;

import com.intellij.ui.charts.CategoryLineChart;
import com.intellij.ui.charts.CategoryLineDataset;
import com.intellij.ui.charts.ChartWrapperKt;
import com.intellij.ui.charts.Coordinates;
import com.intellij.ui.charts.Dataset;
import com.intellij.ui.charts.Grid;
import com.intellij.ui.charts.GridChartWrapper;
import com.intellij.ui.charts.LineChartKt;
import com.intellij.ui.charts.LineDataset;
import com.intellij.ui.charts.LineStepped;
import com.intellij.ui.charts.MinMax;
import com.intellij.ui.charts.XYLineChart;
import com.intellij.ui.charts.XYLineDataset;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0003\b&\u0018\u0000 0*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u0002*\u0014\b\u0002\u0010\u0004*\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u00052\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0006:\u00010B\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0014\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u001eH\u0016J-\u0010\u001f\u001a\u00020\u001a*\u00028\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u001eH\u0002\u00a2\u0006\u0002\u0010!J.\u0010\"\u001a\u00020#2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u001e2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010%J\u001d\u0010&\u001a\u00020\u001a2\u0006\u0010'\u001a\u00028\u00002\u0006\u0010(\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010)J\u000b\u0010*\u001a\u00028\u0002\u00a2\u0006\u0002\u0010+J\"\u0010,\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00052\u0006\u0010-\u001a\u00020.H\u0087\u0002\u00a2\u0006\u0002\b*J\u0006\u0010/\u001a\u00020\u001aR \u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R \u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u00061"}, d2={"Lcom/intellij/ui/charts/LineChart;", "X", "", "Y", "D", "Lcom/intellij/ui/charts/LineDataset;", "Lcom/intellij/ui/charts/GridChartWrapper;", "<init>", "()V", "datasets", "", "getDatasets", "()Ljava/util/List;", "setDatasets", "(Ljava/util/List;)V", "borderPainted", "", "getBorderPainted", "()Z", "setBorderPainted", "(Z)V", "ranges", "Lcom/intellij/ui/charts/Grid;", "getRanges", "()Lcom/intellij/ui/charts/Grid;", "paintComponent", "", "g", "Ljava/awt/Graphics2D;", "findMinMax", "Lcom/intellij/ui/charts/MinMax;", "paintDataset", "xy", "(Lcom/intellij/ui/charts/LineDataset;Ljava/awt/Graphics2D;Lcom/intellij/ui/charts/MinMax;)V", "findLocation", "Ljava/awt/geom/Point2D$Double;", "coordinates", "Lcom/intellij/ui/charts/Coordinates;", "add", "x", "y", "(Ljava/lang/Number;Ljava/lang/Number;)V", "getDataset", "()Lcom/intellij/ui/charts/LineDataset;", "get", "label", "", "clear", "Companion", "intellij.platform.ide.ui"})
@SourceDebugExtension(value={"SMAP\nLineChart.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LineChart.kt\ncom/intellij/ui/charts/LineChart\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,307:1\n1915#2,2:308\n1915#2,2:310\n1924#2,3:312\n1915#2,2:316\n1#3:315\n*S KotlinDebug\n*F\n+ 1 LineChart.kt\ncom/intellij/ui/charts/LineChart\n*L\n135#1:308,2\n143#1:310,2\n159#1:312,3\n224#1:316,2\n*E\n"})
public abstract class LineChart<X extends Number, Y extends Number, D extends LineDataset<X, Y>>
extends GridChartWrapper<X, Y> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private List<? extends D> datasets = new ArrayList();
    private boolean borderPainted;
    @NotNull
    private final Grid<X, Y> ranges = new Grid();

    @NotNull
    public final List<D> getDatasets() {
        return this.datasets;
    }

    public final void setDatasets(@NotNull List<? extends D> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
        this.datasets = list2;
    }

    public final boolean getBorderPainted() {
        return this.borderPainted;
    }

    public final void setBorderPainted(boolean bl) {
        this.borderPainted = bl;
    }

    @Override
    @NotNull
    public Grid<X, Y> getRanges() {
        return this.ranges;
    }

    @Override
    public void paintComponent(@NotNull Graphics2D g) {
        MinMax<X, Y> xy;
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        int gridWidth = this.getWidth() - (this.getMargins().left + this.getMargins().right);
        int gridHeight = this.getHeight() - (this.getMargins().top + this.getMargins().bottom);
        if (this.borderPainted) {
            g.setColor(this.getGridColor());
            g.drawRect(this.getMargins().left, this.getMargins().top, gridWidth, gridHeight);
        }
        if ((xy = this.findMinMax()).isInitialized()) {
            Graphics graphics = g.create(this.getMargins().left, this.getMargins().top, gridWidth, gridHeight);
            Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
            Graphics2D grid = (Graphics2D)graphics;
            this.paintGrid(grid, g, xy);
            Iterable $this$forEach$iv = this.datasets;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LineDataset it = (LineDataset)element$iv;
                boolean bl = false;
                this.paintDataset(it, grid, xy);
            }
            grid.dispose();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public MinMax<X, Y> findMinMax() {
        MinMax minMax;
        if (this.getRanges().isInitialized()) {
            minMax = this.getRanges();
        } else {
            MinMax minMax2;
            MinMax minMax3 = minMax2 = this.getRanges().plus(new MinMax());
            MinMax minMax4 = this.getRanges();
            boolean bl = false;
            Iterable $this$forEach$iv = this.datasets;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LineDataset it = (LineDataset)element$iv;
                boolean bl2 = false;
                Iterable $this$forEach$iv2 = it.getData();
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    void $this$findMinMax_u24lambda_u240;
                    Coordinates p0 = (Coordinates)element$iv2;
                    boolean bl3 = false;
                    $this$findMinMax_u24lambda_u240.process(p0);
                }
            }
            minMax = minMax4.times(minMax2);
        }
        return minMax;
    }

    private final void paintDataset(D $this$paintDataset, Graphics2D g, MinMax<X, Y> xy) {
        Path2D.Double path = new Path2D.Double();
        Point2D.Double first = null;
        Rectangle bounds = g.getClipBounds();
        g.setPaint(((Dataset)$this$paintDataset).getLineColor());
        g.setStroke(((LineDataset)$this$paintDataset).getStroke());
        boolean useSplines = ((LineDataset)$this$paintDataset).getSmooth() && ((LineDataset)$this$paintDataset).getStepped() == LineStepped.NONE;
        int n = 0;
        double[] dArray = new double[8];
        while (n < 8) {
            int n2 = n++;
            dArray[n2] = Double.NaN;
        }
        double[] neighborhood = dArray;
        Iterable $this$forEachIndexed$iv = ((Dataset)$this$paintDataset).getData();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            int n3;
            if ((n3 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Coordinates coordinates = (Coordinates)item$iv;
            int i2 = n3;
            boolean bl = false;
            Object x = coordinates.component1();
            Object y = coordinates.component2();
            double px = this.findX(xy, x);
            double py = this.findY(xy, y);
            LineChartKt.access$shiftLeftByTwo(neighborhood, px, py);
            if (i2 == 0) {
                first = new Point2D.Double(px, py);
                path.moveTo(px, py);
                continue;
            }
            if (!useSplines) {
                switch (WhenMappings.$EnumSwitchMapping$0[((LineDataset)$this$paintDataset).getStepped().ordinal()]) {
                    case 1: {
                        path.lineTo(neighborhood[4], py);
                        break;
                    }
                    case 2: {
                        path.lineTo(px, neighborhood[5]);
                    }
                }
                path.lineTo(px, py);
                continue;
            }
            if (i2 <= 1) continue;
            LineChartKt.access$curveTo(path, neighborhood);
        }
        if (useSplines) {
            LineChartKt.access$shiftLeftByTwo(neighborhood, Double.NaN, Double.NaN);
            LineChartKt.access$curveTo(path, neighborhood);
        }
        g.setPaint(((Dataset)$this$paintDataset).getLineColor());
        g.setStroke(((LineDataset)$this$paintDataset).getStroke());
        g.draw(path);
        Point2D point2D = path.getCurrentPoint();
        if (point2D != null) {
            Point2D point2D2;
            Point2D last = point2D;
            boolean bl = false;
            path.lineTo(last.getX(), (double)bounds.height + 1.0);
            Point2D.Double double_ = first;
            if (double_ == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"first");
                point2D2 = null;
            } else {
                point2D2 = double_;
            }
            path.lineTo(point2D2.getX(), (double)bounds.height + 1.0);
            path.closePath();
        }
        Paint paint = ((Dataset)$this$paintDataset).getFillColor();
        if (paint != null) {
            Paint it = paint;
            boolean bl = false;
            g.setPaint(it);
            g.fill(path);
        }
        if (((LineDataset)$this$paintDataset).getStacked()) {
            Area area = new Area(g.getClip());
            area.subtract(new Area(path));
            g.setClip(area);
        }
    }

    @NotNull
    public final Point2D.Double findLocation(@NotNull MinMax<X, Y> xy, @NotNull Coordinates<X, Y> coordinates) {
        Intrinsics.checkNotNullParameter(xy, (String)"xy");
        Intrinsics.checkNotNullParameter(coordinates, (String)"coordinates");
        return new Point2D.Double(this.findX(xy, coordinates.getX()) + (double)this.getMargins().left, this.findY(xy, coordinates.getY()) + (double)this.getMargins().top);
    }

    public void add(@NotNull X x, @NotNull Y y) {
        block0: {
            Intrinsics.checkNotNullParameter(x, (String)"x");
            Intrinsics.checkNotNullParameter(y, (String)"y");
            LineDataset lineDataset = (LineDataset)CollectionsKt.firstOrNull(this.datasets);
            if (lineDataset == null) break block0;
            Coordinates[] coordinatesArray = new Coordinates[]{ChartWrapperKt.to(x, y)};
            lineDataset.add(coordinatesArray);
        }
    }

    @NotNull
    public final D getDataset() {
        return (D)((LineDataset)CollectionsKt.first(this.datasets));
    }

    @JvmName(name="getDataset")
    @NotNull
    public final LineDataset<X, Y> getDataset(@NotNull String label2) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)label2, (String)"label");
            Iterable iterable = this.datasets;
            for (Object t : iterable) {
                LineDataset it = (LineDataset)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getLabel(), (Object)label2)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        LineDataset lineDataset = v0;
        if (lineDataset == null) {
            throw new NoSuchElementException("Cannot find dataset with label " + this.datasets);
        }
        return lineDataset;
    }

    public final void clear() {
        Iterable $this$forEach$iv = this.datasets;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LineDataset it = (LineDataset)element$iv;
            boolean bl = false;
            Iterable iterable = it.getData();
            Intrinsics.checkNotNull(iterable, (String)"null cannot be cast to non-null type kotlin.collections.MutableList<com.intellij.ui.charts.Coordinates<X of com.intellij.ui.charts.LineChart, Y of com.intellij.ui.charts.LineChart>>");
            TypeIntrinsics.asMutableList(iterable).clear();
        }
    }

    @JvmStatic
    @NotNull
    public static final <T extends Number, D extends CategoryLineDataset<T>> CategoryLineChart<T> of(D ... values2) {
        return Companion.of((CategoryLineDataset[])values2);
    }

    @JvmStatic
    @NotNull
    public static final <X extends Number, Y extends Number, D extends XYLineDataset<X, Y>> XYLineChart<X, Y> of(D ... values2) {
        return Companion.of((XYLineDataset[])values2);
    }

    @JvmStatic
    @NotNull
    public static final <T extends Number> CategoryLineChart<T> of(T ... values2) {
        return Companion.of((Number[])values2);
    }

    @JvmStatic
    @NotNull
    public static final <X extends Number, Y extends Number> XYLineChart<X, Y> of(Coordinates<X, Y> ... points) {
        return Companion.of(points);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JA\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\b\b\u0003\u0010\u0006*\u00020\u0007\"\u000e\b\u0004\u0010\b*\b\u0012\u0004\u0012\u0002H\u00060\t2\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\b0\u000b\"\u0002H\bH\u0007\u00a2\u0006\u0002\u0010\fJW\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u0002H\u000e\u0012\u0004\u0012\u0002H\u000f0\r\"\b\b\u0003\u0010\u000e*\u00020\u0007\"\b\b\u0004\u0010\u000f*\u00020\u0007\"\u0014\b\u0005\u0010\b*\u000e\u0012\u0004\u0012\u0002H\u000e\u0012\u0004\u0012\u0002H\u000f0\u00102\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\b0\u000b\"\u0002H\bH\u0007\u00a2\u0006\u0002\u0010\u0011J1\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\b\b\u0003\u0010\u0006*\u00020\u00072\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00060\u000b\"\u0002H\u0006H\u0007\u00a2\u0006\u0002\u0010\u0012JY\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u0002H\u000e\u0012\u0004\u0012\u0002H\u000f0\r\"\b\b\u0003\u0010\u000e*\u00020\u0007\"\b\b\u0004\u0010\u000f*\u00020\u00072*\u0010\u0013\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u0002H\u000e\u0012\u0004\u0012\u0002H\u000f0\u00140\u000b\"\u000e\u0012\u0004\u0012\u0002H\u000e\u0012\u0004\u0012\u0002H\u000f0\u0014H\u0007\u00a2\u0006\u0002\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lcom/intellij/ui/charts/LineChart$Companion;", "", "<init>", "()V", "of", "Lcom/intellij/ui/charts/CategoryLineChart;", "T", "", "D", "Lcom/intellij/ui/charts/CategoryLineDataset;", "values", "", "([Lcom/intellij/ui/charts/CategoryLineDataset;)Lcom/intellij/ui/charts/CategoryLineChart;", "Lcom/intellij/ui/charts/XYLineChart;", "X", "Y", "Lcom/intellij/ui/charts/XYLineDataset;", "([Lcom/intellij/ui/charts/XYLineDataset;)Lcom/intellij/ui/charts/XYLineChart;", "([Ljava/lang/Number;)Lcom/intellij/ui/charts/CategoryLineChart;", "points", "Lcom/intellij/ui/charts/Coordinates;", "([Lcom/intellij/ui/charts/Coordinates;)Lcom/intellij/ui/charts/XYLineChart;", "intellij.platform.ide.ui"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final <T extends Number, D extends CategoryLineDataset<T>> CategoryLineChart<T> of(D ... values2) {
            CategoryLineChart categoryLineChart;
            Intrinsics.checkNotNullParameter(values2, (String)"values");
            CategoryLineChart $this$of_u24lambda_u240 = categoryLineChart = new CategoryLineChart();
            boolean bl = false;
            $this$of_u24lambda_u240.setDatasets(CollectionsKt.mutableListOf((Object[])Arrays.copyOf(values2, values2.length)));
            return categoryLineChart;
        }

        @JvmStatic
        @NotNull
        public final <X extends Number, Y extends Number, D extends XYLineDataset<X, Y>> XYLineChart<X, Y> of(D ... values2) {
            XYLineChart xYLineChart;
            Intrinsics.checkNotNullParameter(values2, (String)"values");
            XYLineChart $this$of_u24lambda_u241 = xYLineChart = new XYLineChart();
            boolean bl = false;
            $this$of_u24lambda_u241.setDatasets(CollectionsKt.mutableListOf((Object[])Arrays.copyOf(values2, values2.length)));
            return xYLineChart;
        }

        @JvmStatic
        @NotNull
        public final <T extends Number> CategoryLineChart<T> of(T ... values2) {
            CategoryLineChart categoryLineChart;
            Intrinsics.checkNotNullParameter(values2, (String)"values");
            CategoryLineChart $this$of_u24lambda_u242 = categoryLineChart = new CategoryLineChart();
            boolean bl = false;
            Object[] objectArray = new CategoryLineDataset[]{LineDataset.Companion.of((Number[])Arrays.copyOf(values2, values2.length))};
            $this$of_u24lambda_u242.setDatasets(CollectionsKt.mutableListOf((Object[])objectArray));
            return categoryLineChart;
        }

        @JvmStatic
        @NotNull
        public final <X extends Number, Y extends Number> XYLineChart<X, Y> of(Coordinates<X, Y> ... points) {
            XYLineChart xYLineChart;
            Intrinsics.checkNotNullParameter(points, (String)"points");
            XYLineChart $this$of_u24lambda_u243 = xYLineChart = new XYLineChart();
            boolean bl = false;
            Object[] objectArray = new XYLineDataset[]{LineDataset.Companion.of(Arrays.copyOf(points, points.length))};
            $this$of_u24lambda_u243.setDatasets(CollectionsKt.mutableListOf((Object[])objectArray));
            return xYLineChart;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LineStepped.values().length];
            try {
                nArray[LineStepped.AFTER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LineStepped.BEFORE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

