/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.Consumer;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SliderSelectorAction
extends DumbAwareAction {
    @NotNull
    private final Configuration myConfiguration;

    public SliderSelectorAction(@Nullable @NlsActions.ActionText String text2, @Nullable @NlsActions.ActionDescription String description, @Nullable Icon icon2, @NotNull Configuration configuration) {
        if (configuration == null) {
            SliderSelectorAction.$$$reportNull$$$0(0);
        }
        super(text2, description, icon2);
        this.myConfiguration = configuration;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            SliderSelectorAction.$$$reportNull$$$0(1);
        }
        super.update(e);
        String tooltip = this.myConfiguration.getTooltip();
        if (tooltip != null) {
            e.getPresentation().setText(this.getTemplatePresentation().getText() + " (" + tooltip + ")");
            e.getPresentation().setDescription(this.getTemplatePresentation().getDescription() + " (" + tooltip + ")");
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            SliderSelectorAction.$$$reportNull$$$0(2);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            SliderSelectorAction.$$$reportNull$$$0(3);
        }
        JPanel result2 = new JPanel(new BorderLayout());
        JLabel label2 = new JLabel(this.myConfiguration.getSelectText());
        label2.setBorder(BorderFactory.createEmptyBorder(4, 4, 0, 0));
        JPanel wrapper2 = new JPanel(new BorderLayout());
        wrapper2.add((Component)label2, "North");
        final Map<Integer, JLabel> map2 = this.myConfiguration.getDictionary();
        JSlider slider = new JSlider(0, this.myConfiguration.getMin(), this.myConfiguration.getMax(), this.myConfiguration.getSelected()){
            Integer myWidth;
            {
                super(arg0, arg1, arg2, arg3);
                this.myWidth = null;
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension size2 = super.getPreferredSize();
                if (this.myWidth == null) {
                    this.myWidth = 10;
                    FontMetrics fm = this.getFontMetrics(this.getFont());
                    for (JLabel confLabel : map2.values()) {
                        String text2 = confLabel.getText();
                        this.myWidth = this.myWidth + fm.stringWidth(text2 + "W");
                    }
                }
                return new Dimension(this.myWidth, size2.height);
            }
        };
        slider.setMinorTickSpacing(1);
        slider.setPaintTicks(true);
        slider.setPaintTrack(true);
        slider.setSnapToTicks(true);
        UIUtil.setSliderIsFilled((JSlider)slider, (boolean)true);
        slider.setPaintLabels(true);
        slider.setLabelTable(new Hashtable<Integer, JLabel>(map2));
        result2.add((Component)wrapper2, "West");
        result2.add((Component)slider, "Center");
        final Runnable saveSelection = () -> {
            int value = slider.getModel().getValue();
            this.myConfiguration.getResultConsumer().consume((Object)value);
        };
        final Ref popupRef = new Ref(null);
        final JBPopup popup2 = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)result2, (JComponent)slider).setMovable(true).setCancelOnWindowDeactivation(true).setCancelKeyEnabled(this.myConfiguration.isShowOk()).setKeyboardActions(Collections.singletonList(Pair.create((Object)new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                saveSelection.run();
                ((JBPopup)popupRef.get()).closeOk(null);
            }
        }, (Object)KeyStroke.getKeyStroke(10, 0)))).createPopup();
        popupRef.set((Object)popup2);
        if (this.myConfiguration.isShowOk()) {
            JButton done = new JButton(IdeBundle.message((String)"button.done", (Object[])new Object[0]));
            JBPanel doneWrapper = new JBPanel((LayoutManager)new BorderLayout());
            doneWrapper.add((Component)done, (Object)"North");
            result2.add((Component)doneWrapper, "East");
            done.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    saveSelection.run();
                    popup2.closeOk(null);
                }
            });
        } else {
            popup2.setFinalRunnable(saveSelection);
        }
        InputEvent inputEvent = e.getInputEvent();
        this.show(e, result2, popup2, inputEvent);
    }

    protected void show(AnActionEvent e, JPanel result2, JBPopup popup2, InputEvent inputEvent) {
        if (inputEvent instanceof MouseEvent) {
            MouseEvent inputEvent1 = (MouseEvent)inputEvent;
            int width = result2.getPreferredSize().width;
            Point point1 = new Point(inputEvent1.getX() - width / 2, inputEvent1.getY());
            RelativePoint point = new RelativePoint(inputEvent1.getComponent(), point1);
            popup2.show(point);
        } else {
            popup2.showInBestPositionFor(e.getDataContext());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/components/SliderSelectorAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/components/SliderSelectorAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    public static class Configuration {
        @NotNull
        @Nls
        private final String mySelectText;
        @NotNull
        private final Map<Integer, JLabel> myDictionary;
        private final int mySelected;
        private final int myMin;
        private final int myMax;
        @NotNull
        private final Consumer<? super Integer> myResultConsumer;
        private boolean showOk;

        public Configuration(int selected, @NotNull Dictionary<Integer, @Nls String> dictionary, @NotNull @Nls String selectText, @NotNull Consumer<? super Integer> consumer) {
            if (dictionary == null) {
                Configuration.$$$reportNull$$$0(0);
            }
            if (selectText == null) {
                Configuration.$$$reportNull$$$0(1);
            }
            if (consumer == null) {
                Configuration.$$$reportNull$$$0(2);
            }
            this.showOk = false;
            this.mySelected = selected;
            this.myDictionary = new HashMap<Integer, JLabel>();
            this.mySelectText = selectText;
            this.myResultConsumer = consumer;
            int min = 1;
            int max = 0;
            Enumeration<Integer> keys = dictionary.keys();
            while (keys.hasMoreElements()) {
                Integer key = keys.nextElement();
                String value = dictionary.get(key);
                this.myDictionary.put(key, Configuration.markLabel(value));
                min = Math.min(min, key);
                max = Math.max(max, key);
            }
            this.myMin = min;
            this.myMax = max;
        }

        private static JLabel markLabel(@Nls String text2) {
            JLabel label2 = new JLabel(text2);
            label2.setFont(StartupUiUtil.getLabelFont());
            return label2;
        }

        @NotNull
        @Nls
        public String getSelectText() {
            String string = this.mySelectText;
            if (string == null) {
                Configuration.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        public Map<Integer, JLabel> getDictionary() {
            Map<Integer, JLabel> map2 = this.myDictionary;
            if (map2 == null) {
                Configuration.$$$reportNull$$$0(4);
            }
            return map2;
        }

        @NotNull
        public Consumer<? super Integer> getResultConsumer() {
            Consumer<? super Integer> consumer = this.myResultConsumer;
            if (consumer == null) {
                Configuration.$$$reportNull$$$0(5);
            }
            return consumer;
        }

        public int getSelected() {
            return this.mySelected;
        }

        public int getMin() {
            return this.myMin;
        }

        public int getMax() {
            return this.myMax;
        }

        public boolean isShowOk() {
            return this.showOk;
        }

        public void setShowOk(boolean showOk) {
            this.showOk = showOk;
        }

        @NlsContexts.Tooltip
        public String getTooltip() {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dictionary";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectText";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/components/SliderSelectorAction$Configuration";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/components/SliderSelectorAction$Configuration";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSelectText";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDictionary";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResultConsumer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5 -> new IllegalStateException(string);
            };
        }
    }
}

