/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components.impl;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.intellij.lang.documentation.DocumentationSettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.components.JBHtmlPaneStyleConfiguration;
import com.intellij.ui.components.impl.EditorColorsSchemeSnapshot;
import com.intellij.ui.components.impl.JBHtmlPaneStyleConfigurationSnapshot;
import com.intellij.ui.components.impl.JBHtmlPaneStyleSheetRulesProvider;
import com.intellij.util.containers.UtilKt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StyleSheetUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.UIManager;
import javax.swing.text.html.StyleSheet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0001\u0018\u0000 \"2\u00020\u0001:\u0003\"#$B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0002J4\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u00192\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u001aH\u0002J,\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\f\u001a\u00020\u001a2\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u00192\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J,\u0010 \u001a\u00020\u001c2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u001a2\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u0019H\u0002J,\u0010!\u001a\u00020\u001c2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u001a2\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u0019H\u0002R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00050\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/ui/components/impl/JBHtmlPaneStyleSheetRulesProvider;", "", "<init>", "()V", "getStyleSheet", "Ljavax/swing/text/html/StyleSheet;", "paneBackgroundColor", "Ljava/awt/Color;", "scaleFactor", "", "baseFontSize", "", "configuration", "Lcom/intellij/ui/components/JBHtmlPaneStyleConfiguration;", "invalidateCache", "", "inlineCodeStyling", "Lcom/intellij/ui/components/impl/JBHtmlPaneStyleSheetRulesProvider$ControlColorStyleBuilder;", "blockCodeStyling", "shortcutStyling", "styleSheetCache", "Lcom/github/benmanes/caffeine/cache/LoadingCache;", "Lcom/intellij/ui/components/impl/JBHtmlPaneStyleSheetRulesProvider$JBHtmlPaneStylesheetParameters;", "buildStyleSheet", "scale", "Lkotlin/Function1;", "Lcom/intellij/ui/components/impl/JBHtmlPaneStyleConfigurationSnapshot;", "getDefaultFormattingStyles", "", "getMonospaceFontSizeCorrection", "inlineCode", "", "getShortcutRules", "getCodeRules", "Companion", "JBHtmlPaneStylesheetParameters", "ControlColorStyleBuilder", "intellij.platform.ide.impl"})
public final class JBHtmlPaneStyleSheetRulesProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ControlColorStyleBuilder inlineCodeStyling;
    @NotNull
    private final ControlColorStyleBuilder blockCodeStyling;
    @NotNull
    private final ControlColorStyleBuilder shortcutStyling;
    @NotNull
    private final LoadingCache<JBHtmlPaneStylesheetParameters, StyleSheet> styleSheetCache;

    public JBHtmlPaneStyleSheetRulesProvider() {
        MessageBusConnection messageBus = ApplicationManager.getApplication().getMessageBus().connect();
        Topic topic = ProjectManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBus.subscribe(topic, (Object)new ProjectManagerListener(){

            public void projectClosed(Project project2) {
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                this.invalidateCache();
            }
        });
        EditorFactory.getInstance().addEditorFactoryListener(new EditorFactoryListener(){

            public void editorReleased(EditorFactoryEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.invalidateCache();
            }
        }, (Disposable)messageBus);
        Topic topic2 = EditorColorsManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic2, (String)"TOPIC");
        messageBus.subscribe(topic2, (Object)new EditorColorsListener(){

            public void globalSchemeChange(EditorColorsScheme scheme) {
                this.invalidateCache();
            }
        });
        this.inlineCodeStyling = new ControlColorStyleBuilder(JBHtmlPaneStyleConfiguration.ElementKind.CodeInline, new Color(5922155), 10, null, null, 0, 10, false, true, false, 696, null);
        JBHtmlPaneStyleConfiguration.ElementKind elementKind = JBHtmlPaneStyleConfiguration.ElementKind.CodeBlock;
        Color color = new Color(15461616);
        this.blockCodeStyling = new ControlColorStyleBuilder(elementKind, null, 0, null, color, 1, 10, true, true, false, 526, null);
        elementKind = JBHtmlPaneStyleConfiguration.ElementKind.Shortcut;
        color = new Color(11054525);
        this.shortcutStyling = new ControlColorStyleBuilder(elementKind, null, 0, null, color, 1, 7, false, true, true, 142, null);
        LoadingCache loadingCache = Caffeine.newBuilder().maximumSize(20L).build(new CacheLoader(this){
            final /* synthetic */ JBHtmlPaneStyleSheetRulesProvider this$0;
            {
                this.this$0 = $receiver;
            }

            public final StyleSheet load(JBHtmlPaneStylesheetParameters jBHtmlPaneStylesheetParameters) {
                Intrinsics.checkNotNullParameter((Object)jBHtmlPaneStylesheetParameters, (String)"<destruct>");
                int bgColor = jBHtmlPaneStylesheetParameters.component1();
                float scaleFactor = jBHtmlPaneStylesheetParameters.component2();
                int baseFontSize = jBHtmlPaneStylesheetParameters.component3();
                JBHtmlPaneStyleConfigurationSnapshot configuration = jBHtmlPaneStylesheetParameters.component4();
                return JBHtmlPaneStyleSheetRulesProvider.access$buildStyleSheet(this.this$0, new Color(bgColor), arg_0 -> styleSheetCache.1.load$lambda$0(scaleFactor, arg_0), baseFontSize, configuration);
            }

            private static final int load$lambda$0(float $scaleFactor, int it) {
                return MathKt.roundToInt((float)((float)it * $scaleFactor));
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)loadingCache, (String)"build(...)");
        this.styleSheetCache = loadingCache;
    }

    @NotNull
    public final StyleSheet getStyleSheet(@NotNull Color paneBackgroundColor, float scaleFactor, int baseFontSize, @NotNull JBHtmlPaneStyleConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)paneBackgroundColor, (String)"paneBackgroundColor");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Object object = this.styleSheetCache.get((Object)new JBHtmlPaneStylesheetParameters(paneBackgroundColor.getRGB() & 0xFFFFFF, scaleFactor, baseFontSize, new JBHtmlPaneStyleConfigurationSnapshot(configuration)));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (StyleSheet)object;
    }

    private final void invalidateCache() {
        this.styleSheetCache.invalidateAll();
    }

    private final StyleSheet buildStyleSheet(Color paneBackgroundColor, Function1<? super Integer, Integer> scale, int baseFontSize, JBHtmlPaneStyleConfigurationSnapshot configuration) {
        Object[] objectArray = new String[]{this.getDefaultFormattingStyles(configuration, scale, baseFontSize), this.getCodeRules(paneBackgroundColor, configuration, scale), this.getShortcutRules(paneBackgroundColor, configuration, scale)};
        return StyleSheetUtil.loadStyleSheet((String)SequencesKt.joinToString$default((Sequence)SequencesKt.sequenceOf((Object[])objectArray), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
    }

    private final String getDefaultFormattingStyles(JBHtmlPaneStyleConfigurationSnapshot configuration, Function1<? super Integer, Integer> scale, int baseFontSize) {
        int spacingBefore = ((Number)scale.invoke((Object)configuration.getSpaceBeforeParagraph())).intValue();
        int spacingAfter = ((Number)scale.invoke((Object)configuration.getSpaceAfterParagraph())).intValue();
        String string = ColorUtil.toHtmlColor((Color)JBUI.CurrentTheme.Tooltip.separatorColor());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toHtmlColor(...)");
        String hrColor = string;
        String string2 = ColorUtil.toHtmlColor((Color)JBUI.CurrentTheme.Tooltip.grayedForeground());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toHtmlColor(...)");
        String grayedForeground = string2;
        String paragraphSpacing = "padding: " + spacingBefore + "px 0 " + spacingAfter + "px 0";
        String styles = StringsKt.trimIndent((String)("\n      body, p, p-implied, li, ol, ul, th, tr, td, table { font-size: " + scale.invoke((Object)baseFontSize) + " }\n      h6 { font-size: " + scale.invoke((Object)(baseFontSize + 1)) + " }\n      h5 { font-size: " + scale.invoke((Object)(baseFontSize + 2)) + " }\n      h4 { font-size: " + scale.invoke((Object)(baseFontSize + 3)) + " }\n      h3 { font-size: " + scale.invoke((Object)(baseFontSize + 4)) + " }\n      h2 { font-size: " + scale.invoke((Object)(baseFontSize + 6)) + " }\n      h1 { font-size: " + scale.invoke((Object)(baseFontSize + 8)) + " }\n      h1, h2, h3, h4, h5, h6 {margin: " + scale.invoke((Object)4) + "px 0 0 0; " + paragraphSpacing + "; }\n      p { margin: 0 0 0 0; " + paragraphSpacing + "; line-height: 125%; }\n      ul { margin: 0 0 0 " + scale.invoke((Object)10) + "px; " + paragraphSpacing + ";}\n      ol { margin: 0 0 0 " + scale.invoke((Object)20) + "px; " + paragraphSpacing + ";}\n      li { padding: " + scale.invoke((Object)4) + "px 0 " + scale.invoke((Object)2) + "px 0; }\n      details { margin: " + spacingBefore + "px 0 0 0; }\n      summary { margin: 0 0 " + spacingBefore + "px 0; }\n      details p { margin: 0 0 0 " + scale.invoke((Object)10) + "px; }\n      li p, li p-implied { padding-top: 0; padding-bottom: 0; line-height: 125%; }\n      th { text-align: left; }\n      tr, table { margin: 0 0 0 0; padding: 0 0 0 0; }\n      td { margin: 0 0 0 0; padding: " + spacingBefore + "px " + (spacingBefore + spacingAfter) + "px " + spacingAfter + "px 0; }\n      td p { padding-top: 0; padding-bottom: 0; }\n      td pre { padding: " + scale.invoke((Object)1) + "px 0 0 0; margin: 0 0 0 0 }\n      blockquote { \n          padding: 0 0 0 " + scale.invoke((Object)10) + "px; \n          border-left: " + grayedForeground + " solid " + scale.invoke((Object)2) + "px;\n          margin: " + spacingBefore + "px 0 " + spacingAfter + "px 0;\n      }\n      blockquote p { border: none; }\n      .centered { text-align: center }\n      .grayed { color: " + grayedForeground + "}\n      hr { \n         padding: " + scale.invoke((Object)1) + "px 0 0 0; \n         margin: " + spacingBefore + " 0 " + spacingAfter + "px 0; \n         border-bottom: " + scale.invoke((Object)1) + "px solid " + hrColor + "; \n         width: 100%;\n      }\n      p hr {\n         margin: " + (spacingAfter + spacingBefore) + " 0 " + (spacingAfter + spacingBefore) + "px 0; \n      }\n    "));
        return styles;
    }

    private final int getMonospaceFontSizeCorrection(boolean inlineCode) {
        return DocumentationSettings.getMonospaceFontSizeCorrection((boolean)inlineCode);
    }

    private final String getShortcutRules(Color paneBackgroundColor, JBHtmlPaneStyleConfigurationSnapshot configuration, Function1<? super Integer, Integer> scale) {
        String fontName = configuration.getUseFontLigaturesInCode() ? "_EditorFont_" : "_EditorFontNoLigatures_";
        int contentCodeFontSizePercent = this.getMonospaceFontSizeCorrection(true);
        String result2 = StringsKt.trimIndent((String)("\n      kbd { \n        font-size: " + contentCodeFontSizePercent + "%; \n        font-family:\"" + fontName + "\"; \n        padding: " + scale.invoke((Object)1) + "px " + scale.invoke((Object)6) + "px; \n        margin: " + scale.invoke((Object)1) + "px 0px;\n        " + this.shortcutStyling.getCssStyle(paneBackgroundColor, configuration, scale) + "\n      }\n      "));
        return result2;
    }

    private final String getCodeRules(Color paneBackgroundColor, JBHtmlPaneStyleConfigurationSnapshot configuration, Function1<? super Integer, Integer> scale) {
        List result2 = new ArrayList();
        int spacingBefore = ((Number)scale.invoke((Object)configuration.getSpaceBeforeParagraph())).intValue();
        int spacingAfter = ((Number)scale.invoke((Object)configuration.getSpaceAfterParagraph())).intValue();
        int definitionCodeFontSizePercent = this.getMonospaceFontSizeCorrection(false);
        int contentCodeFontSizePercent = this.getMonospaceFontSizeCorrection(true);
        String fontName = configuration.getUseFontLigaturesInCode() ? "_EditorFont_" : "_EditorFontNoLigatures_";
        Object[] objectArray = new String[]{"tt, code, samp, pre, .pre { font-family:\"" + fontName + "\"; font-size:" + contentCodeFontSizePercent + "%; }"};
        UtilKt.addAllIfNotNull((List)result2, (Object[])objectArray);
        result2.add("samp { font-weight: bold }");
        if (!((Collection)configuration.getLargeCodeFontSizeSelectors()).isEmpty()) {
            result2.add(CollectionsKt.joinToString$default((Iterable)configuration.getLargeCodeFontSizeSelectors(), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + " { font-size: " + definitionCodeFontSizePercent + "% }");
        }
        if (configuration.getEnableInlineCodeBackground()) {
            String selectors = SequencesKt.joinToString$default((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)configuration.getInlineCodeParentSelectors()), JBHtmlPaneStyleSheetRulesProvider::getCodeRules$lambda$0), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
            result2.add(selectors + " { " + this.inlineCodeStyling.getCssStyle(paneBackgroundColor, configuration, scale) + " }");
            result2.add(selectors + " { padding: " + scale.invoke((Object)1) + "px " + scale.invoke((Object)4) + "px; margin: " + scale.invoke((Object)1) + "px 0px; }");
        }
        if (configuration.getEnableCodeBlocksBackground()) {
            ControlColorStyleBuilder blockCodeStyling = configuration.getEditorInlineContext() ? ControlColorStyleBuilder.copy$default(this.blockCodeStyling, null, new Color(5922155), 4, null, null, 0, 0, false, false, false, 1017, null) : this.blockCodeStyling;
            result2.add("div.code-block { " + blockCodeStyling.getCssStyle(paneBackgroundColor, configuration, scale) + " }");
            result2.add("div.code-block { margin: " + spacingBefore + "px 0 " + spacingAfter + "px 0; padding: " + scale.invoke((Object)10) + "px " + scale.invoke((Object)13) + "px " + scale.invoke((Object)10) + "px " + scale.invoke((Object)13) + "px; }");
            result2.add("div.code-block pre { padding: 0px; margin: 0px; line-height: 120%; }");
        }
        return CollectionsKt.joinToString$default((Iterable)result2, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    private static final String getCodeRules$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it + " code";
    }

    public static final /* synthetic */ StyleSheet access$buildStyleSheet(JBHtmlPaneStyleSheetRulesProvider $this, Color paneBackgroundColor, Function1 scale, int baseFontSize, JBHtmlPaneStyleConfigurationSnapshot configuration) {
        return $this.buildStyleSheet(paneBackgroundColor, (Function1<? super Integer, Integer>)scale, baseFontSize, configuration);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0000\u00a2\u0006\u0002\b\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ui/components/impl/JBHtmlPaneStyleSheetRulesProvider$Companion;", "", "<init>", "()V", "buildCodeBlock", "Lorg/jsoup/nodes/Element;", "childNodes", "", "Lorg/jsoup/nodes/Node;", "buildCodeBlock$intellij_platform_ide_impl", "toHtmlColor", "", "color", "Ljava/awt/Color;", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Element buildCodeBlock$intellij_platform_ide_impl(@NotNull List<? extends Node> childNodes) {
            Intrinsics.checkNotNullParameter(childNodes, (String)"childNodes");
            Element element = new Element("div").addClass("code-block").appendChild((Node)new Element("pre").attr("style", "padding: 0px; margin: 0px").insertChildren(0, (Collection)childNodes));
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"appendChild(...)");
            return element;
        }

        private final String toHtmlColor(Color color) {
            String string = ColorUtil.toHex((Color)color);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toHex(...)");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0013\b\u0082\b\u0018\u00002\u00020\u0001Bo\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\n\u001a\u00020\u0007\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\r\u0012\b\b\u0002\u0010\u000f\u001a\u00020\r\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0012\u0010 \u001a\u0004\u0018\u00010\u00052\u0006\u0010!\u001a\u00020\"H\u0002J\u0012\u0010#\u001a\u0004\u0018\u00010\u00052\u0006\u0010!\u001a\u00020\"H\u0002J\u0012\u0010$\u001a\u0004\u0018\u00010\u00052\u0006\u0010!\u001a\u00020\"H\u0002J\u0017\u0010%\u001a\u0004\u0018\u00010\u00072\u0006\u0010!\u001a\u00020\"H\u0002\u00a2\u0006\u0002\u0010&J\u0017\u0010'\u001a\u0004\u0018\u00010\u00072\u0006\u0010!\u001a\u00020\"H\u0002\u00a2\u0006\u0002\u0010&J\u0017\u0010(\u001a\u0004\u0018\u00010\u00072\u0006\u0010!\u001a\u00020\"H\u0002\u00a2\u0006\u0002\u0010&J*\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u00052\u0006\u0010!\u001a\u00020\"2\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070-J9\u0010.\u001a\u0004\u0018\u0001H/\"\b\b\u0000\u0010/*\u00020\u00012\b\u00100\u001a\u0004\u0018\u0001H/2\b\u00101\u001a\u0004\u0018\u0001H/2\n\b\u0002\u00102\u001a\u0004\u0018\u0001H/H\u0002\u00a2\u0006\u0002\u00103JS\u00104\u001a\u000205\"\b\b\u0000\u0010/*\u00020\u0001*\u000606j\u0002`72\b\u00100\u001a\u0004\u0018\u0001H/2\b\u00101\u001a\u0004\u0018\u0001H/2\n\b\u0002\u00102\u001a\u0004\u0018\u0001H/2\u0012\u00108\u001a\u000e\u0012\u0004\u0012\u0002H/\u0012\u0004\u0012\u00020*0-H\u0002\u00a2\u0006\u0002\u00109J \u0010:\u001a\u00020\u00052\u0006\u0010;\u001a\u00020\u00052\u0006\u0010<\u001a\u00020\u00052\u0006\u0010=\u001a\u00020\u0007H\u0002J\u001a\u0010>\u001a\u0004\u0018\u00010\u00052\u0006\u0010!\u001a\u00020\"2\u0006\u0010?\u001a\u00020@H\u0002J\u001f\u0010A\u001a\u0004\u0018\u00010\u00072\u0006\u0010!\u001a\u00020\"2\u0006\u0010?\u001a\u00020@H\u0002\u00a2\u0006\u0002\u0010BJ\u0018\u0010C\u001a\u00020*2\u0006\u0010!\u001a\u00020\"2\u0006\u0010?\u001a\u00020@H\u0002J\t\u0010D\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010E\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010F\u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010G\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010H\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010I\u001a\u00020\u0007H\u00c6\u0003J\t\u0010J\u001a\u00020\u0007H\u00c6\u0003J\t\u0010K\u001a\u00020\rH\u00c6\u0003J\t\u0010L\u001a\u00020\rH\u00c6\u0003J\t\u0010M\u001a\u00020\rH\u00c6\u0003Js\u0010N\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\n\u001a\u00020\u00072\b\b\u0002\u0010\u000b\u001a\u00020\u00072\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\r2\b\b\u0002\u0010\u000f\u001a\u00020\rH\u00c6\u0001J\u0014\u0010O\u001a\u00020\r2\b\u0010P\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010Q\u001a\u00020\u0007H\u00d6\u0081\u0004J\n\u0010R\u001a\u00020*H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0013\u0010\b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0015R\u0013\u0010\t\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0015R\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0017R\u0011\u0010\u000b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0017R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u000e\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001dR\u0011\u0010\u000f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001d\u00a8\u0006S"}, d2={"Lcom/intellij/ui/components/impl/JBHtmlPaneStyleSheetRulesProvider$ControlColorStyleBuilder;", "", "elementKind", "Lcom/intellij/ui/components/JBHtmlPaneStyleConfiguration$ElementKind;", "defaultBackgroundColor", "Ljava/awt/Color;", "defaultBackgroundOpacity", "", "defaultForegroundColor", "defaultBorderColor", "defaultBorderWidth", "defaultBorderRadius", "fallbackToEditorBackground", "", "fallbackToEditorForeground", "fallbackToEditorBorder", "<init>", "(Lcom/intellij/ui/components/JBHtmlPaneStyleConfiguration$ElementKind;Ljava/awt/Color;ILjava/awt/Color;Ljava/awt/Color;IIZZZ)V", "getElementKind", "()Lcom/intellij/ui/components/JBHtmlPaneStyleConfiguration$ElementKind;", "getDefaultBackgroundColor", "()Ljava/awt/Color;", "getDefaultBackgroundOpacity", "()I", "getDefaultForegroundColor", "getDefaultBorderColor", "getDefaultBorderWidth", "getDefaultBorderRadius", "getFallbackToEditorBackground", "()Z", "getFallbackToEditorForeground", "getFallbackToEditorBorder", "getBackgroundColor", "configuration", "Lcom/intellij/ui/components/impl/JBHtmlPaneStyleConfigurationSnapshot;", "getForegroundColor", "getBorderColor", "getBackgroundOpacity", "(Lcom/intellij/ui/components/impl/JBHtmlPaneStyleConfigurationSnapshot;)Ljava/lang/Integer;", "getBorderWidth", "getBorderRadius", "getCssStyle", "", "editorPaneBackgroundColor", "scale", "Lkotlin/Function1;", "choose", "T", "themeVersion", "defaultVersion", "editorVersion", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "append", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "mapper", "(Ljava/lang/StringBuilder;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)V", "mixColors", "c1", "c2", "opacity2", "getColor", "property", "Lcom/intellij/ui/components/JBHtmlPaneStyleConfiguration$ElementProperty;", "getInt", "(Lcom/intellij/ui/components/impl/JBHtmlPaneStyleConfigurationSnapshot;Lcom/intellij/ui/components/JBHtmlPaneStyleConfiguration$ElementProperty;)Ljava/lang/Integer;", "getKey", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "component10", "copy", "equals", "other", "hashCode", "toString", "intellij.platform.ide.impl"})
    @SourceDebugExtension(value={"SMAP\nJBHtmlPaneStyleSheetRulesProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JBHtmlPaneStyleSheetRulesProvider.kt\ncom/intellij/ui/components/impl/JBHtmlPaneStyleSheetRulesProvider$ControlColorStyleBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,450:1\n1#2:451\n*E\n"})
    private static final class ControlColorStyleBuilder {
        @NotNull
        private final JBHtmlPaneStyleConfiguration.ElementKind elementKind;
        @Nullable
        private final Color defaultBackgroundColor;
        private final int defaultBackgroundOpacity;
        @Nullable
        private final Color defaultForegroundColor;
        @Nullable
        private final Color defaultBorderColor;
        private final int defaultBorderWidth;
        private final int defaultBorderRadius;
        private final boolean fallbackToEditorBackground;
        private final boolean fallbackToEditorForeground;
        private final boolean fallbackToEditorBorder;

        public ControlColorStyleBuilder(@NotNull JBHtmlPaneStyleConfiguration.ElementKind elementKind, @Nullable Color defaultBackgroundColor, int defaultBackgroundOpacity, @Nullable Color defaultForegroundColor, @Nullable Color defaultBorderColor, int defaultBorderWidth, int defaultBorderRadius, boolean fallbackToEditorBackground, boolean fallbackToEditorForeground, boolean fallbackToEditorBorder) {
            Intrinsics.checkNotNullParameter((Object)elementKind, (String)"elementKind");
            this.elementKind = elementKind;
            this.defaultBackgroundColor = defaultBackgroundColor;
            this.defaultBackgroundOpacity = defaultBackgroundOpacity;
            this.defaultForegroundColor = defaultForegroundColor;
            this.defaultBorderColor = defaultBorderColor;
            this.defaultBorderWidth = defaultBorderWidth;
            this.defaultBorderRadius = defaultBorderRadius;
            this.fallbackToEditorBackground = fallbackToEditorBackground;
            this.fallbackToEditorForeground = fallbackToEditorForeground;
            this.fallbackToEditorBorder = fallbackToEditorBorder;
        }

        public /* synthetic */ ControlColorStyleBuilder(JBHtmlPaneStyleConfiguration.ElementKind elementKind, Color color, int n, Color color2, Color color3, int n2, int n3, boolean bl, boolean bl2, boolean bl3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n4 & 2) != 0) {
                color = null;
            }
            if ((n4 & 4) != 0) {
                n = 100;
            }
            if ((n4 & 8) != 0) {
                color2 = null;
            }
            if ((n4 & 0x10) != 0) {
                color3 = null;
            }
            if ((n4 & 0x20) != 0) {
                n2 = 0;
            }
            if ((n4 & 0x40) != 0) {
                n3 = 0;
            }
            if ((n4 & 0x80) != 0) {
                bl = false;
            }
            if ((n4 & 0x100) != 0) {
                bl2 = false;
            }
            if ((n4 & 0x200) != 0) {
                bl3 = false;
            }
            this(elementKind, color, n, color2, color3, n2, n3, bl, bl2, bl3);
        }

        @NotNull
        public final JBHtmlPaneStyleConfiguration.ElementKind getElementKind() {
            return this.elementKind;
        }

        @Nullable
        public final Color getDefaultBackgroundColor() {
            return this.defaultBackgroundColor;
        }

        public final int getDefaultBackgroundOpacity() {
            return this.defaultBackgroundOpacity;
        }

        @Nullable
        public final Color getDefaultForegroundColor() {
            return this.defaultForegroundColor;
        }

        @Nullable
        public final Color getDefaultBorderColor() {
            return this.defaultBorderColor;
        }

        public final int getDefaultBorderWidth() {
            return this.defaultBorderWidth;
        }

        public final int getDefaultBorderRadius() {
            return this.defaultBorderRadius;
        }

        public final boolean getFallbackToEditorBackground() {
            return this.fallbackToEditorBackground;
        }

        public final boolean getFallbackToEditorForeground() {
            return this.fallbackToEditorForeground;
        }

        public final boolean getFallbackToEditorBorder() {
            return this.fallbackToEditorBorder;
        }

        private final Color getBackgroundColor(JBHtmlPaneStyleConfigurationSnapshot configuration) {
            return this.getColor(configuration, JBHtmlPaneStyleConfiguration.ElementProperty.BackgroundColor);
        }

        private final Color getForegroundColor(JBHtmlPaneStyleConfigurationSnapshot configuration) {
            return this.getColor(configuration, JBHtmlPaneStyleConfiguration.ElementProperty.ForegroundColor);
        }

        private final Color getBorderColor(JBHtmlPaneStyleConfigurationSnapshot configuration) {
            return this.getColor(configuration, JBHtmlPaneStyleConfiguration.ElementProperty.BorderColor);
        }

        private final Integer getBackgroundOpacity(JBHtmlPaneStyleConfigurationSnapshot configuration) {
            return this.getInt(configuration, JBHtmlPaneStyleConfiguration.ElementProperty.BackgroundOpacity);
        }

        private final Integer getBorderWidth(JBHtmlPaneStyleConfigurationSnapshot configuration) {
            return this.getInt(configuration, JBHtmlPaneStyleConfiguration.ElementProperty.BorderWidth);
        }

        private final Integer getBorderRadius(JBHtmlPaneStyleConfigurationSnapshot configuration) {
            return this.getInt(configuration, JBHtmlPaneStyleConfiguration.ElementProperty.BorderRadius);
        }

        @NotNull
        public final String getCssStyle(@NotNull Color editorPaneBackgroundColor, @NotNull JBHtmlPaneStyleConfigurationSnapshot configuration, @NotNull Function1<? super Integer, Integer> scale) {
            EditorColorsSchemeSnapshot editorColorsScheme;
            EditorColorsSchemeSnapshot editorColorsSchemeSnapshot;
            TextAttributes attributes;
            Intrinsics.checkNotNullParameter((Object)editorPaneBackgroundColor, (String)"editorPaneBackgroundColor");
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            Intrinsics.checkNotNullParameter(scale, (String)"scale");
            StringBuilder result2 = new StringBuilder();
            if (configuration.getEditorInlineContext() && (attributes = configuration.getColorScheme().getAttributes(this.elementKind)) != null) {
                Color it;
                Color color = attributes.getBackgroundColor();
                if (color != null) {
                    it = color;
                    boolean bl = false;
                    result2.append("background-color: #" + Companion.toHtmlColor(it) + ";");
                }
                Color color2 = attributes.getForegroundColor();
                if (color2 != null) {
                    it = color2;
                    boolean bl = false;
                    result2.append("color: #" + Companion.toHtmlColor(it) + ";");
                }
                if (attributes.getEffectType() == EffectType.BOXED && attributes.getEffectColor() != null) {
                    Integer n;
                    Color color3 = attributes.getEffectColor();
                    Intrinsics.checkNotNullExpressionValue((Object)color3, (String)"getEffectColor(...)");
                    result2.append("border-color: #" + Companion.toHtmlColor(color3) + ";");
                    ControlColorStyleBuilder controlColorStyleBuilder = this;
                    StringBuilder stringBuilder = result2;
                    Integer n2 = this.getBorderWidth(configuration);
                    if (n2 != null) {
                        Integer n3 = n2;
                        int it2 = ((Number)n3).intValue();
                        StringBuilder stringBuilder2 = stringBuilder;
                        ControlColorStyleBuilder controlColorStyleBuilder2 = controlColorStyleBuilder;
                        boolean bl = false;
                        boolean bl2 = it2 > 0;
                        controlColorStyleBuilder = controlColorStyleBuilder2;
                        stringBuilder = stringBuilder2;
                        n = bl2 ? n3 : null;
                    } else {
                        n = null;
                    }
                    ControlColorStyleBuilder.append$default(controlColorStyleBuilder, stringBuilder, n, 1, null, arg_0 -> ControlColorStyleBuilder.getCssStyle$lambda$3(scale, arg_0), 4, null);
                }
                ControlColorStyleBuilder.append$default(this, result2, this.getBorderRadius(configuration), this.defaultBorderRadius, null, arg_0 -> ControlColorStyleBuilder.getCssStyle$lambda$4(scale, arg_0), 4, null);
                String string = result2.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                return string;
            }
            EditorColorsSchemeSnapshot it = editorColorsSchemeSnapshot = (editorColorsScheme = configuration.getColorScheme());
            Color color = this.defaultBackgroundColor;
            Color color4 = this.getBackgroundColor(configuration);
            StringBuilder stringBuilder = result2;
            ControlColorStyleBuilder controlColorStyleBuilder = this;
            boolean bl = false;
            boolean bl3 = this.fallbackToEditorBackground;
            EditorColorsSchemeSnapshot editorColorsSchemeSnapshot2 = bl3 ? editorColorsSchemeSnapshot : null;
            controlColorStyleBuilder.append(stringBuilder, color4, color, editorColorsSchemeSnapshot2 != null ? editorColorsSchemeSnapshot2.getDefaultBackground() : null, arg_0 -> ControlColorStyleBuilder.getCssStyle$lambda$6(this, configuration, editorPaneBackgroundColor, arg_0));
            it = editorColorsSchemeSnapshot = editorColorsScheme;
            color = this.defaultForegroundColor;
            color4 = this.getForegroundColor(configuration);
            stringBuilder = result2;
            controlColorStyleBuilder = this;
            boolean bl4 = false;
            bl3 = this.fallbackToEditorForeground;
            EditorColorsSchemeSnapshot editorColorsSchemeSnapshot3 = bl3 ? editorColorsSchemeSnapshot : null;
            controlColorStyleBuilder.append(stringBuilder, color4, color, editorColorsSchemeSnapshot3 != null ? editorColorsSchemeSnapshot3.getDefaultForeground() : null, ControlColorStyleBuilder::getCssStyle$lambda$8);
            it = editorColorsSchemeSnapshot = editorColorsScheme;
            color = this.defaultBorderColor;
            color4 = this.getBorderColor(configuration);
            stringBuilder = result2;
            controlColorStyleBuilder = this;
            boolean bl5 = false;
            bl3 = this.fallbackToEditorBorder;
            EditorColorsSchemeSnapshot editorColorsSchemeSnapshot4 = bl3 ? editorColorsSchemeSnapshot : null;
            controlColorStyleBuilder.append(stringBuilder, color4, color, editorColorsSchemeSnapshot4 != null ? editorColorsSchemeSnapshot4.getDefaultForeground() : null, ControlColorStyleBuilder::getCssStyle$lambda$10);
            ControlColorStyleBuilder.append$default(this, result2, this.getBorderWidth(configuration), this.defaultBorderWidth, null, arg_0 -> ControlColorStyleBuilder.getCssStyle$lambda$11(scale, arg_0), 4, null);
            ControlColorStyleBuilder.append$default(this, result2, this.getBorderRadius(configuration), this.defaultBorderRadius, null, arg_0 -> ControlColorStyleBuilder.getCssStyle$lambda$12(scale, arg_0), 4, null);
            String string = result2.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        private final <T> T choose(T themeVersion, T defaultVersion, T editorVersion) {
            T t = themeVersion;
            if (t == null && (t = defaultVersion) == null) {
                t = editorVersion;
            }
            return t;
        }

        static /* synthetic */ Object choose$default(ControlColorStyleBuilder controlColorStyleBuilder, Object object, Object object2, Object object3, int n, Object object4) {
            if ((n & 4) != 0) {
                object3 = null;
            }
            return controlColorStyleBuilder.choose(object, object2, object3);
        }

        private final <T> void append(StringBuilder $this$append, T themeVersion, T defaultVersion, T editorVersion, Function1<? super T, String> mapper) {
            block0: {
                Object object = this.choose(themeVersion, defaultVersion, editorVersion);
                if (object == null || (object = (String)mapper.invoke(object)) == null) break block0;
                Object it = object;
                boolean bl = false;
                $this$append.append((String)it);
            }
        }

        static /* synthetic */ void append$default(ControlColorStyleBuilder controlColorStyleBuilder, StringBuilder stringBuilder, Object object, Object object2, Object object3, Function1 function1, int n, Object object4) {
            if ((n & 4) != 0) {
                object3 = null;
            }
            controlColorStyleBuilder.append(stringBuilder, object, object2, object3, function1);
        }

        private final Color mixColors(Color c1, Color c2, int opacity2) {
            if (opacity2 >= 100) {
                return c2;
            }
            if (opacity2 <= 0) {
                return c1;
            }
            return new Color(((100 - opacity2) * c1.getRed() + opacity2 * c2.getRed()) / 100, ((100 - opacity2) * c1.getGreen() + opacity2 * c2.getGreen()) / 100, ((100 - opacity2) * c1.getBlue() + opacity2 * c2.getBlue()) / 100);
        }

        private final Color getColor(JBHtmlPaneStyleConfigurationSnapshot configuration, JBHtmlPaneStyleConfiguration.ElementProperty property) {
            return UIManager.getColor(this.getKey(configuration, property));
        }

        private final Integer getInt(JBHtmlPaneStyleConfigurationSnapshot configuration, JBHtmlPaneStyleConfiguration.ElementProperty property) {
            return (Integer)UIManager.get(this.getKey(configuration, property));
        }

        /*
         * Unable to fully structure code
         */
        private final String getKey(JBHtmlPaneStyleConfigurationSnapshot configuration, JBHtmlPaneStyleConfiguration.ElementProperty property) {
            themeOverrides = configuration.getElementStyleOverrides();
            if (themeOverrides == null) ** GOTO lbl-1000
            v0 = (Collection)themeOverrides.getOverrides().get(this.elementKind);
            v1 = v0 != null ? v0.contains(property) : false;
            if (v1) {
                v2 = "." + themeOverrides.getElementKindThemePropertySuffix();
            } else lbl-1000:
            // 2 sources

            {
                v2 = "";
            }
            suffix = v2;
            return this.elementKind.getId() + suffix + "." + property.getId();
        }

        @NotNull
        public final JBHtmlPaneStyleConfiguration.ElementKind component1() {
            return this.elementKind;
        }

        @Nullable
        public final Color component2() {
            return this.defaultBackgroundColor;
        }

        public final int component3() {
            return this.defaultBackgroundOpacity;
        }

        @Nullable
        public final Color component4() {
            return this.defaultForegroundColor;
        }

        @Nullable
        public final Color component5() {
            return this.defaultBorderColor;
        }

        public final int component6() {
            return this.defaultBorderWidth;
        }

        public final int component7() {
            return this.defaultBorderRadius;
        }

        public final boolean component8() {
            return this.fallbackToEditorBackground;
        }

        public final boolean component9() {
            return this.fallbackToEditorForeground;
        }

        public final boolean component10() {
            return this.fallbackToEditorBorder;
        }

        @NotNull
        public final ControlColorStyleBuilder copy(@NotNull JBHtmlPaneStyleConfiguration.ElementKind elementKind, @Nullable Color defaultBackgroundColor, int defaultBackgroundOpacity, @Nullable Color defaultForegroundColor, @Nullable Color defaultBorderColor, int defaultBorderWidth, int defaultBorderRadius, boolean fallbackToEditorBackground, boolean fallbackToEditorForeground, boolean fallbackToEditorBorder) {
            Intrinsics.checkNotNullParameter((Object)elementKind, (String)"elementKind");
            return new ControlColorStyleBuilder(elementKind, defaultBackgroundColor, defaultBackgroundOpacity, defaultForegroundColor, defaultBorderColor, defaultBorderWidth, defaultBorderRadius, fallbackToEditorBackground, fallbackToEditorForeground, fallbackToEditorBorder);
        }

        public static /* synthetic */ ControlColorStyleBuilder copy$default(ControlColorStyleBuilder controlColorStyleBuilder, JBHtmlPaneStyleConfiguration.ElementKind elementKind, Color color, int n, Color color2, Color color3, int n2, int n3, boolean bl, boolean bl2, boolean bl3, int n4, Object object) {
            if ((n4 & 1) != 0) {
                elementKind = controlColorStyleBuilder.elementKind;
            }
            if ((n4 & 2) != 0) {
                color = controlColorStyleBuilder.defaultBackgroundColor;
            }
            if ((n4 & 4) != 0) {
                n = controlColorStyleBuilder.defaultBackgroundOpacity;
            }
            if ((n4 & 8) != 0) {
                color2 = controlColorStyleBuilder.defaultForegroundColor;
            }
            if ((n4 & 0x10) != 0) {
                color3 = controlColorStyleBuilder.defaultBorderColor;
            }
            if ((n4 & 0x20) != 0) {
                n2 = controlColorStyleBuilder.defaultBorderWidth;
            }
            if ((n4 & 0x40) != 0) {
                n3 = controlColorStyleBuilder.defaultBorderRadius;
            }
            if ((n4 & 0x80) != 0) {
                bl = controlColorStyleBuilder.fallbackToEditorBackground;
            }
            if ((n4 & 0x100) != 0) {
                bl2 = controlColorStyleBuilder.fallbackToEditorForeground;
            }
            if ((n4 & 0x200) != 0) {
                bl3 = controlColorStyleBuilder.fallbackToEditorBorder;
            }
            return controlColorStyleBuilder.copy(elementKind, color, n, color2, color3, n2, n3, bl, bl2, bl3);
        }

        @NotNull
        public String toString() {
            return "ControlColorStyleBuilder(elementKind=" + this.elementKind + ", defaultBackgroundColor=" + this.defaultBackgroundColor + ", defaultBackgroundOpacity=" + this.defaultBackgroundOpacity + ", defaultForegroundColor=" + this.defaultForegroundColor + ", defaultBorderColor=" + this.defaultBorderColor + ", defaultBorderWidth=" + this.defaultBorderWidth + ", defaultBorderRadius=" + this.defaultBorderRadius + ", fallbackToEditorBackground=" + this.fallbackToEditorBackground + ", fallbackToEditorForeground=" + this.fallbackToEditorForeground + ", fallbackToEditorBorder=" + this.fallbackToEditorBorder + ")";
        }

        public int hashCode() {
            int result2 = this.elementKind.hashCode();
            result2 = result2 * 31 + (this.defaultBackgroundColor == null ? 0 : this.defaultBackgroundColor.hashCode());
            result2 = result2 * 31 + Integer.hashCode(this.defaultBackgroundOpacity);
            result2 = result2 * 31 + (this.defaultForegroundColor == null ? 0 : this.defaultForegroundColor.hashCode());
            result2 = result2 * 31 + (this.defaultBorderColor == null ? 0 : this.defaultBorderColor.hashCode());
            result2 = result2 * 31 + Integer.hashCode(this.defaultBorderWidth);
            result2 = result2 * 31 + Integer.hashCode(this.defaultBorderRadius);
            result2 = result2 * 31 + Boolean.hashCode(this.fallbackToEditorBackground);
            result2 = result2 * 31 + Boolean.hashCode(this.fallbackToEditorForeground);
            result2 = result2 * 31 + Boolean.hashCode(this.fallbackToEditorBorder);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ControlColorStyleBuilder)) {
                return false;
            }
            ControlColorStyleBuilder controlColorStyleBuilder = (ControlColorStyleBuilder)other;
            if (this.elementKind != controlColorStyleBuilder.elementKind) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.defaultBackgroundColor, (Object)controlColorStyleBuilder.defaultBackgroundColor)) {
                return false;
            }
            if (this.defaultBackgroundOpacity != controlColorStyleBuilder.defaultBackgroundOpacity) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.defaultForegroundColor, (Object)controlColorStyleBuilder.defaultForegroundColor)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.defaultBorderColor, (Object)controlColorStyleBuilder.defaultBorderColor)) {
                return false;
            }
            if (this.defaultBorderWidth != controlColorStyleBuilder.defaultBorderWidth) {
                return false;
            }
            if (this.defaultBorderRadius != controlColorStyleBuilder.defaultBorderRadius) {
                return false;
            }
            if (this.fallbackToEditorBackground != controlColorStyleBuilder.fallbackToEditorBackground) {
                return false;
            }
            if (this.fallbackToEditorForeground != controlColorStyleBuilder.fallbackToEditorForeground) {
                return false;
            }
            return this.fallbackToEditorBorder == controlColorStyleBuilder.fallbackToEditorBorder;
        }

        private static final String getCssStyle$lambda$3(Function1 $scale, int it) {
            return "border-width: " + $scale.invoke((Object)it) + "px;";
        }

        private static final String getCssStyle$lambda$4(Function1 $scale, int it) {
            return "border-radius: " + $scale.invoke((Object)it) + "px;";
        }

        private static final String getCssStyle$lambda$6(ControlColorStyleBuilder this$0, JBHtmlPaneStyleConfigurationSnapshot $configuration, Color $editorPaneBackgroundColor, Color it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            Integer n = (Integer)ControlColorStyleBuilder.choose$default(this$0, this$0.getBackgroundOpacity($configuration), this$0.defaultBackgroundOpacity, null, 4, null);
            int opacity = n != null ? n : 100;
            Color background = this$0.mixColors($editorPaneBackgroundColor, it, opacity);
            return "background-color: #" + Companion.toHtmlColor(background) + ";";
        }

        private static final String getCssStyle$lambda$8(Color it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return "color: #" + Companion.toHtmlColor(it) + ";";
        }

        private static final String getCssStyle$lambda$10(Color it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return "border-color: #" + Companion.toHtmlColor(it) + ";";
        }

        private static final String getCssStyle$lambda$11(Function1 $scale, int it) {
            return "border-width: " + $scale.invoke((Object)it) + "px;";
        }

        private static final String getCssStyle$lambda$12(Function1 $scale, int it) {
            return "border-radius: " + $scale.invoke((Object)it) + "px;";
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\bH\u00c6\u0003J1\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0014\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u001a\u001a\u00020\u0003H\u00d6\u0081\u0004J\n\u0010\u001b\u001a\u00020\u001cH\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001d"}, d2={"Lcom/intellij/ui/components/impl/JBHtmlPaneStyleSheetRulesProvider$JBHtmlPaneStylesheetParameters;", "", "bgColor", "", "scaleFactor", "", "baseFontSize", "configuration", "Lcom/intellij/ui/components/impl/JBHtmlPaneStyleConfigurationSnapshot;", "<init>", "(IFILcom/intellij/ui/components/impl/JBHtmlPaneStyleConfigurationSnapshot;)V", "getBgColor", "()I", "getScaleFactor", "()F", "getBaseFontSize", "getConfiguration", "()Lcom/intellij/ui/components/impl/JBHtmlPaneStyleConfigurationSnapshot;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.platform.ide.impl"})
    private static final class JBHtmlPaneStylesheetParameters {
        private final int bgColor;
        private final float scaleFactor;
        private final int baseFontSize;
        @NotNull
        private final JBHtmlPaneStyleConfigurationSnapshot configuration;

        public JBHtmlPaneStylesheetParameters(int bgColor, float scaleFactor, int baseFontSize, @NotNull JBHtmlPaneStyleConfigurationSnapshot configuration) {
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            this.bgColor = bgColor;
            this.scaleFactor = scaleFactor;
            this.baseFontSize = baseFontSize;
            this.configuration = configuration;
        }

        public final int getBgColor() {
            return this.bgColor;
        }

        public final float getScaleFactor() {
            return this.scaleFactor;
        }

        public final int getBaseFontSize() {
            return this.baseFontSize;
        }

        @NotNull
        public final JBHtmlPaneStyleConfigurationSnapshot getConfiguration() {
            return this.configuration;
        }

        public final int component1() {
            return this.bgColor;
        }

        public final float component2() {
            return this.scaleFactor;
        }

        public final int component3() {
            return this.baseFontSize;
        }

        @NotNull
        public final JBHtmlPaneStyleConfigurationSnapshot component4() {
            return this.configuration;
        }

        @NotNull
        public final JBHtmlPaneStylesheetParameters copy(int bgColor, float scaleFactor, int baseFontSize, @NotNull JBHtmlPaneStyleConfigurationSnapshot configuration) {
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            return new JBHtmlPaneStylesheetParameters(bgColor, scaleFactor, baseFontSize, configuration);
        }

        public static /* synthetic */ JBHtmlPaneStylesheetParameters copy$default(JBHtmlPaneStylesheetParameters jBHtmlPaneStylesheetParameters, int n, float f, int n2, JBHtmlPaneStyleConfigurationSnapshot jBHtmlPaneStyleConfigurationSnapshot, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = jBHtmlPaneStylesheetParameters.bgColor;
            }
            if ((n3 & 2) != 0) {
                f = jBHtmlPaneStylesheetParameters.scaleFactor;
            }
            if ((n3 & 4) != 0) {
                n2 = jBHtmlPaneStylesheetParameters.baseFontSize;
            }
            if ((n3 & 8) != 0) {
                jBHtmlPaneStyleConfigurationSnapshot = jBHtmlPaneStylesheetParameters.configuration;
            }
            return jBHtmlPaneStylesheetParameters.copy(n, f, n2, jBHtmlPaneStyleConfigurationSnapshot);
        }

        @NotNull
        public String toString() {
            return "JBHtmlPaneStylesheetParameters(bgColor=" + this.bgColor + ", scaleFactor=" + this.scaleFactor + ", baseFontSize=" + this.baseFontSize + ", configuration=" + this.configuration + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.bgColor);
            result2 = result2 * 31 + Float.hashCode(this.scaleFactor);
            result2 = result2 * 31 + Integer.hashCode(this.baseFontSize);
            result2 = result2 * 31 + this.configuration.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof JBHtmlPaneStylesheetParameters)) {
                return false;
            }
            JBHtmlPaneStylesheetParameters jBHtmlPaneStylesheetParameters = (JBHtmlPaneStylesheetParameters)other;
            if (this.bgColor != jBHtmlPaneStylesheetParameters.bgColor) {
                return false;
            }
            if (Float.compare(this.scaleFactor, jBHtmlPaneStylesheetParameters.scaleFactor) != 0) {
                return false;
            }
            if (this.baseFontSize != jBHtmlPaneStylesheetParameters.baseFontSize) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.configuration, (Object)jBHtmlPaneStylesheetParameters.configuration);
        }
    }
}

