/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac;

import com.intellij.ide.RecentProjectsManagerBase;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.IdeGlassPaneImplKt;
import com.intellij.openapi.wm.impl.ProjectFrameHelper;
import com.intellij.platform.jbr.JdkEx;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.components.panels.OpaquePanel;
import com.intellij.ui.mac.MacWinTabsHandlerV2;
import com.intellij.ui.mac.foundation.Foundation;
import com.intellij.ui.mac.foundation.ID;
import com.intellij.ui.mac.foundation.MacUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.sun.jna.Callback;
import com.sun.jna.Pointer;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Window;
import java.lang.reflect.Method;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class MacWinTabsHandler {
    private static final String WIN_TAB_FILLER = "WIN_TAB_FILLER_KEY";
    private static final String CLOSE_MARKER = "TABS_CLOSE_MARKER";
    protected final IdeFrameImpl myFrame;
    private final boolean myFrameAllowed;
    private static Callback myObserverCallback;
    private static ID myObserverDelegate;

    @NotNull
    public static JComponent createAndInstallHandlerComponent(@NotNull JRootPane rootPane) {
        if (rootPane == null) {
            MacWinTabsHandler.$$$reportNull$$$0(0);
        }
        if (MacWinTabsHandler.isVersion2()) {
            JComponent jComponent = MacWinTabsHandlerV2._createAndInstallHandlerComponent(rootPane);
            if (jComponent == null) {
                MacWinTabsHandler.$$$reportNull$$$0(1);
            }
            return jComponent;
        }
        OpaquePanel filler = new OpaquePanel();
        filler.setBorder(JBUI.Borders.customLineBottom((Color)UIUtil.getTooltipSeparatorColor()));
        filler.setVisible(false);
        rootPane.putClientProperty(WIN_TAB_FILLER, filler);
        rootPane.putClientProperty("Window.transparentTitleBarHeight", 28);
        OpaquePanel opaquePanel = filler;
        if (opaquePanel == null) {
            MacWinTabsHandler.$$$reportNull$$$0(2);
        }
        return opaquePanel;
    }

    public static void fastInit(@NotNull IdeFrameImpl frame) {
        if (frame == null) {
            MacWinTabsHandler.$$$reportNull$$$0(3);
        }
        if (MacWinTabsHandler.isVersion2()) {
            MacWinTabsHandlerV2._fastInit(frame);
            return;
        }
        if (JdkEx.setTabbingMode(frame, MacWinTabsHandler.getWindowId(), () -> MacWinTabsHandler.updateTabBars(null))) {
            Foundation.invoke((String)"NSWindow", (String)"setAllowsAutomaticWindowTabbing:", (Object[])new Object[]{true});
        }
    }

    public static boolean isVersion2() {
        return ExperimentalUI.isNewUI() && Registry.is((String)"ide.mac.os.wintabs.version2", (boolean)true);
    }

    public MacWinTabsHandler(@NotNull IdeFrameImpl frame, @NotNull CoroutineScope coroutineScope) {
        if (frame == null) {
            MacWinTabsHandler.$$$reportNull$$$0(4);
        }
        if (coroutineScope == null) {
            MacWinTabsHandler.$$$reportNull$$$0(5);
        }
        this.myFrame = frame;
        this.myFrameAllowed = this.initFrame(frame, coroutineScope);
    }

    protected boolean initFrame(@NotNull IdeFrameImpl frame, @NotNull CoroutineScope coroutineScope) {
        boolean allowed;
        if (frame == null) {
            MacWinTabsHandler.$$$reportNull$$$0(6);
        }
        if (coroutineScope == null) {
            MacWinTabsHandler.$$$reportNull$$$0(7);
        }
        boolean bl = allowed = MacWinTabsHandler.isAllowedFrame(frame) && JdkEx.setTabbingMode(frame, MacWinTabsHandler.getWindowId(), () -> MacWinTabsHandler.updateTabBars(null));
        if (allowed) {
            Foundation.invoke((String)"NSWindow", (String)"setAllowsAutomaticWindowTabbing:", (Object[])new Object[]{true});
            IdeGlassPaneImplKt.executeOnCancelInEdt(coroutineScope, (Function0<Unit>)((Function0)() -> {
                MacWinTabsHandler.updateTabBars(null);
                return Unit.INSTANCE;
            }));
        }
        return allowed;
    }

    private static boolean isAllowedFrame(@Nullable JFrame frame) {
        return frame == null || frame instanceof IdeFrameImpl;
    }

    @NotNull
    static String getWindowId() {
        String string = (MacWinTabsHandler.isVersion2() ? "+" : "") + ApplicationNamesInfo.getInstance().getProductName() + (PluginManagerCore.isRunningFromSources() ? "-Snapshot" : "") + "-AwtWindow-WithTabs";
        if (string == null) {
            MacWinTabsHandler.$$$reportNull$$$0(8);
        }
        return string;
    }

    public void setProject() {
        ApplicationManager.getApplication().invokeLater(() -> MacWinTabsHandler.updateTabBars(this.myFrame));
    }

    public void enteringFullScreen() {
        this.enterFullScreen();
    }

    public void enterFullScreen() {
        if (!this.myFrameAllowed) {
            return;
        }
        this.updateTabBar();
    }

    public void exitFullScreen() {
        if (this.myFrameAllowed) {
            this.updateTabBar();
        }
    }

    private void updateTabBar() {
        Foundation.executeOnMainThread((boolean)true, (boolean)false, () -> {
            ID window = MacUtil.getWindowFromJavaWindow((Window)this.myFrame);
            int visibleAndHeight = (int)Foundation.invoke_fpret((ID)window, (String)"getTabBarVisibleAndHeight", (Object[])new Object[0]);
            ApplicationManager.getApplication().invokeLater(() -> MacWinTabsHandler.updateTabBar(this.myFrame, visibleAndHeight == -1 ? MacWinTabsHandler.DEFAULT_WIN_TAB_HEIGHT() : visibleAndHeight));
        });
    }

    static void updateTabBars(@Nullable JFrame newFrame) {
        if (!MacWinTabsHandler.isAllowedFrame(newFrame) || !JdkEx.isTabbingModeAvailable()) {
            return;
        }
        IdeFrame[] frames = WindowManager.getInstance().getAllProjectFrames();
        if (frames.length < 2) {
            if (frames.length == 1) {
                MacWinTabsHandler.updateTabBar(frames[0], 0);
                if (newFrame == null) {
                    ProjectFrameHelper helper = (ProjectFrameHelper)frames[0];
                    if (helper.isInFullScreen()) {
                        MacWinTabsHandler.handleFullScreenResize(helper.getFrame());
                    }
                } else {
                    Foundation.executeOnMainThread((boolean)true, (boolean)false, () -> MacWinTabsHandler.addTabObserver(MacUtil.getWindowFromJavaWindow((Window)newFrame)));
                }
            }
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            int i2;
            Integer[] visibleAndHeights = new Integer[frames.length];
            boolean callInAppkit = false;
            int newIndex = -1;
            for (i2 = 0; i2 < frames.length; ++i2) {
                ProjectFrameHelper helper = (ProjectFrameHelper)frames[i2];
                if (helper.isDisposed()) {
                    visibleAndHeights[i2] = 0;
                    continue;
                }
                if (newFrame == helper.getFrame()) {
                    newIndex = i2;
                    continue;
                }
                callInAppkit = true;
            }
            if (callInAppkit) {
                Foundation.executeOnMainThread((boolean)true, (boolean)false, () -> {
                    for (int i2 = 0; i2 < frames.length; ++i2) {
                        ID window = MacUtil.getWindowFromJavaWindow((Window)((ProjectFrameHelper)frames[i2]).getFrame());
                        MacWinTabsHandler.addTabObserver(window);
                        if (visibleAndHeights[i2] != null) continue;
                        visibleAndHeights[i2] = (int)Foundation.invoke_fpret((ID)window, (String)"getTabBarVisibleAndHeight", (Object[])new Object[0]);
                        if (visibleAndHeights[i2] != -1) continue;
                        visibleAndHeights[i2] = MacWinTabsHandler.DEFAULT_WIN_TAB_HEIGHT();
                    }
                    ApplicationManager.getApplication().invokeLater(() -> {
                        for (int i2 = 0; i2 < frames.length; ++i2) {
                            MacWinTabsHandler.updateTabBar(frames[i2], visibleAndHeights[i2]);
                        }
                    });
                });
            } else {
                Foundation.executeOnMainThread((boolean)true, (boolean)false, () -> {
                    for (IdeFrame frame : frames) {
                        MacWinTabsHandler.addTabObserver(MacUtil.getWindowFromJavaWindow((Window)((ProjectFrameHelper)frame).getFrame()));
                    }
                });
                if (newIndex != -1) {
                    visibleAndHeights[newIndex] = 0;
                }
                for (i2 = 0; i2 < frames.length; ++i2) {
                    MacWinTabsHandler.updateTabBar(frames[i2], visibleAndHeights[i2]);
                }
            }
        });
    }

    private static void updateTabBar(@NotNull Object frameObject, int height) {
        JRootPane rootPane;
        if (frameObject == null) {
            MacWinTabsHandler.$$$reportNull$$$0(9);
        }
        if (frameObject instanceof JFrame) {
            rootPane = ((JFrame)frameObject).getRootPane();
        } else if (frameObject instanceof ProjectFrameHelper) {
            ProjectFrameHelper frameHelper = (ProjectFrameHelper)frameObject;
            rootPane = frameHelper.getFrame().getRootPane();
        } else {
            return;
        }
        if (rootPane == null) {
            return;
        }
        JComponent filler = (JComponent)rootPane.getClientProperty(WIN_TAB_FILLER);
        if (filler == null) {
            return;
        }
        if (height > 0) {
            ++height;
        }
        boolean visible = height > 0;
        boolean oldVisible = filler.isVisible();
        filler.setVisible(visible);
        filler.setPreferredSize(new Dimension(-1, height));
        Container parent = filler.getParent();
        if (parent == null || oldVisible == visible) {
            return;
        }
        parent.doLayout();
        parent.revalidate();
        parent.repaint();
    }

    protected static void handleFullScreenResize(@NotNull Window window) {
        block7: {
            if (window == null) {
                MacWinTabsHandler.$$$reportNull$$$0(10);
            }
            try {
                Object cPlatformWindow = MacUtil.getPlatformWindow((Window)window);
                if (cPlatformWindow == null) break block7;
                Class<?> windowClass = cPlatformWindow.getClass();
                Method deliverMoveResize = ReflectionUtil.getDeclaredMethod(windowClass, (String)"doDeliverMoveResizeEvent", (Class[])new Class[0]);
                if (deliverMoveResize != null) {
                    try {
                        deliverMoveResize.invoke(cPlatformWindow, new Object[0]);
                    }
                    catch (Throwable e) {
                        Logger.getInstance(MacWinTabsHandler.class).error(e);
                    }
                    return;
                }
                Method javaDeliverMoveResize = ReflectionUtil.getDeclaredMethod(windowClass, (String)"deliverMoveResizeEvent", (Class[])new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE});
                if (javaDeliverMoveResize == null) {
                    return;
                }
                Rectangle rect = window.getGraphicsConfiguration().getBounds();
                Foundation.executeOnMainThread((boolean)true, (boolean)false, () -> {
                    try {
                        javaDeliverMoveResize.invoke(cPlatformWindow, rect.x, rect.y, rect.width, rect.height, true);
                    }
                    catch (Throwable e) {
                        Logger.getInstance(MacWinTabsHandler.class).error(e);
                    }
                });
            }
            catch (Throwable e) {
                Logger.getInstance(MacWinTabsHandler.class).error(e);
            }
        }
    }

    private static int DEFAULT_WIN_TAB_HEIGHT() {
        return Registry.intValue((String)"ide.mac.bigsur.window.with.tabs.height", (int)28);
    }

    private static void addTabObserver(@NotNull ID window) {
        ID tabGroup;
        if (window == null) {
            MacWinTabsHandler.$$$reportNull$$$0(11);
        }
        if (!ID.NIL.equals((Object)Foundation.invoke((ID)(tabGroup = Foundation.invoke((ID)window, (String)"tabGroup", (Object[])new Object[0])), (String)"observationInfo", (Object[])new Object[0]))) {
            return;
        }
        if (myObserverDelegate == null) {
            myObserverCallback = new Callback(){

                public void callback(ID self, Pointer selector, ID keyPath, ID ofObject, ID change, Pointer context2) {
                    ApplicationManager.getApplication().invokeLater(() -> MacWinTabsHandler.updateTabBars(null));
                }
            };
            ID delegateClass = Foundation.allocateObjcClassPair((ID)Foundation.getObjcClass((String)"NSObject"), (String)"MyWindowTabGroupObserver");
            Foundation.addMethod((ID)delegateClass, (Pointer)Foundation.createSelector((String)"observeValueForKeyPath:ofObject:change:context:"), (Callback)myObserverCallback, (String)"v*");
            Foundation.registerObjcClassPair((ID)delegateClass);
            myObserverDelegate = Foundation.invoke((String)"MyWindowTabGroupObserver", (String)"new", (Object[])new Object[0]);
        }
        Foundation.invoke((ID)tabGroup, (String)"addObserver:forKeyPath:options:context:", (Object[])new Object[]{myObserverDelegate, Foundation.nsString((String)"windows"), 0, ID.NIL});
    }

    public static void switchFrameIfPossible(@NotNull JFrame frame, boolean next) {
        if (frame == null) {
            MacWinTabsHandler.$$$reportNull$$$0(12);
        }
        if (JdkEx.isTabbingModeAvailable()) {
            Foundation.executeOnMainThread((boolean)true, (boolean)false, () -> Foundation.invoke((ID)MacUtil.getWindowFromJavaWindow((Window)frame), (String)(next ? "selectNextTab:" : "selectPreviousTab:"), (Object[])new Object[]{ID.NIL}));
        }
    }

    public void appClosing() {
        if (!this.myFrameAllowed) {
            return;
        }
        IdeFrame[] frames = WindowManager.getInstance().getAllProjectFrames();
        int length = frames.length;
        if (length < 2) {
            return;
        }
        ID[] windows = new ID[length];
        for (int i2 = 0; i2 < length; ++i2) {
            IdeFrameImpl frame = ((ProjectFrameHelper)frames[i2]).getFrame();
            JRootPane pane2 = frame.getRootPane();
            if (pane2.getClientProperty(CLOSE_MARKER) != null) {
                return;
            }
            pane2.putClientProperty(CLOSE_MARKER, Boolean.TRUE);
            windows[i2] = MacUtil.getWindowFromJavaWindow((Window)frame);
        }
        ID tabs = Foundation.invoke((ID)windows[0], (String)"tabbedWindows", (Object[])new Object[0]);
        if (Foundation.invoke((ID)tabs, (String)"count", (Object[])new Object[0]).intValue() != length) {
            return;
        }
        IdeFrame[] orderedFrames = new IdeFrame[length];
        for (int i3 = 0; i3 < length; ++i3) {
            int index = Foundation.invoke((ID)tabs, (String)"indexOfObject:", (Object[])new Object[]{windows[i3]}).intValue();
            orderedFrames[index] = frames[i3];
        }
        RecentProjectsManagerBase manager2 = RecentProjectsManagerBase.getInstanceEx();
        for (IdeFrame frame : orderedFrames) {
            Project project2 = frame.getProject();
            if (project2 == null) continue;
            manager2.markPathRecent(project2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPane";
                break;
            }
            case 1: 
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/mac/MacWinTabsHandler";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coroutineScope";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameObject";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/mac/MacWinTabsHandler";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createAndInstallHandlerComponent";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getWindowId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createAndInstallHandlerComponent";
                break;
            }
            case 1: 
            case 2: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "fastInit";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "initFrame";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "updateTabBar";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "handleFullScreenResize";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addTabObserver";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "switchFrameIfPossible";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 8 -> new IllegalStateException(string);
        };
    }
}

