/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.internal.inspector.UiInspectorActionUtil;
import com.intellij.internal.inspector.UiInspectorUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUiKind;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionHolder;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.KeepPopupOnPerform;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutProvider;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.ActionMenu;
import com.intellij.openapi.actionSystem.impl.ActionPresentationDecorator;
import com.intellij.openapi.actionSystem.impl.ActualActionUiKind;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.actionSystem.impl.Utils;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.IPopupChooserBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.TreePopup;
import com.intellij.openapi.ui.popup.TreePopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ScalableIcon;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.TextWithMnemonic;
import com.intellij.psi.PsiElement;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.CommonActionsPanel;
import com.intellij.ui.HintHint;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.icons.CustomIconUtilKt;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.ui.popup.ActionGroupPopupActivity;
import com.intellij.ui.popup.ActionPopupOptions;
import com.intellij.ui.popup.ActionPopupStep;
import com.intellij.ui.popup.ActionStepBuilder;
import com.intellij.ui.popup.BalloonPopupBuilderImpl;
import com.intellij.ui.popup.ComponentPopupBuilderImpl;
import com.intellij.ui.popup.NumericMnemonicItem;
import com.intellij.ui.popup.PopupListAdapter;
import com.intellij.ui.popup.PopupOwner;
import com.intellij.ui.popup.PopupTableAdapter;
import com.intellij.ui.popup.PopupTreeAdapter;
import com.intellij.ui.popup.WizardPopup;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.ui.popup.mock.MockConfirmation;
import com.intellij.ui.popup.tree.TreePopupImpl;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.Html;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.RootPaneContainer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkListener;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class PopupFactoryImpl
extends JBPopupFactory {
    public static final Key<VisualPosition> ANCHOR_POPUP_POSITION = Key.create((String)"popup.anchor.position");
    public static final Key<Point> ANCHOR_POPUP_POINT = Key.create((String)"popup.anchor.point");
    public static final Key<Boolean> DISABLE_ICON_IN_LIST = Key.create((String)"popup.disable.icon.in.list");
    private static final Logger LOG = Logger.getInstance(PopupFactoryImpl.class);

    @NotNull
    public <T> IPopupChooserBuilder<T> createPopupChooserBuilder(@NotNull List<? extends T> list2) {
        if (list2 == null) {
            PopupFactoryImpl.$$$reportNull$$$0(0);
        }
        LOG.assertTrue(list2.isEmpty() || !(list2.get(0) instanceof PsiElement) || ApplicationManager.getApplication().isUnitTestMode(), (Object)"Do not use PsiElement for popup model. See PsiTargetNavigator");
        JBList jbList = new JBList((ListModel)new CollectionListModel(list2));
        PopupUtil.applyNewUIBackground((Component)jbList);
        return new PopupChooserBuilder((JList)jbList);
    }

    @NotNull
    public ListPopup createConfirmation(@NlsContexts.PopupTitle @Nullable String title2, Runnable onYes, int defaultOptionIndex) {
        ListPopup listPopup = this.createConfirmation(title2, CommonBundle.getYesButtonText(), CommonBundle.getNoButtonText(), onYes, defaultOptionIndex);
        if (listPopup == null) {
            PopupFactoryImpl.$$$reportNull$$$0(1);
        }
        return listPopup;
    }

    @NotNull
    public ListPopup createConfirmation(@NlsContexts.PopupTitle @Nullable String title2, String yesText, String noText, Runnable onYes, int defaultOptionIndex) {
        ListPopup listPopup = this.createConfirmation(title2, yesText, noText, onYes, EmptyRunnable.getInstance(), defaultOptionIndex);
        if (listPopup == null) {
            PopupFactoryImpl.$$$reportNull$$$0(2);
        }
        return listPopup;
    }

    @NotNull
    public JBPopup createMessage(@NlsContexts.PopupTitle String text2) {
        ListPopup listPopup = this.createListPopup((ListPopupStep)new BaseListPopupStep(null, (Object[])new String[]{text2}));
        if (listPopup == null) {
            PopupFactoryImpl.$$$reportNull$$$0(3);
        }
        return listPopup;
    }

    public Balloon getParentBalloonFor(@Nullable Component c) {
        if (c == null) {
            return null;
        }
        for (Component eachParent = c; eachParent != null; eachParent = eachParent.getParent()) {
            Object balloon;
            if (!(eachParent instanceof JComponent) || !((balloon = ((JComponent)eachParent).getClientProperty("Balloon.property")) instanceof Balloon)) continue;
            return (Balloon)balloon;
        }
        return null;
    }

    protected <T> // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull PopupChooserBuilder.PopupComponentAdapter<T> createPopupComponentAdapter(@NotNull PopupChooserBuilder<T> builder, @NotNull JList<T> list2) {
        if (builder == null) {
            PopupFactoryImpl.$$$reportNull$$$0(4);
        }
        if (list2 == null) {
            PopupFactoryImpl.$$$reportNull$$$0(5);
        }
        return new PopupListAdapter<T>(builder, list2);
    }

    protected <T> // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull PopupChooserBuilder.PopupComponentAdapter<T> createPopupComponentAdapter(@NotNull PopupChooserBuilder<T> builder, @NotNull JTree tree2) {
        if (builder == null) {
            PopupFactoryImpl.$$$reportNull$$$0(6);
        }
        if (tree2 == null) {
            PopupFactoryImpl.$$$reportNull$$$0(7);
        }
        return new PopupTreeAdapter(builder, tree2);
    }

    protected <T> // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull PopupChooserBuilder.PopupComponentAdapter<T> createPopupComponentAdapter(@NotNull PopupChooserBuilder<T> builder, @NotNull JTable table2) {
        if (builder == null) {
            PopupFactoryImpl.$$$reportNull$$$0(8);
        }
        if (table2 == null) {
            PopupFactoryImpl.$$$reportNull$$$0(9);
        }
        return new PopupTableAdapter(builder, table2);
    }

    @NotNull
    public ListPopup createConfirmation(@NlsContexts.PopupTitle @Nullable String title2, final @NlsContexts.Label String yesText, @NlsContexts.Label String noText, final Runnable onYes, final Runnable onNo, int defaultOptionIndex) {
        BaseListPopupStep<String> step2 = new BaseListPopupStep<String>(this, title2, new String[]{yesText, noText}){
            boolean myRunYes;

            public PopupStep<?> onChosen(String selectedValue, boolean finalChoice) {
                this.myRunYes = selectedValue.equals(yesText);
                return FINAL_CHOICE;
            }

            public void canceled() {
                (this.myRunYes ? onYes : onNo).run();
            }

            public boolean isMnemonicsNavigationEnabled() {
                return true;
            }
        };
        step2.setDefaultOptionIndex(defaultOptionIndex);
        Application app = ApplicationManager.getApplication();
        return app == null || !app.isUnitTestMode() ? new ListPopupImpl((ListPopupStep)step2) : new MockConfirmation((ListPopupStep)step2, yesText);
    }

    @NotNull
    public ListPopup createActionGroupPopup(@NlsContexts.PopupTitle @Nullable String title2, @NotNull ActionGroup actionGroup, @NotNull DataContext dataContext2, JBPopupFactory.ActionSelectionAid aid, boolean showDisabledActions, Runnable disposeCallback, int maxRowCount, Condition<? super AnAction> preselectCondition, @Nullable String actionPlace) {
        if (actionGroup == null) {
            PopupFactoryImpl.$$$reportNull$$$0(10);
        }
        if (dataContext2 == null) {
            PopupFactoryImpl.$$$reportNull$$$0(11);
        }
        return new ActionGroupPopup(null, title2, actionGroup, dataContext2, actionPlace == null ? "popup" : actionPlace, new PresentationFactory(), ActionPopupOptions.forAid(aid, showDisabledActions, maxRowCount, preselectCondition), disposeCallback);
    }

    @NotNull
    public ListPopup createActionGroupPopup(@NlsContexts.PopupTitle @Nullable String title2, @NotNull ActionGroup actionGroup, @NotNull DataContext dataContext2, boolean showNumbers, boolean showDisabledActions, boolean honorActionMnemonics, Runnable disposeCallback, int maxRowCount, Condition<? super AnAction> preselectCondition) {
        if (actionGroup == null) {
            PopupFactoryImpl.$$$reportNull$$$0(12);
        }
        if (dataContext2 == null) {
            PopupFactoryImpl.$$$reportNull$$$0(13);
        }
        return new ActionGroupPopup(null, title2, actionGroup, dataContext2, "popup", new PresentationFactory(), ActionPopupOptions.create(showNumbers, true, showDisabledActions, honorActionMnemonics, maxRowCount, false, preselectCondition), disposeCallback);
    }

    @NotNull
    public ListPopupStep<ActionItem> createActionsStep(@NotNull ActionGroup actionGroup, @NotNull DataContext dataContext2, @Nullable String actionPlace, boolean showNumbers, boolean showDisabledActions, @NlsContexts.PopupTitle @Nullable String title2, Component component2, boolean honorActionMnemonics, int defaultOptionIndex, boolean autoSelectionEnabled) {
        if (actionGroup == null) {
            PopupFactoryImpl.$$$reportNull$$$0(14);
        }
        if (dataContext2 == null) {
            PopupFactoryImpl.$$$reportNull$$$0(15);
        }
        PresentationFactory presentationFactory = new PresentationFactory();
        DataContext asyncDataContext = Utils.createAsyncDataContext(dataContext2);
        ListPopupStep<ActionItem> listPopupStep = ActionPopupStep.createActionsStep(title2, actionGroup, asyncDataContext, actionPlace == null ? "popup" : actionPlace, presentationFactory, () -> asyncDataContext, ActionPopupOptions.forStepAndItems(showNumbers, true, showDisabledActions, honorActionMnemonics, autoSelectionEnabled, null, defaultOptionIndex));
        if (listPopupStep == null) {
            PopupFactoryImpl.$$$reportNull$$$0(16);
        }
        return listPopupStep;
    }

    @ApiStatus.Internal
    public static boolean anyMnemonicsIn(Iterable<? extends ActionItem> items2) {
        for (ActionItem actionItem : items2) {
            if (actionItem.getAction().getTemplatePresentation().getMnemonic() == 0) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public ListPopup createListPopup(@NotNull ListPopupStep step2) {
        if (step2 == null) {
            PopupFactoryImpl.$$$reportNull$$$0(17);
        }
        return new ListPopupImpl(step2);
    }

    @NotNull
    public ListPopup createListPopup(@NotNull ListPopupStep step2, int maxRowCount) {
        if (step2 == null) {
            PopupFactoryImpl.$$$reportNull$$$0(18);
        }
        ListPopupImpl popup2 = new ListPopupImpl(step2);
        popup2.setMaxRowCount(maxRowCount);
        ListPopupImpl listPopupImpl = popup2;
        if (listPopupImpl == null) {
            PopupFactoryImpl.$$$reportNull$$$0(19);
        }
        return listPopupImpl;
    }

    @NotNull
    public ListPopup createListPopup(@NotNull Project project2, @NotNull ListPopupStep step2, final @NotNull Function<? super ListCellRenderer, ? extends ListCellRenderer> cellRendererProducer) {
        if (project2 == null) {
            PopupFactoryImpl.$$$reportNull$$$0(20);
        }
        if (step2 == null) {
            PopupFactoryImpl.$$$reportNull$$$0(21);
        }
        if (cellRendererProducer == null) {
            PopupFactoryImpl.$$$reportNull$$$0(22);
        }
        return new ListPopupImpl(this, project2, step2){

            @Override
            protected ListCellRenderer<?> getListElementRenderer() {
                return (ListCellRenderer)cellRendererProducer.apply(super.getListElementRenderer());
            }
        };
    }

    @NotNull
    public TreePopup createTree(JBPopup parent, @NotNull TreePopupStep aStep, Object parentValue) {
        if (aStep == null) {
            PopupFactoryImpl.$$$reportNull$$$0(23);
        }
        return new TreePopupImpl(aStep.getProject(), parent, (TreePopupStep<Object>)aStep, parentValue);
    }

    @NotNull
    public TreePopup createTree(@NotNull TreePopupStep aStep) {
        if (aStep == null) {
            PopupFactoryImpl.$$$reportNull$$$0(24);
        }
        return new TreePopupImpl(aStep.getProject(), null, (TreePopupStep<Object>)aStep, null);
    }

    @NotNull
    public ComponentPopupBuilder createComponentPopupBuilder(@NotNull JComponent content2, JComponent preferableFocusComponent) {
        if (content2 == null) {
            PopupFactoryImpl.$$$reportNull$$$0(25);
        }
        return new ComponentPopupBuilderImpl(content2, preferableFocusComponent);
    }

    @NotNull
    public RelativePoint guessBestPopupLocation(@NotNull AnAction action2, @NotNull AnActionEvent event) {
        MouseEvent me;
        Object object;
        ActionToolbar actionToolbar2;
        ActionUiKind uiKind;
        if (action2 == null) {
            PopupFactoryImpl.$$$reportNull$$$0(26);
        }
        if (event == null) {
            PopupFactoryImpl.$$$reportNull$$$0(27);
        }
        if ((uiKind = event.getUiKind()) instanceof ActualActionUiKind.Toolbar) {
            ActualActionUiKind.Toolbar o = (ActualActionUiKind.Toolbar)uiKind;
            actionToolbar2 = o.getToolbar();
        } else if (event.getInputEvent() != null && (object = event.getInputEvent().getSource()) instanceof JComponent) {
            JComponent o = (JComponent)object;
            actionToolbar2 = ActionToolbar.findToolbarBy((Component)o);
        } else {
            actionToolbar2 = null;
        }
        ActionToolbar toolbar2 = actionToolbar2;
        JComponent component2 = PopupFactoryImpl.getNonNullPopupTarget(event.getDataContext(), () -> action2.getClass().getName() + "@" + event.getPlace() + "(" + event.getPresentation().getText() + ")");
        RelativePoint point = CommonActionsPanel.getPreferredPopupPoint((AnAction)action2, (Component)(toolbar2 != null ? toolbar2.getComponent() : component2));
        if (point != null) {
            RelativePoint relativePoint = point;
            if (relativePoint == null) {
                PopupFactoryImpl.$$$reportNull$$$0(28);
            }
            return relativePoint;
        }
        Serializable serializable = event.getInputEvent();
        if (serializable instanceof MouseEvent && (serializable = (me = (MouseEvent)serializable).getComponent()) instanceof JComponent) {
            JComponent button2 = (JComponent)serializable;
            RelativePoint relativePoint = RelativePoint.getSouthWestOf((JComponent)button2);
            if (relativePoint == null) {
                PopupFactoryImpl.$$$reportNull$$$0(29);
            }
            return relativePoint;
        }
        RelativePoint relativePoint = this.guessBestPopupLocation(event.getDataContext());
        if (relativePoint == null) {
            PopupFactoryImpl.$$$reportNull$$$0(30);
        }
        return relativePoint;
    }

    @NotNull
    public RelativePoint guessBestPopupLocation(@NotNull DataContext dataContext2) {
        if (dataContext2 == null) {
            PopupFactoryImpl.$$$reportNull$$$0(31);
        }
        JComponent component2 = PopupFactoryImpl.getNonNullPopupTarget(dataContext2, () -> "dataContext");
        Point point = (Point)PlatformDataKeys.CONTEXT_MENU_POINT.getData(dataContext2);
        if (point != null) {
            return new RelativePoint((Component)component2, point);
        }
        Editor editor2 = (Editor)CommonDataKeys.EDITOR.getData(dataContext2);
        if (editor2 != null && component2 == editor2.getContentComponent()) {
            RelativePoint relativePoint = this.guessBestPopupLocation(editor2);
            if (relativePoint == null) {
                PopupFactoryImpl.$$$reportNull$$$0(32);
            }
            return relativePoint;
        }
        RelativePoint relativePoint = this.guessBestPopupLocation(component2);
        if (relativePoint == null) {
            PopupFactoryImpl.$$$reportNull$$$0(33);
        }
        return relativePoint;
    }

    @NotNull
    private static JComponent getNonNullPopupTarget(@NotNull DataContext dataContext2, @NotNull Supplier<String> errorInfoSupplier) {
        Container parent;
        JRootPane rootPane;
        Component component2;
        if (dataContext2 == null) {
            PopupFactoryImpl.$$$reportNull$$$0(34);
        }
        if (errorInfoSupplier == null) {
            PopupFactoryImpl.$$$reportNull$$$0(35);
        }
        if ((component2 = (Component)dataContext2.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT)) == null) {
            Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext2);
            component2 = AbstractPopup.getFocusedParent(project2);
        }
        if (component2 instanceof JComponent) {
            JComponent c;
            JComponent jComponent = c = (JComponent)component2;
            if (jComponent == null) {
                PopupFactoryImpl.$$$reportNull$$$0(36);
            }
            return jComponent;
        }
        if (component2 instanceof RootPaneContainer) {
            RootPaneContainer o = (RootPaneContainer)((Object)component2);
            v1 = o.getRootPane();
        } else {
            v1 = rootPane = null;
        }
        if (rootPane != null) {
            JRootPane jRootPane = rootPane;
            if (jRootPane == null) {
                PopupFactoryImpl.$$$reportNull$$$0(37);
            }
            return jRootPane;
        }
        Container container = parent = component2 == null ? null : component2.getParent();
        if (parent instanceof JComponent) {
            JComponent c;
            JComponent jComponent = c = (JComponent)parent;
            if (jComponent == null) {
                PopupFactoryImpl.$$$reportNull$$$0(38);
            }
            return jComponent;
        }
        String componentClass = component2 == null ? null : component2.getClass().getName();
        throw new AssertionError((Object)("Unexpected component for " + errorInfoSupplier.get() + ": " + componentClass));
    }

    @NotNull
    public RelativePoint guessBestPopupLocation(@NotNull JComponent component2) {
        if (component2 == null) {
            PopupFactoryImpl.$$$reportNull$$$0(39);
        }
        Point popupMenuPoint = null;
        Rectangle visibleRect = component2.getVisibleRect();
        if (component2 instanceof JList) {
            int[] selectedIndices;
            JList list2 = (JList)component2;
            int firstVisibleIndex = list2.getFirstVisibleIndex();
            int lastVisibleIndex = list2.getLastVisibleIndex();
            for (int index : selectedIndices = list2.getSelectedIndices()) {
                if (firstVisibleIndex > index || index > lastVisibleIndex) continue;
                Rectangle cellBounds = list2.getCellBounds(index, index);
                popupMenuPoint = new Point(visibleRect.x + visibleRect.width / 4, cellBounds.y + cellBounds.height - 1);
                break;
            }
        } else if (component2 instanceof JTree) {
            JTree tree2 = (JTree)component2;
            TreePath[] paths = tree2.getSelectionPaths();
            if (paths != null && paths.length > 0) {
                TreePath pathFound = null;
                int distanceFound = Integer.MAX_VALUE;
                int center = visibleRect.y + visibleRect.height / 2;
                for (TreePath path : paths) {
                    int distance;
                    Rectangle bounds = tree2.getPathBounds(path);
                    if (bounds == null || (distance = Math.abs(bounds.y + bounds.height / 2 - center)) >= distanceFound) continue;
                    popupMenuPoint = new Point(bounds.x + 2, bounds.y + bounds.height - 1);
                    distanceFound = distance;
                    pathFound = path;
                }
                if (pathFound != null) {
                    TreeUtil.scrollToVisible((JTree)tree2, pathFound, (boolean)false);
                }
            }
        } else if (component2 instanceof JTable) {
            JTable table2 = (JTable)component2;
            int column = table2.getColumnModel().getSelectionModel().getLeadSelectionIndex();
            int row2 = Math.max(table2.getSelectionModel().getLeadSelectionIndex(), table2.getSelectionModel().getAnchorSelectionIndex());
            Rectangle rect = table2.getCellRect(row2, column, false);
            if (!visibleRect.intersects(rect)) {
                table2.scrollRectToVisible(rect);
            }
            popupMenuPoint = new Point(rect.x, rect.y + rect.height - 1);
        } else if (component2 instanceof PopupOwner) {
            PopupOwner popupOwner = (PopupOwner)((Object)component2);
            JComponent popupComponent = popupOwner.getPopupComponent();
            popupMenuPoint = popupComponent == null || popupComponent == popupOwner ? ((PopupOwner)((Object)component2)).getBestPopupPosition() : this.guessBestPopupLocation(popupComponent).getPoint((Component)component2);
        }
        if (popupMenuPoint == null) {
            popupMenuPoint = new Point(visibleRect.x + visibleRect.width / 2, visibleRect.y + visibleRect.height / 2);
        }
        return new RelativePoint((Component)component2, popupMenuPoint);
    }

    public boolean isBestPopupLocationVisible(@NotNull Editor editor2) {
        if (editor2 == null) {
            PopupFactoryImpl.$$$reportNull$$$0(40);
        }
        return PopupFactoryImpl.getVisibleBestPopupLocation(editor2) != null;
    }

    @NotNull
    public RelativePoint guessBestPopupLocation(@NotNull Editor editor2) {
        Point p;
        if (editor2 == null) {
            PopupFactoryImpl.$$$reportNull$$$0(41);
        }
        if ((p = PopupFactoryImpl.getVisibleBestPopupLocation(editor2)) == null) {
            Rectangle visibleArea = editor2.getScrollingModel().getVisibleArea();
            p = new Point(visibleArea.x + visibleArea.width / 3, visibleArea.y + visibleArea.height / 2);
        }
        return new RelativePoint((Component)editor2.getContentComponent(), p);
    }

    @Nullable
    private static Point getVisibleBestPopupLocation(@NotNull Editor editor2) {
        Rectangle visibleArea;
        if (editor2 == null) {
            PopupFactoryImpl.$$$reportNull$$$0(42);
        }
        int lineHeight = editor2.getLineHeight();
        Point p = (Point)editor2.getUserData(ANCHOR_POPUP_POINT);
        if (p == null) {
            VisualPosition visualPosition = (VisualPosition)editor2.getUserData(ANCHOR_POPUP_POSITION);
            if (visualPosition == null) {
                CaretModel caretModel = editor2.getCaretModel();
                visualPosition = caretModel.isUpToDate() ? caretModel.getVisualPosition() : editor2.offsetToVisualPosition(caretModel.getOffset());
            }
            p = editor2.visualPositionToXY(visualPosition);
            p.y += lineHeight;
        }
        return !(visibleArea = editor2.getScrollingModel().getVisibleArea()).contains(p) && !visibleArea.contains(p.x, p.y - lineHeight) ? null : p;
    }

    public Point getCenterOf(JComponent container, JComponent content2) {
        return AbstractPopup.getCenterOf((Component)container, content2);
    }

    public @Unmodifiable @NotNull List<JBPopup> getChildPopups(@NotNull Component component2) {
        if (component2 == null) {
            PopupFactoryImpl.$$$reportNull$$$0(43);
        }
        List<JBPopup> list2 = AbstractPopup.getChildPopups(component2);
        if (list2 == null) {
            PopupFactoryImpl.$$$reportNull$$$0(44);
        }
        return list2;
    }

    public boolean isPopupActive() {
        return IdeEventQueue.getInstance().isPopupActive();
    }

    @NotNull
    public BalloonBuilder createBalloonBuilder(@NotNull JComponent content2) {
        if (content2 == null) {
            PopupFactoryImpl.$$$reportNull$$$0(45);
        }
        return new BalloonPopupBuilderImpl(content2);
    }

    @NotNull
    public BalloonBuilder createDialogBalloonBuilder(@NotNull JComponent content2, @NlsContexts.PopupTitle @Nullable String title2) {
        if (content2 == null) {
            PopupFactoryImpl.$$$reportNull$$$0(46);
        }
        BalloonPopupBuilderImpl builder = new BalloonPopupBuilderImpl(content2);
        BalloonBuilder balloonBuilder = this.fillDialogBalloonBuilder(builder, title2);
        if (balloonBuilder == null) {
            PopupFactoryImpl.$$$reportNull$$$0(47);
        }
        return balloonBuilder;
    }

    @NotNull
    protected BalloonBuilder fillDialogBalloonBuilder(BalloonBuilder builder, @NlsContexts.PopupTitle @Nullable String title2) {
        Color bg = UIManager.getColor("Panel.background");
        JBColor borderOriginal = JBColor.DARK_GRAY;
        Color border = ColorUtil.toAlpha((Color)borderOriginal, (int)75);
        BalloonBuilder balloonBuilder = builder.setDialogMode(true).setTitle(title2).setAnimationCycle(200).setFillColor(bg).setBorderColor(border).setHideOnClickOutside(false).setHideOnKeyOutside(false).setHideOnAction(false).setCloseButtonEnabled(true).setShadow(true);
        if (balloonBuilder == null) {
            PopupFactoryImpl.$$$reportNull$$$0(48);
        }
        return balloonBuilder;
    }

    @NotNull
    public BalloonBuilder createHtmlTextBalloonBuilder(@NotNull String htmlContent, @Nullable Icon icon2, Color textColor, Color fillColor, @Nullable HyperlinkListener listener2) {
        if (htmlContent == null) {
            PopupFactoryImpl.$$$reportNull$$$0(49);
        }
        BalloonBuilder balloonBuilder = this.createHtmlTextBalloonBuilder(new Html(htmlContent), icon2, textColor, fillColor, listener2);
        if (balloonBuilder == null) {
            PopupFactoryImpl.$$$reportNull$$$0(50);
        }
        return balloonBuilder;
    }

    @NotNull
    public BalloonBuilder createHtmlTextBalloonBuilder(@NotNull Html html, @Nullable Icon icon2, Color textColor, Color fillColor, @Nullable HyperlinkListener listener2) {
        if (html == null) {
            PopupFactoryImpl.$$$reportNull$$$0(51);
        }
        if (textColor == null) {
            textColor = MessageType.INFO.getTitleForeground();
        }
        if (fillColor == null) {
            fillColor = MessageType.INFO.getPopupBackground();
        }
        JEditorPane text2 = IdeTooltipManager.initPane(html, new HintHint().setTextFg(textColor).setTextBg(fillColor).setAwtTooltip(true), null, true);
        if (listener2 != null) {
            text2.addHyperlinkListener(listener2);
        }
        text2.setEditable(false);
        NonOpaquePanel.setTransparent((JComponent)text2);
        text2.setBorder(null);
        JLabel label2 = new JLabel();
        NonOpaquePanel content2 = new NonOpaquePanel((LayoutManager)new BorderLayout((int)((double)label2.getIconTextGap() * 1.5), (int)((double)label2.getIconTextGap() * 1.5)));
        NonOpaquePanel textWrapper = new NonOpaquePanel((LayoutManager)new BorderLayout());
        JScrollPane scrolledText = ScrollPaneFactory.createScrollPane((Component)text2, (boolean)true);
        scrolledText.setBackground(fillColor);
        scrolledText.getViewport().setBackground(fillColor);
        textWrapper.add((Component)scrolledText, (Object)"Center");
        content2.add((Component)textWrapper, "Center");
        if (icon2 != null) {
            NonOpaquePanel north = new NonOpaquePanel((LayoutManager)new BorderLayout());
            north.add((Component)new JLabel(icon2), (Object)"North");
            content2.add((Component)north, "West");
        }
        content2.setBorder((Border)JBUI.Borders.empty((int)2, (int)4));
        BalloonBuilder builder = this.createBalloonBuilder((JComponent)content2);
        builder.setFillColor(fillColor);
        BalloonBuilder balloonBuilder = builder;
        if (balloonBuilder == null) {
            PopupFactoryImpl.$$$reportNull$$$0(52);
        }
        return balloonBuilder;
    }

    @NotNull
    public BalloonBuilder createHtmlTextBalloonBuilder(@NotNull String htmlContent, @NotNull MessageType messageType, @Nullable HyperlinkListener listener2) {
        if (htmlContent == null) {
            PopupFactoryImpl.$$$reportNull$$$0(53);
        }
        if (messageType == null) {
            PopupFactoryImpl.$$$reportNull$$$0(54);
        }
        BalloonBuilder balloonBuilder = this.createHtmlTextBalloonBuilder(htmlContent, messageType.getDefaultIcon(), messageType.getTitleForeground(), messageType.getPopupBackground(), listener2).setBorderColor(messageType.getBorderColor());
        if (balloonBuilder == null) {
            PopupFactoryImpl.$$$reportNull$$$0(55);
        }
        return balloonBuilder;
    }

    @Nullable
    private static Icon scaleIconToSize(@Nullable Icon icon2, int maxIconWidth, int maxIconHeight) {
        float f;
        if (icon2 == null) {
            return icon2;
        }
        if (icon2.getClass() == EmptyIcon.class) {
            return icon2.getIconWidth() == maxIconWidth && icon2.getIconHeight() == maxIconHeight ? icon2 : EmptyIcon.create((int)maxIconWidth, (int)maxIconHeight);
        }
        if (icon2 instanceof ScalableIcon) {
            ScalableIcon scalableIcon = (ScalableIcon)icon2;
            f = scalableIcon.getScale();
        } else {
            f = 1.0f;
        }
        float currentScale = f;
        float neededScale = (float)Math.min(maxIconWidth, maxIconHeight) / (float)Math.min(icon2.getIconWidth(), icon2.getIconHeight()) * currentScale;
        return Math.abs(currentScale - neededScale) < 0.01f ? icon2 : CustomIconUtilKt.scaleIconOrLoadCustomVersion((Icon)icon2, (float)neededScale);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 16, 19, 28, 29, 30, 32, 33, 36, 37, 38, 44, 47, 48, 50, 52, 55 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 16: 
            case 19: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 36: 
            case 37: 
            case 38: 
            case 44: 
            case 47: 
            case 48: 
            case 50: 
            case 52: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/popup/PopupFactoryImpl";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionGroup";
                break;
            }
            case 11: 
            case 13: 
            case 15: 
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 17: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "step";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cellRendererProducer";
                break;
            }
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aStep";
                break;
            }
            case 25: 
            case 45: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorInfoSupplier";
                break;
            }
            case 39: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 49: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "htmlContent";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "html";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/popup/PopupFactoryImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createConfirmation";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createMessage";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createActionsStep";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createListPopup";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "guessBestPopupLocation";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonNullPopupTarget";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildPopups";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "createDialogBalloonBuilder";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "fillDialogBalloonBuilder";
                break;
            }
            case 50: 
            case 52: 
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "createHtmlTextBalloonBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createPopupChooserBuilder";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 16: 
            case 19: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 36: 
            case 37: 
            case 38: 
            case 44: 
            case 47: 
            case 48: 
            case 50: 
            case 52: 
            case 55: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createPopupComponentAdapter";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createActionGroupPopup";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createActionsStep";
                break;
            }
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createListPopup";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createTree";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createComponentPopupBuilder";
                break;
            }
            case 26: 
            case 27: 
            case 31: 
            case 39: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "guessBestPopupLocation";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getNonNullPopupTarget";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "isBestPopupLocationVisible";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getVisibleBestPopupLocation";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getChildPopups";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "createBalloonBuilder";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "createDialogBalloonBuilder";
                break;
            }
            case 49: 
            case 51: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "createHtmlTextBalloonBuilder";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 16, 19, 28, 29, 30, 32, 33, 36, 37, 38, 44, 47, 48, 50, 52, 55 -> new IllegalStateException(string);
        };
    }

    public static class ActionGroupPopup
    extends ListPopupImpl {
        private final Runnable myDisposeCallback;
        private final Component myComponent;

        @Deprecated(forRemoval=true)
        public ActionGroupPopup(@NlsContexts.PopupTitle @Nullable String title2, @NotNull ActionGroup actionGroup, @NotNull DataContext dataContext2, boolean showNumbers, boolean useAlphaAsNumbers, boolean showDisabledActions, boolean honorActionMnemonics, Runnable disposeCallback, int maxRowCount, Condition<? super AnAction> preselectCondition, @Nullable String actionPlace) {
            if (actionGroup == null) {
                ActionGroupPopup.$$$reportNull$$$0(0);
            }
            if (dataContext2 == null) {
                ActionGroupPopup.$$$reportNull$$$0(1);
            }
            this(title2, actionGroup, dataContext2, showNumbers, useAlphaAsNumbers, showDisabledActions, honorActionMnemonics, disposeCallback, maxRowCount, preselectCondition, actionPlace, null, false);
        }

        @Deprecated(forRemoval=true)
        public ActionGroupPopup(@NlsContexts.PopupTitle @Nullable String title2, @NotNull ActionGroup actionGroup, @NotNull DataContext dataContext2, boolean showNumbers, boolean useAlphaAsNumbers, boolean showDisabledActions, boolean honorActionMnemonics, Runnable disposeCallback, int maxRowCount, Condition<? super AnAction> preselectCondition, @Nullable String actionPlace, boolean autoSelection) {
            if (actionGroup == null) {
                ActionGroupPopup.$$$reportNull$$$0(2);
            }
            if (dataContext2 == null) {
                ActionGroupPopup.$$$reportNull$$$0(3);
            }
            this(title2, actionGroup, dataContext2, showNumbers, useAlphaAsNumbers, showDisabledActions, honorActionMnemonics, disposeCallback, maxRowCount, preselectCondition, actionPlace, null, autoSelection);
        }

        @Deprecated(forRemoval=true)
        public ActionGroupPopup(@NlsContexts.PopupTitle @Nullable String title2, @NotNull ActionGroup actionGroup, @NotNull DataContext dataContext2, boolean showNumbers, boolean useAlphaAsNumbers, boolean showDisabledActions, boolean honorActionMnemonics, Runnable disposeCallback, int maxRowCount, Condition<? super AnAction> preselectCondition, @Nullable String actionPlace, @Nullable PresentationFactory presentationFactory, boolean autoSelection) {
            if (actionGroup == null) {
                ActionGroupPopup.$$$reportNull$$$0(4);
            }
            if (dataContext2 == null) {
                ActionGroupPopup.$$$reportNull$$$0(5);
            }
            this(null, title2, actionGroup, dataContext2, actionPlace == null ? "popup" : actionPlace, presentationFactory == null ? new PresentationFactory() : presentationFactory, ActionPopupOptions.create(showNumbers, useAlphaAsNumbers, showDisabledActions, honorActionMnemonics, maxRowCount, autoSelection, preselectCondition), disposeCallback);
        }

        public ActionGroupPopup(@Nullable WizardPopup parentPopup, @NlsContexts.PopupTitle @Nullable String title2, final @NotNull ActionGroup actionGroup, @NotNull DataContext dataContext2, final @NotNull String actionPlace, @NotNull PresentationFactory presentationFactory, @NotNull ActionPopupOptions options2, @Nullable Runnable disposeCallback) {
            if (actionGroup == null) {
                ActionGroupPopup.$$$reportNull$$$0(6);
            }
            if (dataContext2 == null) {
                ActionGroupPopup.$$$reportNull$$$0(7);
            }
            if (actionPlace == null) {
                ActionGroupPopup.$$$reportNull$$$0(8);
            }
            if (presentationFactory == null) {
                ActionGroupPopup.$$$reportNull$$$0(9);
            }
            if (options2 == null) {
                ActionGroupPopup.$$$reportNull$$$0(10);
            }
            this(parentPopup, ActionGroupPopup.createStep(title2, actionGroup, dataContext2, actionPlace, presentationFactory, options2), disposeCallback, dataContext2, options2.getMaxRowCount());
            UiInspectorUtil.registerProvider((JComponent)this.getList(), () -> UiInspectorActionUtil.collectActionGroupInfo("Menu", actionGroup, actionPlace, ((ActionPopupStep)this.getStep()).getPresentationFactory()));
            this.addListener(new JBPopupListener(){

                public void beforeShown(@NotNull LightweightWindowEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    ActionGroupPopupActivity.start(this, actionGroup, actionPlace);
                }

                public void onClosed(@NotNull LightweightWindowEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    ActionGroupPopupActivity.stop(this, event.isOk());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "event";
                    objectArray2[1] = "com/intellij/ui/popup/PopupFactoryImpl$ActionGroupPopup$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "beforeShown";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onClosed";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }

        protected ActionGroupPopup(@Nullable WizardPopup aParent, @NotNull ListPopupStep<?> step2, @Nullable Runnable disposeCallback, @NotNull DataContext dataContext2, int maxRowCount) {
            if (step2 == null) {
                ActionGroupPopup.$$$reportNull$$$0(11);
            }
            if (dataContext2 == null) {
                ActionGroupPopup.$$$reportNull$$$0(12);
            }
            super((Project)CommonDataKeys.PROJECT.getData(dataContext2), aParent, step2, null);
            this.setMaxRowCount(maxRowCount);
            this.myDisposeCallback = disposeCallback;
            this.myComponent = (Component)PlatformCoreDataKeys.CONTEXT_COMPONENT.getData(dataContext2);
            this.registerAction("handleActionToggle1", 32, 0, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.handleToggleAction(this.createKeyEvent(e, 32));
                }
            });
            this.addListSelectionListener(e -> {
                JList list2 = (JList)e.getSource();
                ActionItem actionItem = (ActionItem)list2.getSelectedValue();
                if (actionItem == null) {
                    return;
                }
                ActionMenu.showDescriptionInStatusBar(true, this.myComponent, actionItem.getDescription());
            });
        }

        @NotNull
        protected static ListPopupStep<ActionItem> createStep(@NlsContexts.PopupTitle @Nullable String title2, @NotNull ActionGroup actionGroup, @NotNull DataContext dataContext2, @NotNull String actionPlace, @NotNull PresentationFactory presentationFactory, @NotNull ActionPopupOptions options2) {
            if (actionGroup == null) {
                ActionGroupPopup.$$$reportNull$$$0(13);
            }
            if (dataContext2 == null) {
                ActionGroupPopup.$$$reportNull$$$0(14);
            }
            if (actionPlace == null) {
                ActionGroupPopup.$$$reportNull$$$0(15);
            }
            if (presentationFactory == null) {
                ActionGroupPopup.$$$reportNull$$$0(16);
            }
            if (options2 == null) {
                ActionGroupPopup.$$$reportNull$$$0(17);
            }
            DataContext asyncDataContext = Utils.createAsyncDataContext(dataContext2);
            ListPopupStep<ActionItem> listPopupStep = ActionPopupStep.createActionsStep(title2, actionGroup, asyncDataContext, actionPlace, presentationFactory, () -> asyncDataContext, options2);
            if (listPopupStep == null) {
                ActionGroupPopup.$$$reportNull$$$0(18);
            }
            return listPopupStep;
        }

        @Override
        public void dispose() {
            if (this.myDisposeCallback != null) {
                this.myDisposeCallback.run();
            }
            ActionMenu.showDescriptionInStatusBar(true, this.myComponent, null);
            super.dispose();
        }

        @Override
        public void handleSelect(boolean handleFinalChoices, InputEvent e) {
            ActionPopupStep step2;
            ActionItem item = (ActionItem)ObjectUtils.tryCast(this.getList().getSelectedValue(), ActionItem.class);
            ActionGroupPopupActivity fusActivity = ActionGroupPopupActivity.getCurrentActivity(this);
            if (fusActivity != null && item != null) {
                fusActivity.itemSelected(item.myAction, null);
            }
            if ((step2 = (ActionPopupStep)ObjectUtils.tryCast(this.getListStep(), ActionPopupStep.class)) != null && item != null && step2.isSelectable(item) && Utils.isKeepPopupOpen(item.getKeepPopupOnPerform(), e)) {
                step2.performActionItem(item, e);
                step2.updateStepItems(this.getList());
            } else {
                super.handleSelect(handleFinalChoices, e);
            }
        }

        @Override
        protected void handleRightKeyPressed(@NotNull KeyEvent keyEvent) {
            if (keyEvent == null) {
                ActionGroupPopup.$$$reportNull$$$0(19);
            }
            if (!this.handleRightOrLeftKeyPressed(keyEvent, true)) {
                super.handleRightKeyPressed(keyEvent);
            }
        }

        @Override
        protected void handleLeftKeyPressed(@NotNull KeyEvent keyEvent) {
            if (keyEvent == null) {
                ActionGroupPopup.$$$reportNull$$$0(20);
            }
            if (!this.handleRightOrLeftKeyPressed(keyEvent, false)) {
                super.handleLeftKeyPressed(keyEvent);
            }
        }

        private boolean handleRightOrLeftKeyPressed(@NotNull KeyEvent keyEvent, boolean isRightKey) {
            AnAction anAction;
            if (keyEvent == null) {
                ActionGroupPopup.$$$reportNull$$$0(21);
            }
            ActionItem item = (ActionItem)ObjectUtils.tryCast(this.getList().getSelectedValue(), ActionItem.class);
            ActionPopupStep step2 = (ActionPopupStep)ObjectUtils.tryCast(this.getListStep(), ActionPopupStep.class);
            if (step2 != null && item != null && step2.isSelectable(item) && item.getKeepPopupOnPerform() != KeepPopupOnPerform.Never && (anAction = item.getAction()) instanceof ToggleAction) {
                ToggleAction toggle = (ToggleAction)anAction;
                AnActionEvent event = step2.createAnActionEvent(item, keyEvent);
                ActionManagerEx actionManager = (ActionManagerEx)event.getActionManager();
                actionManager.performWithActionCallbacks((AnAction)toggle, event, () -> toggle.setSelected(event, isRightKey));
                step2.updateStepItems(this.getList());
                return true;
            }
            return false;
        }

        protected void handleToggleAction(@Nullable InputEvent inputEvent) {
            List selectedValues = this.getList().getSelectedValuesList();
            ActionPopupStep step2 = (ActionPopupStep)ObjectUtils.tryCast(this.getListStep(), ActionPopupStep.class);
            if (step2 == null) {
                return;
            }
            boolean updateStep = false;
            for (Object value : selectedValues) {
                ActionItem item = (ActionItem)ObjectUtils.tryCast(value, ActionItem.class);
                if (item == null || !step2.isSelectable(item) || !(item.getAction() instanceof Toggleable)) continue;
                step2.performActionItem(item, inputEvent);
                updateStep = true;
            }
            if (updateStep) {
                step2.updateStepItems(this.getList());
            }
        }

        public void registerShortcuts() {
            for (Object value : this.getListStep().getValues()) {
                if (!(value instanceof AnActionHolder)) continue;
                ((AnActionHolder)value).getAction().registerCustomShortcutSet(this.getComponent(), (Disposable)this);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 18 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionGroup";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 7: 
                case 12: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataContext";
                    break;
                }
                case 8: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionPlace";
                    break;
                }
                case 9: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentationFactory";
                    break;
                }
                case 10: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "options";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "step";
                    break;
                }
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/popup/PopupFactoryImpl$ActionGroupPopup";
                    break;
                }
                case 19: 
                case 20: 
                case 21: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "keyEvent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/popup/PopupFactoryImpl$ActionGroupPopup";
                    break;
                }
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createStep";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "createStep";
                    break;
                }
                case 18: {
                    break;
                }
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "handleRightKeyPressed";
                    break;
                }
                case 20: {
                    objectArray = objectArray;
                    objectArray[2] = "handleLeftKeyPressed";
                    break;
                }
                case 21: {
                    objectArray = objectArray;
                    objectArray[2] = "handleRightOrLeftKeyPressed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 18 -> new IllegalStateException(string);
            };
        }
    }

    public static final class ActionItem
    implements ShortcutProvider,
    AnActionHolder,
    NumericMnemonicItem {
        private final AnAction myAction;
        private final Presentation myPresentation;
        private @NlsActions.ActionText String myText;
        private Icon myIcon;
        private Icon mySelectedIcon;
        private final int maxIconWidth;
        private final int maxIconHeight;
        private final Character myMnemonicChar;
        private final boolean myMnemonicsEnabled;
        private final boolean myHonorActionMnemonics;
        boolean myPrependWithSeparator;
        private @NlsContexts.Separator String mySeparatorText;
        @NotNull
        private List<ActionItem> myInlineActions;
        @Nls
        @Nullable
        private String myAccessibleIconDescription;

        ActionItem(@NotNull AnAction action2, @Nullable Character mnemonicChar, boolean mnemonicsEnabled, boolean honorActionMnemonics, int maxIconWidth, int maxIconHeight, boolean prependWithSeparator, @NlsContexts.Separator String separatorText) {
            if (action2 == null) {
                ActionItem.$$$reportNull$$$0(0);
            }
            this.myPresentation = Presentation.newTemplatePresentation();
            this.myAction = action2;
            this.myMnemonicChar = mnemonicChar;
            this.myMnemonicsEnabled = mnemonicsEnabled;
            this.myHonorActionMnemonics = honorActionMnemonics;
            this.maxIconWidth = maxIconWidth;
            this.maxIconHeight = maxIconHeight;
            this.myPrependWithSeparator = prependWithSeparator;
            this.mySeparatorText = separatorText;
            this.myInlineActions = Collections.emptyList();
            this.myAction.getTemplatePresentation().addPropertyChangeListener(evt -> {
                if ("text".equals(evt.getPropertyName())) {
                    this.myText = this.myAction.getTemplatePresentation().getText();
                }
            });
        }

        ActionItem(@NotNull AnAction action2, @NotNull @NlsActions.ActionText String text2) {
            if (action2 == null) {
                ActionItem.$$$reportNull$$$0(1);
            }
            if (text2 == null) {
                ActionItem.$$$reportNull$$$0(2);
            }
            this.myPresentation = Presentation.newTemplatePresentation();
            this.myAction = action2;
            this.myText = text2;
            this.myMnemonicChar = null;
            this.myMnemonicsEnabled = false;
            this.myHonorActionMnemonics = false;
            this.maxIconWidth = -1;
            this.maxIconHeight = -1;
            this.myPrependWithSeparator = false;
            this.mySeparatorText = null;
            this.myInlineActions = Collections.emptyList();
        }

        @NotNull
        Presentation clonePresentation() {
            Presentation presentation2 = this.myPresentation.clone();
            if (presentation2 == null) {
                ActionItem.$$$reportNull$$$0(3);
            }
            return presentation2;
        }

        @NotNull
        public List<ActionItem> getInlineItems() {
            List<ActionItem> list2 = this.myInlineActions;
            if (list2 == null) {
                ActionItem.$$$reportNull$$$0(4);
            }
            return list2;
        }

        void updateFromPresentation(@NotNull PresentationFactory presentationFactory, @NotNull String actionPlace) {
            if (presentationFactory == null) {
                ActionItem.$$$reportNull$$$0(5);
            }
            if (actionPlace == null) {
                ActionItem.$$$reportNull$$$0(6);
            }
            Presentation presentation2 = presentationFactory.getPresentation(this.myAction);
            this.updateFromPresentation(presentation2, actionPlace);
            List inlineActions = (List)presentation2.getClientProperty(ActionUtil.INLINE_ACTIONS);
            this.myInlineActions = this.createInlineItems(presentationFactory, actionPlace, inlineActions);
        }

        void updateFromPresentation(@NotNull Presentation presentation2, @NotNull String actionPlace) {
            boolean disableIcon;
            String text2;
            if (presentation2 == null) {
                ActionItem.$$$reportNull$$$0(7);
            }
            if (actionPlace == null) {
                ActionItem.$$$reportNull$$$0(8);
            }
            this.myPresentation.copyFrom(presentation2, null, true);
            TextWithMnemonic textWithMnemonic = (TextWithMnemonic)presentation2.getTextWithPossibleMnemonic().get();
            if (textWithMnemonic != null && !this.myMnemonicsEnabled && this.myHonorActionMnemonics) {
                text2 = textWithMnemonic.format(false, Character.valueOf('\u001b'), true);
            } else {
                String string = text2 = textWithMnemonic != null ? textWithMnemonic.getText() : null;
            }
            if (StringUtil.isEmpty((String)text2)) {
                Utils.reportEmptyTextMenuItem(this.myAction, actionPlace);
                text2 = "";
            }
            this.myText = ActionPresentationDecorator.decorateTextIfNeeded(this.myAction, text2);
            Pair<Icon, Icon> icons = ActionStepBuilder.calcRawIcons(this.myAction, presentation2, false);
            Icon icon2 = (Icon)icons.first;
            Icon selectedIcon = (Icon)icons.second;
            if (this.maxIconWidth != -1 && this.maxIconHeight != -1) {
                icon2 = PopupFactoryImpl.scaleIconToSize(icon2, this.maxIconWidth, this.maxIconHeight);
                selectedIcon = PopupFactoryImpl.scaleIconToSize(selectedIcon, this.maxIconWidth, this.maxIconHeight);
            }
            if (icon2 == null) {
                icon2 = selectedIcon != null ? selectedIcon : EmptyIcon.create((int)this.maxIconWidth, (int)this.maxIconHeight);
            }
            this.myIcon = (disableIcon = Boolean.TRUE.equals(presentation2.getClientProperty(DISABLE_ICON_IN_LIST))) ? null : icon2;
            this.mySelectedIcon = selectedIcon;
            if (this.myAction instanceof Toggleable) {
                this.myAccessibleIconDescription = Toggleable.isSelected((Presentation)presentation2) ? IdeBundle.message((String)"popup.action.item.toggleable.checked.accessible.description", (Object[])new Object[0]) : IdeBundle.message((String)"popup.action.item.toggleable.not.checked.accessible.description", (Object[])new Object[0]);
            }
        }

        @NotNull
        private List<ActionItem> createInlineItems(@NotNull PresentationFactory presentationFactory, @NotNull String actionPlace, @Nullable List<? extends AnAction> inlineActions) {
            if (presentationFactory == null) {
                ActionItem.$$$reportNull$$$0(9);
            }
            if (actionPlace == null) {
                ActionItem.$$$reportNull$$$0(10);
            }
            if (inlineActions == null) {
                List<ActionItem> list2 = Collections.emptyList();
                if (list2 == null) {
                    ActionItem.$$$reportNull$$$0(11);
                }
                return list2;
            }
            ArrayList res = new ArrayList();
            for (AnAction anAction : inlineActions) {
                Presentation p = presentationFactory.getPresentation(anAction);
                if (!p.isVisible()) continue;
                ActionItem item = new ActionItem(anAction, null, false, false, this.maxIconWidth, this.maxIconHeight, false, null);
                item.updateFromPresentation(p, actionPlace);
                res.add(item);
            }
            List<ActionItem> list3 = res.isEmpty() ? Collections.emptyList() : res;
            if (list3 == null) {
                ActionItem.$$$reportNull$$$0(12);
            }
            return list3;
        }

        @Override
        @Nullable
        public Character getMnemonicChar() {
            return this.myMnemonicChar;
        }

        @Override
        public boolean digitMnemonicsEnabled() {
            return this.myMnemonicsEnabled;
        }

        @NotNull
        public AnAction getAction() {
            AnAction anAction = this.myAction;
            if (anAction == null) {
                ActionItem.$$$reportNull$$$0(13);
            }
            return anAction;
        }

        @NotNull
        @NlsActions.ActionText
        public String getText() {
            String string = this.myText;
            if (string == null) {
                ActionItem.$$$reportNull$$$0(14);
            }
            return string;
        }

        @Nullable
        public Icon getIcon(boolean selected) {
            return selected && this.mySelectedIcon != null ? this.mySelectedIcon : this.myIcon;
        }

        public boolean isPrependWithSeparator() {
            return this.myPrependWithSeparator;
        }

        @NlsContexts.Separator
        public String getSeparatorText() {
            return this.mySeparatorText;
        }

        @Nls
        @Nullable
        public String getAccessibleIconDescription() {
            return this.myAccessibleIconDescription;
        }

        public void setSeparatorText(@NlsContexts.Separator String separatorText) {
            this.myPrependWithSeparator = separatorText != null;
            this.mySeparatorText = separatorText;
        }

        public boolean isEnabled() {
            return this.myPresentation.isEnabled();
        }

        public boolean isPerformGroup() {
            return this.myAction instanceof ActionGroup && this.myPresentation.isPerformGroup();
        }

        public boolean isSubstepSuppressed() {
            return this.myAction instanceof ActionGroup && Utils.isSubmenuSuppressed(this.myPresentation);
        }

        @NotNull
        public KeepPopupOnPerform getKeepPopupOnPerform() {
            KeepPopupOnPerform keepPopupOnPerform = this.myPresentation.getKeepPopupOnPerform();
            if (keepPopupOnPerform == null) {
                ActionItem.$$$reportNull$$$0(15);
            }
            return keepPopupOnPerform;
        }

        @NlsContexts.DetailedDescription
        public String getDescription() {
            String description = this.myPresentation.getDescription();
            return description == null ? this.getTooltip() : description;
        }

        @NlsContexts.Tooltip
        public String getTooltip() {
            return (String)this.myPresentation.getClientProperty(ActionUtil.TOOLTIP_TEXT);
        }

        @NotNull
        public ShortcutSet getShortcut() {
            ShortcutSet shortcutSet = this.myAction.getShortcutSet();
            if (shortcutSet == null) {
                ActionItem.$$$reportNull$$$0(16);
            }
            return shortcutSet;
        }

        @Nullable
        public <T> T getClientProperty(@NotNull Key<T> key) {
            if (key == null) {
                ActionItem.$$$reportNull$$$0(17);
            }
            return (T)this.myPresentation.getClientProperty(key);
        }

        public String toString() {
            return this.myText;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 11, 12, 13, 14, 15, 16 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 3: 
                case 4: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/popup/PopupFactoryImpl$ActionItem";
                    break;
                }
                case 5: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentationFactory";
                    break;
                }
                case 6: 
                case 8: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionPlace";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/popup/PopupFactoryImpl$ActionItem";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "clonePresentation";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInlineItems";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createInlineItems";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAction";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKeepPopupOnPerform";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getShortcut";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: {
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "updateFromPresentation";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "createInlineItems";
                    break;
                }
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "getClientProperty";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 11, 12, 13, 14, 15, 16 -> new IllegalStateException(string);
            };
        }
    }
}

