/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.zip.signer.signing;

import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.zip.signer.metadata.Digest;
import org.jetbrains.zip.signer.metadata.SignatureAlgorithm;
import org.jetbrains.zip.signer.metadata.SignatureData;
import org.jetbrains.zip.signer.metadata.SignerBlock;
import org.jetbrains.zip.signer.signing.SignatureProvider;
import org.jetbrains.zip.signer.verifier.DefaultSignatureVerifier;
import org.jetbrains.zip.signer.verifier.SignatureVerifier;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a,\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003H\u0000\u001a \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"generateSignerBlock", "Lorg/jetbrains/zip/signer/metadata/SignerBlock;", "certificates", "", "Ljava/security/cert/X509Certificate;", "signatureProvider", "Lorg/jetbrains/zip/signer/signing/SignatureProvider;", "contentDigests", "Lorg/jetbrains/zip/signer/metadata/Digest;", "generateSignatureOverData", "", "digest", "signatureVerifier", "Lorg/jetbrains/zip/signer/verifier/SignatureVerifier;", "lib"})
@SourceDebugExtension(value={"SMAP\nSigning.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Signing.kt\norg/jetbrains/zip/signer/signing/SigningKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,46:1\n1563#2:47\n1634#2,3:48\n*S KotlinDebug\n*F\n+ 1 Signing.kt\norg/jetbrains/zip/signer/signing/SigningKt\n*L\n19#1:47\n19#1:48,3\n*E\n"})
public final class SigningKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final SignerBlock generateSignerBlock(@NotNull List<? extends X509Certificate> certificates, @NotNull SignatureProvider signatureProvider, @NotNull List<Digest> contentDigests) {
        Object v0;
        SignatureAlgorithm signatureAlgorithm;
        List encodedCertificates;
        block4: {
            Digest it;
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(certificates, (String)"certificates");
            Intrinsics.checkNotNullParameter((Object)signatureProvider, (String)"signatureProvider");
            Intrinsics.checkNotNullParameter(contentDigests, (String)"contentDigests");
            if (certificates.isEmpty()) {
                throw new SignatureException("No certificates configured for signer");
            }
            Iterable $this$map$iv = certificates;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                X509Certificate x509Certificate = (X509Certificate)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(((Certificate)((Object)it)).getEncoded());
            }
            encodedCertificates = (List)destination$iv$iv;
            signatureAlgorithm = signatureProvider.getSignatureAlgorithm();
            Iterable iterable2 = contentDigests;
            for (Object t : iterable2) {
                it = (Digest)t;
                boolean bl = false;
                if (!(it.getAlgorithm() == signatureAlgorithm.getContentDigestAlgorithm())) continue;
                v0 = t;
                break block4;
            }
            v0 = null;
        }
        Digest digest = v0;
        if (digest == null) {
            throw new RuntimeException((Object)((Object)signatureAlgorithm.getContentDigestAlgorithm()) + " content digest not computed");
        }
        Digest digest2 = digest;
        DefaultSignatureVerifier signatureVerifier = new DefaultSignatureVerifier(certificates, signatureAlgorithm);
        SignatureData signature = new SignatureData(signatureAlgorithm, SigningKt.generateSignatureOverData(digest2, signatureProvider, signatureVerifier));
        return new SignerBlock(encodedCertificates, CollectionsKt.listOf((Object)signature));
    }

    private static final byte[] generateSignatureOverData(Digest digest, SignatureProvider signatureProvider, SignatureVerifier signatureVerifier) {
        byte[] signatureBytes = signatureProvider.sign(digest.getDigestBytes());
        signatureVerifier.verify(digest.getDigestBytes(), signatureBytes);
        return signatureBytes;
    }
}

