/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.split.connection.impl.state;

import com.intellij.platform.split.connection.protocol.ConnectionState;
import com.jetbrains.rd.platform.codeWithMe.comms.state.ConnectionStateKind;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0007\u00a8\u0006\u0004"}, d2={"mapWireStateToConnectionStateKind", "Lcom/jetbrains/rd/platform/codeWithMe/comms/state/ConnectionStateKind;", "wireState", "Lcom/intellij/platform/split/connection/protocol/ConnectionState;", "intellij.platform.split.connection"})
public final class ConnectionStateUtilKt {
    @ApiStatus.Internal
    @NotNull
    public static final ConnectionStateKind mapWireStateToConnectionStateKind(@NotNull ConnectionState wireState) {
        ConnectionStateKind connectionStateKind;
        Intrinsics.checkNotNullParameter((Object)wireState, (String)"wireState");
        ConnectionState connectionState = wireState;
        if (connectionState instanceof ConnectionState.NOT_CONNECTED) {
            connectionStateKind = (ConnectionStateKind)ConnectionStateKind.NotConnected.INSTANCE;
        } else if (connectionState instanceof ConnectionState.CONNECTED) {
            connectionStateKind = (ConnectionStateKind)ConnectionStateKind.Connected.INSTANCE;
        } else if (connectionState instanceof ConnectionState.CLOSED) {
            connectionStateKind = (ConnectionStateKind)ConnectionStateKind.Closed.INSTANCE;
        } else if (connectionState instanceof ConnectionState.FAULTED) {
            connectionStateKind = (ConnectionStateKind)new ConnectionStateKind.Faulted(((ConnectionState.FAULTED)wireState).getThrowable());
        } else if (connectionState instanceof ConnectionState.DECLINED) {
            connectionStateKind = (ConnectionStateKind)new ConnectionStateKind.Declined(((ConnectionState.DECLINED)wireState).getReason());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return connectionStateKind;
    }
}

